/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.cqframework.cql.cql2elm.ModelInfoLoader;
import org.cqframework.cql.cql2elm.model.Model;
import org.cqframework.cql.cql2elm.model.SystemModel;
import org.hl7.cql.model.ModelIdentifier;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class ModelManager {
    private final NamespaceManager namespaceManager;
    private Path path;
    private ModelInfoLoader modelInfoLoader;
    private final Map<String, Model> models = new HashMap<String, Model>();
    private final Set<String> loadingModels = new HashSet<String>();
    private final Map<String, Model> modelsByUri = new HashMap<String, Model>();
    private final Map<ModelIdentifier, Model> globalCache;
    private boolean enableDefaultModelInfoLoading = true;

    public ModelManager() {
        this.namespaceManager = new NamespaceManager();
        this.globalCache = new ConcurrentHashMap<ModelIdentifier, Model>();
        this.initialize();
    }

    public ModelManager(Map<ModelIdentifier, Model> globalCache) {
        Objects.requireNonNull(globalCache, "globalCache can not be null.");
        this.namespaceManager = new NamespaceManager();
        this.globalCache = globalCache;
        this.initialize();
    }

    public ModelManager(Path path) {
        this.namespaceManager = new NamespaceManager();
        this.globalCache = new ConcurrentHashMap<ModelIdentifier, Model>();
        this.path = path;
        this.initialize();
    }

    public ModelManager(Path path, Map<ModelIdentifier, Model> globalCache) {
        Objects.requireNonNull(globalCache, "globalCache can not be null.");
        this.namespaceManager = new NamespaceManager();
        this.globalCache = globalCache;
        this.path = path;
        this.initialize();
    }

    public ModelManager(boolean enableDefaultModelInfoLoading) {
        this.namespaceManager = new NamespaceManager();
        this.globalCache = new ConcurrentHashMap<ModelIdentifier, Model>();
        this.enableDefaultModelInfoLoading = enableDefaultModelInfoLoading;
        this.initialize();
    }

    public ModelManager(boolean enableDefaultModelInfoLoading, Map<ModelIdentifier, Model> globalCache) {
        Objects.requireNonNull(globalCache, "globalCache can not be null.");
        this.namespaceManager = new NamespaceManager();
        this.globalCache = globalCache;
        this.enableDefaultModelInfoLoading = enableDefaultModelInfoLoading;
        this.initialize();
    }

    public ModelManager(boolean enableDefaultModelInfoLoading, Path path) {
        this.namespaceManager = new NamespaceManager();
        this.globalCache = new ConcurrentHashMap<ModelIdentifier, Model>();
        this.path = path;
        this.enableDefaultModelInfoLoading = enableDefaultModelInfoLoading;
        this.initialize();
    }

    public ModelManager(boolean enableDefaultModelInfoLoading, Path path, Map<ModelIdentifier, Model> globalCache) {
        Objects.requireNonNull(globalCache, "globalCache can not be null.");
        this.namespaceManager = new NamespaceManager();
        this.globalCache = globalCache;
        this.path = path;
        this.enableDefaultModelInfoLoading = enableDefaultModelInfoLoading;
        this.initialize();
    }

    public ModelManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
        this.globalCache = new ConcurrentHashMap<ModelIdentifier, Model>();
        this.initialize();
    }

    public ModelManager(NamespaceManager namespaceManager, Map<ModelIdentifier, Model> globalCache) {
        Objects.requireNonNull(globalCache, "globalCache can not be null.");
        this.namespaceManager = namespaceManager;
        this.globalCache = globalCache;
        this.initialize();
    }

    public ModelManager(NamespaceManager namespaceManager, Path path) {
        this.namespaceManager = namespaceManager;
        this.globalCache = new ConcurrentHashMap<ModelIdentifier, Model>();
        this.path = path;
        this.initialize();
    }

    public ModelManager(NamespaceManager namespaceManager, Path path, Map<ModelIdentifier, Model> globalCache) {
        Objects.requireNonNull(globalCache, "globalCache can not be null.");
        this.namespaceManager = namespaceManager;
        this.globalCache = globalCache;
        this.path = path;
        this.initialize();
    }

    public ModelManager(NamespaceManager namespaceManager, boolean enableDefaultModelInfoLoading) {
        this.namespaceManager = namespaceManager;
        this.globalCache = new ConcurrentHashMap<ModelIdentifier, Model>();
        this.enableDefaultModelInfoLoading = enableDefaultModelInfoLoading;
        this.initialize();
    }

    public ModelManager(NamespaceManager namespaceManager, boolean enableDefaultModelInfoLoading, Map<ModelIdentifier, Model> globalCache) {
        Objects.requireNonNull(globalCache, "globalCache can not be null.");
        this.namespaceManager = namespaceManager;
        this.globalCache = globalCache;
        this.enableDefaultModelInfoLoading = enableDefaultModelInfoLoading;
        this.initialize();
    }

    public ModelManager(NamespaceManager namespaceManager, boolean enableDefaultModelInfoLoading, Path path) {
        this.namespaceManager = namespaceManager;
        this.globalCache = new ConcurrentHashMap<ModelIdentifier, Model>();
        this.path = path;
        this.enableDefaultModelInfoLoading = enableDefaultModelInfoLoading;
        this.initialize();
    }

    public ModelManager(NamespaceManager namespaceManager, boolean enableDefaultModelInfoLoading, Path path, Map<ModelIdentifier, Model> globalCache) {
        Objects.requireNonNull(globalCache, "globalCache can not be null.");
        this.namespaceManager = namespaceManager;
        this.globalCache = globalCache;
        this.path = path;
        this.enableDefaultModelInfoLoading = enableDefaultModelInfoLoading;
        this.initialize();
    }

    private void initialize() {
        this.modelInfoLoader = new ModelInfoLoader();
        this.modelInfoLoader.setNamespaceManager(this.namespaceManager);
        if (this.path != null) {
            this.modelInfoLoader.setPath(this.path);
        }
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public ModelInfoLoader getModelInfoLoader() {
        return this.modelInfoLoader;
    }

    public boolean isDefaultModelInfoLoadingEnabled() {
        return this.enableDefaultModelInfoLoading;
    }

    public Map<ModelIdentifier, Model> getGlobalCache() {
        return this.globalCache;
    }

    public boolean isWellKnownModelName(String unqualifiedIdentifier) {
        if (unqualifiedIdentifier == null) {
            return false;
        }
        switch (unqualifiedIdentifier) {
            case "FHIR": 
            case "QDM": 
            case "USCore": 
            case "QICore": 
            case "QUICK": {
                return true;
            }
        }
        return false;
    }

    private Model buildModel(ModelIdentifier identifier) {
        Model model = null;
        if (identifier == null) {
            throw new IllegalArgumentException("Model identifier is required");
        }
        if (identifier.getId() == null || identifier.getId().equals("")) {
            throw new IllegalArgumentException("Model identifier Id is required");
        }
        String modelPath = NamespaceManager.getPath((String)identifier.getSystem(), (String)identifier.getId());
        this.pushLoading(modelPath);
        try {
            ModelInfo modelInfo = this.modelInfoLoader.getModelInfo(identifier);
            model = identifier.getId().equals("System") ? new SystemModel(modelInfo) : new Model(modelInfo, this);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not load model information for model %s, version %s.", identifier.getId(), identifier.getVersion()));
        }
        finally {
            this.popLoading(modelPath);
        }
        return model;
    }

    private void pushLoading(String modelId) {
        if (this.loadingModels.contains(modelId)) {
            throw new IllegalArgumentException(String.format("Circular model reference %s", modelId));
        }
        this.loadingModels.add(modelId);
    }

    private void popLoading(String modelId) {
        this.loadingModels.remove(modelId);
    }

    public Model resolveModel(String modelName) {
        return this.resolveModel(modelName, null);
    }

    public Model resolveModel(String modelName, String version) {
        return this.resolveModel(new ModelIdentifier().withId(modelName).withVersion(version));
    }

    public Model resolveModel(ModelIdentifier modelIdentifier) {
        String modelPath = NamespaceManager.getPath((String)modelIdentifier.getSystem(), (String)modelIdentifier.getId());
        Model model = this.models.get(modelPath);
        if (model != null) {
            this.checkModelVersion(modelIdentifier, model);
        }
        if (model == null && this.globalCache.containsKey(modelIdentifier)) {
            model = this.globalCache.get(modelIdentifier);
            this.models.put(modelPath, model);
        }
        if (model == null) {
            model = this.buildModel(modelIdentifier);
            this.globalCache.put(modelIdentifier, model);
            this.checkModelVersion(modelIdentifier, model);
            this.models.put(modelPath, model);
            this.modelsByUri.put(model.getModelInfo().getUrl(), model);
        }
        return model;
    }

    private void checkModelVersion(ModelIdentifier modelIdentifier, Model model) {
        if (modelIdentifier.getVersion() != null && !modelIdentifier.getVersion().equals(model.getModelInfo().getVersion())) {
            throw new IllegalArgumentException(String.format("Could not load model information for model %s, version %s because version %s is already loaded.", modelIdentifier.getId(), modelIdentifier.getVersion(), model.getModelInfo().getVersion()));
        }
    }

    public Model resolveModelByUri(String namespaceUri) {
        Model model = this.modelsByUri.get(namespaceUri);
        if (model == null) {
            throw new IllegalArgumentException(String.format("Could not resolve model with namespace %s", namespaceUri));
        }
        return model;
    }
}

