/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.ForwardInvocationResult;
import org.cqframework.cql.cql2elm.model.CallContext;
import org.cqframework.cql.cql2elm.model.Conversion;
import org.cqframework.cql.cql2elm.model.ConversionMap;
import org.cqframework.cql.cql2elm.preprocessor.FunctionDefinitionInfo;
import org.cqframework.cql.elm.tracking.Trackable;
import org.hl7.cql.model.DataType;
import org.hl7.elm.r1.FunctionDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardInvocationValidator {
    private static final Logger logger = LoggerFactory.getLogger(ForwardInvocationValidator.class);

    public static FunctionDefinitionInfo resolveOnSignature(CallContext callContextFromCaller, Iterable<FunctionDefinitionInfo> candidateFunctionDefinitions, ConversionMap conversionMap) {
        if (candidateFunctionDefinitions != null) {
            List paramTypesFromCaller = StreamSupport.stream(callContextFromCaller.getSignature().getOperandTypes().spliterator(), false).collect(Collectors.toList());
            Map<DataType, List<Conversion>> implicitConversionsPerParamType = paramTypesFromCaller.stream().distinct().collect(Collectors.toMap(Function.identity(), entry -> conversionMap.getConversions((DataType)entry).stream().filter(Conversion::isImplicit).collect(Collectors.toList())));
            ArrayList<ForwardInvocationResult> resolvedFunctionDefinitionInfos = new ArrayList<ForwardInvocationResult>();
            for (FunctionDefinitionInfo candidateFunctionDefinition : candidateFunctionDefinitions) {
                ForwardInvocationResult currentResult = ForwardInvocationValidator.scoreFunctionHeaderOrNothing(callContextFromCaller, candidateFunctionDefinition, implicitConversionsPerParamType);
                ForwardInvocationValidator.evaluateCandidateParamScores(currentResult, resolvedFunctionDefinitionInfos);
            }
            if (resolvedFunctionDefinitionInfos.size() == 0) {
                throw new CqlCompilerException("forward declaration resolution found NO functions for name:" + callContextFromCaller.getOperatorName());
            }
            if (resolvedFunctionDefinitionInfos.size() > 1) {
                throw new CqlCompilerException("forward declaration resolution found more than one functions for name:" + callContextFromCaller.getOperatorName());
            }
            return ((ForwardInvocationResult)resolvedFunctionDefinitionInfos.get(0)).getFunctionDefinitionInfo();
        }
        return null;
    }

    private static void evaluateCandidateParamScores(ForwardInvocationResult currentResult, List<ForwardInvocationResult> previousForwardInvocationResults) {
        if (currentResult.isNoMatch()) {
            return;
        }
        if (previousForwardInvocationResults.isEmpty()) {
            previousForwardInvocationResults.add(currentResult);
            return;
        }
        if (previousForwardInvocationResults.stream().map(ForwardInvocationResult::getScores).anyMatch(scores -> ((int[])scores).length != currentResult.getScores().length)) {
            return;
        }
        Boolean allScoresLessThanOrEqual = null;
        Boolean isPrevMatchScoreLessThanOrEqual = null;
        for (int index = 0; index < currentResult.getScores().length; ++index) {
            int currentScore = currentResult.getScores()[index];
            List previousScoresForPreviousResults = previousForwardInvocationResults.stream().map(ForwardInvocationResult::getScores).collect(Collectors.toList());
            for (int[] previousScores : previousScoresForPreviousResults) {
                boolean isScoreLessThanOrEqual;
                boolean bl = isScoreLessThanOrEqual = currentScore <= previousScores[index];
                allScoresLessThanOrEqual = allScoresLessThanOrEqual == null ? Boolean.valueOf(isScoreLessThanOrEqual) : Boolean.valueOf(isScoreLessThanOrEqual && allScoresLessThanOrEqual != false);
                if (isPrevMatchScoreLessThanOrEqual != null && isPrevMatchScoreLessThanOrEqual != isScoreLessThanOrEqual) {
                    throw new CqlCompilerException("Cannot resolve forward declaration for function call:" + currentResult.getFunctionDefinitionInfo().getName());
                }
                isPrevMatchScoreLessThanOrEqual = isScoreLessThanOrEqual;
            }
        }
        if (allScoresLessThanOrEqual != null && allScoresLessThanOrEqual.booleanValue()) {
            previousForwardInvocationResults.clear();
            previousForwardInvocationResults.add(currentResult);
        }
    }

    public static ForwardInvocationResult scoreFunctionHeaderOrNothing(CallContext callContextFromCaller, FunctionDefinitionInfo candidateFunctionDefinition, Map<DataType, List<Conversion>> implicitConversionsPerParamType) {
        FunctionDef functionDefFromCandidate = candidateFunctionDefinition.getPreCompileOutput().getFunctionDef();
        if (!callContextFromCaller.getOperatorName().equals(functionDefFromCandidate.getName())) {
            return ForwardInvocationResult.noMatch(candidateFunctionDefinition);
        }
        List paramTypesFromCaller = StreamSupport.stream(callContextFromCaller.getSignature().getOperandTypes().spliterator(), false).collect(Collectors.toList());
        List paramTypesFromCandidate = functionDefFromCandidate.getOperand().stream().map(Trackable::getResultType).collect(Collectors.toList());
        if (paramTypesFromCaller.size() != paramTypesFromCandidate.size()) {
            return ForwardInvocationResult.noMatch(candidateFunctionDefinition);
        }
        int[] scores = new int[paramTypesFromCaller.size()];
        for (int index = 0; index < paramTypesFromCaller.size(); ++index) {
            int score;
            DataType dataTypeFromCaller = (DataType)paramTypesFromCaller.get(index);
            DataType dataTypeFromCandidate = (DataType)paramTypesFromCandidate.get(index);
            scores[index] = score = ForwardInvocationValidator.compareEachMethodParam(dataTypeFromCaller, dataTypeFromCandidate, implicitConversionsPerParamType);
        }
        return new ForwardInvocationResult(candidateFunctionDefinition, scores);
    }

    private static int compareEachMethodParam(DataType dataTypeFromCaller, DataType dataTypeFromCandidate, Map<DataType, List<Conversion>> implicitConversionsPerParamType) {
        if (dataTypeFromCaller.isCompatibleWith(dataTypeFromCandidate)) {
            return Integer.MIN_VALUE;
        }
        return ForwardInvocationValidator.handleImplicitConversion(dataTypeFromCaller, dataTypeFromCandidate, implicitConversionsPerParamType);
    }

    private static int handleImplicitConversion(DataType dataTypeFromCaller, DataType dataTypeFromCandidate, Map<DataType, List<Conversion>> implicitConversionsPerParamType) {
        List<Conversion> conversions = implicitConversionsPerParamType.get(dataTypeFromCaller);
        List conversionsMatchingToType = conversions.stream().filter(conv -> conv.getToType().equals(dataTypeFromCandidate)).collect(Collectors.toList());
        if (conversionsMatchingToType.size() != 1) {
            return Integer.MAX_VALUE;
        }
        return ((Conversion)conversionsMatchingToType.get(0)).getScore();
    }
}

