/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.ModelResolver;
import org.cqframework.cql.cql2elm.model.Model;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.NamedType;
import org.hl7.cql.model.TupleType;
import org.hl7.cql.model.TupleTypeElement;
import org.hl7.cql.model.TypeParameter;
import org.hl7.elm.r1.ObjectFactory;
import org.hl7.elm.r1.ParameterTypeSpecifier;
import org.hl7.elm.r1.TupleElementDefinition;
import org.hl7.elm.r1.TypeSpecifier;
import org.hl7.elm_modelinfo.r1.ModelInfo;

public class TypeBuilder {
    private ObjectFactory of;
    private ModelResolver mr;

    public TypeBuilder(ObjectFactory of, ModelResolver mr) {
        this.of = of;
        this.mr = mr;
    }

    public TypeBuilder(ObjectFactory of, ModelManager modelManager) {
        this(of, new InternalModelResolver(modelManager));
    }

    public QName dataTypeToQName(DataType type) {
        if (type instanceof NamedType) {
            NamedType namedType = (NamedType)type;
            ModelInfo modelInfo = this.mr.getModel(namedType.getNamespace()).getModelInfo();
            return new QName(modelInfo.getTargetUrl() != null ? modelInfo.getTargetUrl() : modelInfo.getUrl(), namedType.getTarget() != null ? namedType.getTarget() : namedType.getSimpleName());
        }
        throw new IllegalArgumentException("A named type is required in this context.");
    }

    public Iterable<TypeSpecifier> dataTypesToTypeSpecifiers(Iterable<DataType> types) {
        ArrayList<TypeSpecifier> result = new ArrayList<TypeSpecifier>();
        for (DataType type : types) {
            result.add(this.dataTypeToTypeSpecifier(type));
        }
        return result;
    }

    public TypeSpecifier dataTypeToTypeSpecifier(DataType type) {
        if (type instanceof NamedType) {
            return (TypeSpecifier)this.of.createNamedTypeSpecifier().withName(this.dataTypeToQName(type)).withResultType(type);
        }
        if (type instanceof ListType) {
            return this.listTypeToTypeSpecifier((ListType)type);
        }
        if (type instanceof IntervalType) {
            return this.intervalTypeToTypeSpecifier((IntervalType)type);
        }
        if (type instanceof TupleType) {
            return this.tupleTypeToTypeSpecifier((TupleType)type);
        }
        if (type instanceof ChoiceType) {
            return this.choiceTypeToTypeSpecifier((ChoiceType)type);
        }
        if (type instanceof TypeParameter) {
            return this.typeParameterToTypeSpecifier((TypeParameter)type);
        }
        throw new IllegalArgumentException(String.format("Could not convert type %s to a type specifier.", type));
    }

    private TypeSpecifier listTypeToTypeSpecifier(ListType type) {
        return (TypeSpecifier)this.of.createListTypeSpecifier().withElementType(this.dataTypeToTypeSpecifier(type.getElementType())).withResultType((DataType)type);
    }

    private TypeSpecifier intervalTypeToTypeSpecifier(IntervalType type) {
        return (TypeSpecifier)this.of.createIntervalTypeSpecifier().withPointType(this.dataTypeToTypeSpecifier(type.getPointType())).withResultType((DataType)type);
    }

    private TypeSpecifier tupleTypeToTypeSpecifier(TupleType type) {
        return (TypeSpecifier)this.of.createTupleTypeSpecifier().withElement(this.tupleTypeElementsToTupleElementDefinitions(type.getElements())).withResultType((DataType)type);
    }

    private TupleElementDefinition[] tupleTypeElementsToTupleElementDefinitions(Iterable<TupleTypeElement> elements) {
        ArrayList<TupleElementDefinition> definitions = new ArrayList<TupleElementDefinition>();
        for (TupleTypeElement element : elements) {
            definitions.add(this.of.createTupleElementDefinition().withName(element.getName()).withElementType(this.dataTypeToTypeSpecifier(element.getType())));
        }
        return definitions.toArray(new TupleElementDefinition[definitions.size()]);
    }

    private TypeSpecifier choiceTypeToTypeSpecifier(ChoiceType type) {
        return (TypeSpecifier)this.of.createChoiceTypeSpecifier().withChoice(this.choiceTypeTypesToTypeSpecifiers(type)).withResultType((DataType)type);
    }

    private TypeSpecifier[] choiceTypeTypesToTypeSpecifiers(ChoiceType choiceType) {
        ArrayList<TypeSpecifier> specifiers = new ArrayList<TypeSpecifier>();
        for (DataType type : choiceType.getTypes()) {
            specifiers.add(this.dataTypeToTypeSpecifier(type));
        }
        return specifiers.toArray(new TypeSpecifier[specifiers.size()]);
    }

    private TypeSpecifier typeParameterToTypeSpecifier(TypeParameter type) {
        return new ParameterTypeSpecifier().withParameterName(type.getIdentifier());
    }

    public static class InternalModelResolver
    implements ModelResolver {
        private ModelManager modelManager;

        public InternalModelResolver(ModelManager modelManager) {
            this.modelManager = modelManager;
        }

        @Override
        public Model getModel(String modelName) {
            return this.modelManager.resolveModel(modelName);
        }
    }
}

