/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.cql2elm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.cqframework.cql.cql2elm.Cql2ElmVisitor;
import org.cqframework.cql.cql2elm.CqlCompilerException;
import org.cqframework.cql.cql2elm.CqlCompilerOptions;
import org.cqframework.cql.cql2elm.CqlSyntaxException;
import org.cqframework.cql.cql2elm.LibraryBuilder;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.StringEscapeUtils;
import org.cqframework.cql.cql2elm.elm.ElmEdit;
import org.cqframework.cql.cql2elm.elm.ElmEditor;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.cqframework.cql.cql2elm.preprocessor.CqlPreprocessor;
import org.cqframework.cql.elm.IdObjectFactory;
import org.cqframework.cql.elm.tracking.TrackBack;
import org.cqframework.cql.gen.cqlLexer;
import org.cqframework.cql.gen.cqlParser;
import org.hl7.cql.model.NamespaceAware;
import org.hl7.cql.model.NamespaceInfo;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.ObjectFactory;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.VersionedIdentifier;

public class CqlCompiler {
    private Library library = null;
    private CompiledLibrary compiledLibrary = null;
    private Object visitResult = null;
    private List<Retrieve> retrieves = null;
    private List<CqlCompilerException> exceptions = null;
    private List<CqlCompilerException> errors = null;
    private List<CqlCompilerException> warnings = null;
    private List<CqlCompilerException> messages = null;
    private final VersionedIdentifier sourceInfo;
    private final NamespaceInfo namespaceInfo;
    private final LibraryManager libraryManager;

    public CqlCompiler(LibraryManager libraryManager) {
        this(null, null, libraryManager);
    }

    public CqlCompiler(NamespaceInfo namespaceInfo, LibraryManager libraryManager) {
        this(namespaceInfo, null, libraryManager);
    }

    public CqlCompiler(NamespaceInfo namespaceInfo, VersionedIdentifier sourceInfo, LibraryManager libraryManager) {
        this.namespaceInfo = namespaceInfo;
        this.libraryManager = libraryManager;
        this.sourceInfo = sourceInfo == null ? new VersionedIdentifier().withId("Anonymous").withSystem("text/cql") : sourceInfo;
        if (this.namespaceInfo != null) {
            libraryManager.getNamespaceManager().ensureNamespaceRegistered(this.namespaceInfo);
        }
        if (libraryManager.getNamespaceManager().hasNamespaces() && libraryManager.getLibrarySourceLoader() instanceof NamespaceAware) {
            ((NamespaceAware)libraryManager.getLibrarySourceLoader()).setNamespaceManager(libraryManager.getNamespaceManager());
        }
    }

    public Library getLibrary() {
        return this.library;
    }

    public CompiledLibrary getCompiledLibrary() {
        return this.compiledLibrary;
    }

    public Object toObject() {
        return this.visitResult;
    }

    public List<Retrieve> toRetrieves() {
        return this.retrieves;
    }

    public Map<VersionedIdentifier, CompiledLibrary> getCompiledLibraries() {
        return this.libraryManager.getCompiledLibraries();
    }

    public Map<VersionedIdentifier, Library> getLibraries() {
        HashMap<VersionedIdentifier, Library> result = new HashMap<VersionedIdentifier, Library>();
        for (VersionedIdentifier id : this.libraryManager.getCompiledLibraries().keySet()) {
            result.put(id, this.libraryManager.getCompiledLibraries().get(id).getLibrary());
        }
        return result;
    }

    public List<CqlCompilerException> getExceptions() {
        return this.exceptions;
    }

    public List<CqlCompilerException> getErrors() {
        return this.errors;
    }

    public List<CqlCompilerException> getWarnings() {
        return this.warnings;
    }

    public List<CqlCompilerException> getMessages() {
        return this.messages;
    }

    public Library run(File cqlFile) throws IOException {
        return this.run(CharStreams.fromStream((InputStream)new FileInputStream(cqlFile)));
    }

    public Library run(String cqlText) {
        return this.run((CharStream)CharStreams.fromString((String)cqlText));
    }

    public Library run(InputStream is) throws IOException {
        return this.run(CharStreams.fromStream((InputStream)is));
    }

    public Library run(CharStream is) {
        this.exceptions = new ArrayList<CqlCompilerException>();
        this.errors = new ArrayList<CqlCompilerException>();
        this.warnings = new ArrayList<CqlCompilerException>();
        this.messages = new ArrayList<CqlCompilerException>();
        Set<CqlCompilerOptions.Options> options = this.libraryManager.getCqlCompilerOptions().getOptions();
        LibraryBuilder builder = new LibraryBuilder(this.namespaceInfo, this.libraryManager, (ObjectFactory)new IdObjectFactory());
        CqlErrorListener errorListener = new CqlErrorListener(builder, options.contains((Object)CqlCompilerOptions.Options.EnableDetailedErrors));
        cqlLexer lexer = new cqlLexer(is);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        cqlParser parser = new cqlParser((TokenStream)tokens);
        parser.setBuildParseTree(true);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        cqlParser.LibraryContext tree = parser.library();
        CqlPreprocessor preprocessor = new CqlPreprocessor(builder, (TokenStream)tokens);
        preprocessor.visit((ParseTree)tree);
        Cql2ElmVisitor visitor = new Cql2ElmVisitor(builder, (TokenStream)tokens, preprocessor.getLibraryInfo());
        this.visitResult = visitor.visit((ParseTree)tree);
        this.library = builder.getLibrary();
        List<ElmEdit> edits = this.allNonNull(!options.contains((Object)CqlCompilerOptions.Options.EnableAnnotations) ? ElmEdit.REMOVE_ANNOTATION : null, !options.contains((Object)CqlCompilerOptions.Options.EnableResultTypes) ? ElmEdit.REMOVE_RESULT_TYPE : null, !options.contains((Object)CqlCompilerOptions.Options.EnableLocators) ? ElmEdit.REMOVE_LOCATOR : null);
        new ElmEditor(edits).edit(this.library);
        this.compiledLibrary = builder.getCompiledLibrary();
        this.retrieves = visitor.getRetrieves();
        this.exceptions.addAll(builder.getExceptions());
        this.errors.addAll(builder.getErrors());
        this.warnings.addAll(builder.getWarnings());
        this.messages.addAll(builder.getMessages());
        return this.library;
    }

    private List<ElmEdit> allNonNull(ElmEdit ... ts) {
        return Arrays.stream(ts).filter(x -> x != null).collect(Collectors.toList());
    }

    private class CqlErrorListener
    extends BaseErrorListener {
        private LibraryBuilder builder;
        private boolean detailedErrors;

        public CqlErrorListener(LibraryBuilder builder, boolean detailedErrors) {
            this.builder = builder;
            this.detailedErrors = detailedErrors;
        }

        private VersionedIdentifier extractLibraryIdentifier(cqlParser parser) {
            cqlParser.LibraryDefinitionContext ldc;
            ParserRuleContext context = parser.getContext();
            while (context != null && !(context instanceof cqlParser.LibraryContext)) {
                context = context.parent;
            }
            if (context instanceof cqlParser.LibraryContext && (ldc = ((cqlParser.LibraryContext)context).libraryDefinition()) != null && ldc.qualifiedIdentifier() != null && ldc.qualifiedIdentifier().identifier() != null) {
                return new VersionedIdentifier().withId(StringEscapeUtils.unescapeCql(ldc.qualifiedIdentifier().identifier().getText()));
            }
            return null;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            VersionedIdentifier libraryIdentifier = this.builder.getLibraryIdentifier();
            if (libraryIdentifier == null) {
                if (recognizer instanceof cqlParser) {
                    libraryIdentifier = this.extractLibraryIdentifier((cqlParser)recognizer);
                }
                if (libraryIdentifier == null) {
                    libraryIdentifier = CqlCompiler.this.sourceInfo;
                }
            }
            TrackBack trackback = new TrackBack(libraryIdentifier, line, charPositionInLine, line, charPositionInLine);
            if (this.detailedErrors) {
                this.builder.recordParsingException(new CqlSyntaxException(msg, trackback, (Throwable)e));
                this.builder.recordParsingException(new CqlCompilerException(msg, trackback, (Throwable)e));
            } else if (offendingSymbol instanceof CommonToken) {
                CommonToken token = (CommonToken)offendingSymbol;
                this.builder.recordParsingException(new CqlSyntaxException(String.format("Syntax error at %s", token.getText()), trackback, (Throwable)e));
            } else {
                this.builder.recordParsingException(new CqlSyntaxException("Syntax error", trackback, (Throwable)e));
            }
        }
    }
}

