grammar test;

statement : expression (',' expression)*;

expression : identifier | literal;

identifier : QUOTEDIDENTIFIER;

literal : stringLiteral | quantityLiteral | dateTimeLiteral | timeLiteral;

stringLiteral : STRING;
quantityLiteral : QUANTITY;
dateTimeLiteral : DATETIME;
timeLiteral : TIME;

IDENTIFIER
    : ([A-Za-z] | '_')([A-Za-z0-9] | '_')*
    ;

QUANTITY
    : [0-9]+('.'[0-9]+)?
    ;

DATETIME
    : '@'
        [0-9][0-9][0-9][0-9] // year
        (
            '-'[0-9][0-9] // month
            (
                '-'[0-9][0-9] // day
                (
                    'T'
                        [0-9][0-9] (':'[0-9][0-9] (':'[0-9][0-9] ('.'[0-9]+)?)?)?
                        (('+' | '-') [0-9][0-9]':'[0-9][0-9])? // timezone
                )?
             )?
         )?
         'Z'? // UTC specifier
    ;

TIME
    : '@'
        'T'
            [0-9][0-9] (':'[0-9][0-9] (':'[0-9][0-9] ('.'[0-9]+)?)?)?
            ('Z' | (('+' | '-') [0-9][0-9]':'[0-9][0-9]))? // timezone
    ;

QUOTEDIDENTIFIER
    : '"' (ESC | .)* '"'
    ;

STRING
    : '\'' (ESC | .)* '\''
    ;


//STRING : '"' ( ESC | . )*? '"';
//fragment ESC : '\\\\' | '\\"';
//fragment ESC : '\\' [btnr"\\];

fragment ESC
    : '\\' (["'\\/fnrt] | UNICODE) // allow \", \', \\, \/, \f, etc. and \uXXX
    ;

fragment UNICODE
    : 'u' HEX HEX HEX HEX
    ;

fragment HEX
    : [0-9a-fA-F]
    ;

WS
    : (' ' | '\r' | '\t') -> channel(HIDDEN)
    ;

NEWLINE
    : ('\n') -> channel(HIDDEN)
    ;

COMMENT
    : '/*' .*? '*/' -> channel(HIDDEN)
    ;

LINE_COMMENT
    :   '//' ~[\r\n]* -> channel(HIDDEN)
    ;

