/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import java.util.LinkedHashSet;
import java.util.Set;
import org.cqframework.cql.elm.requirements.ComparableElmRequirement;
import org.cqframework.cql.elm.requirements.ElmCloner;
import org.cqframework.cql.elm.requirements.ElmConditionRequirement;
import org.cqframework.cql.elm.requirements.ElmConjunctiveRequirement;
import org.cqframework.cql.elm.requirements.ElmExpressionRequirement;
import org.cqframework.cql.elm.requirements.ElmJoinRequirement;
import org.cqframework.cql.elm.requirements.ElmPropertyRequirement;
import org.cqframework.cql.elm.requirements.ElmQueryRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirementsContext;
import org.hl7.cql.model.ClassType;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.SearchType;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.CodeFilterElement;
import org.hl7.elm.r1.DateFilterElement;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.End;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.IncludeElement;
import org.hl7.elm.r1.Interval;
import org.hl7.elm.r1.LetClause;
import org.hl7.elm.r1.Null;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.Search;
import org.hl7.elm.r1.Start;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.elm.r1.With;

public class ElmDataRequirement
extends ElmExpressionRequirement {
    private Retrieve inferredFrom;
    private Element querySource;
    private Set<Property> propertySet;
    private ElmConjunctiveRequirement conjunctiveRequirement;

    public ElmDataRequirement(VersionedIdentifier libraryIdentifier, Retrieve element) {
        super(libraryIdentifier, (Expression)element);
    }

    public ElmDataRequirement(VersionedIdentifier libraryIdentifier, Retrieve element, Retrieve inferredFrom) {
        super(libraryIdentifier, (Expression)element);
        this.inferredFrom = inferredFrom;
    }

    public Retrieve getRetrieve() {
        return (Retrieve)this.element;
    }

    public Retrieve getElement() {
        return this.getRetrieve();
    }

    public Retrieve getInferredFrom() {
        return this.inferredFrom;
    }

    public Element getQuerySource() {
        return this.querySource;
    }

    public void setQuerySource(Element querySource) {
        this.querySource = querySource;
    }

    public String getAlias() {
        if (this.querySource instanceof AliasedQuerySource) {
            return ((AliasedQuerySource)this.querySource).getAlias();
        }
        if (this.querySource instanceof LetClause) {
            return ((LetClause)this.querySource).getIdentifier();
        }
        throw new IllegalArgumentException("Cannot determine alias from data requirement because source is not an AliasedQuerySource or LetClause");
    }

    @Override
    public Expression getExpression() {
        if (this.querySource instanceof AliasedQuerySource) {
            return ((AliasedQuerySource)this.querySource).getExpression();
        }
        if (this.querySource instanceof LetClause) {
            return ((LetClause)this.querySource).getExpression();
        }
        throw new IllegalArgumentException("Cannot determine expression for data requirement because source is not an AliasedQuerySource or LetClause");
    }

    private static ElmDataRequirement inferFrom(ElmDataRequirement requirement) {
        Retrieve inferredRetrieve = ElmCloner.clone(requirement.getRetrieve());
        ElmDataRequirement result = new ElmDataRequirement(requirement.libraryIdentifier, inferredRetrieve, requirement.getRetrieve());
        result.propertySet = requirement.propertySet;
        return result;
    }

    private static ElmDataRequirement inferFrom(ElmQueryRequirement requirement) {
        ElmDataRequirement singleSourceRequirement = null;
        for (ElmDataRequirement dataRequirement : requirement.getDataRequirements()) {
            if (singleSourceRequirement == null) {
                singleSourceRequirement = dataRequirement;
                continue;
            }
            singleSourceRequirement = null;
            break;
        }
        if (singleSourceRequirement != null) {
            return ElmDataRequirement.inferFrom(singleSourceRequirement);
        }
        return new ElmDataRequirement(requirement.libraryIdentifier, ElmDataRequirement.getRetrieve((Expression)requirement.getQuery()));
    }

    public static ElmDataRequirement inferFrom(ElmExpressionRequirement requirement) {
        if (requirement instanceof ElmDataRequirement) {
            return ElmDataRequirement.inferFrom((ElmDataRequirement)requirement);
        }
        if (requirement instanceof ElmQueryRequirement) {
            return ElmDataRequirement.inferFrom((ElmQueryRequirement)requirement);
        }
        return new ElmDataRequirement(requirement.libraryIdentifier, ElmDataRequirement.getRetrieve(requirement.getExpression()));
    }

    private static Retrieve getRetrieve(Expression expression) {
        return (Retrieve)new Retrieve().withLocalId(expression.getLocalId()).withLocator(expression.getLocator()).withResultTypeName(expression.getResultTypeName()).withResultTypeSpecifier(expression.getResultTypeSpecifier()).withResultType(expression.getResultType());
    }

    public Iterable<Property> getProperties() {
        return this.propertySet;
    }

    public void addProperty(Property property) {
        if (this.propertySet == null) {
            this.propertySet = new LinkedHashSet<Property>();
        }
        this.propertySet.add(property);
    }

    public void reportProperty(ElmPropertyRequirement propertyRequirement) {
        if (this.propertySet == null) {
            this.propertySet = new LinkedHashSet<Property>();
        }
        this.propertySet.add(propertyRequirement.getProperty());
    }

    public ElmConjunctiveRequirement getConjunctiveRequirement() {
        this.ensureConjunctiveRequirement();
        return this.conjunctiveRequirement;
    }

    private void ensureConjunctiveRequirement() {
        if (this.conjunctiveRequirement == null) {
            this.conjunctiveRequirement = new ElmConjunctiveRequirement(this.libraryIdentifier, (Expression)new Null());
        }
    }

    public void addConditionRequirement(ElmConditionRequirement conditionRequirement) {
        this.ensureConjunctiveRequirement();
        this.conjunctiveRequirement.combine(conditionRequirement);
    }

    public void addJoinRequirement(ElmJoinRequirement joinRequirement) {
        this.ensureConjunctiveRequirement();
        this.conjunctiveRequirement.combine(joinRequirement);
    }

    private void extractStatedRequirements(Retrieve retrieve) {
        if (retrieve.getIdProperty() != null || retrieve.getIdSearch() != null) {
            // empty if block
        }
        if (retrieve.getCodeProperty() != null || retrieve.getCodeSearch() != null) {
            // empty if block
        }
        if (retrieve.getDateProperty() != null || retrieve.getDateSearch() != null || retrieve.getDateLowProperty() != null || retrieve.getDateHighProperty() != null) {
            // empty if block
        }
    }

    private void applyConditionRequirementTo(ElmConditionRequirement conditionRequirement, Retrieve retrieve, ElmRequirementsContext context) {
        if (retrieve.getDataType() == null) {
            return;
        }
        if (!conditionRequirement.isTargetable()) {
            return;
        }
        Property property = conditionRequirement.getProperty().getProperty();
        DataType comparisonType = conditionRequirement.getComparand().getExpression().getResultType();
        if (comparisonType != null) {
            if (context.getTypeResolver().isTerminologyType(comparisonType)) {
                CodeFilterElement codeFilter = new CodeFilterElement();
                if (property instanceof Search) {
                    codeFilter.setSearch(property.getPath());
                } else {
                    codeFilter.setProperty(property.getPath());
                }
                switch (conditionRequirement.getElement().getClass().getSimpleName()) {
                    case "Equal": {
                        codeFilter.setComparator("=");
                        break;
                    }
                    case "Equivalent": {
                        codeFilter.setComparator("~");
                        break;
                    }
                    case "In": 
                    case "InValueSet": 
                    case "AnyInValueSet": {
                        codeFilter.setComparator("in");
                    }
                }
                if (codeFilter.getComparator() != null && conditionRequirement.isTargetable()) {
                    codeFilter.setValue(conditionRequirement.getComparand().getExpression());
                    if (!ComparableElmRequirement.hasCodeFilter(retrieve.getCodeFilter(), codeFilter)) {
                        retrieve.getCodeFilter().add(codeFilter);
                    }
                }
            } else if (context.getTypeResolver().isDateType(comparisonType)) {
                DateFilterElement dateFilter = new DateFilterElement();
                if (property instanceof Search) {
                    dateFilter.setSearch(property.getPath());
                } else {
                    dateFilter.setProperty(property.getPath());
                }
                Expression comparand = conditionRequirement.getComparand().getExpression();
                if (conditionRequirement.isTargetable()) {
                    if (context.getTypeResolver().isIntervalType(comparisonType)) {
                        switch (conditionRequirement.getElement().getClass().getSimpleName()) {
                            case "Equal": 
                            case "Equivalent": 
                            case "SameAs": 
                            case "In": 
                            case "IncludedIn": {
                                dateFilter.setValue(comparand);
                                break;
                            }
                            case "Before": {
                                dateFilter.setValue((Expression)new Interval().withLowClosed(Boolean.valueOf(true)).withHigh((Expression)new Start().withOperand(comparand)).withHighClosed(Boolean.valueOf(false)));
                                break;
                            }
                            case "SameOrBefore": {
                                dateFilter.setValue((Expression)new Interval().withLowClosed(Boolean.valueOf(true)).withHigh((Expression)new Start().withOperand(comparand)).withHighClosed(Boolean.valueOf(true)));
                                break;
                            }
                            case "After": {
                                dateFilter.setValue((Expression)new Interval().withLow((Expression)new End().withOperand(comparand)).withLowClosed(Boolean.valueOf(false)).withHighClosed(Boolean.valueOf(true)));
                                break;
                            }
                            case "SameOrAfter": {
                                dateFilter.setValue((Expression)new Interval().withLow((Expression)new End().withOperand(comparand)).withLowClosed(Boolean.valueOf(true)).withHighClosed(Boolean.valueOf(true)));
                                break;
                            }
                        }
                    } else {
                        switch (conditionRequirement.getElement().getClass().getSimpleName()) {
                            case "Equal": 
                            case "Equivalent": 
                            case "SameAs": {
                                dateFilter.setValue((Expression)new Interval().withLow(comparand).withLowClosed(Boolean.valueOf(true)).withHigh(comparand).withHighClosed(Boolean.valueOf(true)));
                                break;
                            }
                            case "Less": 
                            case "Before": {
                                dateFilter.setValue((Expression)new Interval().withLowClosed(Boolean.valueOf(true)).withHigh(comparand).withHighClosed(Boolean.valueOf(false)));
                                break;
                            }
                            case "LessOrEqual": 
                            case "SameOrBefore": {
                                dateFilter.setValue((Expression)new Interval().withLowClosed(Boolean.valueOf(true)).withHigh(comparand).withHighClosed(Boolean.valueOf(true)));
                                break;
                            }
                            case "Greater": 
                            case "After": {
                                dateFilter.setValue((Expression)new Interval().withLow(comparand).withLowClosed(Boolean.valueOf(false)).withHighClosed(Boolean.valueOf(true)));
                                break;
                            }
                            case "GreaterOrEqual": 
                            case "SameOrAfter": {
                                dateFilter.setValue((Expression)new Interval().withLow(comparand).withLowClosed(Boolean.valueOf(true)).withHighClosed(Boolean.valueOf(true)));
                            }
                        }
                    }
                }
                if (dateFilter.getValue() != null && !ComparableElmRequirement.hasDateFilter(retrieve.getDateFilter(), dateFilter)) {
                    retrieve.getDateFilter().add(dateFilter);
                }
            }
        }
    }

    private ClassType getRetrieveType(ElmRequirementsContext context, Retrieve retrieve) {
        DataType elementType;
        DataType dataType = elementType = retrieve.getResultType() instanceof ListType ? ((ListType)retrieve.getResultType()).getElementType() : retrieve.getResultType();
        if (elementType instanceof ClassType) {
            return (ClassType)elementType;
        }
        return null;
    }

    private void applyJoinRequirementTo(ElmJoinRequirement joinRequirement, Retrieve retrieve, ElmRequirementsContext context, ElmQueryRequirement queryRequirements) {
        ElmDataRequirement leftRequirement = queryRequirements.getDataRequirement(joinRequirement.getLeftProperty().getSource());
        ElmDataRequirement rightRequirement = queryRequirements.getDataRequirement(joinRequirement.getRightProperty().getSource());
        if (leftRequirement != null && rightRequirement != null) {
            Retrieve leftRetrieve = leftRequirement.getRetrieve();
            Retrieve rightRetrieve = rightRequirement.getRetrieve();
            if (leftRetrieve.getDataType() != null && rightRetrieve.getDataType() != null) {
                ClassType leftRetrieveType = this.getRetrieveType(context, leftRetrieve);
                ClassType rightRetrieveType = this.getRetrieveType(context, rightRetrieve);
                if (leftRetrieveType != null && rightRetrieveType != null) {
                    for (SearchType search : leftRetrieveType.getSearches()) {
                        if (!joinRequirement.getLeftProperty().getProperty().getPath().startsWith(search.getPath()) || !search.getType().isCompatibleWith((DataType)rightRetrieveType)) continue;
                        SearchType leftSearch = search;
                        break;
                    }
                    for (SearchType search : rightRetrieveType.getSearches()) {
                        if (!joinRequirement.getRightProperty().getProperty().getPath().startsWith(search.getPath()) || !search.getType().isCompatibleWith((DataType)leftRetrieveType)) continue;
                        SearchType rightSearch = search;
                        break;
                    }
                }
                if (leftRetrieve.getLocalId() == null) {
                    leftRetrieve.setLocalId(context.generateLocalId());
                }
                if (rightRetrieve.getLocalId() == null) {
                    rightRetrieve.setLocalId(context.generateLocalId());
                }
                if (rightRequirement.getQuerySource() instanceof With) {
                    leftRetrieve.getInclude().add(new IncludeElement().withIncludeFrom(rightRetrieve.getLocalId()).withRelatedDataType(rightRetrieve.getDataType()).withRelatedProperty(joinRequirement.getLeftProperty().getProperty().getPath()).withIsReverse(Boolean.valueOf(false)));
                    rightRetrieve.setIncludedIn(leftRetrieve.getLocalId());
                } else {
                    rightRetrieve.getInclude().add(new IncludeElement().withIncludeFrom(leftRetrieve.getLocalId()).withRelatedDataType(leftRetrieve.getDataType()).withRelatedProperty(joinRequirement.getRightProperty().getProperty().getPath()).withIsReverse(Boolean.valueOf(false)));
                    leftRetrieve.setIncludedIn(rightRetrieve.getLocalId());
                }
            }
        }
    }

    private void applyTo(Retrieve retrieve, ElmRequirementsContext context, ElmQueryRequirement queryRequirements) {
        for (ElmExpressionRequirement conditionRequirement : this.getConjunctiveRequirement().getArguments()) {
            if (conditionRequirement instanceof ElmConditionRequirement) {
                this.applyConditionRequirementTo((ElmConditionRequirement)conditionRequirement, retrieve, context);
                continue;
            }
            if (!(conditionRequirement instanceof ElmJoinRequirement)) continue;
            this.applyJoinRequirementTo((ElmJoinRequirement)conditionRequirement, retrieve, context, queryRequirements);
        }
    }

    public void applyDataRequirements(ElmRequirementsContext context, ElmQueryRequirement queryRequirements) {
        this.extractStatedRequirements(this.getRetrieve());
        this.applyTo(this.getRetrieve(), context, queryRequirements);
    }
}

