/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.model.Model;
import org.hl7.cql.model.ChoiceType;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.TupleType;
import org.hl7.cql.model.TupleTypeElement;
import org.hl7.elm.r1.ChoiceTypeSpecifier;
import org.hl7.elm.r1.IntervalTypeSpecifier;
import org.hl7.elm.r1.ListTypeSpecifier;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.hl7.elm.r1.TupleElementDefinition;
import org.hl7.elm.r1.TupleTypeSpecifier;
import org.hl7.elm.r1.TypeSpecifier;

public class TypeResolver {
    private LibraryManager libraryManager;
    private DataType stringType;
    private DataType codeType;
    private DataType conceptType;
    private DataType valueSetType;
    private DataType codeSystemType;
    private DataType dateType;
    private DataType dateTimeType;
    private DataType timeType;
    private DataType booleanType;
    private DataType integerType;
    private DataType decimalType;
    private DataType quantityType;

    public TypeResolver(LibraryManager libraryManager) {
        if (libraryManager == null) {
            throw new IllegalArgumentException("libraryManager is required");
        }
        this.libraryManager = libraryManager;
    }

    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public DataType resolveTypeName(QName typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is required");
        }
        if (typeName.getNamespaceURI() == null || typeName.getNamespaceURI().equals("")) {
            throw new IllegalArgumentException("namespaceURI is required");
        }
        Model model = this.libraryManager.getModelManager().resolveModelByUri(typeName.getNamespaceURI());
        DataType result = model.resolveTypeName(typeName.getLocalPart());
        if (result == null) {
            throw new IllegalArgumentException(String.format("Could not resolve type %s", typeName.toString()));
        }
        return result;
    }

    public DataType resolveTypeSpecifier(TypeSpecifier typeSpecifier) {
        if (typeSpecifier == null) {
            throw new IllegalArgumentException("typeSpecifier is required");
        }
        if (typeSpecifier.getResultType() != null) {
            return typeSpecifier.getResultType();
        }
        if (typeSpecifier instanceof NamedTypeSpecifier) {
            return this.resolveNamedTypeSpecifier((NamedTypeSpecifier)typeSpecifier);
        }
        if (typeSpecifier instanceof TupleTypeSpecifier) {
            return this.resolveTupleTypeSpecifier((TupleTypeSpecifier)typeSpecifier);
        }
        if (typeSpecifier instanceof IntervalTypeSpecifier) {
            return this.resolveIntervalTypeSpecifier((IntervalTypeSpecifier)typeSpecifier);
        }
        if (typeSpecifier instanceof ListTypeSpecifier) {
            return this.resolveListTypeSpecifier((ListTypeSpecifier)typeSpecifier);
        }
        if (typeSpecifier instanceof ChoiceTypeSpecifier) {
            return this.resolveChoiceTypeSpecifier((ChoiceTypeSpecifier)typeSpecifier);
        }
        throw new IllegalArgumentException(String.format("Unknown type specifier category: %s", typeSpecifier.getClass().getSimpleName()));
    }

    private DataType resolveNamedTypeSpecifier(NamedTypeSpecifier typeSpecifier) {
        return this.resolveTypeName(typeSpecifier.getName());
    }

    private DataType resolveTupleTypeSpecifier(TupleTypeSpecifier typeSpecifier) {
        TupleType tupleType = new TupleType();
        for (TupleElementDefinition element : typeSpecifier.getElement()) {
            TupleTypeElement tupleElement = new TupleTypeElement(element.getName(), this.resolveTypeSpecifier(element.getElementType()));
            tupleType.addElement(tupleElement);
        }
        return tupleType;
    }

    private DataType resolveIntervalTypeSpecifier(IntervalTypeSpecifier typeSpecifier) {
        return new IntervalType(this.resolveTypeSpecifier(typeSpecifier.getPointType()));
    }

    private DataType resolveListTypeSpecifier(ListTypeSpecifier typeSpecifier) {
        return new ListType(this.resolveTypeSpecifier(typeSpecifier.getElementType()));
    }

    private DataType resolveChoiceTypeSpecifier(ChoiceTypeSpecifier typeSpecifier) {
        ArrayList<DataType> choiceTypes = new ArrayList<DataType>();
        for (TypeSpecifier choiceType : typeSpecifier.getChoice()) {
            choiceTypes.add(this.resolveTypeSpecifier(choiceType));
        }
        return new ChoiceType(choiceTypes);
    }

    public DataType resolveTypeName(String modelName, String typeName) {
        if (modelName == null || modelName.equals("")) {
            throw new IllegalArgumentException("Unqualified type name cannot be resolved");
        }
        Model model = this.libraryManager.getModelManager().resolveModel(modelName);
        DataType result = model.resolveTypeName(typeName);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Could not resolve type %s.%s", modelName, typeName));
        }
        return result;
    }

    public DataType getStringType() {
        if (this.stringType == null) {
            this.stringType = this.resolveTypeName("System", "String");
        }
        return this.stringType;
    }

    public DataType getCodeType() {
        if (this.codeType == null) {
            this.codeType = this.resolveTypeName("System", "Code");
        }
        return this.codeType;
    }

    public DataType getConceptType() {
        if (this.conceptType == null) {
            this.conceptType = this.resolveTypeName("System", "Concept");
        }
        return this.conceptType;
    }

    public DataType getValueSetType() {
        if (this.valueSetType == null) {
            this.valueSetType = this.resolveTypeName("System", "ValueSet");
        }
        return this.valueSetType;
    }

    public DataType getCodeSystemType() {
        if (this.codeSystemType == null) {
            this.codeSystemType = this.resolveTypeName("System", "CodeSystem");
        }
        return this.codeSystemType;
    }

    public DataType getDateType() {
        if (this.dateType == null) {
            this.dateType = this.resolveTypeName("System", "Date");
        }
        return this.dateType;
    }

    public DataType getDateTimeType() {
        if (this.dateTimeType == null) {
            this.dateTimeType = this.resolveTypeName("System", "DateTime");
        }
        return this.dateTimeType;
    }

    public DataType getTimeType() {
        if (this.timeType == null) {
            this.timeType = this.resolveTypeName("System", "Time");
        }
        return this.timeType;
    }

    public DataType getBooleanType() {
        if (this.booleanType == null) {
            this.booleanType = this.resolveTypeName("System", "Boolean");
        }
        return this.booleanType;
    }

    public DataType getIntegerType() {
        if (this.integerType == null) {
            this.integerType = this.resolveTypeName("System", "Integer");
        }
        return this.integerType;
    }

    public DataType getDecimalType() {
        if (this.decimalType == null) {
            this.decimalType = this.resolveTypeName("System", "Decimal");
        }
        return this.decimalType;
    }

    public DataType getQuantityType() {
        if (this.quantityType == null) {
            this.quantityType = this.resolveTypeName("System", "Quantity");
        }
        return this.quantityType;
    }

    public boolean isTerminologyType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getCodeType()) || dataType.isSubTypeOf(this.getConceptType()) || dataType.isSubTypeOf(this.getValueSetType()) || dataType.isSubTypeOf(this.getCodeSystemType()) || dataType.isSubTypeOf(this.getStringType()) || dataType instanceof ListType && (((ListType)dataType).getElementType().isSubTypeOf(this.getCodeType()) || ((ListType)dataType).getElementType().isSubTypeOf(this.getConceptType()) || ((ListType)dataType).getElementType().isSubTypeOf(this.getStringType()));
        }
        return false;
    }

    public boolean isDateType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getDateType()) || dataType.isSubTypeOf(this.getDateTimeType()) || dataType instanceof IntervalType && (((IntervalType)dataType).getPointType().isSubTypeOf(this.getDateType()) || ((IntervalType)dataType).getPointType().isSubTypeOf(this.getDateTimeType()));
        }
        return false;
    }

    public boolean isDateTimeType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getDateTimeType()) || dataType instanceof IntervalType && ((IntervalType)dataType).getPointType().isSubTypeOf(this.getDateTimeType());
        }
        return false;
    }

    public boolean isTimeType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getTimeType());
        }
        return false;
    }

    public boolean isIntegerType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getIntegerType());
        }
        return false;
    }

    public boolean isDecimalType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getDecimalType());
        }
        return false;
    }

    public boolean isQuantityType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getQuantityType());
        }
        return false;
    }

    public boolean isBooleanType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getBooleanType());
        }
        return false;
    }

    public boolean isStringType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getStringType());
        }
        return false;
    }

    public boolean isListType(DataType dataType) {
        return dataType instanceof ListType;
    }

    public boolean isIntervalType(DataType dataType) {
        return dataType instanceof IntervalType;
    }

    public boolean isCodeType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getCodeType());
        }
        return false;
    }

    public boolean isConceptType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getConceptType());
        }
        return false;
    }
}

