/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import java.util.HashSet;
import java.util.Set;
import org.cqframework.cql.elm.requirements.ElmCloner;
import org.cqframework.cql.elm.requirements.ElmConditionRequirement;
import org.cqframework.cql.elm.requirements.ElmConjunctiveRequirement;
import org.cqframework.cql.elm.requirements.ElmDataRequirement;
import org.cqframework.cql.elm.requirements.ElmDisjunctiveRequirement;
import org.cqframework.cql.elm.requirements.ElmExpressionRequirement;
import org.cqframework.cql.elm.requirements.ElmJoinRequirement;
import org.cqframework.cql.elm.requirements.ElmPropertyRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirementsContext;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.LetClause;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.VersionedIdentifier;

public class ElmQueryRequirement
extends ElmExpressionRequirement {
    private Set<ElmDataRequirement> dataRequirements = new HashSet<ElmDataRequirement>();

    public ElmQueryRequirement(VersionedIdentifier libraryIdentifier, Query query) {
        super(libraryIdentifier, (Expression)query);
    }

    public Query getQuery() {
        return (Query)this.element;
    }

    public Query getElement() {
        return this.getQuery();
    }

    public Iterable<ElmDataRequirement> getDataRequirements() {
        return this.dataRequirements;
    }

    public void addDataRequirements(ElmDataRequirement dataRequirement) {
        if (dataRequirement == null) {
            throw new IllegalArgumentException("dataRequirement must be provided");
        }
        if (dataRequirement.getQuerySource() == null) {
            throw new IllegalArgumentException("Data requirement must be associated with an alias to be added to a query requirements");
        }
        this.dataRequirements.add(dataRequirement);
    }

    public ElmDataRequirement getDataRequirement(Element querySource) {
        if (querySource instanceof AliasedQuerySource) {
            return this.getDataRequirement(((AliasedQuerySource)querySource).getAlias());
        }
        if (querySource instanceof LetClause) {
            return this.getDataRequirement(((LetClause)querySource).getIdentifier());
        }
        return null;
    }

    public ElmDataRequirement getDataRequirement(String alias) {
        for (ElmDataRequirement dataRequirement : this.dataRequirements) {
            if (!dataRequirement.getAlias().equals(alias)) continue;
            return dataRequirement;
        }
        return null;
    }

    @Override
    public boolean hasRequirement(ElmRequirement requirement) {
        boolean superHasRequirement = super.hasRequirement(requirement);
        if (!superHasRequirement) {
            for (ElmDataRequirement dataRequirement : this.dataRequirements) {
                if (!dataRequirement.hasRequirement(requirement)) continue;
                return true;
            }
        }
        return superHasRequirement;
    }

    private void distributeConditionRequirement(ElmConditionRequirement requirement) {
        ElmDataRequirement dataRequirement = this.getDataRequirement(requirement.getProperty().getSource());
        if (dataRequirement != null) {
            dataRequirement.addConditionRequirement(requirement);
        }
    }

    private void distributeJoinRequirement(ElmJoinRequirement requirement) {
        ElmDataRequirement leftDataRequirement = this.getDataRequirement(requirement.getLeftProperty().getSource());
        ElmDataRequirement rightDataRequirement = this.getDataRequirement(requirement.getRightProperty().getSource());
        if (leftDataRequirement != null && rightDataRequirement != null) {
            leftDataRequirement.addJoinRequirement(requirement);
        }
    }

    private void distributeNestedConditionRequirement(ElmDataRequirement dataRequirement, String path, ElmConditionRequirement requirement) {
        Property qualifiedProperty = new Property();
        Property nestedProperty = requirement.getProperty().getProperty();
        qualifiedProperty.setPath(String.format("%s.%s", path, nestedProperty.getPath()));
        qualifiedProperty.setScope(dataRequirement.getAlias());
        qualifiedProperty.setResultType(nestedProperty.getResultType());
        qualifiedProperty.setResultTypeName(nestedProperty.getResultTypeName());
        qualifiedProperty.setResultTypeSpecifier(nestedProperty.getResultTypeSpecifier());
        ElmPropertyRequirement qualifiedPropertyRequirement = new ElmPropertyRequirement(this.libraryIdentifier, qualifiedProperty, dataRequirement.getQuerySource(), true);
        ElmConditionRequirement qualifiedCondition = new ElmConditionRequirement(this.libraryIdentifier, requirement.getExpression(), qualifiedPropertyRequirement, requirement.getComparand());
        dataRequirement.addConditionRequirement(qualifiedCondition);
    }

    private boolean distributeQueryRequirement(ElmQueryRequirement requirement, ElmRequirementsContext context) {
        if (requirement.dataRequirements.size() == 1) {
            for (ElmDataRequirement nestedAlias : requirement.dataRequirements) {
                if (nestedAlias.getExpression() instanceof Property) {
                    ElmDataRequirement aliasDataRequirement;
                    Property sourceProperty = (Property)nestedAlias.getExpression();
                    if (sourceProperty.getScope() == null || (aliasDataRequirement = this.getDataRequirement(sourceProperty.getScope())) == null || nestedAlias.getConjunctiveRequirement() == null) continue;
                    for (ElmExpressionRequirement nestedRequirement : nestedAlias.getConjunctiveRequirement().getArguments()) {
                        if (!(nestedRequirement instanceof ElmConditionRequirement)) continue;
                        this.distributeNestedConditionRequirement(aliasDataRequirement, sourceProperty.getPath(), (ElmConditionRequirement)nestedRequirement);
                        return true;
                    }
                    continue;
                }
                if (!(nestedAlias.getExpression() instanceof Retrieve)) continue;
                for (ElmExpressionRequirement nestedRequirement : nestedAlias.getConjunctiveRequirement().getArguments()) {
                    ElmPropertyRequirement comparand;
                    ElmDataRequirement relatedRequirement;
                    ElmConditionRequirement nestedConditionRequirement;
                    if (!(nestedRequirement instanceof ElmConditionRequirement) || !((nestedConditionRequirement = (ElmConditionRequirement)nestedRequirement).getComparand() instanceof ElmPropertyRequirement) || (relatedRequirement = this.getDataRequirement((comparand = (ElmPropertyRequirement)nestedConditionRequirement.getComparand()).getSource())) == null) continue;
                    ElmDataRequirement newRequirement = new ElmDataRequirement(this.libraryIdentifier, nestedAlias.getRetrieve());
                    String localId = context.generateLocalId();
                    AliasedQuerySource aqs = new AliasedQuerySource().withExpression((Expression)newRequirement.getRetrieve()).withLocalId(localId).withAlias(localId);
                    newRequirement.setQuerySource((Element)aqs);
                    Property leftProperty = ElmCloner.clone(nestedConditionRequirement.getProperty().getProperty());
                    leftProperty.setSource(null);
                    leftProperty.setScope(localId);
                    ElmPropertyRequirement leftPropertyRequirement = new ElmPropertyRequirement(this.libraryIdentifier, leftProperty, (Element)aqs, true);
                    ElmJoinRequirement joinRequirement = new ElmJoinRequirement(this.libraryIdentifier, nestedConditionRequirement.getExpression(), leftPropertyRequirement, comparand);
                    newRequirement.getConjunctiveRequirement().combine(joinRequirement);
                    this.addDataRequirements(newRequirement);
                    return true;
                }
            }
        }
        return false;
    }

    public void addChildRequirements(ElmRequirement childRequirements) {
    }

    public boolean distributeExpressionRequirement(ElmExpressionRequirement requirement, ElmRequirementsContext context) {
        if (requirement instanceof ElmConjunctiveRequirement) {
            for (ElmExpressionRequirement expressionRequirement : ((ElmConjunctiveRequirement)requirement).getArguments()) {
                this.distributeExpressionRequirement(expressionRequirement, context);
            }
            return true;
        }
        if (requirement instanceof ElmDisjunctiveRequirement) {
            return true;
        }
        if (requirement instanceof ElmConditionRequirement) {
            this.distributeConditionRequirement((ElmConditionRequirement)requirement);
            return true;
        }
        if (requirement instanceof ElmJoinRequirement) {
            this.distributeJoinRequirement((ElmJoinRequirement)requirement);
            return true;
        }
        if (requirement instanceof ElmQueryRequirement) {
            return this.distributeQueryRequirement((ElmQueryRequirement)requirement, context);
        }
        return false;
    }

    public void analyzeDataRequirements(ElmRequirementsContext context) {
        for (ElmDataRequirement dataRequirement : this.dataRequirements) {
            dataRequirement.applyDataRequirements(context, this);
        }
    }
}

