/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.model.Model;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;

public class TypeResolver {
    private LibraryManager libraryManager;
    private DataType stringType;
    private DataType codeType;
    private DataType conceptType;
    private DataType valueSetType;
    private DataType codeSystemType;
    private DataType dateType;
    private DataType dateTimeType;

    public TypeResolver(LibraryManager libraryManager) {
        if (libraryManager == null) {
            throw new IllegalArgumentException("libraryManager is required");
        }
        this.libraryManager = libraryManager;
    }

    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public DataType resolveTypeName(String modelName, String typeName) {
        if (modelName == null || modelName.equals("")) {
            throw new IllegalArgumentException("Unqualified type name cannot be resolved");
        }
        Model model = this.libraryManager.getModelManager().resolveModel(modelName);
        DataType result = model.resolveTypeName(typeName);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Could not resolve type %s.%s", modelName, typeName));
        }
        return result;
    }

    public DataType getStringType() {
        if (this.stringType == null) {
            this.stringType = this.resolveTypeName("System", "String");
        }
        return this.stringType;
    }

    public DataType getCodeType() {
        if (this.codeType == null) {
            this.codeType = this.resolveTypeName("System", "Code");
        }
        return this.codeType;
    }

    public DataType getConceptType() {
        if (this.conceptType == null) {
            this.conceptType = this.resolveTypeName("System", "Concept");
        }
        return this.conceptType;
    }

    public DataType getValueSetType() {
        if (this.valueSetType == null) {
            this.valueSetType = this.resolveTypeName("System", "ValueSet");
        }
        return this.valueSetType;
    }

    public DataType getCodeSystemType() {
        if (this.codeSystemType == null) {
            this.codeSystemType = this.resolveTypeName("System", "CodeSystem");
        }
        return this.codeSystemType;
    }

    public DataType getDateType() {
        if (this.dateType == null) {
            this.dateType = this.resolveTypeName("System", "Date");
        }
        return this.dateType;
    }

    public DataType getDateTimeType() {
        if (this.dateTimeType == null) {
            this.dateTimeType = this.resolveTypeName("System", "DateTime");
        }
        return this.dateTimeType;
    }

    public boolean isTerminologyType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getCodeType()) || dataType.isSubTypeOf(this.getConceptType()) || dataType.isSubTypeOf(this.getValueSetType()) || dataType.isSubTypeOf(this.getCodeSystemType()) || dataType.isSubTypeOf(this.getStringType()) || dataType instanceof ListType && (((ListType)dataType).getElementType().isSubTypeOf(this.getCodeType()) || ((ListType)dataType).getElementType().isSubTypeOf(this.getConceptType()) || ((ListType)dataType).getElementType().isSubTypeOf(this.getStringType()));
        }
        return false;
    }

    public boolean isDateType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getDateType()) || dataType.isSubTypeOf(this.getDateTimeType()) || dataType instanceof IntervalType && (((IntervalType)dataType).getPointType().isSubTypeOf(this.getDateType()) || ((IntervalType)dataType).getPointType().isSubTypeOf(this.getDateTimeType()));
        }
        return false;
    }

    public boolean isDateTimeType(DataType dataType) {
        if (dataType != null) {
            return dataType.isSubTypeOf(this.getDateTimeType()) || dataType instanceof IntervalType && ((IntervalType)dataType).getPointType().isSubTypeOf(this.getDateTimeType());
        }
        return false;
    }

    public boolean isListType(DataType dataType) {
        return dataType instanceof ListType;
    }

    public boolean isIntervalType(DataType dataType) {
        return dataType instanceof IntervalType;
    }
}

