/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import org.cqframework.cql.elm.requirements.ElmConditionRequirement;
import org.cqframework.cql.elm.requirements.ElmConjunctiveRequirement;
import org.cqframework.cql.elm.requirements.ElmConstraintRequirement;
import org.cqframework.cql.elm.requirements.ElmDataRequirement;
import org.cqframework.cql.elm.requirements.ElmDisjunctiveRequirement;
import org.cqframework.cql.elm.requirements.ElmExpressionRequirement;
import org.cqframework.cql.elm.requirements.ElmJoinRequirement;
import org.cqframework.cql.elm.requirements.ElmOperatorRequirement;
import org.cqframework.cql.elm.requirements.ElmPropertyRequirement;
import org.cqframework.cql.elm.requirements.ElmQueryAliasContext;
import org.cqframework.cql.elm.requirements.ElmQueryContext;
import org.cqframework.cql.elm.requirements.ElmQueryLetContext;
import org.cqframework.cql.elm.requirements.ElmQueryRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirements;
import org.cqframework.cql.elm.requirements.ElmRequirementsContext;
import org.cqframework.cql.elm.tracking.Trackable;
import org.cqframework.cql.elm.visiting.ElmBaseLibraryVisitor;
import org.hl7.cql.model.ListType;
import org.hl7.elm.r1.Abs;
import org.hl7.elm.r1.Add;
import org.hl7.elm.r1.After;
import org.hl7.elm.r1.AggregateExpression;
import org.hl7.elm.r1.AliasRef;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.AllTrue;
import org.hl7.elm.r1.And;
import org.hl7.elm.r1.AnyInCodeSystem;
import org.hl7.elm.r1.AnyInValueSet;
import org.hl7.elm.r1.AnyTrue;
import org.hl7.elm.r1.As;
import org.hl7.elm.r1.Avg;
import org.hl7.elm.r1.Before;
import org.hl7.elm.r1.BinaryExpression;
import org.hl7.elm.r1.ByColumn;
import org.hl7.elm.r1.ByDirection;
import org.hl7.elm.r1.ByExpression;
import org.hl7.elm.r1.CalculateAge;
import org.hl7.elm.r1.CalculateAgeAt;
import org.hl7.elm.r1.Case;
import org.hl7.elm.r1.CaseItem;
import org.hl7.elm.r1.Ceiling;
import org.hl7.elm.r1.Coalesce;
import org.hl7.elm.r1.Code;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeRef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.CodeSystemRef;
import org.hl7.elm.r1.Collapse;
import org.hl7.elm.r1.Combine;
import org.hl7.elm.r1.Concatenate;
import org.hl7.elm.r1.Concept;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.ConceptRef;
import org.hl7.elm.r1.Contains;
import org.hl7.elm.r1.ContextDef;
import org.hl7.elm.r1.Convert;
import org.hl7.elm.r1.Count;
import org.hl7.elm.r1.Current;
import org.hl7.elm.r1.DateFrom;
import org.hl7.elm.r1.DateTime;
import org.hl7.elm.r1.DateTimeComponentFrom;
import org.hl7.elm.r1.DifferenceBetween;
import org.hl7.elm.r1.Distinct;
import org.hl7.elm.r1.Divide;
import org.hl7.elm.r1.DurationBetween;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.End;
import org.hl7.elm.r1.Ends;
import org.hl7.elm.r1.Equal;
import org.hl7.elm.r1.Equivalent;
import org.hl7.elm.r1.Except;
import org.hl7.elm.r1.Exists;
import org.hl7.elm.r1.Exp;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.ExpressionRef;
import org.hl7.elm.r1.Filter;
import org.hl7.elm.r1.First;
import org.hl7.elm.r1.Flatten;
import org.hl7.elm.r1.Floor;
import org.hl7.elm.r1.ForEach;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.Greater;
import org.hl7.elm.r1.GreaterOrEqual;
import org.hl7.elm.r1.IdentifierRef;
import org.hl7.elm.r1.If;
import org.hl7.elm.r1.In;
import org.hl7.elm.r1.InCodeSystem;
import org.hl7.elm.r1.InValueSet;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.IncludedIn;
import org.hl7.elm.r1.Includes;
import org.hl7.elm.r1.IndexOf;
import org.hl7.elm.r1.Indexer;
import org.hl7.elm.r1.Instance;
import org.hl7.elm.r1.InstanceElement;
import org.hl7.elm.r1.Intersect;
import org.hl7.elm.r1.Interval;
import org.hl7.elm.r1.IntervalTypeSpecifier;
import org.hl7.elm.r1.Is;
import org.hl7.elm.r1.IsFalse;
import org.hl7.elm.r1.IsNull;
import org.hl7.elm.r1.IsTrue;
import org.hl7.elm.r1.Last;
import org.hl7.elm.r1.Length;
import org.hl7.elm.r1.Less;
import org.hl7.elm.r1.LessOrEqual;
import org.hl7.elm.r1.LetClause;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.List;
import org.hl7.elm.r1.ListTypeSpecifier;
import org.hl7.elm.r1.Literal;
import org.hl7.elm.r1.Ln;
import org.hl7.elm.r1.Log;
import org.hl7.elm.r1.Lower;
import org.hl7.elm.r1.Max;
import org.hl7.elm.r1.MaxValue;
import org.hl7.elm.r1.Median;
import org.hl7.elm.r1.Meets;
import org.hl7.elm.r1.MeetsAfter;
import org.hl7.elm.r1.MeetsBefore;
import org.hl7.elm.r1.Min;
import org.hl7.elm.r1.MinValue;
import org.hl7.elm.r1.Mode;
import org.hl7.elm.r1.Modulo;
import org.hl7.elm.r1.Multiply;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.hl7.elm.r1.NaryExpression;
import org.hl7.elm.r1.Negate;
import org.hl7.elm.r1.Not;
import org.hl7.elm.r1.NotEqual;
import org.hl7.elm.r1.Now;
import org.hl7.elm.r1.Null;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.OperandRef;
import org.hl7.elm.r1.OperatorExpression;
import org.hl7.elm.r1.Or;
import org.hl7.elm.r1.Overlaps;
import org.hl7.elm.r1.OverlapsAfter;
import org.hl7.elm.r1.OverlapsBefore;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.ParameterRef;
import org.hl7.elm.r1.PopulationStdDev;
import org.hl7.elm.r1.PopulationVariance;
import org.hl7.elm.r1.PositionOf;
import org.hl7.elm.r1.Power;
import org.hl7.elm.r1.Predecessor;
import org.hl7.elm.r1.ProperContains;
import org.hl7.elm.r1.ProperIn;
import org.hl7.elm.r1.ProperIncludedIn;
import org.hl7.elm.r1.ProperIncludes;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Quantity;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.QueryLetRef;
import org.hl7.elm.r1.RelationshipClause;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.ReturnClause;
import org.hl7.elm.r1.Round;
import org.hl7.elm.r1.SameAs;
import org.hl7.elm.r1.SameOrAfter;
import org.hl7.elm.r1.SameOrBefore;
import org.hl7.elm.r1.SingletonFrom;
import org.hl7.elm.r1.Sort;
import org.hl7.elm.r1.SortByItem;
import org.hl7.elm.r1.SortClause;
import org.hl7.elm.r1.Split;
import org.hl7.elm.r1.Start;
import org.hl7.elm.r1.Starts;
import org.hl7.elm.r1.StdDev;
import org.hl7.elm.r1.Substring;
import org.hl7.elm.r1.Subtract;
import org.hl7.elm.r1.Successor;
import org.hl7.elm.r1.Sum;
import org.hl7.elm.r1.TernaryExpression;
import org.hl7.elm.r1.Time;
import org.hl7.elm.r1.TimeFrom;
import org.hl7.elm.r1.TimeOfDay;
import org.hl7.elm.r1.Times;
import org.hl7.elm.r1.TimezoneOffsetFrom;
import org.hl7.elm.r1.ToBoolean;
import org.hl7.elm.r1.ToConcept;
import org.hl7.elm.r1.ToDateTime;
import org.hl7.elm.r1.ToDecimal;
import org.hl7.elm.r1.ToInteger;
import org.hl7.elm.r1.ToQuantity;
import org.hl7.elm.r1.ToString;
import org.hl7.elm.r1.ToTime;
import org.hl7.elm.r1.Today;
import org.hl7.elm.r1.Truncate;
import org.hl7.elm.r1.TruncatedDivide;
import org.hl7.elm.r1.Tuple;
import org.hl7.elm.r1.TupleElement;
import org.hl7.elm.r1.TupleElementDefinition;
import org.hl7.elm.r1.TupleTypeSpecifier;
import org.hl7.elm.r1.TypeSpecifier;
import org.hl7.elm.r1.UnaryExpression;
import org.hl7.elm.r1.Union;
import org.hl7.elm.r1.Upper;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.ValueSetRef;
import org.hl7.elm.r1.Variance;
import org.hl7.elm.r1.Width;
import org.hl7.elm.r1.With;
import org.hl7.elm.r1.Without;
import org.hl7.elm.r1.Xor;

public class ElmRequirementsVisitor
extends ElmBaseLibraryVisitor<ElmRequirement, ElmRequirementsContext> {
    public ElmRequirement aggregateResult(ElmRequirement result, ElmRequirement nextResult) {
        if (result == null) {
            return nextResult;
        }
        if (nextResult == null) {
            return result;
        }
        if (result instanceof ElmRequirements) {
            ((ElmRequirements)result).reportRequirement(nextResult);
            return result;
        }
        ElmRequirements requirements = new ElmRequirements(result.getLibraryIdentifier(), result.getElement());
        requirements.reportRequirement(result);
        requirements.reportRequirement(nextResult);
        return requirements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElmRequirement visitExpressionDef(ExpressionDef elm, ElmRequirementsContext context) {
        ElmRequirement result = null;
        context.enterExpressionDef(elm);
        try {
            result = (ElmRequirement)super.visitExpressionDef(elm, (Object)context);
            context.exitExpressionDef(result);
        }
        catch (Throwable throwable) {
            context.exitExpressionDef(result);
            throw throwable;
        }
        return result;
    }

    public ElmRequirement visitFunctionDef(FunctionDef elm, ElmRequirementsContext context) {
        context.reportFunctionDef(elm);
        return (ElmRequirement)super.visitFunctionDef(elm, (Object)context);
    }

    public ElmRequirement visitExpressionRef(ExpressionRef elm, ElmRequirementsContext context) {
        ElmRequirement result = null;
        result = elm instanceof FunctionRef ? this.visitFunctionRef((FunctionRef)elm, context) : context.reportExpressionRef(elm);
        if (result != null) {
            if (result instanceof ElmDataRequirement) {
                ElmDataRequirement inferredRequirement = ElmDataRequirement.inferFrom((ElmExpressionRequirement)((ElmDataRequirement)result));
                result = inferredRequirement;
            } else if (result instanceof ElmQueryRequirement) {
                ElmDataRequirement inferredRequirement = ElmDataRequirement.inferFrom((ElmExpressionRequirement)((ElmQueryRequirement)result));
                result = inferredRequirement;
            }
            return result;
        }
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitFunctionRef(FunctionRef elm, ElmRequirementsContext context) {
        context.reportFunctionRef(elm);
        ElmRequirement result = (ElmRequirement)super.visitFunctionRef(elm, (Object)context);
        if (result instanceof ElmDataRequirement && (elm.getOperand().size() != 1 || ((Expression)elm.getOperand().get(0)).getResultType() instanceof ListType && !(elm.getResultType() instanceof ListType))) {
            return new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm).combine((ElmDataRequirement)result);
        }
        if (result != null) {
            return result;
        }
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitParameterDef(ParameterDef elm, ElmRequirementsContext context) {
        context.reportParameterDef(elm);
        return (ElmRequirement)super.visitParameterDef(elm, (Object)context);
    }

    public ElmRequirement visitParameterRef(ParameterRef elm, ElmRequirementsContext context) {
        context.reportParameterRef(elm);
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitRetrieve(Retrieve elm, ElmRequirementsContext context) {
        super.visitRetrieve(elm, (Object)context);
        ElmDataRequirement result = new ElmDataRequirement(context.getCurrentLibraryIdentifier(), elm);
        if (!context.getOptions().getAnalyzeDataRequirements() || !context.inQueryContext()) {
            context.reportRequirements(result, null);
        }
        return result;
    }

    public ElmRequirement visitCodeSystemDef(CodeSystemDef elm, ElmRequirementsContext context) {
        context.reportCodeSystemDef(elm);
        return (ElmRequirement)super.visitCodeSystemDef(elm, (Object)context);
    }

    public ElmRequirement visitValueSetDef(ValueSetDef elm, ElmRequirementsContext context) {
        context.reportValueSetDef(elm);
        return (ElmRequirement)super.visitValueSetDef(elm, (Object)context);
    }

    public ElmRequirement visitCodeSystemRef(CodeSystemRef elm, ElmRequirementsContext context) {
        context.reportCodeSystemRef(elm);
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitValueSetRef(ValueSetRef elm, ElmRequirementsContext context) {
        context.reportValueSetRef(elm);
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElmRequirement visitLibrary(Library elm, ElmRequirementsContext context) {
        context.enterLibrary(elm.getIdentifier());
        try {
            ElmRequirement elmRequirement = (ElmRequirement)super.visitLibrary(elm, (Object)context);
            return elmRequirement;
        }
        finally {
            context.exitLibrary();
        }
    }

    public ElmRequirement visitIncludeDef(IncludeDef elm, ElmRequirementsContext context) {
        context.reportIncludeDef(elm);
        return (ElmRequirement)super.visitIncludeDef(elm, (Object)context);
    }

    public ElmRequirement visitContextDef(ContextDef elm, ElmRequirementsContext context) {
        context.reportContextDef(elm);
        return (ElmRequirement)super.visitContextDef(elm, (Object)context);
    }

    public ElmRequirement visitCodeRef(CodeRef elm, ElmRequirementsContext context) {
        context.reportCodeRef(elm);
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitCodeDef(CodeDef elm, ElmRequirementsContext context) {
        context.reportCodeDef(elm);
        return (ElmRequirement)super.visitCodeDef(elm, (Object)context);
    }

    public ElmRequirement visitConceptRef(ConceptRef elm, ElmRequirementsContext context) {
        context.reportConceptRef(elm);
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitConceptDef(ConceptDef elm, ElmRequirementsContext context) {
        context.reportConceptDef(elm);
        return (ElmRequirement)super.visitConceptDef(elm, (Object)context);
    }

    public ElmRequirement visitExpression(Expression elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitExpression(elm, (Object)context);
    }

    public ElmRequirement visitOperatorExpression(OperatorExpression elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitOperatorExpression(elm, (Object)context);
    }

    public ElmRequirement visitUnaryExpression(UnaryExpression elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitUnaryExpression(elm, (Object)context);
    }

    protected ElmRequirement inferConditionRequirement(Expression elm, ElmRequirementsContext context, ElmRequirement left, ElmRequirement right) {
        ElmPropertyRequirement rightProperty;
        ElmPropertyRequirement leftProperty = left instanceof ElmPropertyRequirement ? (ElmPropertyRequirement)left : null;
        ElmPropertyRequirement elmPropertyRequirement = rightProperty = right instanceof ElmPropertyRequirement ? (ElmPropertyRequirement)right : null;
        if (leftProperty != null && leftProperty.getInCurrentScope()) {
            if (rightProperty != null && rightProperty.getInCurrentScope()) {
                if (leftProperty.getSource() == rightProperty.getSource()) {
                    return new ElmConstraintRequirement(context.getCurrentLibraryIdentifier(), elm, leftProperty, rightProperty);
                }
                if (leftProperty.getSource() instanceof AliasedQuerySource && rightProperty.getSource() instanceof AliasedQuerySource) {
                    return new ElmJoinRequirement(context.getCurrentLibraryIdentifier(), elm, leftProperty, rightProperty);
                }
            }
            if (right instanceof ElmExpressionRequirement) {
                return new ElmConditionRequirement(context.getCurrentLibraryIdentifier(), elm, leftProperty, (ElmExpressionRequirement)right);
            }
        } else if (rightProperty != null && rightProperty.getInCurrentScope()) {
            if (leftProperty != null && leftProperty.getInCurrentScope()) {
                if (leftProperty.getSource() == rightProperty.getSource()) {
                    return new ElmConstraintRequirement(context.getCurrentLibraryIdentifier(), elm, leftProperty, rightProperty);
                }
                if (leftProperty.getSource() instanceof AliasedQuerySource && rightProperty.getSource() instanceof AliasedQuerySource) {
                    return new ElmJoinRequirement(context.getCurrentLibraryIdentifier(), elm, leftProperty, rightProperty);
                }
            }
            if (left instanceof ElmExpressionRequirement) {
                return new ElmConditionRequirement(context.getCurrentLibraryIdentifier(), elm, (ElmPropertyRequirement)right, (ElmExpressionRequirement)left);
            }
        }
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), elm);
    }

    public ElmRequirement visitChildren(BinaryExpression elm, ElmRequirementsContext context) {
        if (elm.getOperand().size() != 2) {
            return (ElmRequirement)super.visitChildren(elm, (Object)context);
        }
        switch (elm.getClass().getSimpleName()) {
            case "Equal": 
            case "Equivalent": 
            case "Greater": 
            case "GreaterOrEqual": 
            case "Less": 
            case "LessOrEqual": 
            case "In": 
            case "Contains": {
                ElmRequirement left = this.visitElement((Element)elm.getOperand().get(0), context);
                ElmRequirement right = this.visitElement((Element)elm.getOperand().get(1), context);
                return this.inferConditionRequirement((Expression)elm, context, left, right);
            }
            case "And": {
                ElmRequirement left = this.visitElement((Element)elm.getOperand().get(0), context);
                ElmRequirement right = this.visitElement((Element)elm.getOperand().get(1), context);
                if (left instanceof ElmExpressionRequirement && right instanceof ElmExpressionRequirement) {
                    return new ElmConjunctiveRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm).combine((ElmExpressionRequirement)left).combine((ElmExpressionRequirement)right);
                }
                if (left instanceof ElmExpressionRequirement && right == null) {
                    return left;
                }
                if (right instanceof ElmExpressionRequirement && left == null) {
                    return right;
                }
                throw new IllegalArgumentException("Expected ElmExpressionRequirement");
            }
            case "Or": {
                ElmRequirement left = this.visitElement((Element)elm.getOperand().get(0), context);
                ElmRequirement right = this.visitElement((Element)elm.getOperand().get(1), context);
                if (left instanceof ElmExpressionRequirement && right instanceof ElmExpressionRequirement) {
                    return new ElmDisjunctiveRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm).combine((ElmExpressionRequirement)left).combine((ElmExpressionRequirement)right);
                }
                if (left instanceof ElmExpressionRequirement && right == null) {
                    return left;
                }
                if (right instanceof ElmExpressionRequirement && left == null) {
                    return right;
                }
                throw new IllegalArgumentException("Expected ElmExpressionRequirement");
            }
        }
        super.visitChildren(elm, (Object)context);
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitBinaryExpression(BinaryExpression elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitBinaryExpression(elm, (Object)context);
    }

    public ElmRequirement visitTernaryExpression(TernaryExpression elm, ElmRequirementsContext context) {
        super.visitTernaryExpression(elm, (Object)context);
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitNaryExpression(NaryExpression elm, ElmRequirementsContext context) {
        super.visitNaryExpression(elm, (Object)context);
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitOperandDef(OperandDef elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitOperandDef(elm, (Object)context);
    }

    public ElmRequirement visitOperandRef(OperandRef elm, ElmRequirementsContext context) {
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitIdentifierRef(IdentifierRef elm, ElmRequirementsContext context) {
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitLiteral(Literal elm, ElmRequirementsContext context) {
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitTupleElement(TupleElement elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitTupleElement(elm, (Object)context);
    }

    public ElmRequirement visitTuple(Tuple elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitTuple(elm, (Object)context);
    }

    public ElmRequirement visitInstanceElement(InstanceElement elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitInstanceElement(elm, (Object)context);
    }

    public ElmRequirement visitInstance(Instance elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitInstance(elm, (Object)context);
    }

    public ElmRequirement visitInterval(Interval elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitInterval(elm, (Object)context);
    }

    public ElmRequirement visitList(List elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitList(elm, (Object)context);
    }

    public ElmRequirement visitAnd(And elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitAnd(elm, (Object)context);
    }

    public ElmRequirement visitOr(Or elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitOr(elm, (Object)context);
    }

    public ElmRequirement visitXor(Xor elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitXor(elm, (Object)context);
    }

    public ElmRequirement visitNot(Not elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitNot(elm, (Object)context);
    }

    public ElmRequirement visitIf(If elm, ElmRequirementsContext context) {
        return new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitCaseItem(CaseItem elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitCaseItem(elm, (Object)context);
    }

    public ElmRequirement visitCase(Case elm, ElmRequirementsContext context) {
        ElmOperatorRequirement result = new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
        ElmRequirement childResult = null;
        if (elm.getComparand() != null && (childResult = this.visitElement((Element)elm.getComparand(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        for (CaseItem ci : elm.getCaseItem()) {
            childResult = this.visitElement((Element)ci, context);
            if (!(childResult instanceof ElmExpressionRequirement)) continue;
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getElse() != null && (childResult = this.visitElement((Element)elm.getElse(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        return result;
    }

    public ElmRequirement visitNull(Null elm, ElmRequirementsContext context) {
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitIsNull(IsNull elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitIsNull(elm, (Object)context);
    }

    public ElmRequirement visitIsTrue(IsTrue elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitIsTrue(elm, (Object)context);
    }

    public ElmRequirement visitIsFalse(IsFalse elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitIsFalse(elm, (Object)context);
    }

    public ElmRequirement visitCoalesce(Coalesce elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitCoalesce(elm, (Object)context);
    }

    public ElmRequirement visitIs(Is elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitIs(elm, (Object)context);
    }

    public ElmRequirement visitAs(As elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitAs(elm, (Object)context);
    }

    public ElmRequirement visitConvert(Convert elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitConvert(elm, (Object)context);
    }

    public ElmRequirement visitToBoolean(ToBoolean elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitToBoolean(elm, (Object)context);
    }

    public ElmRequirement visitToConcept(ToConcept elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitToConcept(elm, (Object)context);
    }

    public ElmRequirement visitToDateTime(ToDateTime elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitToDateTime(elm, (Object)context);
    }

    public ElmRequirement visitToDecimal(ToDecimal elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitToDecimal(elm, (Object)context);
    }

    public ElmRequirement visitToInteger(ToInteger elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitToInteger(elm, (Object)context);
    }

    public ElmRequirement visitToQuantity(ToQuantity elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitToQuantity(elm, (Object)context);
    }

    public ElmRequirement visitToString(ToString elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitToString(elm, (Object)context);
    }

    public ElmRequirement visitToTime(ToTime elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitToTime(elm, (Object)context);
    }

    public ElmRequirement visitEqual(Equal elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitEqual(elm, (Object)context);
    }

    public ElmRequirement visitEquivalent(Equivalent elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitEquivalent(elm, (Object)context);
    }

    public ElmRequirement visitNotEqual(NotEqual elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitNotEqual(elm, (Object)context);
    }

    public ElmRequirement visitLess(Less elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitLess(elm, (Object)context);
    }

    public ElmRequirement visitGreater(Greater elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitGreater(elm, (Object)context);
    }

    public ElmRequirement visitLessOrEqual(LessOrEqual elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitLessOrEqual(elm, (Object)context);
    }

    public ElmRequirement visitGreaterOrEqual(GreaterOrEqual elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitGreaterOrEqual(elm, (Object)context);
    }

    public ElmRequirement visitAdd(Add elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitAdd(elm, (Object)context);
    }

    public ElmRequirement visitSubtract(Subtract elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitSubtract(elm, (Object)context);
    }

    public ElmRequirement visitMultiply(Multiply elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitMultiply(elm, (Object)context);
    }

    public ElmRequirement visitDivide(Divide elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitDivide(elm, (Object)context);
    }

    public ElmRequirement visitTruncatedDivide(TruncatedDivide elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitTruncatedDivide(elm, (Object)context);
    }

    public ElmRequirement visitModulo(Modulo elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitModulo(elm, (Object)context);
    }

    public ElmRequirement visitCeiling(Ceiling elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitCeiling(elm, (Object)context);
    }

    public ElmRequirement visitFloor(Floor elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitFloor(elm, (Object)context);
    }

    public ElmRequirement visitTruncate(Truncate elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitTruncate(elm, (Object)context);
    }

    public ElmRequirement visitAbs(Abs elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitAbs(elm, (Object)context);
    }

    public ElmRequirement visitNegate(Negate elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitNegate(elm, (Object)context);
    }

    public ElmRequirement visitRound(Round elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitRound(elm, (Object)context);
    }

    public ElmRequirement visitLn(Ln elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitLn(elm, (Object)context);
    }

    public ElmRequirement visitExp(Exp elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitExp(elm, (Object)context);
    }

    public ElmRequirement visitLog(Log elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitLog(elm, (Object)context);
    }

    public ElmRequirement visitPower(Power elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitPower(elm, (Object)context);
    }

    public ElmRequirement visitSuccessor(Successor elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitSuccessor(elm, (Object)context);
    }

    public ElmRequirement visitPredecessor(Predecessor elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitPredecessor(elm, (Object)context);
    }

    public ElmRequirement visitMinValue(MinValue elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitMinValue(elm, (Object)context);
    }

    public ElmRequirement visitMaxValue(MaxValue elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitMaxValue(elm, (Object)context);
    }

    public ElmRequirement visitConcatenate(Concatenate elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitConcatenate(elm, (Object)context);
    }

    public ElmRequirement visitCombine(Combine elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitCombine(elm, (Object)context);
    }

    public ElmRequirement visitSplit(Split elm, ElmRequirementsContext context) {
        if (elm.getSeparator() instanceof Literal) {
            return this.visitElement((Element)elm.getStringToSplit(), context);
        }
        return (ElmRequirement)super.visitSplit(elm, (Object)context);
    }

    public ElmRequirement visitLength(Length elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitLength(elm, (Object)context);
    }

    public ElmRequirement visitUpper(Upper elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitUpper(elm, (Object)context);
    }

    public ElmRequirement visitLower(Lower elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitLower(elm, (Object)context);
    }

    public ElmRequirement visitIndexer(Indexer elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitIndexer(elm, (Object)context);
    }

    public ElmRequirement visitPositionOf(PositionOf elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitPositionOf(elm, (Object)context);
    }

    public ElmRequirement visitSubstring(Substring elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitSubstring(elm, (Object)context);
    }

    public ElmRequirement visitDurationBetween(DurationBetween elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitDurationBetween(elm, (Object)context);
    }

    public ElmRequirement visitDifferenceBetween(DifferenceBetween elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitDifferenceBetween(elm, (Object)context);
    }

    public ElmRequirement visitDateFrom(DateFrom elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitDateFrom(elm, (Object)context);
    }

    public ElmRequirement visitTimeFrom(TimeFrom elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitTimeFrom(elm, (Object)context);
    }

    public ElmRequirement visitTimezoneOffsetFrom(TimezoneOffsetFrom elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitTimezoneOffsetFrom(elm, (Object)context);
    }

    public ElmRequirement visitDateTimeComponentFrom(DateTimeComponentFrom elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitDateTimeComponentFrom(elm, (Object)context);
    }

    public ElmRequirement visitTimeOfDay(TimeOfDay elm, ElmRequirementsContext context) {
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitToday(Today elm, ElmRequirementsContext context) {
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitNow(Now elm, ElmRequirementsContext context) {
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitDateTime(DateTime elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitDateTime(elm, (Object)context);
    }

    public ElmRequirement visitTime(Time elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitTime(elm, (Object)context);
    }

    public ElmRequirement visitSameAs(SameAs elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitSameAs(elm, (Object)context);
    }

    public ElmRequirement visitSameOrBefore(SameOrBefore elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitSameOrBefore(elm, (Object)context);
    }

    public ElmRequirement visitSameOrAfter(SameOrAfter elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitSameOrAfter(elm, (Object)context);
    }

    public ElmRequirement visitWidth(Width elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitWidth(elm, (Object)context);
    }

    public ElmRequirement visitStart(Start elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitStart(elm, (Object)context);
    }

    public ElmRequirement visitEnd(End elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitEnd(elm, (Object)context);
    }

    public ElmRequirement visitContains(Contains elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitContains(elm, (Object)context);
    }

    public ElmRequirement visitProperContains(ProperContains elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitProperContains(elm, (Object)context);
    }

    public ElmRequirement visitIn(In elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitIn(elm, (Object)context);
    }

    public ElmRequirement visitProperIn(ProperIn elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitProperIn(elm, (Object)context);
    }

    public ElmRequirement visitIncludes(Includes elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitIncludes(elm, (Object)context);
    }

    public ElmRequirement visitIncludedIn(IncludedIn elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitIncludedIn(elm, (Object)context);
    }

    public ElmRequirement visitProperIncludes(ProperIncludes elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitProperIncludes(elm, (Object)context);
    }

    public ElmRequirement visitProperIncludedIn(ProperIncludedIn elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitProperIncludedIn(elm, (Object)context);
    }

    public ElmRequirement visitBefore(Before elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitBefore(elm, (Object)context);
    }

    public ElmRequirement visitAfter(After elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitAfter(elm, (Object)context);
    }

    public ElmRequirement visitMeets(Meets elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitMeets(elm, (Object)context);
    }

    public ElmRequirement visitMeetsBefore(MeetsBefore elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitMeetsBefore(elm, (Object)context);
    }

    public ElmRequirement visitMeetsAfter(MeetsAfter elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitMeetsAfter(elm, (Object)context);
    }

    public ElmRequirement visitOverlaps(Overlaps elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitOverlaps(elm, (Object)context);
    }

    public ElmRequirement visitOverlapsBefore(OverlapsBefore elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitOverlapsBefore(elm, (Object)context);
    }

    public ElmRequirement visitOverlapsAfter(OverlapsAfter elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitOverlapsAfter(elm, (Object)context);
    }

    public ElmRequirement visitStarts(Starts elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitStarts(elm, (Object)context);
    }

    public ElmRequirement visitEnds(Ends elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitEnds(elm, (Object)context);
    }

    public ElmRequirement visitCollapse(Collapse elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitCollapse(elm, (Object)context);
    }

    public ElmRequirement visitUnion(Union elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitUnion(elm, (Object)context);
    }

    public ElmRequirement visitIntersect(Intersect elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitIntersect(elm, (Object)context);
    }

    public ElmRequirement visitExcept(Except elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitExcept(elm, (Object)context);
    }

    public ElmRequirement visitExists(Exists elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitExists(elm, (Object)context);
    }

    public ElmRequirement visitTimes(Times elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitTimes(elm, (Object)context);
    }

    public ElmRequirement visitFilter(Filter elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitFilter(elm, (Object)context);
    }

    public ElmRequirement visitFirst(First elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitFirst(elm, (Object)context);
    }

    public ElmRequirement visitLast(Last elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitLast(elm, (Object)context);
    }

    public ElmRequirement visitIndexOf(IndexOf elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitIndexOf(elm, (Object)context);
    }

    public ElmRequirement visitFlatten(Flatten elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitFlatten(elm, (Object)context);
    }

    public ElmRequirement visitSort(Sort elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitSort(elm, (Object)context);
    }

    public ElmRequirement visitForEach(ForEach elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitForEach(elm, (Object)context);
    }

    public ElmRequirement visitDistinct(Distinct elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitDistinct(elm, (Object)context);
    }

    public ElmRequirement visitCurrent(Current elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitCurrent(elm, (Object)context);
    }

    public ElmRequirement visitSingletonFrom(SingletonFrom elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitSingletonFrom(elm, (Object)context);
    }

    public ElmRequirement visitAggregateExpression(AggregateExpression elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitAggregateExpression(elm, (Object)context);
    }

    public ElmRequirement visitCount(Count elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitCount(elm, (Object)context);
    }

    public ElmRequirement visitSum(Sum elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitSum(elm, (Object)context);
    }

    public ElmRequirement visitMin(Min elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitMin(elm, (Object)context);
    }

    public ElmRequirement visitMax(Max elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitMax(elm, (Object)context);
    }

    public ElmRequirement visitAvg(Avg elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitAvg(elm, (Object)context);
    }

    public ElmRequirement visitMedian(Median elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitMedian(elm, (Object)context);
    }

    public ElmRequirement visitMode(Mode elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitMode(elm, (Object)context);
    }

    public ElmRequirement visitVariance(Variance elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitVariance(elm, (Object)context);
    }

    public ElmRequirement visitPopulationVariance(PopulationVariance elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitPopulationVariance(elm, (Object)context);
    }

    public ElmRequirement visitStdDev(StdDev elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitStdDev(elm, (Object)context);
    }

    public ElmRequirement visitPopulationStdDev(PopulationStdDev elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitPopulationStdDev(elm, (Object)context);
    }

    public ElmRequirement visitAllTrue(AllTrue elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitAllTrue(elm, (Object)context);
    }

    public ElmRequirement visitAnyTrue(AnyTrue elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitAnyTrue(elm, (Object)context);
    }

    public ElmRequirement visitProperty(Property elm, ElmRequirementsContext context) {
        ElmRequirement visitResult = (ElmRequirement)super.visitProperty(elm, (Object)context);
        if (visitResult instanceof ElmPropertyRequirement) {
            ElmPropertyRequirement visitPropertyRequirement = (ElmPropertyRequirement)visitResult;
            Property qualifiedProperty = new Property();
            Property sourceProperty = visitPropertyRequirement.getProperty();
            qualifiedProperty.setSource(sourceProperty.getSource());
            qualifiedProperty.setScope(sourceProperty.getScope());
            qualifiedProperty.setResultType(elm.getResultType());
            qualifiedProperty.setResultTypeName(elm.getResultTypeName());
            qualifiedProperty.setResultTypeSpecifier(elm.getResultTypeSpecifier());
            qualifiedProperty.setLocalId(sourceProperty.getLocalId());
            qualifiedProperty.setPath(sourceProperty.getPath() + "." + elm.getPath());
            return context.reportProperty(qualifiedProperty);
        }
        ElmPropertyRequirement propertyRequirement = context.reportProperty(elm);
        ElmRequirement result = this.aggregateResult(propertyRequirement, visitResult);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElmRequirement visitChildren(AliasedQuerySource elm, ElmRequirementsContext context) {
        ElmRequirement result = (ElmRequirement)this.defaultResult((Trackable)elm, context);
        ElmQueryAliasContext aliasContext = null;
        context.getCurrentQueryContext().enterAliasDefinitionContext(elm);
        try {
            if (elm.getExpression() != null) {
                ElmRequirement childResult = this.visitElement((Element)elm.getExpression(), context);
                result = this.aggregateResult(result, childResult);
            }
        }
        finally {
            aliasContext = context.getCurrentQueryContext().exitAliasDefinitionContext(result);
        }
        return aliasContext.getRequirements();
    }

    public ElmRequirement visitAliasedQuerySource(AliasedQuerySource elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitAliasedQuerySource(elm, (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElmRequirement visitLetClause(LetClause elm, ElmRequirementsContext context) {
        ElmRequirement result = (ElmRequirement)this.defaultResult((Trackable)elm, context);
        ElmQueryLetContext letContext = null;
        context.getCurrentQueryContext().enterLetDefinitionContext(elm);
        try {
            if (elm.getExpression() != null) {
                ElmRequirement childResult = (ElmRequirement)super.visitLetClause(elm, (Object)context);
                result = this.aggregateResult(result, childResult);
            }
        }
        finally {
            letContext = context.getCurrentQueryContext().exitLetDefinitionContext(result);
        }
        return letContext.getRequirements();
    }

    public ElmRequirement visitChildren(RelationshipClause elm, ElmRequirementsContext context) {
        ElmRequirement result = this.visitChildren((AliasedQuerySource)elm, context);
        if (elm.getSuchThat() != null) {
            ElmRequirement childResult = this.visitSuchThatClause(elm.getSuchThat(), elm instanceof With, context);
            result = this.aggregateResult(result, childResult);
        }
        context.getCurrentQueryContext().descopeAlias((AliasedQuerySource)elm);
        return result;
    }

    public ElmRequirement visitRelationshipClause(RelationshipClause elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitRelationshipClause(elm, (Object)context);
    }

    public ElmRequirement visitWith(With elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitWith(elm, (Object)context);
    }

    public ElmRequirement visitWithout(Without elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitWithout(elm, (Object)context);
    }

    public ElmRequirement visitSortByItem(SortByItem elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitSortByItem(elm, (Object)context);
    }

    public ElmRequirement visitByDirection(ByDirection elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitByDirection(elm, (Object)context);
    }

    public ElmRequirement visitByColumn(ByColumn elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitByColumn(elm, (Object)context);
    }

    public ElmRequirement visitByExpression(ByExpression elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitByExpression(elm, (Object)context);
    }

    public ElmRequirement visitSortClause(SortClause elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitSortClause(elm, (Object)context);
    }

    public ElmRequirement visitReturnClause(ReturnClause elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitReturnClause(elm, (Object)context);
    }

    public ElmRequirement visitWhereClause(Expression elm, ElmRequirementsContext context) {
        ElmRequirement childResult = (ElmRequirement)super.visitWhereClause(elm, (Object)context);
        context.getCurrentQueryContext().reportQueryRequirements(childResult);
        return childResult;
    }

    public ElmRequirement visitSuchThatClause(Expression elm, boolean isWith, ElmRequirementsContext context) {
        ElmRequirement childResult = (ElmRequirement)super.visitSuchThatClause(elm, isWith, (Object)context);
        if (isWith) {
            context.getCurrentQueryContext().reportQueryRequirements(childResult);
        }
        return childResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElmRequirement visitQuery(Query elm, ElmRequirementsContext context) {
        ElmRequirement childResult = null;
        ElmQueryContext queryContext = null;
        context.enterQueryContext(elm);
        try {
            childResult = (ElmRequirement)super.visitQuery(elm, (Object)context);
        }
        finally {
            queryContext = context.exitQueryContext();
        }
        ElmQueryRequirement result = queryContext.getQueryRequirement(childResult, context);
        result.analyzeDataRequirements(context);
        context.reportRequirements(result, null);
        return result;
    }

    public ElmRequirement visitAliasRef(AliasRef elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitAliasRef(elm, (Object)context);
    }

    public ElmRequirement visitQueryLetRef(QueryLetRef elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitQueryLetRef(elm, (Object)context);
    }

    public ElmRequirement visitCode(Code elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitCode(elm, (Object)context);
    }

    public ElmRequirement visitConcept(Concept elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitConcept(elm, (Object)context);
    }

    public ElmRequirement visitInCodeSystem(InCodeSystem elm, ElmRequirementsContext context) {
        if (elm.getCode() != null && (elm.getCodesystem() != null || elm.getCodesystemExpression() != null)) {
            ElmRequirement left = this.visitElement((Element)elm.getCode(), context);
            ElmRequirement right = elm.getCodesystem() != null ? this.visitElement((Element)elm.getCodesystem(), context) : this.visitElement((Element)elm.getCodesystemExpression(), context);
            return this.inferConditionRequirement((Expression)elm, context, left, right);
        }
        return (ElmRequirement)super.visitInCodeSystem(elm, (Object)context);
    }

    public ElmRequirement visitAnyInCodeSystem(AnyInCodeSystem elm, ElmRequirementsContext context) {
        if (elm.getCodes() != null && (elm.getCodesystem() != null || elm.getCodesystemExpression() != null)) {
            ElmRequirement left = this.visitElement((Element)elm.getCodes(), context);
            ElmRequirement right = elm.getCodesystem() != null ? this.visitElement((Element)elm.getCodesystem(), context) : this.visitElement((Element)elm.getCodesystemExpression(), context);
            return this.inferConditionRequirement((Expression)elm, context, left, right);
        }
        return (ElmRequirement)super.visitAnyInCodeSystem(elm, (Object)context);
    }

    public ElmRequirement visitInValueSet(InValueSet elm, ElmRequirementsContext context) {
        if (elm.getCode() != null && (elm.getValueset() != null || elm.getValuesetExpression() != null)) {
            ElmRequirement left = this.visitElement((Element)elm.getCode(), context);
            ElmRequirement right = elm.getValueset() != null ? this.visitElement((Element)elm.getValueset(), context) : this.visitElement((Element)elm.getValuesetExpression(), context);
            return this.inferConditionRequirement((Expression)elm, context, left, right);
        }
        return (ElmRequirement)super.visitInValueSet(elm, (Object)context);
    }

    public ElmRequirement visitAnyInValueSet(AnyInValueSet elm, ElmRequirementsContext context) {
        if (elm.getCodes() != null && (elm.getValueset() != null || elm.getValuesetExpression() != null)) {
            ElmRequirement left = this.visitElement((Element)elm.getCodes(), context);
            ElmRequirement right = elm.getValueset() != null ? this.visitElement((Element)elm.getValueset(), context) : this.visitElement((Element)elm.getValuesetExpression(), context);
            return this.inferConditionRequirement((Expression)elm, context, left, right);
        }
        return (ElmRequirement)super.visitAnyInValueSet(elm, (Object)context);
    }

    public ElmRequirement visitQuantity(Quantity elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitQuantity(elm, (Object)context);
    }

    public ElmRequirement visitCalculateAge(CalculateAge elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitCalculateAge(elm, (Object)context);
    }

    public ElmRequirement visitCalculateAgeAt(CalculateAgeAt elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitCalculateAgeAt(elm, (Object)context);
    }

    public ElmRequirement visitElement(Element elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitElement(elm, (Object)context);
    }

    public ElmRequirement visitTypeSpecifier(TypeSpecifier elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitTypeSpecifier(elm, (Object)context);
    }

    public ElmRequirement visitNamedTypeSpecifier(NamedTypeSpecifier elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitNamedTypeSpecifier(elm, (Object)context);
    }

    public ElmRequirement visitIntervalTypeSpecifier(IntervalTypeSpecifier elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitIntervalTypeSpecifier(elm, (Object)context);
    }

    public ElmRequirement visitListTypeSpecifier(ListTypeSpecifier elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitListTypeSpecifier(elm, (Object)context);
    }

    public ElmRequirement visitTupleElementDefinition(TupleElementDefinition elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitTupleElementDefinition(elm, (Object)context);
    }

    public ElmRequirement visitTupleTypeSpecifier(TupleTypeSpecifier elm, ElmRequirementsContext context) {
        return (ElmRequirement)super.visitTupleTypeSpecifier(elm, (Object)context);
    }

    public ElmRequirement visitUsingDef(UsingDef elm, ElmRequirementsContext context) {
        context.reportUsingDef(elm);
        return (ElmRequirement)super.visitUsingDef(elm, (Object)context);
    }
}

