/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements.fhir;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBElement;
import org.cqframework.cql.cql2elm.CqlTranslatorOptions;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.NamespaceManager;
import org.cqframework.cql.cql2elm.model.TranslatedLibrary;
import org.cqframework.cql.elm.requirements.ElmDataRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirements;
import org.cqframework.cql.elm.requirements.ElmRequirementsContext;
import org.cqframework.cql.elm.requirements.ElmRequirementsVisitor;
import org.hl7.cql.model.IntervalType;
import org.hl7.cql.model.ListType;
import org.hl7.cql.model.NamedType;
import org.hl7.cql_annotations.r1.Annotation;
import org.hl7.cql_annotations.r1.Narrative;
import org.hl7.elm.r1.AccessModifier;
import org.hl7.elm.r1.Code;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeFilterElement;
import org.hl7.elm.r1.CodeRef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.Concept;
import org.hl7.elm.r1.ConceptRef;
import org.hl7.elm.r1.Date;
import org.hl7.elm.r1.DateFilterElement;
import org.hl7.elm.r1.DateTime;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.IncludeElement;
import org.hl7.elm.r1.Interval;
import org.hl7.elm.r1.Literal;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.ParameterRef;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.ToList;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.ValueSetRef;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class DataRequirementsProcessor {
    private List<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();

    public List<ValidationMessage> getValidationMessages() {
        return this.validationMessages;
    }

    public Library gatherDataRequirements(LibraryManager libraryManager, TranslatedLibrary translatedLibrary, CqlTranslatorOptions options, Set<String> expressions, boolean includeLogicDefinitions) {
        return this.gatherDataRequirements(libraryManager, translatedLibrary, options, expressions, includeLogicDefinitions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Library gatherDataRequirements(LibraryManager libraryManager, TranslatedLibrary translatedLibrary, CqlTranslatorOptions options, Set<String> expressions, boolean includeLogicDefinitions, boolean recursive) {
        if (libraryManager == null) {
            throw new IllegalArgumentException("libraryManager required");
        }
        if (translatedLibrary == null) {
            throw new IllegalArgumentException("translatedLibrary required");
        }
        ElmRequirementsVisitor visitor = new ElmRequirementsVisitor();
        ElmRequirementsContext context = new ElmRequirementsContext(libraryManager, options, visitor);
        List expressionDefs = null;
        if (expressions == null) {
            visitor.visitLibrary(translatedLibrary.getLibrary(), context);
            expressionDefs = translatedLibrary.getLibrary() != null && translatedLibrary.getLibrary().getStatements() != null ? translatedLibrary.getLibrary().getStatements().getDef() : new ArrayList();
        } else {
            if (expressionDefs == null) {
                expressionDefs = new ArrayList();
            }
            context.enterLibrary(translatedLibrary.getIdentifier());
            try {
                for (String expression : expressions) {
                    ExpressionDef ed = translatedLibrary.resolveExpressionRef(expression);
                    if (ed != null) {
                        expressionDefs.add(ed);
                        visitor.visitElement((Element)ed, context);
                        continue;
                    }
                    Iterable fds = translatedLibrary.resolveFunctionRef(expression);
                    for (FunctionDef fd : fds) {
                        expressionDefs.add(fd);
                        visitor.visitElement((Element)fd, context);
                    }
                }
            }
            finally {
                context.exitLibrary();
            }
        }
        ElmRequirements requirements = new ElmRequirements(translatedLibrary.getIdentifier(), (Element)translatedLibrary.getLibrary());
        if (recursive) {
            requirements.reportRequirement(context.getRequirements());
            for (ElmRequirements reportedRequirements : context.getReportedRequirements()) {
                requirements.reportRequirement(reportedRequirements);
            }
            for (ElmRequirement inferredRequirement : context.getInferredRequirements()) {
                requirements.reportRequirement(inferredRequirement);
            }
        } else {
            for (ElmRequirement requirement : context.getRequirements().getRequirements()) {
                if (!requirement.getLibraryIdentifier().equals((Object)translatedLibrary.getIdentifier())) continue;
                requirements.reportRequirement(requirement);
            }
            for (ExpressionDef ed : expressionDefs) {
                if (ed == null) continue;
                ElmRequirements reportedRequirements = context.getReportedRequirements(ed);
                requirements.reportRequirement(reportedRequirements);
                ElmRequirement inferredRequirement = context.getInferredRequirements(ed);
                requirements.reportRequirement(inferredRequirement);
            }
        }
        if (options.getCollapseDataRequirements()) {
            requirements = requirements.collapse();
        }
        return this.createLibrary(context, requirements, translatedLibrary.getIdentifier(), expressionDefs, includeLogicDefinitions);
    }

    private Library createLibrary(ElmRequirementsContext context, ElmRequirements requirements, VersionedIdentifier libraryIdentifier, Iterable<ExpressionDef> expressionDefs, boolean includeLogicDefinitions) {
        Library returnLibrary = new Library();
        returnLibrary.setStatus(Enumerations.PublicationStatus.ACTIVE);
        CodeableConcept libraryType = new CodeableConcept();
        Coding typeCoding = new Coding().setCode("module-definition");
        typeCoding.setSystem("http://terminology.hl7.org/CodeSystem/library-type");
        libraryType.addCoding(typeCoding);
        returnLibrary.setType(libraryType);
        returnLibrary.setDate(new java.util.Date());
        returnLibrary.setSubject((DataType)this.extractSubject(context));
        returnLibrary.getExtension().addAll(this.extractDirectReferenceCodes(context, requirements));
        returnLibrary.getRelatedArtifact().addAll(this.extractRelatedArtifacts(context, requirements));
        returnLibrary.getDataRequirement().addAll(this.extractDataRequirements(context, requirements));
        returnLibrary.getParameter().addAll(this.extractParameters(context, requirements, libraryIdentifier, expressionDefs));
        if (includeLogicDefinitions) {
            returnLibrary.getExtension().addAll(this.extractLogicDefinitions(context, requirements));
        }
        return returnLibrary;
    }

    private CodeableConcept extractSubject(ElmRequirementsContext context) {
        return null;
    }

    private List<Extension> extractDirectReferenceCodes(ElmRequirementsContext context, ElmRequirements requirements) {
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (ElmRequirement def : requirements.getCodeDefs()) {
            result.add(this.toDirectReferenceCode(context, def.getLibraryIdentifier(), (CodeDef)def.getElement()));
        }
        return result;
    }

    private Extension toDirectReferenceCode(ElmRequirementsContext context, VersionedIdentifier libraryIdentifier, CodeDef def) {
        Extension e = new Extension();
        e.setUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-directReferenceCode");
        e.setValue((DataType)this.toCoding(context, libraryIdentifier, context.toCode(def)));
        return e;
    }

    private List<RelatedArtifact> extractRelatedArtifacts(ElmRequirementsContext context, ElmRequirements requirements) {
        ArrayList<RelatedArtifact> result = new ArrayList<RelatedArtifact>();
        for (ElmRequirement def : requirements.getUsingDefs()) {
            if (((UsingDef)def.getElement()).getLocalIdentifier().equals("System")) continue;
            result.add(this.toRelatedArtifact(def.getLibraryIdentifier(), (UsingDef)def.getElement()));
        }
        for (ElmRequirement def : requirements.getIncludeDefs()) {
            result.add(this.toRelatedArtifact(def.getLibraryIdentifier(), (IncludeDef)def.getElement()));
        }
        for (ElmRequirement def : requirements.getCodeSystemDefs()) {
            result.add(this.toRelatedArtifact(def.getLibraryIdentifier(), (CodeSystemDef)def.getElement()));
        }
        for (ElmRequirement def : requirements.getValueSetDefs()) {
            result.add(this.toRelatedArtifact(def.getLibraryIdentifier(), (ValueSetDef)def.getElement()));
        }
        return result;
    }

    private boolean isEquivalentDefinition(ParameterDefinition existingPd, ParameterDefinition pd) {
        return pd.getType() == existingPd.getType();
    }

    private List<ParameterDefinition> extractParameters(ElmRequirementsContext context, ElmRequirements requirements, VersionedIdentifier libraryIdentifier, Iterable<ExpressionDef> expressionDefs) {
        ArrayList<ParameterDefinition> result = new ArrayList<ParameterDefinition>();
        HashMap<String, ParameterDefinition> pds = new HashMap<String, ParameterDefinition>();
        for (ElmRequirement elmRequirement : requirements.getParameterDefs()) {
            ParameterDefinition pd = this.toParameterDefinition(elmRequirement.getLibraryIdentifier(), (ParameterDef)elmRequirement.getElement());
            if (pds.containsKey(pd.getName())) {
                ParameterDefinition existingPd = (ParameterDefinition)pds.get(pd.getName());
                if (this.isEquivalentDefinition(existingPd, pd)) continue;
                this.validationMessages.add(new ValidationMessage(ValidationMessage.Source.Publisher, ValidationMessage.IssueType.NOTSUPPORTED, "CQL Library Packaging", String.format("Parameter declaration %s.%s is already defined in a different library with a different type. Parameter binding may result in errors during evaluation.", elmRequirement.getLibraryIdentifier().getId(), pd.getName()), ValidationMessage.IssueSeverity.WARNING));
                continue;
            }
            pds.put(pd.getName(), pd);
            result.add(pd);
        }
        for (ExpressionDef expressionDef : expressionDefs) {
            if (expressionDef == null || expressionDef instanceof FunctionDef || expressionDef.getAccessLevel() != null && expressionDef.getAccessLevel() != AccessModifier.PUBLIC) continue;
            result.add(this.toOutputParameterDefinition(libraryIdentifier, expressionDef));
        }
        return result;
    }

    private Annotation getAnnotation(Element e) {
        for (Object o : e.getAnnotation()) {
            if (!(o instanceof Annotation)) continue;
            return (Annotation)o;
        }
        return null;
    }

    private String toNarrativeText(Annotation a) {
        StringBuilder sb = new StringBuilder();
        if (a.getS() != null) {
            this.addNarrativeText(sb, a.getS());
        }
        return sb.toString();
    }

    private void addNarrativeText(StringBuilder sb, Narrative n) {
        for (Serializable s : n.getContent()) {
            JAXBElement j;
            if (s instanceof Narrative) {
                this.addNarrativeText(sb, (Narrative)s);
                continue;
            }
            if (s instanceof String) {
                sb.append((String)((Object)s));
                continue;
            }
            if (!(s instanceof JAXBElement) || !((j = (JAXBElement)s).getValue() instanceof Narrative)) continue;
            this.addNarrativeText(sb, (Narrative)j.getValue());
        }
    }

    private List<Extension> extractLogicDefinitions(ElmRequirementsContext context, ElmRequirements requirements) {
        ArrayList<Extension> result = new ArrayList<Extension>();
        int sequence = 0;
        for (ElmRequirement req : requirements.getExpressionDefs()) {
            ExpressionDef def = (ExpressionDef)req.getElement();
            Annotation a = this.getAnnotation((Element)def);
            if (a == null) continue;
            result.add(this.toLogicDefinition(req, def, this.toNarrativeText(a), sequence++));
        }
        return result;
    }

    private StringType toString(String value) {
        StringType result = new StringType();
        result.setValue((Object)value);
        return result;
    }

    private IntegerType toInteger(int value) {
        IntegerType result = new IntegerType();
        result.setValue((Object)value);
        return result;
    }

    private Extension toLogicDefinition(ElmRequirement req, ExpressionDef def, String text, int sequence) {
        Extension e = new Extension();
        e.setUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-logicDefinition");
        e.addExtension(new Extension().setUrl("libraryName").setValue((DataType)this.toString(req.getLibraryIdentifier().getId())));
        e.addExtension(new Extension().setUrl("name").setValue((DataType)this.toString(def.getName())));
        e.addExtension(new Extension().setUrl("statement").setValue((DataType)this.toString(text)));
        e.addExtension(new Extension().setUrl("displaySequence").setValue((DataType)this.toInteger(sequence)));
        return e;
    }

    private List<DataRequirement> extractDataRequirements(ElmRequirementsContext context, ElmRequirements requirements) {
        ArrayList<DataRequirement> result = new ArrayList<DataRequirement>();
        HashMap<String, Retrieve> retrieveMap = new HashMap<String, Retrieve>();
        for (ElmRequirement retrieve : requirements.getRetrieves()) {
            if (retrieve.getElement().getLocalId() == null) continue;
            retrieveMap.put(retrieve.getElement().getLocalId(), (Retrieve)retrieve.getElement());
        }
        for (ElmRequirement retrieve : requirements.getRetrieves()) {
            if (((Retrieve)retrieve.getElement()).getDataType() == null) continue;
            result.add(this.toDataRequirement(context, retrieve.getLibraryIdentifier(), (Retrieve)retrieve.getElement(), retrieveMap, retrieve instanceof ElmDataRequirement ? ((ElmDataRequirement)retrieve).getProperties() : null));
        }
        return result;
    }

    private RelatedArtifact toRelatedArtifact(VersionedIdentifier libraryIdentifier, UsingDef usingDef) {
        return new RelatedArtifact().setType(RelatedArtifact.RelatedArtifactType.DEPENDSON).setDisplay(usingDef.getLocalIdentifier() != null ? String.format("%s model information", usingDef.getLocalIdentifier()) : null).setResource(this.getModelInfoReferenceUrl(usingDef.getUri(), usingDef.getLocalIdentifier(), usingDef.getVersion()));
    }

    private String mapModelInfoUri(String uri, String name) {
        if (name.equals("FHIR") && uri.equals("http://hl7.org/fhir")) {
            return "http://fhir.org/guides/cqf/common";
        }
        return uri;
    }

    private String getModelInfoReferenceUrl(String uri, String name, String version) {
        if (uri != null) {
            return String.format("%s/Library/%s-ModelInfo%s", this.mapModelInfoUri(uri, name), name, version != null ? "|" + version : "");
        }
        return String.format("Library/%-ModelInfo%s", name, version != null ? "|" + version : "");
    }

    private RelatedArtifact toRelatedArtifact(VersionedIdentifier libraryIdentifier, IncludeDef includeDef) {
        return new RelatedArtifact().setType(RelatedArtifact.RelatedArtifactType.DEPENDSON).setDisplay(includeDef.getLocalIdentifier() != null ? String.format("Library %s", includeDef.getLocalIdentifier()) : null).setResource(this.getReferenceUrl(includeDef.getPath(), includeDef.getVersion()));
    }

    private String getReferenceUrl(String path, String version) {
        String uri = NamespaceManager.getUriPart((String)path);
        String name = NamespaceManager.getNamePart((String)path);
        if (uri != null) {
            return String.format("%s/Library/%s%s", uri, name, version != null ? "|" + version : "");
        }
        return String.format("Library/%s%s", path, version != null ? "|" + version : "");
    }

    private RelatedArtifact toRelatedArtifact(VersionedIdentifier libraryIdentifier, CodeSystemDef codeSystemDef) {
        return new RelatedArtifact().setType(RelatedArtifact.RelatedArtifactType.DEPENDSON).setDisplay(String.format("Code system %s", codeSystemDef.getName())).setResource(this.toReference(codeSystemDef));
    }

    private RelatedArtifact toRelatedArtifact(VersionedIdentifier libraryIdentifier, ValueSetDef valueSetDef) {
        return new RelatedArtifact().setType(RelatedArtifact.RelatedArtifactType.DEPENDSON).setDisplay(String.format("Value set %s", valueSetDef.getName())).setResource(this.toReference(valueSetDef));
    }

    private ParameterDefinition toParameterDefinition(VersionedIdentifier libraryIdentifier, ParameterDef def) {
        AtomicBoolean isList = new AtomicBoolean(false);
        Enumerations.FHIRAllTypes typeCode = Enumerations.FHIRAllTypes.fromCode((String)this.toFHIRParameterTypeCode(def.getResultType(), def.getName(), isList));
        return new ParameterDefinition().setName(def.getName()).setUse(Enumerations.OperationParameterUse.IN).setMin(0).setMax(isList.get() ? "*" : "1").setType(typeCode);
    }

    private ParameterDefinition toOutputParameterDefinition(VersionedIdentifier libraryIdentifier, ExpressionDef def) {
        AtomicBoolean isList = new AtomicBoolean(false);
        Enumerations.FHIRAllTypes typeCode = null;
        try {
            typeCode = Enumerations.FHIRAllTypes.fromCode((String)this.toFHIRResultTypeCode(def.getResultType(), def.getName(), isList));
        }
        catch (FHIRException fhirException) {
            this.validationMessages.add(new ValidationMessage(ValidationMessage.Source.Publisher, ValidationMessage.IssueType.NOTSUPPORTED, "CQL Library Packaging", String.format("Result type %s of library %s is not supported; implementations may not be able to use the result of this expression", def.getResultType().toLabel(), libraryIdentifier.getId()), ValidationMessage.IssueSeverity.WARNING));
        }
        return new ParameterDefinition().setName(def.getName()).setUse(Enumerations.OperationParameterUse.OUT).setMin(0).setMax(isList.get() ? "*" : "1").setType(typeCode);
    }

    private String toFHIRResultTypeCode(org.hl7.cql.model.DataType dataType, String defName, AtomicBoolean isList) {
        AtomicBoolean isValid = new AtomicBoolean(true);
        String resultCode = this.toFHIRTypeCode(dataType, isValid, isList);
        if (!isValid.get()) {
            this.validationMessages.add(new ValidationMessage(ValidationMessage.Source.Publisher, ValidationMessage.IssueType.NOTSUPPORTED, "CQL Library Packaging", String.format("Result type %s of definition %s is not supported; implementations may not be able to use the result of this expression", dataType.toLabel(), defName), ValidationMessage.IssueSeverity.WARNING));
        }
        return resultCode;
    }

    private String toFHIRParameterTypeCode(org.hl7.cql.model.DataType dataType, String parameterName, AtomicBoolean isList) {
        AtomicBoolean isValid = new AtomicBoolean(true);
        String resultCode = this.toFHIRTypeCode(dataType, isValid, isList);
        if (!isValid.get()) {
            this.validationMessages.add(new ValidationMessage(ValidationMessage.Source.Publisher, ValidationMessage.IssueType.NOTSUPPORTED, "CQL Library Packaging", String.format("Parameter type %s of parameter %s is not supported; reported as FHIR.Any", dataType.toLabel(), parameterName), ValidationMessage.IssueSeverity.WARNING));
        }
        return resultCode;
    }

    private String toFHIRTypeCode(org.hl7.cql.model.DataType dataType, AtomicBoolean isValid, AtomicBoolean isList) {
        isList.set(false);
        if (dataType instanceof ListType) {
            isList.set(true);
            return this.toFHIRTypeCode(((ListType)dataType).getElementType(), isValid);
        }
        return this.toFHIRTypeCode(dataType, isValid);
    }

    private String toFHIRTypeCode(org.hl7.cql.model.DataType dataType, AtomicBoolean isValid) {
        isValid.set(true);
        if (dataType instanceof NamedType) {
            switch (((NamedType)dataType).getName()) {
                case "System.Boolean": {
                    return "boolean";
                }
                case "System.Integer": {
                    return "integer";
                }
                case "System.Decimal": {
                    return "decimal";
                }
                case "System.Date": {
                    return "date";
                }
                case "System.DateTime": {
                    return "dateTime";
                }
                case "System.Time": {
                    return "time";
                }
                case "System.String": {
                    return "string";
                }
                case "System.Quantity": {
                    return "Quantity";
                }
                case "System.Ratio": {
                    return "Ratio";
                }
                case "System.Any": {
                    return "Any";
                }
                case "System.Code": {
                    return "Coding";
                }
                case "System.Concept": {
                    return "CodeableConcept";
                }
            }
            if ("FHIR".equals(((NamedType)dataType).getNamespace())) {
                return ((NamedType)dataType).getSimpleName();
            }
        }
        if (dataType instanceof IntervalType && ((IntervalType)dataType).getPointType() instanceof NamedType) {
            switch (((NamedType)((IntervalType)dataType).getPointType()).getName()) {
                case "System.Date": 
                case "System.DateTime": {
                    return "Period";
                }
                case "System.Quantity": {
                    return "Range";
                }
            }
        }
        isValid.set(false);
        return "Any";
    }

    private DataRequirement.DataRequirementCodeFilterComponent toCodeFilterComponent(ElmRequirementsContext context, VersionedIdentifier libraryIdentifier, String property, Expression value) {
        DataRequirement.DataRequirementCodeFilterComponent cfc = new DataRequirement.DataRequirementCodeFilterComponent();
        cfc.setPath(property);
        if (value instanceof ValueSetRef) {
            ValueSetRef vsr = (ValueSetRef)value;
            cfc.setValueSet(this.toReference(context.resolveValueSetRef(libraryIdentifier, vsr)));
        }
        if (value instanceof ToList) {
            ToList toList = (ToList)value;
            this.resolveCodeFilterCodes(context, libraryIdentifier, cfc, toList.getOperand());
        }
        if (value instanceof org.hl7.elm.r1.List) {
            org.hl7.elm.r1.List codeList = (org.hl7.elm.r1.List)value;
            for (Expression e : codeList.getElement()) {
                this.resolveCodeFilterCodes(context, libraryIdentifier, cfc, e);
            }
        }
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            cfc.addCode().setCode(literal.getValue());
        }
        return cfc;
    }

    private DataType toFhirValue(ElmRequirementsContext context, Expression value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Interval) {
            return new Period().setStartElement((DateTimeType)this.toFhirValue(context, ((Interval)value).getLow())).setEndElement((DateTimeType)this.toFhirValue(context, ((Interval)value).getHigh()));
        }
        if (value instanceof Literal) {
            if (context.getTypeResolver().isDateTimeType(value.getResultType())) {
                return new DateTimeType(((Literal)value).getValue());
            }
            if (context.getTypeResolver().isDateType(value.getResultType())) {
                return new DateType(((Literal)value).getValue());
            }
        } else {
            if (value instanceof DateTime) {
                throw new IllegalArgumentException("toFhirValue not implemented for DateTime");
            }
            if (value instanceof Date) {
                throw new IllegalArgumentException("toFhirValue not implemented for Date");
            }
        }
        throw new IllegalArgumentException(String.format("toFhirValue not implemented for %s", value.getClass().getSimpleName()));
    }

    private DataRequirement.DataRequirementDateFilterComponent toDateFilterComponent(ElmRequirementsContext context, VersionedIdentifier libraryIdentifier, String property, Expression value) {
        DataRequirement.DataRequirementDateFilterComponent dfc = new DataRequirement.DataRequirementDateFilterComponent();
        dfc.setPath(property);
        if (value instanceof ParameterRef) {
            dfc.setValue((DataType)new DateTimeType());
            dfc.getValue().addExtension("http://hl7.org/fhir/StructureDefinition/cqf-expression", (DataType)new org.hl7.fhir.r5.model.Expression().setLanguage("text/cql-identifier").setExpression(((ParameterRef)value).getName()));
        } else {
            dfc.setValue(this.toFhirValue(context, value));
        }
        return dfc;
    }

    private String stripReference(String path) {
        if (path.endsWith(".reference")) {
            return path.substring(0, path.lastIndexOf("."));
        }
        return path;
    }

    private DataRequirement toDataRequirement(ElmRequirementsContext context, VersionedIdentifier libraryIdentifier, Retrieve retrieve, Map<String, Retrieve> retrieveMap, Iterable<Property> properties) {
        DataRequirement dr = new DataRequirement();
        try {
            dr.setType(Enumerations.FHIRAllTypes.fromCode((String)retrieve.getDataType().getLocalPart()));
        }
        catch (FHIRException fhirException) {
            this.validationMessages.add(new ValidationMessage(ValidationMessage.Source.Publisher, ValidationMessage.IssueType.NOTSUPPORTED, "CQL Library Packaging", String.format("Result type %s of library %s is not supported; implementations may not be able to use the result of this expression", retrieve.getDataType().getLocalPart(), libraryIdentifier.getId()), ValidationMessage.IssueSeverity.WARNING));
        }
        if (retrieve.getLocalId() != null && retrieve.getInclude() != null && retrieve.getInclude().size() > 0) {
            for (Object ie : retrieve.getInclude()) {
                if (ie.getIncludeFrom() == null) continue;
                dr.setId(retrieve.getLocalId());
            }
        }
        if (retrieve.getTemplateId() != null) {
            dr.setProfile(Collections.singletonList(new CanonicalType(retrieve.getTemplateId())));
        }
        HashSet<String> ps = new HashSet<String>();
        if (retrieve.getCodeProperty() != null) {
            dr.getCodeFilter().add(this.toCodeFilterComponent(context, libraryIdentifier, retrieve.getCodeProperty(), retrieve.getCodes()));
            ps.add(retrieve.getCodeProperty());
        }
        for (CodeFilterElement cfe : retrieve.getCodeFilter()) {
            dr.getCodeFilter().add(this.toCodeFilterComponent(context, libraryIdentifier, cfe.getProperty(), cfe.getValue()));
        }
        if (retrieve.getDateProperty() != null) {
            dr.getDateFilter().add(this.toDateFilterComponent(context, libraryIdentifier, retrieve.getDateProperty(), retrieve.getDateRange()));
            ps.add(retrieve.getDateProperty());
        }
        for (DateFilterElement dfe : retrieve.getDateFilter()) {
            dr.getDateFilter().add(this.toDateFilterComponent(context, libraryIdentifier, dfe.getProperty(), dfe.getValue()));
        }
        if (retrieve.getIncludedIn() != null) {
            Retrieve relatedRetrieve = retrieveMap.get(retrieve.getIncludedIn());
            if (relatedRetrieve == null) {
                throw new IllegalArgumentException(String.format("Could not resolve related retrieve with localid %s", retrieve.getIncludedIn()));
            }
            IncludeElement includeElement = null;
            for (IncludeElement ie : relatedRetrieve.getInclude()) {
                if (ie.getIncludeFrom() == null || !ie.getIncludeFrom().equals(retrieve.getLocalId())) continue;
                includeElement = ie;
                break;
            }
            if (relatedRetrieve != null && includeElement != null) {
                Extension relatedRequirement = new Extension().setUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-relatedRequirement");
                relatedRequirement.addExtension("targetId", (DataType)new StringType(retrieve.getIncludedIn()));
                relatedRequirement.addExtension("targetProperty", (DataType)new StringType(this.stripReference(includeElement.getRelatedProperty())));
                dr.addExtension(relatedRequirement);
            }
        }
        if (properties != null) {
            for (Property p : properties) {
                if (ps.contains(p.getPath())) continue;
                ps.add(p.getPath());
            }
        }
        for (String s : ps) {
            dr.addMustSupport(s);
        }
        return dr;
    }

    private void resolveCodeFilterCodes(ElmRequirementsContext context, VersionedIdentifier libraryIdentifier, DataRequirement.DataRequirementCodeFilterComponent cfc, Expression e) {
        CodeRef cr;
        if (e instanceof CodeRef) {
            cr = (CodeRef)e;
            cfc.addCode(this.toCoding(context, libraryIdentifier, context.toCode(context.resolveCodeRef(libraryIdentifier, cr))));
        }
        if (e instanceof Code) {
            cfc.addCode(this.toCoding(context, libraryIdentifier, (Code)e));
        }
        if (e instanceof ConceptRef) {
            cr = (ConceptRef)e;
            CodeableConcept c = this.toCodeableConcept(context, libraryIdentifier, context.toConcept(libraryIdentifier, context.resolveConceptRef(libraryIdentifier, (ConceptRef)cr)));
            for (Coding code : c.getCoding()) {
                cfc.addCode(code);
            }
        }
        if (e instanceof Concept) {
            CodeableConcept c = this.toCodeableConcept(context, libraryIdentifier, (Concept)e);
            for (Coding code : c.getCoding()) {
                cfc.addCode(code);
            }
        }
    }

    private Coding toCoding(ElmRequirementsContext context, VersionedIdentifier libraryIdentifier, Code code) {
        CodeSystemDef codeSystemDef = context.resolveCodeSystemRef(libraryIdentifier, code.getSystem());
        Coding coding = new Coding();
        coding.setCode(code.getCode());
        coding.setDisplay(code.getDisplay());
        coding.setSystem(codeSystemDef.getId());
        coding.setVersion(codeSystemDef.getVersion());
        return coding;
    }

    private CodeableConcept toCodeableConcept(ElmRequirementsContext context, VersionedIdentifier libraryIdentifier, Concept concept) {
        CodeableConcept codeableConcept = new CodeableConcept();
        codeableConcept.setText(concept.getDisplay());
        for (Code code : concept.getCode()) {
            codeableConcept.addCoding(this.toCoding(context, libraryIdentifier, code));
        }
        return codeableConcept;
    }

    private String toReference(CodeSystemDef codeSystemDef) {
        return codeSystemDef.getId() + (codeSystemDef.getVersion() != null ? "|" + codeSystemDef.getVersion() : "");
    }

    private String toReference(ValueSetDef valueSetDef) {
        return valueSetDef.getId() + (valueSetDef.getVersion() != null ? "|" + valueSetDef.getVersion() : "");
    }
}

