/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.cqframework.cql.cql2elm.CqlTranslatorOptions;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.TypeBuilder;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.cqframework.cql.cql2elm.model.LibraryRef;
import org.cqframework.cql.elm.requirements.ElmDataRequirement;
import org.cqframework.cql.elm.requirements.ElmExpressionDefContext;
import org.cqframework.cql.elm.requirements.ElmPertinenceContext;
import org.cqframework.cql.elm.requirements.ElmPropertyRequirement;
import org.cqframework.cql.elm.requirements.ElmQueryAliasContext;
import org.cqframework.cql.elm.requirements.ElmQueryContext;
import org.cqframework.cql.elm.requirements.ElmQueryLetContext;
import org.cqframework.cql.elm.requirements.ElmQueryRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirements;
import org.cqframework.cql.elm.requirements.ElmRequirementsVisitor;
import org.cqframework.cql.elm.requirements.TypeResolver;
import org.hl7.cql.model.DataType;
import org.hl7.cql.model.NamespaceManager;
import org.hl7.elm.r1.AliasRef;
import org.hl7.elm.r1.Code;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeRef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.CodeSystemRef;
import org.hl7.elm.r1.Concept;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.ConceptRef;
import org.hl7.elm.r1.ContextDef;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.ExpressionRef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.hl7.elm.r1.Null;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.ParameterRef;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.QueryLetRef;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.TypeSpecifier;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.ValueSetRef;
import org.hl7.elm.r1.VersionedIdentifier;

public class ElmRequirementsContext {
    private CqlTranslatorOptions options;
    private LibraryManager libraryManager;
    private TypeResolver typeResolver;
    private TypeBuilder typeBuilder;
    private int nextLocalId = 10000;
    private Stack<ElmExpressionDefContext> expressionDefStack = new Stack();
    private List<ElmPertinenceContext> pertinenceContextStack = new ArrayList<ElmPertinenceContext>();
    private Map<ExpressionDef, ElmRequirements> reportedRequirements = new LinkedHashMap<ExpressionDef, ElmRequirements>();
    private Map<ExpressionDef, ElmRequirement> inferredRequirements = new LinkedHashMap<ExpressionDef, ElmRequirement>();
    private Stack<VersionedIdentifier> libraryStack = new Stack();
    private Set<Element> visited = new LinkedHashSet<Element>();
    private ElmRequirements requirements;
    private ElmRequirementsVisitor visitor;
    private Map<QName, ElmDataRequirement> unboundDataRequirements = new LinkedHashMap<QName, ElmDataRequirement>();

    public ElmRequirementsContext(LibraryManager libraryManager, CqlTranslatorOptions options, ElmRequirementsVisitor visitor) {
        if (libraryManager == null) {
            throw new IllegalArgumentException("Library Manager required");
        }
        this.libraryManager = libraryManager;
        this.options = options;
        this.typeResolver = new TypeResolver(libraryManager);
        this.typeBuilder = new TypeBuilder(this.libraryManager.getModelManager());
        if (visitor == null) {
            throw new IllegalArgumentException("visitor required");
        }
        this.visitor = visitor;
        this.requirements = new ElmRequirements(new VersionedIdentifier().withId("result"), (Element)new Null());
    }

    public CqlTranslatorOptions getOptions() {
        return this.options;
    }

    public void setOptions(CqlTranslatorOptions options) {
        this.options = options;
    }

    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public String generateLocalId() {
        ++this.nextLocalId;
        return String.format("G%d", this.nextLocalId);
    }

    public void enterExpressionDef(ExpressionDef expressionDef) {
        if (expressionDef == null) {
            throw new IllegalArgumentException("expressionDef required");
        }
        ElmExpressionDefContext expressionDefContext = new ElmExpressionDefContext(this.getCurrentLibraryIdentifier(), expressionDef);
        this.expressionDefStack.push(expressionDefContext);
    }

    public void exitExpressionDef(ElmRequirement inferredRequirements) {
        if (this.expressionDefStack.empty()) {
            throw new IllegalArgumentException("Not in an expressionDef context");
        }
        ElmExpressionDefContext expressionDefContext = this.expressionDefStack.pop();
        ExpressionDef ed = expressionDefContext.getExpressionDef();
        this.reportExpressionDef(ed);
        this.reportedRequirements.put(ed, expressionDefContext.getReportedRequirements());
        this.inferredRequirements.put(ed, inferredRequirements);
    }

    public ElmExpressionDefContext getCurrentExpressionDefContext() {
        if (this.expressionDefStack.empty()) {
            throw new IllegalArgumentException("Expression definition is not in progress");
        }
        return this.expressionDefStack.peek();
    }

    public boolean inExpressionDefContext() {
        return !this.expressionDefStack.empty();
    }

    public boolean enterPertinenceContext(ExpressionDef expressionDef) {
        ElmPertinenceContext pertinenceContext = new ElmPertinenceContext(expressionDef);
        if (pertinenceContext.checkPertinenceTag()) {
            this.pertinenceContextStack.add(0, pertinenceContext);
            return true;
        }
        return false;
    }

    public ElmPertinenceContext peekPertinenceContext() {
        ElmPertinenceContext context = null;
        Iterator<ElmPertinenceContext> iterator = this.pertinenceContextStack.iterator();
        while (iterator.hasNext()) {
            ElmPertinenceContext c;
            context = c = iterator.next();
        }
        return context;
    }

    public void exitPertinenceContext() {
        if (this.pertinenceContextStack.size() > 0) {
            this.pertinenceContextStack.remove(0);
        }
    }

    public Iterable<ElmRequirements> getReportedRequirements() {
        return this.reportedRequirements.values();
    }

    public ElmRequirements getReportedRequirements(ExpressionDef ed) {
        return this.reportedRequirements.get(ed);
    }

    public Iterable<ElmRequirement> getInferredRequirements() {
        return this.inferredRequirements.values();
    }

    public ElmRequirement getInferredRequirements(ExpressionDef ed) {
        return this.inferredRequirements.get(ed);
    }

    public void enterLibrary(VersionedIdentifier libraryIdentifier) {
        if (libraryIdentifier == null) {
            throw new IllegalArgumentException("Library Identifier must be provided");
        }
        this.libraryStack.push(libraryIdentifier);
    }

    public void exitLibrary() {
        this.libraryStack.pop();
    }

    public VersionedIdentifier getCurrentLibraryIdentifier() {
        if (this.libraryStack.empty()) {
            throw new IllegalArgumentException("Not in a library context");
        }
        return this.libraryStack.peek();
    }

    private CompiledLibrary prepareLibraryVisit(VersionedIdentifier libraryIdentifier, String localLibraryName) {
        CompiledLibrary targetLibrary = this.resolveLibrary(libraryIdentifier);
        if (localLibraryName != null) {
            IncludeDef includeDef = targetLibrary.resolveIncludeRef(localLibraryName);
            if (!this.visited.contains(includeDef)) {
                this.visitor.visitElement((Element)includeDef, this);
            }
            targetLibrary = this.resolveLibraryFromIncludeDef(includeDef);
            this.enterLibrary(targetLibrary.getIdentifier());
        }
        return targetLibrary;
    }

    private void unprepareLibraryVisit(String localLibraryName) {
        if (localLibraryName != null) {
            this.exitLibrary();
        }
    }

    public void enterQueryContext(Query query) {
        this.getCurrentExpressionDefContext().enterQueryContext(query);
    }

    public ElmQueryContext exitQueryContext() {
        return this.getCurrentExpressionDefContext().exitQueryContext();
    }

    public ElmQueryContext getCurrentQueryContext() {
        return this.getCurrentExpressionDefContext().getCurrentQueryContext();
    }

    public boolean inQueryContext() {
        return this.getCurrentExpressionDefContext().inQueryContext();
    }

    public ElmQueryAliasContext resolveAlias(String aliasName) {
        return this.getCurrentExpressionDefContext().resolveAlias(aliasName);
    }

    public ElmQueryLetContext resolveLet(String letName) {
        return this.getCurrentExpressionDefContext().resolveLet(letName);
    }

    public ElmRequirements getRequirements() {
        return this.requirements;
    }

    public ElmRequirementsVisitor getVisitor() {
        return this.visitor;
    }

    private boolean isDefinition(Element elm) {
        return elm instanceof Library || elm instanceof UsingDef || elm instanceof IncludeDef || elm instanceof CodeSystemDef || elm instanceof ValueSetDef || elm instanceof CodeDef || elm instanceof ConceptDef || elm instanceof ParameterDef || elm instanceof ContextDef || elm instanceof ExpressionDef;
    }

    private void reportRequirement(ElmRequirement requirement) {
        if (this.isDefinition(requirement.getElement())) {
            this.visited.add(requirement.getElement());
            this.requirements.reportRequirement(requirement);
        } else if (this.expressionDefStack.empty()) {
            this.requirements.reportRequirement(requirement);
        } else {
            this.expressionDefStack.peek().reportRequirement(requirement);
        }
    }

    private void reportRequirement(Element element) {
        this.reportRequirement(new ElmRequirement(this.getCurrentLibraryIdentifier(), element));
    }

    public void reportUsingDef(UsingDef usingDef) {
        this.reportRequirement((Element)usingDef);
    }

    public void reportIncludeDef(IncludeDef includeDef) {
        this.reportRequirement((Element)includeDef);
    }

    public void reportContextDef(ContextDef contextDef) {
        this.reportRequirement((Element)contextDef);
    }

    public void reportCodeDef(CodeDef codeDef) {
        this.reportRequirement((Element)codeDef);
    }

    public void reportCodeSystemDef(CodeSystemDef codeSystemDef) {
        this.reportRequirement((Element)codeSystemDef);
    }

    public void reportConceptDef(ConceptDef conceptDef) {
        this.reportRequirement((Element)conceptDef);
    }

    public void reportParameterDef(ParameterDef parameterDef) {
        this.reportRequirement((Element)parameterDef);
    }

    public void reportValueSetDef(ValueSetDef valueSetDef) {
        this.reportRequirement((Element)valueSetDef);
    }

    public void reportExpressionDef(ExpressionDef expressionDef) {
        if (!(expressionDef instanceof FunctionDef)) {
            this.reportRequirement((Element)expressionDef);
        }
    }

    public void reportFunctionDef(FunctionDef functionDef) {
        this.reportRequirement((Element)functionDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportCodeRef(CodeRef codeRef) {
        CompiledLibrary targetLibrary = this.prepareLibraryVisit(this.getCurrentLibraryIdentifier(), codeRef.getLibraryName());
        try {
            CodeDef cd = targetLibrary.resolveCodeRef(codeRef.getName());
            if (!this.visited.contains(cd)) {
                this.visitor.visitElement((Element)cd, this);
            }
        }
        finally {
            this.unprepareLibraryVisit(codeRef.getLibraryName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportCodeSystemRef(CodeSystemRef codeSystemRef) {
        CompiledLibrary targetLibrary = this.prepareLibraryVisit(this.getCurrentLibraryIdentifier(), codeSystemRef.getLibraryName());
        try {
            CodeSystemDef csd = targetLibrary.resolveCodeSystemRef(codeSystemRef.getName());
            if (!this.visited.contains(csd)) {
                this.visitor.visitElement((Element)csd, this);
            }
        }
        finally {
            this.unprepareLibraryVisit(codeSystemRef.getLibraryName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportConceptRef(ConceptRef conceptRef) {
        CompiledLibrary targetLibrary = this.prepareLibraryVisit(this.getCurrentLibraryIdentifier(), conceptRef.getLibraryName());
        try {
            ConceptDef cd = targetLibrary.resolveConceptRef(conceptRef.getName());
            if (!this.visited.contains(cd)) {
                this.visitor.visitElement((Element)cd, this);
            }
        }
        finally {
            this.unprepareLibraryVisit(conceptRef.getLibraryName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportParameterRef(ParameterRef parameterRef) {
        CompiledLibrary targetLibrary = this.prepareLibraryVisit(this.getCurrentLibraryIdentifier(), parameterRef.getLibraryName());
        try {
            ParameterDef pd = targetLibrary.resolveParameterRef(parameterRef.getName());
            if (!this.visited.contains(pd)) {
                this.visitor.visitElement((Element)pd, this);
            }
        }
        finally {
            this.unprepareLibraryVisit(parameterRef.getLibraryName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportValueSetRef(ValueSetRef valueSetRef) {
        CompiledLibrary targetLibrary = this.prepareLibraryVisit(this.getCurrentLibraryIdentifier(), valueSetRef.getLibraryName());
        try {
            ValueSetDef vsd = targetLibrary.resolveValueSetRef(valueSetRef.getName());
            if (!this.visited.contains(vsd)) {
                this.visitor.visitElement((Element)vsd, this);
            }
        }
        finally {
            this.unprepareLibraryVisit(valueSetRef.getLibraryName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElmRequirement reportExpressionRef(ExpressionRef expressionRef) {
        CompiledLibrary targetLibrary = this.prepareLibraryVisit(this.getCurrentLibraryIdentifier(), expressionRef.getLibraryName());
        try {
            ExpressionDef ed = targetLibrary.resolveExpressionRef(expressionRef.getName());
            if (!this.visited.contains(ed)) {
                this.visitor.visitElement((Element)ed, this);
            }
            ElmRequirement inferredRequirements = this.getInferredRequirements(ed);
            ElmRequirements reportedRequirements = this.getReportedRequirements(ed);
            if (reportedRequirements != null) {
                this.reportRequirements(reportedRequirements, inferredRequirements);
            }
            ElmRequirement elmRequirement = inferredRequirements;
            return elmRequirement;
        }
        finally {
            this.unprepareLibraryVisit(expressionRef.getLibraryName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportFunctionRef(FunctionRef functionRef) {
        CompiledLibrary targetLibrary = this.prepareLibraryVisit(this.getCurrentLibraryIdentifier(), functionRef.getLibraryName());
        try {
            ArrayList<DataType> signature = new ArrayList<DataType>();
            for (TypeSpecifier ts : functionRef.getSignature()) {
                signature.add(this.typeResolver.resolveTypeSpecifier(ts));
            }
            if (signature.size() != functionRef.getOperand().size()) {
                for (Expression e : functionRef.getOperand()) {
                    if (e.getResultType() != null) {
                        signature.add(e.getResultType());
                        continue;
                    }
                    if (e.getResultTypeName() != null) {
                        signature.add(this.typeResolver.resolveTypeName(e.getResultTypeName()));
                        continue;
                    }
                    if (e.getResultTypeSpecifier() != null) {
                        signature.add(this.typeResolver.resolveTypeSpecifier(e.getResultTypeSpecifier()));
                        continue;
                    }
                    signature = null;
                    break;
                }
            }
            Iterable fds = targetLibrary.resolveFunctionRef(functionRef.getName(), signature);
            for (FunctionDef fd : fds) {
                if (this.visited.contains(fd)) continue;
                this.visitor.visitElement((Element)fd, this);
            }
        }
        finally {
            this.unprepareLibraryVisit(functionRef.getLibraryName());
        }
    }

    public void reportRetrieve(Retrieve retrieve) {
        this.reportRequirement((Element)retrieve);
    }

    public void reportRequirements(ElmRequirement requirement, ElmRequirement inferredRequirements) {
        if (requirement instanceof ElmRequirements) {
            for (ElmRequirement childRequirement : ((ElmRequirements)requirement).getRequirements()) {
                if (inferredRequirements != null && inferredRequirements.hasRequirement(childRequirement)) continue;
                this.reportRequirement(childRequirement);
            }
        } else if (requirement instanceof ElmQueryRequirement) {
            ElmQueryRequirement queryRequirement = (ElmQueryRequirement)requirement;
            for (ElmDataRequirement dataRequirement : queryRequirement.getDataRequirements()) {
                if (inferredRequirements != null && inferredRequirements.hasRequirement(dataRequirement)) continue;
                this.reportRequirement(dataRequirement);
            }
        } else {
            this.reportRequirement(requirement);
        }
    }

    private QName getType(Expression expression) {
        if (expression != null) {
            if (expression.getResultTypeName() != null) {
                return expression.getResultTypeName();
            }
            if (expression.getResultTypeSpecifier() instanceof NamedTypeSpecifier) {
                return ((NamedTypeSpecifier)expression.getResultTypeSpecifier()).getName();
            }
        }
        return null;
    }

    private ElmDataRequirement getDataRequirementForTypeName(QName typeName) {
        ElmDataRequirement requirement = this.unboundDataRequirements.get(typeName);
        if (requirement == null) {
            Retrieve retrieve = new Retrieve();
            retrieve.setDataType(typeName);
            if (typeName.getNamespaceURI() != null && typeName.getLocalPart() != null) {
                retrieve.setTemplateId(typeName.getNamespaceURI() + "/" + typeName.getLocalPart());
            }
            requirement = new ElmDataRequirement(this.getCurrentLibraryIdentifier(), retrieve);
            this.unboundDataRequirements.put(typeName, requirement);
            this.reportRequirement(requirement);
        }
        return requirement;
    }

    public ElmPropertyRequirement reportProperty(Property property) {
        if (property.getScope() != null || property.getSource() instanceof AliasRef) {
            String aliasName = property.getScope() != null ? property.getScope() : ((AliasRef)property.getSource()).getName();
            ElmQueryAliasContext aliasContext = this.getCurrentQueryContext().resolveAlias(aliasName);
            boolean inCurrentScope = true;
            if (aliasContext == null) {
                aliasContext = this.resolveAlias(aliasName);
                inCurrentScope = false;
            }
            ElmPropertyRequirement propertyRequirement = new ElmPropertyRequirement(this.getCurrentLibraryIdentifier(), property, (Element)aliasContext.getQuerySource(), inCurrentScope);
            aliasContext.reportProperty(propertyRequirement);
            return propertyRequirement;
        }
        if (property.getSource() instanceof QueryLetRef) {
            String letName = ((QueryLetRef)property.getSource()).getName();
            ElmQueryLetContext letContext = this.getCurrentQueryContext().resolveLet(letName);
            boolean inCurrentScope = true;
            if (letContext == null) {
                letContext = this.resolveLet(letName);
                inCurrentScope = false;
            }
            ElmPropertyRequirement propertyRequirement = new ElmPropertyRequirement(this.getCurrentLibraryIdentifier(), property, (Element)letContext.getLetClause(), inCurrentScope);
            letContext.reportProperty(propertyRequirement);
            return propertyRequirement;
        }
        if (property.getSource() instanceof Property) {
            Property sourceProperty = (Property)property.getSource();
            Property qualifiedProperty = new Property();
            qualifiedProperty.setSource(sourceProperty.getSource());
            qualifiedProperty.setScope(sourceProperty.getScope());
            qualifiedProperty.setResultType(property.getResultType());
            qualifiedProperty.setResultTypeName(property.getResultTypeName());
            qualifiedProperty.setResultTypeSpecifier(property.getResultTypeSpecifier());
            qualifiedProperty.setLocalId(sourceProperty.getLocalId());
            qualifiedProperty.setPath(sourceProperty.getPath() + "." + property.getPath());
            return this.reportProperty(qualifiedProperty);
        }
        QName typeName = this.getType(property.getSource());
        if (typeName != null) {
            ElmDataRequirement requirement = this.getDataRequirementForTypeName(typeName);
            ElmPropertyRequirement propertyRequirement = new ElmPropertyRequirement(this.getCurrentLibraryIdentifier(), property, (Element)property.getSource(), false);
            requirement.reportProperty(propertyRequirement);
            return propertyRequirement;
        }
        return null;
    }

    public Concept toConcept(ElmRequirement conceptDef) {
        return this.toConcept(conceptDef.getLibraryIdentifier(), (ConceptDef)conceptDef.getElement());
    }

    public Concept toConcept(VersionedIdentifier libraryIdentifier, ConceptDef conceptDef) {
        Concept concept = new Concept();
        concept.setDisplay(conceptDef.getDisplay());
        for (CodeRef codeRef : conceptDef.getCode()) {
            concept.getCode().add(this.toCode(this.resolveCodeRef(libraryIdentifier, codeRef)));
        }
        return concept;
    }

    public Code toCode(CodeDef codeDef) {
        return new Code().withCode(codeDef.getId()).withSystem(codeDef.getCodeSystem()).withDisplay(codeDef.getDisplay());
    }

    public CodeDef resolveCodeRef(ElmRequirement codeRef) {
        return this.resolveCodeRef(codeRef.getLibraryIdentifier(), (CodeRef)codeRef.getElement());
    }

    public CodeDef resolveCodeRef(VersionedIdentifier libraryIdentifier, CodeRef codeRef) {
        if (codeRef.getLibraryName() != null) {
            return this.resolveLibrary(libraryIdentifier, codeRef.getLibraryName()).resolveCodeRef(codeRef.getName());
        }
        return this.resolveLibrary(libraryIdentifier).resolveCodeRef(codeRef.getName());
    }

    public ConceptDef resolveConceptRef(ElmRequirement conceptRef) {
        return this.resolveConceptRef(conceptRef.getLibraryIdentifier(), (ConceptRef)conceptRef.getElement());
    }

    public ConceptDef resolveConceptRef(VersionedIdentifier libraryIdentifier, ConceptRef conceptRef) {
        if (conceptRef.getLibraryName() != null) {
            return this.resolveLibrary(libraryIdentifier, conceptRef.getLibraryName()).resolveConceptRef(conceptRef.getName());
        }
        return this.resolveLibrary(libraryIdentifier).resolveConceptRef(conceptRef.getName());
    }

    public CodeSystemDef resolveCodeSystemRef(ElmRequirement codeSystemRef) {
        return this.resolveCodeSystemRef(codeSystemRef.getLibraryIdentifier(), (CodeSystemRef)codeSystemRef.getElement());
    }

    public CodeSystemDef resolveCodeSystemRef(VersionedIdentifier libraryIdentifier, CodeSystemRef codeSystemRef) {
        if (codeSystemRef.getLibraryName() != null) {
            return this.resolveLibrary(libraryIdentifier, codeSystemRef.getLibraryName()).resolveCodeSystemRef(codeSystemRef.getName());
        }
        return this.resolveLibrary(libraryIdentifier).resolveCodeSystemRef(codeSystemRef.getName());
    }

    public ValueSetDef resolveValueSetRef(ElmRequirement valueSetRef) {
        return this.resolveValueSetRef(valueSetRef.getLibraryIdentifier(), (ValueSetRef)valueSetRef.getElement());
    }

    public ValueSetDef resolveValueSetRef(VersionedIdentifier libraryIdentifier, ValueSetRef valueSetRef) {
        if (valueSetRef.getLibraryName() != null) {
            return this.resolveLibrary(libraryIdentifier, valueSetRef.getLibraryName()).resolveValueSetRef(valueSetRef.getName());
        }
        return this.resolveLibrary(libraryIdentifier).resolveValueSetRef(valueSetRef.getName());
    }

    public CompiledLibrary resolveLibrary(ElmRequirement libraryRef) {
        return this.resolveLibrary(libraryRef.getLibraryIdentifier(), ((LibraryRef)libraryRef.getElement()).getLibraryName());
    }

    public IncludeDef resolveIncludeRef(VersionedIdentifier libraryIdentifier, String localLibraryName) {
        CompiledLibrary targetLibrary = this.resolveLibrary(libraryIdentifier);
        return targetLibrary.resolveIncludeRef(localLibraryName);
    }

    public CompiledLibrary resolveLibrary(VersionedIdentifier libraryIdentifier, String localLibraryName) {
        IncludeDef includeDef = this.resolveIncludeRef(libraryIdentifier, localLibraryName);
        return this.resolveLibraryFromIncludeDef(includeDef);
    }

    public CompiledLibrary resolveLibraryFromIncludeDef(IncludeDef includeDef) {
        VersionedIdentifier targetLibraryIdentifier = new VersionedIdentifier().withSystem(NamespaceManager.getUriPart((String)includeDef.getPath())).withId(NamespaceManager.getNamePart((String)includeDef.getPath())).withVersion(includeDef.getVersion());
        return this.resolveLibrary(targetLibraryIdentifier);
    }

    public CompiledLibrary resolveLibrary(VersionedIdentifier libraryIdentifier) {
        ArrayList errors = new ArrayList();
        CompiledLibrary referencedLibrary = this.libraryManager.resolveLibrary(libraryIdentifier, this.options, errors);
        return referencedLibrary;
    }
}

