/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.evaluation;

import java.math.BigDecimal;
import org.cqframework.cql.elm.requirements.ElmRequirementsContext;
import org.hl7.cql.model.IntervalType;
import org.hl7.elm.r1.Date;
import org.hl7.elm.r1.DateTime;
import org.hl7.elm.r1.End;
import org.hl7.elm.r1.Interval;
import org.hl7.elm.r1.Literal;
import org.hl7.elm.r1.ParameterRef;
import org.hl7.elm.r1.Start;
import org.hl7.elm.r1.Time;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TimeType;

public class ElmAnalysisHelper {
    private static DateTimeType toFhirDateTimeValue(ElmRequirementsContext context, org.hl7.elm.r1.Expression value) {
        if (value == null) {
            return null;
        }
        DataType result = ElmAnalysisHelper.toFhirValue(context, value);
        if (result instanceof DateTimeType) {
            return (DateTimeType)result;
        }
        if (result instanceof DateType) {
            return new DateTimeType(((DateType)result).getValueAsString());
        }
        throw new IllegalArgumentException("Could not convert expression to a DateTime value");
    }

    public static DataType toFhirValue(ElmRequirementsContext context, org.hl7.elm.r1.Expression value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ParameterRef) {
            if (context.getTypeResolver().isIntervalType(value.getResultType())) {
                Extension e = ElmAnalysisHelper.toExpression(context, (ParameterRef)value);
                org.hl7.cql.model.DataType pointType = ((IntervalType)value.getResultType()).getPointType();
                if (context.getTypeResolver().isDateTimeType(pointType) || context.getTypeResolver().isDateType(pointType)) {
                    Period period = new Period();
                    period.addExtension(e);
                    return period;
                }
                if (context.getTypeResolver().isQuantityType(pointType) || context.getTypeResolver().isIntegerType(pointType) || context.getTypeResolver().isDecimalType(pointType)) {
                    Range range = new Range();
                    range.addExtension(e);
                    return range;
                }
                throw new IllegalArgumentException(String.format("toFhirValue not implemented for interval of %s", pointType.toString()));
            }
            if (context.getTypeResolver().isBooleanType(value.getResultType())) {
                BooleanType result = new BooleanType();
                result.addExtension(ElmAnalysisHelper.toExpression(context, (ParameterRef)value));
                return result;
            }
            if (context.getTypeResolver().isIntegerType(value.getResultType())) {
                IntegerType result = new IntegerType();
                result.addExtension(ElmAnalysisHelper.toExpression(context, (ParameterRef)value));
                return result;
            }
            if (context.getTypeResolver().isDecimalType(value.getResultType())) {
                DecimalType result = new DecimalType();
                result.addExtension(ElmAnalysisHelper.toExpression(context, (ParameterRef)value));
                return result;
            }
            if (context.getTypeResolver().isQuantityType(value.getResultType())) {
                Quantity result = new Quantity();
                result.addExtension(ElmAnalysisHelper.toExpression(context, (ParameterRef)value));
                return result;
            }
            if (context.getTypeResolver().isCodeType(value.getResultType())) {
                Coding result = new Coding();
                result.addExtension(ElmAnalysisHelper.toExpression(context, (ParameterRef)value));
                return result;
            }
            if (context.getTypeResolver().isConceptType(value.getResultType())) {
                CodeableConcept result = new CodeableConcept();
                result.addExtension(ElmAnalysisHelper.toExpression(context, (ParameterRef)value));
                return result;
            }
            if (context.getTypeResolver().isDateType(value.getResultType())) {
                DateType result = new DateType();
                result.addExtension(ElmAnalysisHelper.toExpression(context, (ParameterRef)value));
                return result;
            }
            if (context.getTypeResolver().isDateTimeType(value.getResultType())) {
                DateTimeType result = new DateTimeType();
                result.addExtension(ElmAnalysisHelper.toExpression(context, (ParameterRef)value));
                return result;
            }
            if (context.getTypeResolver().isTimeType(value.getResultType())) {
                TimeType result = new TimeType();
                result.addExtension(ElmAnalysisHelper.toExpression(context, (ParameterRef)value));
                return result;
            }
            throw new IllegalArgumentException(String.format("toFhirValue not implemented for parameter of type %s", value.getResultType().toString()));
        }
        if (value instanceof Interval) {
            return new Period().setStartElement(ElmAnalysisHelper.toFhirDateTimeValue(context, ((Interval)value).getLow())).setEndElement(ElmAnalysisHelper.toFhirDateTimeValue(context, ((Interval)value).getHigh()));
        }
        if (value instanceof Literal) {
            if (context.getTypeResolver().isDateTimeType(value.getResultType())) {
                return new DateTimeType(((Literal)value).getValue());
            }
            if (context.getTypeResolver().isDateType(value.getResultType())) {
                return new DateType(((Literal)value).getValue());
            }
            if (context.getTypeResolver().isIntegerType(value.getResultType())) {
                return new IntegerType(((Literal)value).getValue());
            }
            if (context.getTypeResolver().isDecimalType(value.getResultType())) {
                return new DecimalType(((Literal)value).getValue());
            }
            if (context.getTypeResolver().isStringType(value.getResultType())) {
                return new StringType(((Literal)value).getValue());
            }
        } else {
            DataType operand;
            if (value instanceof DateTime) {
                DateTime dateTime = (DateTime)value;
                return new DateTimeType(ElmAnalysisHelper.toDateTimeString(ElmAnalysisHelper.toFhirValue(context, dateTime.getYear()), ElmAnalysisHelper.toFhirValue(context, dateTime.getMonth()), ElmAnalysisHelper.toFhirValue(context, dateTime.getDay()), ElmAnalysisHelper.toFhirValue(context, dateTime.getHour()), ElmAnalysisHelper.toFhirValue(context, dateTime.getMinute()), ElmAnalysisHelper.toFhirValue(context, dateTime.getSecond()), ElmAnalysisHelper.toFhirValue(context, dateTime.getMillisecond()), ElmAnalysisHelper.toFhirValue(context, dateTime.getTimezoneOffset())));
            }
            if (value instanceof Date) {
                Date date = (Date)value;
                return new DateType(ElmAnalysisHelper.toDateString(ElmAnalysisHelper.toFhirValue(context, date.getYear()), ElmAnalysisHelper.toFhirValue(context, date.getMonth()), ElmAnalysisHelper.toFhirValue(context, date.getDay())));
            }
            if (value instanceof Time) {
                Time time = (Time)value;
                return new TimeType(ElmAnalysisHelper.toTimeString(ElmAnalysisHelper.toFhirValue(context, time.getHour()), ElmAnalysisHelper.toFhirValue(context, time.getMinute()), ElmAnalysisHelper.toFhirValue(context, time.getSecond()), ElmAnalysisHelper.toFhirValue(context, time.getMillisecond())));
            }
            if (value instanceof Start) {
                DataType operand2 = ElmAnalysisHelper.toFhirValue(context, ((Start)value).getOperand());
                if (operand2 != null) {
                    Period period = (Period)operand2;
                    return period.getStartElement();
                }
            } else if (value instanceof End && (operand = ElmAnalysisHelper.toFhirValue(context, ((End)value).getOperand())) != null) {
                Period period = (Period)operand;
                return period.getEndElement();
            }
        }
        throw new IllegalArgumentException(String.format("toFhirValue not implemented for %s", value.getClass().getSimpleName()));
    }

    private static String padLeft(String input, int width, String padWith) {
        if (input == null || padWith == null || padWith.length() == 0) {
            return null;
        }
        while (((String)input).length() < width) {
            input = padWith + (String)input;
        }
        return input;
    }

    private static String padZero(String input, int width) {
        return ElmAnalysisHelper.padLeft(input, width, "0");
    }

    private static String toDateTimeString(DataType year, DataType month, DataType day, DataType hour, DataType minute, DataType second, DataType millisecond, DataType timezoneOffset) {
        if (year == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (year instanceof IntegerType) {
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)year).getValue()).toString(), 4));
        }
        if (month instanceof IntegerType) {
            result.append("-");
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)month).getValue()).toString(), 2));
        }
        if (day instanceof IntegerType) {
            result.append("-");
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)day).getValue()).toString(), 2));
        }
        if (hour instanceof IntegerType) {
            result.append("T");
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)hour).getValue()).toString(), 2));
        }
        if (minute instanceof IntegerType) {
            result.append(":");
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)minute).getValue()).toString(), 2));
        }
        if (second instanceof IntegerType) {
            result.append(":");
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)second).getValue()).toString(), 2));
        }
        if (millisecond instanceof IntegerType) {
            result.append(".");
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)millisecond).getValue()).toString(), 3));
        }
        if (timezoneOffset instanceof DecimalType) {
            BigDecimal offset = (BigDecimal)((DecimalType)timezoneOffset).getValue();
            if (offset.intValue() >= 0) {
                result.append("+");
                result.append(ElmAnalysisHelper.padZero(Integer.toString(offset.intValue()), 2));
            } else {
                result.append("-");
                result.append(ElmAnalysisHelper.padZero(Integer.toString(Math.abs(offset.intValue())), 2));
            }
            int minutes = new BigDecimal("60").multiply(offset.remainder(BigDecimal.ONE)).intValue();
            result.append(":");
            result.append(ElmAnalysisHelper.padZero(Integer.toString(minutes), 2));
        }
        return result.toString();
    }

    private static String toDateString(DataType year, DataType month, DataType day) {
        if (year == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (year instanceof IntegerType) {
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)year).getValue()).toString(), 4));
        }
        if (month instanceof IntegerType) {
            result.append("-");
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)month).getValue()).toString(), 2));
        }
        if (day instanceof IntegerType) {
            result.append("-");
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)day).getValue()).toString(), 2));
        }
        return result.toString();
    }

    private static String toTimeString(DataType hour, DataType minute, DataType second, DataType millisecond) {
        if (hour == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (hour instanceof IntegerType) {
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)hour).getValue()).toString(), 2));
        }
        if (minute instanceof IntegerType) {
            result.append(":");
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)minute).getValue()).toString(), 2));
        }
        if (second instanceof IntegerType) {
            result.append(":");
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)second).getValue()).toString(), 2));
        }
        if (millisecond instanceof IntegerType) {
            result.append(".");
            result.append(ElmAnalysisHelper.padZero(((Integer)((IntegerType)millisecond).getValue()).toString(), 3));
        }
        return result.toString();
    }

    private static Extension toExpression(ElmRequirementsContext context, ParameterRef parameterRef) {
        String expression = parameterRef.getName();
        if (parameterRef.getLibraryName() != null && !parameterRef.getLibraryName().equals(context.getCurrentLibraryIdentifier().getId())) {
            expression = String.format("\"%s\".\"%s\"", parameterRef.getLibraryName(), parameterRef.getName());
        }
        return new Extension().setUrl("http://hl7.org/fhir/StructureDefinition/cqf-expression").setValue((DataType)new Expression().setLanguage("text/cql-identifier").setExpression(expression));
    }
}

