/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import java.util.Iterator;
import java.util.Stack;
import org.cqframework.cql.elm.requirements.ElmQueryAliasContext;
import org.cqframework.cql.elm.requirements.ElmQueryContext;
import org.cqframework.cql.elm.requirements.ElmQueryLetContext;
import org.cqframework.cql.elm.requirements.ElmRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirements;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.VersionedIdentifier;

public class ElmExpressionDefContext {
    private VersionedIdentifier libraryIdentifier;
    private ExpressionDef expressionDef;
    private ElmRequirements reportedRequirements;
    private Stack<ElmQueryContext> queryStack = new Stack();

    public ElmExpressionDefContext(VersionedIdentifier libraryIdentifier, ExpressionDef expressionDef) {
        if (libraryIdentifier == null) {
            throw new IllegalArgumentException("libraryIdentifier required");
        }
        this.libraryIdentifier = libraryIdentifier;
        if (expressionDef == null) {
            throw new IllegalArgumentException("expressionDef requirement");
        }
        this.expressionDef = expressionDef;
        this.reportedRequirements = new ElmRequirements(libraryIdentifier, (Element)expressionDef);
    }

    public VersionedIdentifier getLibraryIdentifier() {
        return this.libraryIdentifier;
    }

    public ExpressionDef getExpressionDef() {
        return this.expressionDef;
    }

    public ElmRequirements getReportedRequirements() {
        return this.reportedRequirements;
    }

    public void reportRequirement(ElmRequirement requirement) {
        this.reportedRequirements.reportRequirement(requirement);
    }

    public void enterQueryContext(Query query) {
        this.queryStack.push(new ElmQueryContext(this.libraryIdentifier, query));
    }

    public ElmQueryContext exitQueryContext() {
        ElmQueryContext queryContext = this.queryStack.pop();
        return queryContext;
    }

    public ElmQueryContext getCurrentQueryContext() {
        if (this.queryStack.empty()) {
            throw new IllegalArgumentException("Not in a query context");
        }
        return this.queryStack.peek();
    }

    public boolean inQueryContext() {
        return !this.queryStack.empty();
    }

    public ElmQueryLetContext resolveLet(String letName) {
        ElmQueryContext queryContext;
        ElmQueryLetContext letContext = null;
        Iterator iterator = this.queryStack.iterator();
        while (iterator.hasNext() && (letContext = (queryContext = (ElmQueryContext)iterator.next()).resolveLet(letName)) == null) {
        }
        if (letContext == null) {
            throw new IllegalArgumentException(String.format("Could not resolve let %s", letName));
        }
        return letContext;
    }

    public ElmQueryAliasContext resolveAlias(String aliasName) {
        ElmQueryContext queryContext;
        ElmQueryAliasContext aliasContext = null;
        Iterator iterator = this.queryStack.iterator();
        while (iterator.hasNext() && (aliasContext = (queryContext = (ElmQueryContext)iterator.next()).resolveAlias(aliasName)) == null) {
        }
        if (aliasContext == null) {
            throw new IllegalArgumentException(String.format("Could not resolve alias %s", aliasName));
        }
        return aliasContext;
    }
}

