/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import org.cqframework.cql.elm.requirements.ElmConditionRequirement;
import org.cqframework.cql.elm.requirements.ElmConjunctiveRequirement;
import org.cqframework.cql.elm.requirements.ElmConstraintRequirement;
import org.cqframework.cql.elm.requirements.ElmDataRequirement;
import org.cqframework.cql.elm.requirements.ElmDisjunctiveRequirement;
import org.cqframework.cql.elm.requirements.ElmExpressionRequirement;
import org.cqframework.cql.elm.requirements.ElmJoinRequirement;
import org.cqframework.cql.elm.requirements.ElmOperatorRequirement;
import org.cqframework.cql.elm.requirements.ElmPertinenceContext;
import org.cqframework.cql.elm.requirements.ElmPropertyRequirement;
import org.cqframework.cql.elm.requirements.ElmQueryAliasContext;
import org.cqframework.cql.elm.requirements.ElmQueryContext;
import org.cqframework.cql.elm.requirements.ElmQueryLetContext;
import org.cqframework.cql.elm.requirements.ElmQueryRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirements;
import org.cqframework.cql.elm.requirements.ElmRequirementsContext;
import org.cqframework.cql.elm.tracking.Trackable;
import org.cqframework.cql.elm.visiting.BaseElmLibraryVisitor;
import org.hl7.cql.model.ListType;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.AnyInCodeSystem;
import org.hl7.elm.r1.AnyInValueSet;
import org.hl7.elm.r1.BinaryExpression;
import org.hl7.elm.r1.Case;
import org.hl7.elm.r1.CaseItem;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeRef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.CodeSystemRef;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.ConceptRef;
import org.hl7.elm.r1.ContextDef;
import org.hl7.elm.r1.Date;
import org.hl7.elm.r1.DateTime;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.ExpressionRef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.IdentifierRef;
import org.hl7.elm.r1.If;
import org.hl7.elm.r1.InCodeSystem;
import org.hl7.elm.r1.InValueSet;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.Interval;
import org.hl7.elm.r1.LetClause;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.Literal;
import org.hl7.elm.r1.NaryExpression;
import org.hl7.elm.r1.Now;
import org.hl7.elm.r1.Null;
import org.hl7.elm.r1.OperandRef;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.ParameterRef;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.RelationshipClause;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.Split;
import org.hl7.elm.r1.TernaryExpression;
import org.hl7.elm.r1.Time;
import org.hl7.elm.r1.TimeOfDay;
import org.hl7.elm.r1.Today;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.ValueSetRef;
import org.hl7.elm.r1.With;
import org.hl7.elm.r1.Without;

public class ElmRequirementsVisitor
extends BaseElmLibraryVisitor<ElmRequirement, ElmRequirementsContext> {
    public ElmRequirement aggregateResult(ElmRequirement result, ElmRequirement nextResult) {
        if (result == null) {
            return nextResult;
        }
        if (nextResult == null) {
            return result;
        }
        if (result instanceof ElmRequirements) {
            ((ElmRequirements)result).reportRequirement(nextResult);
            return result;
        }
        ElmRequirements requirements = new ElmRequirements(result.getLibraryIdentifier(), result.getElement());
        requirements.reportRequirement(result);
        requirements.reportRequirement(nextResult);
        return requirements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElmRequirement visitExpressionDef(ExpressionDef elm, ElmRequirementsContext context) {
        ElmRequirement result = null;
        context.enterExpressionDef(elm);
        boolean pertinenceTagFound = context.enterPertinenceContext(elm);
        try {
            result = (ElmRequirement)super.visitExpressionDef(elm, (Object)context);
            context.exitExpressionDef(result);
            if (pertinenceTagFound) {
                context.exitPertinenceContext();
            }
        }
        catch (Throwable throwable) {
            context.exitExpressionDef(result);
            if (pertinenceTagFound) {
                context.exitPertinenceContext();
            }
            throw throwable;
        }
        return result;
    }

    public ElmRequirement visitFunctionDef(FunctionDef elm, ElmRequirementsContext context) {
        context.reportFunctionDef(elm);
        return (ElmRequirement)super.visitFunctionDef(elm, (Object)context);
    }

    public ElmRequirement visitExpressionRef(ExpressionRef elm, ElmRequirementsContext context) {
        ElmRequirement result = null;
        result = elm instanceof FunctionRef ? this.visitFunctionRef((FunctionRef)elm, context) : context.reportExpressionRef(elm);
        if (result != null) {
            if (result instanceof ElmDataRequirement) {
                ElmDataRequirement inferredRequirement = ElmDataRequirement.inferFrom((ElmExpressionRequirement)((ElmDataRequirement)result));
                result = inferredRequirement;
            } else if (result instanceof ElmQueryRequirement) {
                ElmDataRequirement inferredRequirement = ElmDataRequirement.inferFrom((ElmExpressionRequirement)((ElmQueryRequirement)result));
                result = inferredRequirement;
            }
            return result;
        }
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitFunctionRef(FunctionRef elm, ElmRequirementsContext context) {
        context.reportFunctionRef(elm);
        ElmRequirement result = (ElmRequirement)super.visitFunctionRef(elm, (Object)context);
        if (result instanceof ElmDataRequirement && (elm.getOperand().size() != 1 || ((Expression)elm.getOperand().get(0)).getResultType() instanceof ListType && !(elm.getResultType() instanceof ListType))) {
            return new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm).combine((ElmDataRequirement)result);
        }
        if (result != null) {
            return result;
        }
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitParameterDef(ParameterDef elm, ElmRequirementsContext context) {
        context.reportParameterDef(elm);
        return (ElmRequirement)super.visitParameterDef(elm, (Object)context);
    }

    public ElmRequirement visitParameterRef(ParameterRef elm, ElmRequirementsContext context) {
        context.reportParameterRef(elm);
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitRetrieve(Retrieve elm, ElmRequirementsContext context) {
        ElmPertinenceContext elmPertinenceContext = context.peekPertinenceContext();
        super.visitRetrieve(elm, (Object)context);
        ElmDataRequirement result = new ElmDataRequirement(context.getCurrentLibraryIdentifier(), elm);
        if (elmPertinenceContext != null) {
            result.setPertinenceContext(elmPertinenceContext);
        }
        if (!context.getOptions().getAnalyzeDataRequirements() || !context.inQueryContext()) {
            context.reportRequirements(result, null);
        }
        return result;
    }

    public ElmRequirement visitCodeSystemDef(CodeSystemDef elm, ElmRequirementsContext context) {
        context.reportCodeSystemDef(elm);
        return (ElmRequirement)super.visitCodeSystemDef(elm, (Object)context);
    }

    public ElmRequirement visitValueSetDef(ValueSetDef elm, ElmRequirementsContext context) {
        context.reportValueSetDef(elm);
        return (ElmRequirement)super.visitValueSetDef(elm, (Object)context);
    }

    public ElmRequirement visitCodeSystemRef(CodeSystemRef elm, ElmRequirementsContext context) {
        context.reportCodeSystemRef(elm);
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitValueSetRef(ValueSetRef elm, ElmRequirementsContext context) {
        context.reportValueSetRef(elm);
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElmRequirement visitLibrary(Library elm, ElmRequirementsContext context) {
        context.enterLibrary(elm.getIdentifier());
        try {
            ElmRequirement elmRequirement = (ElmRequirement)super.visitLibrary(elm, (Object)context);
            return elmRequirement;
        }
        finally {
            context.exitLibrary();
        }
    }

    public ElmRequirement visitIncludeDef(IncludeDef elm, ElmRequirementsContext context) {
        context.reportIncludeDef(elm);
        return (ElmRequirement)super.visitIncludeDef(elm, (Object)context);
    }

    public ElmRequirement visitContextDef(ContextDef elm, ElmRequirementsContext context) {
        context.reportContextDef(elm);
        return (ElmRequirement)super.visitContextDef(elm, (Object)context);
    }

    public ElmRequirement visitCodeRef(CodeRef elm, ElmRequirementsContext context) {
        context.reportCodeRef(elm);
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitCodeDef(CodeDef elm, ElmRequirementsContext context) {
        context.reportCodeDef(elm);
        return (ElmRequirement)super.visitCodeDef(elm, (Object)context);
    }

    public ElmRequirement visitConceptRef(ConceptRef elm, ElmRequirementsContext context) {
        context.reportConceptRef(elm);
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitConceptDef(ConceptDef elm, ElmRequirementsContext context) {
        context.reportConceptDef(elm);
        return (ElmRequirement)super.visitConceptDef(elm, (Object)context);
    }

    protected ElmRequirement inferConditionRequirement(Expression elm, ElmRequirementsContext context, ElmRequirement left, ElmRequirement right) {
        ElmPropertyRequirement rightProperty;
        ElmPropertyRequirement leftProperty = left instanceof ElmPropertyRequirement ? (ElmPropertyRequirement)left : null;
        ElmPropertyRequirement elmPropertyRequirement = rightProperty = right instanceof ElmPropertyRequirement ? (ElmPropertyRequirement)right : null;
        if (leftProperty != null && leftProperty.getInCurrentScope()) {
            if (rightProperty != null && rightProperty.getInCurrentScope()) {
                if (leftProperty.getSource() == rightProperty.getSource()) {
                    return new ElmConstraintRequirement(context.getCurrentLibraryIdentifier(), elm, leftProperty, rightProperty);
                }
                if (leftProperty.getSource() instanceof AliasedQuerySource && rightProperty.getSource() instanceof AliasedQuerySource) {
                    return new ElmJoinRequirement(context.getCurrentLibraryIdentifier(), elm, leftProperty, rightProperty);
                }
            }
            if (right instanceof ElmExpressionRequirement) {
                return new ElmConditionRequirement(context.getCurrentLibraryIdentifier(), elm, leftProperty, (ElmExpressionRequirement)right);
            }
        } else if (rightProperty != null && rightProperty.getInCurrentScope()) {
            if (leftProperty != null && leftProperty.getInCurrentScope()) {
                if (leftProperty.getSource() == rightProperty.getSource()) {
                    return new ElmConstraintRequirement(context.getCurrentLibraryIdentifier(), elm, leftProperty, rightProperty);
                }
                if (leftProperty.getSource() instanceof AliasedQuerySource && rightProperty.getSource() instanceof AliasedQuerySource) {
                    return new ElmJoinRequirement(context.getCurrentLibraryIdentifier(), elm, leftProperty, rightProperty);
                }
            }
            if (left instanceof ElmExpressionRequirement) {
                return new ElmConditionRequirement(context.getCurrentLibraryIdentifier(), elm, (ElmPropertyRequirement)right, (ElmExpressionRequirement)left);
            }
        }
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), elm);
    }

    public ElmRequirement visitFields(BinaryExpression elm, ElmRequirementsContext context) {
        if (elm.getOperand().size() != 2) {
            throw new IllegalArgumentException("BinaryExpression must have two operands.");
        }
        switch (elm.getClass().getSimpleName()) {
            case "Equal": 
            case "Equivalent": 
            case "SameAs": 
            case "Greater": 
            case "GreaterOrEqual": 
            case "SameOrAfter": 
            case "After": 
            case "Less": 
            case "LessOrEqual": 
            case "SameOrBefore": 
            case "Before": 
            case "In": 
            case "Contains": {
                ElmRequirement left = (ElmRequirement)this.visitElement((Element)elm.getOperand().get(0), context);
                ElmRequirement right = (ElmRequirement)this.visitElement((Element)elm.getOperand().get(1), context);
                return this.inferConditionRequirement((Expression)elm, context, left, right);
            }
            case "And": {
                ElmRequirement left = (ElmRequirement)this.visitElement((Element)elm.getOperand().get(0), context);
                ElmRequirement right = (ElmRequirement)this.visitElement((Element)elm.getOperand().get(1), context);
                if (left instanceof ElmExpressionRequirement && right instanceof ElmExpressionRequirement) {
                    return new ElmConjunctiveRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm).combine((ElmExpressionRequirement)left).combine((ElmExpressionRequirement)right);
                }
                if (left instanceof ElmExpressionRequirement && right == null) {
                    return left;
                }
                if (right instanceof ElmExpressionRequirement && left == null) {
                    return right;
                }
                return this.aggregateResult(left, right);
            }
            case "Or": {
                ElmRequirement left = (ElmRequirement)this.visitElement((Element)elm.getOperand().get(0), context);
                ElmRequirement right = (ElmRequirement)this.visitElement((Element)elm.getOperand().get(1), context);
                if (left instanceof ElmExpressionRequirement && right instanceof ElmExpressionRequirement) {
                    return new ElmDisjunctiveRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm).combine((ElmExpressionRequirement)left).combine((ElmExpressionRequirement)right);
                }
                if (left instanceof ElmExpressionRequirement && right == null) {
                    return left;
                }
                if (right instanceof ElmExpressionRequirement && left == null) {
                    return right;
                }
                return this.aggregateResult(left, right);
            }
        }
        super.visitFields(elm, (Object)context);
        return new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitTernaryExpression(TernaryExpression elm, ElmRequirementsContext context) {
        ElmRequirement requirements = (ElmRequirement)super.visitTernaryExpression(elm, (Object)context);
        return new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm).combine(requirements);
    }

    public ElmRequirement visitNaryExpression(NaryExpression elm, ElmRequirementsContext context) {
        ElmRequirement requirements = (ElmRequirement)super.visitNaryExpression(elm, (Object)context);
        return new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm).combine(requirements);
    }

    public ElmRequirement visitOperandRef(OperandRef elm, ElmRequirementsContext context) {
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitIdentifierRef(IdentifierRef elm, ElmRequirementsContext context) {
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitLiteral(Literal elm, ElmRequirementsContext context) {
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitInterval(Interval elm, ElmRequirementsContext context) {
        ElmRequirement result = (ElmRequirement)super.visitInterval(elm, (Object)context);
        ElmOperatorRequirement finalResult = new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
        finalResult.combine(result);
        return finalResult;
    }

    public ElmRequirement visitIf(If elm, ElmRequirementsContext context) {
        return new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitCase(Case elm, ElmRequirementsContext context) {
        ElmOperatorRequirement result = new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
        ElmRequirement childResult = null;
        if (elm.getComparand() != null && (childResult = (ElmRequirement)this.visitElement((Element)elm.getComparand(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        for (CaseItem ci : elm.getCaseItem()) {
            childResult = (ElmRequirement)this.visitElement((Element)ci, context);
            if (!(childResult instanceof ElmExpressionRequirement)) continue;
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getElse() != null && (childResult = (ElmRequirement)this.visitElement((Element)elm.getElse(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        return result;
    }

    public ElmRequirement visitNull(Null elm, ElmRequirementsContext context) {
        return new ElmExpressionRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitSplit(Split elm, ElmRequirementsContext context) {
        if (elm.getSeparator() instanceof Literal) {
            return (ElmRequirement)this.visitElement((Element)elm.getStringToSplit(), context);
        }
        return (ElmRequirement)super.visitSplit(elm, (Object)context);
    }

    public ElmRequirement visitTimeOfDay(TimeOfDay elm, ElmRequirementsContext context) {
        return new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitToday(Today elm, ElmRequirementsContext context) {
        return new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitNow(Now elm, ElmRequirementsContext context) {
        return new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
    }

    public ElmRequirement visitDateTime(DateTime elm, ElmRequirementsContext context) {
        ElmRequirement childResult;
        ElmOperatorRequirement result = new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
        if (elm.getYear() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getYear(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getMonth() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getMonth(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getDay() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getDay(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getHour() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getHour(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getMinute() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getMinute(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getSecond() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getSecond(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getMillisecond() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getMillisecond(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getTimezoneOffset() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getTimezoneOffset(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        return result;
    }

    public ElmRequirement visitDate(Date elm, ElmRequirementsContext context) {
        ElmRequirement childResult;
        ElmOperatorRequirement result = new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
        if (elm.getYear() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getYear(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getMonth() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getMonth(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getDay() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getDay(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        return result;
    }

    public ElmRequirement visitTime(Time elm, ElmRequirementsContext context) {
        ElmRequirement childResult;
        ElmOperatorRequirement result = new ElmOperatorRequirement(context.getCurrentLibraryIdentifier(), (Expression)elm);
        if (elm.getHour() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getHour(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getMinute() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getMinute(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getSecond() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getSecond(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        if (elm.getMillisecond() != null && (childResult = (ElmRequirement)this.visitExpression(elm.getMillisecond(), context)) instanceof ElmExpressionRequirement) {
            result.combine((ElmExpressionRequirement)childResult);
        }
        return result;
    }

    public ElmRequirement visitProperty(Property elm, ElmRequirementsContext context) {
        ElmRequirement visitResult = (ElmRequirement)super.visitProperty(elm, (Object)context);
        if (visitResult instanceof ElmPropertyRequirement) {
            ElmPropertyRequirement visitPropertyRequirement = (ElmPropertyRequirement)visitResult;
            Property qualifiedProperty = new Property();
            Property sourceProperty = visitPropertyRequirement.getProperty();
            qualifiedProperty.setSource(sourceProperty.getSource());
            qualifiedProperty.setScope(sourceProperty.getScope());
            qualifiedProperty.setResultType(elm.getResultType());
            qualifiedProperty.setResultTypeName(elm.getResultTypeName());
            qualifiedProperty.setResultTypeSpecifier(elm.getResultTypeSpecifier());
            qualifiedProperty.setLocalId(sourceProperty.getLocalId());
            qualifiedProperty.setPath(sourceProperty.getPath() + "." + elm.getPath());
            return context.reportProperty(qualifiedProperty);
        }
        ElmPropertyRequirement propertyRequirement = context.reportProperty(elm);
        ElmRequirement result = this.aggregateResult(propertyRequirement, visitResult);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElmRequirement visitFields(AliasedQuerySource elm, ElmRequirementsContext context) {
        ElmRequirement result = (ElmRequirement)this.defaultResult((Trackable)elm, context);
        ElmQueryAliasContext aliasContext = null;
        context.getCurrentQueryContext().enterAliasDefinitionContext(elm);
        try {
            if (elm.getExpression() != null) {
                ElmRequirement childResult = (ElmRequirement)this.visitElement((Element)elm.getExpression(), context);
                result = this.aggregateResult(result, childResult);
            }
        }
        finally {
            aliasContext = context.getCurrentQueryContext().exitAliasDefinitionContext(result);
        }
        if (result instanceof ElmOperatorRequirement) {
            context.reportRequirements(result, null);
        }
        return aliasContext.getRequirements();
    }

    public ElmRequirement visitWith(With elm, ElmRequirementsContext context) {
        ElmRequirement result = this.visitFields((AliasedQuerySource)elm, context);
        if (elm.getSuchThat() != null) {
            ElmRequirement childResult = (ElmRequirement)this.visitExpression(elm.getSuchThat(), context);
            context.getCurrentQueryContext().reportQueryRequirements(childResult);
            result = this.aggregateResult(result, childResult);
        }
        context.getCurrentQueryContext().descopeAlias((AliasedQuerySource)elm);
        return result;
    }

    public ElmRequirement visitWithout(Without elm, ElmRequirementsContext context) {
        ElmRequirement result = this.visitFields((AliasedQuerySource)elm, context);
        if (elm.getSuchThat() != null) {
            ElmRequirement childResult = (ElmRequirement)this.visitExpression(elm.getSuchThat(), context);
            result = this.aggregateResult(result, childResult);
        }
        context.getCurrentQueryContext().descopeAlias((AliasedQuerySource)elm);
        return result;
    }

    public ElmRequirement visitAliasedQuerySource(AliasedQuerySource elm, ElmRequirementsContext context) {
        if (elm instanceof RelationshipClause) {
            return (ElmRequirement)this.visitRelationshipClause((RelationshipClause)elm, context);
        }
        return this.visitFields(elm, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElmRequirement visitLetClause(LetClause elm, ElmRequirementsContext context) {
        ElmRequirement result = (ElmRequirement)this.defaultResult((Trackable)elm, context);
        ElmQueryLetContext letContext = null;
        context.getCurrentQueryContext().enterLetDefinitionContext(elm);
        try {
            if (elm.getExpression() != null) {
                ElmRequirement childResult = (ElmRequirement)super.visitLetClause(elm, (Object)context);
                result = this.aggregateResult(result, childResult);
            }
        }
        finally {
            letContext = context.getCurrentQueryContext().exitLetDefinitionContext(result);
        }
        return letContext.getRequirements();
    }

    protected ElmRequirement visitFields(Query elm, ElmRequirementsContext context) {
        ElmRequirement childResult;
        ElmRequirement childResult2;
        ElmRequirement result = (ElmRequirement)this.visitFields((Expression)elm, context);
        for (AliasedQuerySource source : elm.getSource()) {
            childResult2 = this.visitAliasedQuerySource(source, context);
            result = this.aggregateResult(result, childResult2);
        }
        for (LetClause let : elm.getLet()) {
            childResult2 = this.visitLetClause(let, context);
            result = this.aggregateResult(result, childResult2);
        }
        for (RelationshipClause r : elm.getRelationship()) {
            childResult2 = (ElmRequirement)this.visitRelationshipClause(r, context);
            result = this.aggregateResult(result, childResult2);
        }
        if (elm.getWhere() != null) {
            childResult = (ElmRequirement)this.visitExpression(elm.getWhere(), context);
            context.getCurrentQueryContext().reportQueryRequirements(childResult);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getReturn() != null) {
            childResult = (ElmRequirement)this.visitReturnClause(elm.getReturn(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getAggregate() != null) {
            childResult = (ElmRequirement)this.visitAggregateClause(elm.getAggregate(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getSort() != null) {
            childResult = (ElmRequirement)this.visitSortClause(elm.getSort(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getResultTypeSpecifier() != null) {
            childResult = (ElmRequirement)this.visitTypeSpecifier(elm.getResultTypeSpecifier(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElmRequirement visitQuery(Query elm, ElmRequirementsContext context) {
        ElmRequirement childResult = null;
        ElmQueryContext queryContext = null;
        context.enterQueryContext(elm);
        try {
            childResult = this.visitFields(elm, context);
        }
        finally {
            queryContext = context.exitQueryContext();
        }
        ElmQueryRequirement result = queryContext.getQueryRequirement(childResult, context);
        result.analyzeDataRequirements(context);
        context.reportRequirements(result, null);
        return result;
    }

    public ElmRequirement visitInCodeSystem(InCodeSystem elm, ElmRequirementsContext context) {
        if (elm.getCode() != null && (elm.getCodesystem() != null || elm.getCodesystemExpression() != null)) {
            ElmRequirement left = (ElmRequirement)this.visitElement((Element)elm.getCode(), context);
            ElmRequirement right = elm.getCodesystem() != null ? (ElmRequirement)this.visitElement((Element)elm.getCodesystem(), context) : (ElmRequirement)this.visitElement((Element)elm.getCodesystemExpression(), context);
            return this.inferConditionRequirement((Expression)elm, context, left, right);
        }
        return (ElmRequirement)super.visitInCodeSystem(elm, (Object)context);
    }

    public ElmRequirement visitAnyInCodeSystem(AnyInCodeSystem elm, ElmRequirementsContext context) {
        if (elm.getCodes() != null && (elm.getCodesystem() != null || elm.getCodesystemExpression() != null)) {
            ElmRequirement left = (ElmRequirement)this.visitElement((Element)elm.getCodes(), context);
            ElmRequirement right = elm.getCodesystem() != null ? (ElmRequirement)this.visitElement((Element)elm.getCodesystem(), context) : (ElmRequirement)this.visitElement((Element)elm.getCodesystemExpression(), context);
            return this.inferConditionRequirement((Expression)elm, context, left, right);
        }
        return (ElmRequirement)super.visitAnyInCodeSystem(elm, (Object)context);
    }

    public ElmRequirement visitInValueSet(InValueSet elm, ElmRequirementsContext context) {
        if (elm.getCode() != null && (elm.getValueset() != null || elm.getValuesetExpression() != null)) {
            ElmRequirement left = (ElmRequirement)this.visitElement((Element)elm.getCode(), context);
            ElmRequirement right = elm.getValueset() != null ? (ElmRequirement)this.visitElement((Element)elm.getValueset(), context) : (ElmRequirement)this.visitElement((Element)elm.getValuesetExpression(), context);
            return this.inferConditionRequirement((Expression)elm, context, left, right);
        }
        return (ElmRequirement)super.visitInValueSet(elm, (Object)context);
    }

    public ElmRequirement visitAnyInValueSet(AnyInValueSet elm, ElmRequirementsContext context) {
        if (elm.getCodes() != null && (elm.getValueset() != null || elm.getValuesetExpression() != null)) {
            ElmRequirement left = (ElmRequirement)this.visitElement((Element)elm.getCodes(), context);
            ElmRequirement right = elm.getValueset() != null ? (ElmRequirement)this.visitElement((Element)elm.getValueset(), context) : (ElmRequirement)this.visitElement((Element)elm.getValuesetExpression(), context);
            return this.inferConditionRequirement((Expression)elm, context, left, right);
        }
        return (ElmRequirement)super.visitAnyInValueSet(elm, (Object)context);
    }

    public ElmRequirement visitUsingDef(UsingDef elm, ElmRequirementsContext context) {
        context.reportUsingDef(elm);
        return (ElmRequirement)super.visitUsingDef(elm, (Object)context);
    }
}

