/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import java.util.ArrayList;
import java.util.List;
import org.cqframework.cql.elm.requirements.ElmConjunctiveRequirement;
import org.cqframework.cql.elm.requirements.ElmExpressionRequirement;
import org.cqframework.cql.elm.requirements.ElmQueryAliasContext;
import org.cqframework.cql.elm.requirements.ElmQueryLetContext;
import org.cqframework.cql.elm.requirements.ElmQueryRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirementsContext;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.LetClause;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.VersionedIdentifier;

public class ElmQueryContext {
    private VersionedIdentifier libraryIdentifier;
    private Query query;
    private ElmExpressionRequirement queryRequirements;
    private ElmQueryAliasContext definitionContext;
    private List<ElmQueryAliasContext> aliasContexts = new ArrayList<ElmQueryAliasContext>();
    private ElmQueryLetContext letDefinitionContext;
    private List<ElmQueryLetContext> letContexts = new ArrayList<ElmQueryLetContext>();
    private ElmQueryRequirement queryRequirement;

    public ElmQueryContext(VersionedIdentifier libraryIdentifier, Query query) {
        if (libraryIdentifier == null) {
            throw new IllegalArgumentException("libraryIdentifier is required");
        }
        if (query == null) {
            throw new IllegalArgumentException("query is required");
        }
        this.libraryIdentifier = libraryIdentifier;
        this.query = query;
        this.queryRequirements = new ElmConjunctiveRequirement(libraryIdentifier, (Expression)query);
        this.queryRequirement = new ElmQueryRequirement(libraryIdentifier, query);
    }

    public void enterLetDefinitionContext(LetClause letClause) {
        if (this.letDefinitionContext != null) {
            throw new IllegalArgumentException("Let clause definition already in progress");
        }
        this.letDefinitionContext = new ElmQueryLetContext(this.libraryIdentifier, letClause);
    }

    public ElmQueryLetContext exitLetDefinitionContext(ElmRequirement requirements) {
        if (this.letDefinitionContext == null) {
            throw new IllegalArgumentException("Let definition not in progress");
        }
        this.letContexts.add(this.letDefinitionContext);
        ElmQueryLetContext result = this.letDefinitionContext;
        result.setRequirements(requirements);
        this.letDefinitionContext = null;
        return result;
    }

    public ElmQueryLetContext resolveLet(String identifier) {
        for (ElmQueryLetContext letContext : this.letContexts) {
            if (!letContext.getIdentifier().equals(identifier)) continue;
            return letContext;
        }
        return null;
    }

    public ElmQueryLetContext getLetContext(LetClause letClause) {
        for (ElmQueryLetContext letContext : this.letContexts) {
            if (letContext.getLetClause() != letClause) continue;
            return letContext;
        }
        return null;
    }

    public void enterAliasDefinitionContext(AliasedQuerySource querySource) {
        if (this.definitionContext != null) {
            throw new IllegalArgumentException("Alias definition already in progress");
        }
        this.definitionContext = new ElmQueryAliasContext(this.libraryIdentifier, querySource);
    }

    public ElmQueryAliasContext exitAliasDefinitionContext(ElmRequirement requirements) {
        if (this.definitionContext == null) {
            throw new IllegalArgumentException("Alias definition not in progress");
        }
        this.aliasContexts.add(this.definitionContext);
        ElmQueryAliasContext result = this.definitionContext;
        result.setRequirements(requirements);
        this.definitionContext = null;
        return result;
    }

    public ElmQueryAliasContext resolveAlias(String aliasName) {
        for (ElmQueryAliasContext aliasContext : this.aliasContexts) {
            if (!aliasContext.getAlias().equals(aliasName)) continue;
            return aliasContext;
        }
        return null;
    }

    private ElmQueryAliasContext getAliasContext(AliasedQuerySource querySource) {
        for (ElmQueryAliasContext aliasContext : this.aliasContexts) {
            if (!aliasContext.getAlias().equals(querySource.getAlias())) continue;
            return aliasContext;
        }
        return null;
    }

    public void descopeAlias(AliasedQuerySource querySource) {
        ElmQueryAliasContext aliasContext = this.getAliasContext(querySource);
        if (aliasContext != null) {
            this.aliasContexts.remove(aliasContext);
            this.queryRequirement.addDataRequirements(aliasContext.getRequirements());
        }
        this.aliasContexts.removeIf(x -> x.getAlias().equals(querySource.getAlias()));
    }

    public void reportQueryRequirements(ElmRequirement requirements) {
        if (requirements instanceof ElmExpressionRequirement) {
            this.queryRequirements = this.queryRequirements.combine((ElmExpressionRequirement)requirements);
        }
    }

    public ElmQueryRequirement getQueryRequirement(ElmRequirement childRequirements, ElmRequirementsContext context) {
        for (ElmQueryLetContext letContext : this.letContexts) {
            this.queryRequirement.addDataRequirements(letContext.getRequirements());
        }
        for (ElmQueryAliasContext aliasContext : this.aliasContexts) {
            this.queryRequirement.addDataRequirements(aliasContext.getRequirements());
        }
        this.queryRequirement.addChildRequirements(childRequirements);
        if (context.getOptions().getAnalyzeDataRequirements()) {
            this.queryRequirement.distributeExpressionRequirement(this.queryRequirements, context);
        }
        return this.queryRequirement;
    }
}

