/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import java.util.Iterator;
import org.cqframework.cql.elm.evaluating.SimpleElmEvaluator;
import org.cqframework.cql.elm.requirements.ElmCloner;
import org.cqframework.cql.elm.requirements.ElmDataRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirement;
import org.hl7.elm.r1.CodeFilterElement;
import org.hl7.elm.r1.DateFilterElement;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.IncludeElement;
import org.hl7.elm.r1.OtherFilterElement;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Retrieve;

public class ComparableElmRequirement {
    private ElmRequirement requirement;

    public ComparableElmRequirement(ElmRequirement requirement) {
        if (requirement == null) {
            throw new IllegalArgumentException("requirement is required");
        }
        this.requirement = requirement;
    }

    public ElmRequirement getRequirement() {
        return this.requirement;
    }

    public int hashCode() {
        if (this.requirement.getElement() instanceof Retrieve) {
            String typeUri;
            Retrieve retrieve = (Retrieve)this.requirement.getElement();
            String string = retrieve.getTemplateId() != null ? retrieve.getTemplateId() : (typeUri = retrieve.getDataType() != null && retrieve.getDataType().getLocalPart() != null ? retrieve.getDataType().getLocalPart() : null);
            if (typeUri != null) {
                return typeUri.hashCode();
            }
        }
        return super.hashCode();
    }

    public static boolean codeFilterElementsEqual(CodeFilterElement left, CodeFilterElement right) {
        return SimpleElmEvaluator.stringsEqual((String)left.getProperty(), (String)right.getProperty()) && SimpleElmEvaluator.stringsEqual((String)left.getSearch(), (String)right.getSearch()) && SimpleElmEvaluator.stringsEqual((String)left.getComparator(), (String)right.getComparator()) && SimpleElmEvaluator.stringsEqual((String)left.getValueSetProperty(), (String)right.getValueSetProperty()) && SimpleElmEvaluator.codesEqual((Expression)left.getValue(), (Expression)right.getValue());
    }

    public static boolean hasCodeFilter(Iterable<CodeFilterElement> left, CodeFilterElement right) {
        for (CodeFilterElement cfe : left) {
            if (!ComparableElmRequirement.codeFilterElementsEqual(cfe, right)) continue;
            return true;
        }
        return false;
    }

    public static boolean codeFiltersEqual(Iterable<CodeFilterElement> left, Iterable<CodeFilterElement> right) {
        Iterator<CodeFilterElement> leftIterator = left.iterator();
        Iterator<CodeFilterElement> rightIterator = right.iterator();
        while (leftIterator.hasNext()) {
            CodeFilterElement leftElement = leftIterator.next();
            if (!rightIterator.hasNext()) {
                return false;
            }
            CodeFilterElement rightElement = rightIterator.next();
            if (ComparableElmRequirement.codeFilterElementsEqual(leftElement, rightElement)) continue;
            return false;
        }
        return !rightIterator.hasNext();
    }

    public static boolean dateFilterElementsEqual(DateFilterElement left, DateFilterElement right) {
        return SimpleElmEvaluator.stringsEqual((String)left.getProperty(), (String)right.getProperty()) && SimpleElmEvaluator.stringsEqual((String)left.getLowProperty(), (String)right.getLowProperty()) && SimpleElmEvaluator.stringsEqual((String)left.getHighProperty(), (String)right.getHighProperty()) && SimpleElmEvaluator.stringsEqual((String)left.getSearch(), (String)right.getSearch()) && SimpleElmEvaluator.dateRangesEqual((Expression)left.getValue(), (Expression)right.getValue());
    }

    public static boolean hasDateFilter(Iterable<DateFilterElement> left, DateFilterElement right) {
        for (DateFilterElement dfe : left) {
            if (!ComparableElmRequirement.dateFilterElementsEqual(dfe, right)) continue;
            return true;
        }
        return false;
    }

    public static boolean dateFiltersEqual(Iterable<DateFilterElement> left, Iterable<DateFilterElement> right) {
        Iterator<DateFilterElement> leftIterator = left.iterator();
        Iterator<DateFilterElement> rightIterator = right.iterator();
        while (leftIterator.hasNext()) {
            DateFilterElement leftElement = leftIterator.next();
            if (!rightIterator.hasNext()) {
                return false;
            }
            DateFilterElement rightElement = rightIterator.next();
            if (ComparableElmRequirement.dateFilterElementsEqual(leftElement, rightElement)) continue;
            return false;
        }
        return !rightIterator.hasNext();
    }

    public static boolean otherFilterElementsEqual(OtherFilterElement left, OtherFilterElement right) {
        return SimpleElmEvaluator.stringsEqual((String)left.getProperty(), (String)right.getProperty()) && SimpleElmEvaluator.stringsEqual((String)left.getSearch(), (String)right.getSearch()) && SimpleElmEvaluator.stringsEqual((String)left.getComparator(), (String)right.getComparator()) && SimpleElmEvaluator.stringsEqual((Expression)left.getValue(), (Expression)right.getValue());
    }

    public static boolean hasOtherFilter(Iterable<OtherFilterElement> left, OtherFilterElement right) {
        for (OtherFilterElement ofe : left) {
            if (!ComparableElmRequirement.otherFilterElementsEqual(ofe, right)) continue;
            return true;
        }
        return false;
    }

    public static boolean otherFiltersEqual(Iterable<OtherFilterElement> left, Iterable<OtherFilterElement> right) {
        Iterator<OtherFilterElement> leftIterator = left.iterator();
        Iterator<OtherFilterElement> rightIterator = right.iterator();
        while (leftIterator.hasNext()) {
            OtherFilterElement leftElement = leftIterator.next();
            if (!rightIterator.hasNext()) {
                return false;
            }
            OtherFilterElement rightElement = rightIterator.next();
            if (ComparableElmRequirement.otherFilterElementsEqual(leftElement, rightElement)) continue;
            return false;
        }
        return !rightIterator.hasNext();
    }

    public static boolean includeElementsEqual(IncludeElement left, IncludeElement right) {
        return left.getRelatedDataType() != null && right.getRelatedDataType() != null && SimpleElmEvaluator.stringsEqual((String)left.getRelatedDataType().getNamespaceURI(), (String)right.getRelatedDataType().getNamespaceURI()) && SimpleElmEvaluator.stringsEqual((String)left.getRelatedDataType().getLocalPart(), (String)right.getRelatedDataType().getLocalPart()) && SimpleElmEvaluator.stringsEqual((String)left.getRelatedProperty(), (String)right.getRelatedProperty()) && SimpleElmEvaluator.stringsEqual((String)left.getRelatedSearch(), (String)right.getRelatedSearch());
    }

    public static boolean includeElementsEqual(Iterable<IncludeElement> left, Iterable<IncludeElement> right) {
        Iterator<IncludeElement> leftIterator = left.iterator();
        Iterator<IncludeElement> rightIterator = right.iterator();
        while (leftIterator.hasNext()) {
            IncludeElement leftElement = leftIterator.next();
            if (!rightIterator.hasNext()) {
                return false;
            }
            IncludeElement rightElement = rightIterator.next();
            if (ComparableElmRequirement.includeElementsEqual(leftElement, rightElement)) continue;
            return false;
        }
        return !rightIterator.hasNext();
    }

    public boolean equals(Object other) {
        if (other instanceof ComparableElmRequirement) {
            return ComparableElmRequirement.requirementsEquivalent(this.requirement, ((ComparableElmRequirement)other).getRequirement());
        }
        return false;
    }

    public static boolean requirementsEquivalent(ElmRequirement left, ElmRequirement right) {
        Retrieve retrieve = (Retrieve)left.getElement();
        Retrieve otherRetrieve = (Retrieve)right.getElement();
        return retrieve.getDataType() != null && retrieve.getDataType().equals(otherRetrieve.getDataType()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getTemplateId(), (String)otherRetrieve.getTemplateId()) && SimpleElmEvaluator.stringsEqual((Expression)retrieve.getContext(), (Expression)otherRetrieve.getContext()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getContextProperty(), (String)otherRetrieve.getContextProperty()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getContextSearch(), (String)otherRetrieve.getContextSearch()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getCodeProperty(), (String)otherRetrieve.getCodeProperty()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getCodeSearch(), (String)otherRetrieve.getCodeSearch()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getCodeComparator(), (String)otherRetrieve.getCodeComparator()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getValueSetProperty(), (String)otherRetrieve.getValueSetProperty()) && SimpleElmEvaluator.codesEqual((Expression)retrieve.getCodes(), (Expression)otherRetrieve.getCodes()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getDateProperty(), (String)otherRetrieve.getDateProperty()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getDateLowProperty(), (String)otherRetrieve.getDateLowProperty()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getDateHighProperty(), (String)otherRetrieve.getDateHighProperty()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getDateSearch(), (String)otherRetrieve.getDateSearch()) && SimpleElmEvaluator.dateRangesEqual((Expression)retrieve.getDateRange(), (Expression)otherRetrieve.getDateRange()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getIdProperty(), (String)otherRetrieve.getIdProperty()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getIdSearch(), (String)otherRetrieve.getIdSearch()) && SimpleElmEvaluator.stringsEqual((Expression)retrieve.getId(), (Expression)otherRetrieve.getId()) && ComparableElmRequirement.codeFiltersEqual(retrieve.getCodeFilter(), otherRetrieve.getCodeFilter()) && ComparableElmRequirement.dateFiltersEqual(retrieve.getDateFilter(), otherRetrieve.getDateFilter()) && ComparableElmRequirement.otherFiltersEqual(retrieve.getOtherFilter(), otherRetrieve.getOtherFilter()) && SimpleElmEvaluator.stringsEqual((String)retrieve.getIncludedIn(), (String)otherRetrieve.getIncludedIn()) && ComparableElmRequirement.includeElementsEqual(retrieve.getInclude(), otherRetrieve.getInclude());
    }

    private static boolean hasInclude(Retrieve retrieve, IncludeElement includeElement) {
        for (IncludeElement e : retrieve.getInclude()) {
            if (!ComparableElmRequirement.includeElementsEqual(e, includeElement)) continue;
            return true;
        }
        return false;
    }

    public static ElmRequirement mergeRequirements(ElmRequirement existing, ElmRequirement required) {
        if (existing instanceof ElmDataRequirement && required instanceof ElmDataRequirement && existing.getElement() instanceof Retrieve && required.getElement() instanceof Retrieve) {
            Retrieve existingRetrieve = (Retrieve)existing.getElement();
            Retrieve requiredRetrieve = (Retrieve)required.getElement();
            Retrieve newRetrieve = ElmCloner.clone(existingRetrieve);
            newRetrieve.getTrackbacks().addAll(requiredRetrieve.getTrackbacks());
            ElmDataRequirement newRequirement = new ElmDataRequirement(existing.getLibraryIdentifier(), newRetrieve);
            if (((ElmDataRequirement)existing).getProperties() != null) {
                for (Property property : ((ElmDataRequirement)existing).getProperties()) {
                    newRequirement.addProperty(property);
                }
            }
            if (((ElmDataRequirement)required).getProperties() != null) {
                for (Property property : ((ElmDataRequirement)required).getProperties()) {
                    newRequirement.addProperty(property);
                }
            }
            for (IncludeElement includeElement : requiredRetrieve.getInclude()) {
                if (ComparableElmRequirement.hasInclude(newRetrieve, includeElement)) continue;
                newRetrieve.getInclude().add(ElmCloner.clone(includeElement));
            }
            return newRequirement;
        }
        return existing;
    }
}

