/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements.fhir.utilities;

import org.cqframework.cql.elm.requirements.fhir.utilities.SpecificationLevel;

public class SpecificationSupport {
    private SpecificationLevel specificationLevel;

    public SpecificationSupport() {
        this(SpecificationLevel.US_QM_STU4);
    }

    public SpecificationSupport(SpecificationLevel specificationLevel) {
        this.specificationLevel = specificationLevel;
    }

    public SpecificationLevel getSpecificationLevel() {
        return this.specificationLevel;
    }

    public String getDirectReferenceCodeExtensionUrl() {
        switch (this.specificationLevel) {
            case US_QM_STU4: {
                return "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-directReferenceCode";
            }
        }
        return "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode";
    }

    public String getLogicDefinitionExtensionUrl() {
        switch (this.specificationLevel) {
            case US_QM_STU4: {
                return "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-logicDefinition";
            }
        }
        return "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition";
    }

    public String getRelatedRequirementExtensionUrl() {
        switch (this.specificationLevel) {
            case US_QM_STU4: {
                return "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-relatedRequirement";
            }
        }
        return "http://hl7.org/fhir/StructureDefinition/cqf-relatedRequirement";
    }

    public String getPertinenceExtensionUrl() {
        switch (this.specificationLevel) {
            case US_QM_STU4: {
                return "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-pertinence";
            }
        }
        return "http://hl7.org/fhir/StructureDefinition/cqf-pertinence";
    }
}

