/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cqframework.cql.elm.requirements.CollapsedElmRequirements;
import org.cqframework.cql.elm.requirements.ElmDataRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirementsContext;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.IncludeElement;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.VersionedIdentifier;

public class ElmRequirements
extends ElmRequirement {
    private HashSet<ElmRequirement> requirements = new LinkedHashSet<ElmRequirement>();

    public Iterable<ElmRequirement> getRequirements() {
        return this.requirements;
    }

    public ElmRequirements(VersionedIdentifier libraryIdentifier, Element element) {
        super(libraryIdentifier, element);
    }

    public void reportRequirement(ElmRequirement requirement) {
        if (requirement instanceof ElmRequirements) {
            for (ElmRequirement r : ((ElmRequirements)requirement).getRequirements()) {
                this.reportRequirement(r);
            }
        } else if (requirement != null) {
            this.requirements.add(requirement);
        }
    }

    public Iterable<ElmRequirement> getUsingDefs() {
        return this.requirements.stream().filter(x -> x.getElement() instanceof UsingDef).collect(Collectors.toList());
    }

    public Iterable<ElmRequirement> getIncludeDefs() {
        return this.requirements.stream().filter(x -> x.getElement() instanceof IncludeDef).collect(Collectors.toList());
    }

    public Iterable<ElmRequirement> getCodeSystemDefs() {
        return this.requirements.stream().filter(x -> x.getElement() instanceof CodeSystemDef).collect(Collectors.toList());
    }

    public Iterable<ElmRequirement> getValueSetDefs() {
        return this.requirements.stream().filter(x -> x.getElement() instanceof ValueSetDef).collect(Collectors.toList());
    }

    public Iterable<ElmRequirement> getCodeDefs() {
        return this.requirements.stream().filter(x -> x.getElement() instanceof CodeDef).collect(Collectors.toList());
    }

    public Iterable<ElmRequirement> getConceptDefs() {
        return this.requirements.stream().filter(x -> x.getElement() instanceof ConceptDef).collect(Collectors.toList());
    }

    public Iterable<ElmRequirement> getParameterDefs() {
        return this.requirements.stream().filter(x -> x.getElement() instanceof ParameterDef).collect(Collectors.toList());
    }

    public Iterable<ElmRequirement> getExpressionDefs() {
        return this.requirements.stream().filter(x -> x.getElement() instanceof ExpressionDef && !(x.getElement() instanceof FunctionDef)).collect(Collectors.toList());
    }

    public Iterable<ElmRequirement> getFunctionDefs() {
        return this.requirements.stream().filter(x -> x.getElement() instanceof FunctionDef).collect(Collectors.toList());
    }

    public Iterable<ElmRequirement> getRetrieves() {
        return this.requirements.stream().filter(x -> x.getElement() instanceof Retrieve).collect(Collectors.toList());
    }

    public ElmRequirements collapse(ElmRequirementsContext context) {
        String typeUri;
        ElmRequirements result = new ElmRequirements(this.libraryIdentifier, this.element);
        LinkedHashMap<CallSite, ElmRequirement> models = new LinkedHashMap<CallSite, ElmRequirement>();
        for (ElmRequirement elmRequirement : this.getUsingDefs()) {
            UsingDef usingDef = (UsingDef)elmRequirement.getElement();
            String string = usingDef.getUri() + (String)(usingDef.getVersion() != null ? "|" + usingDef.getVersion() : "");
            if (models.containsKey(string)) continue;
            models.put((CallSite)((Object)string), elmRequirement);
        }
        for (ElmRequirement elmRequirement : models.values()) {
            result.reportRequirement(elmRequirement);
        }
        LinkedHashMap<CallSite, ElmRequirement> libraries = new LinkedHashMap<CallSite, ElmRequirement>();
        for (ElmRequirement elmRequirement : this.getIncludeDefs()) {
            IncludeDef includeDef = (IncludeDef)elmRequirement.getElement();
            String string = includeDef.getPath() + (String)(includeDef.getVersion() != null ? "|" + includeDef.getVersion() : "");
            if (libraries.containsKey(string)) continue;
            libraries.put((CallSite)((Object)string), elmRequirement);
        }
        for (ElmRequirement elmRequirement : libraries.values()) {
            result.reportRequirement(elmRequirement);
        }
        LinkedHashMap<CallSite, ElmRequirement> linkedHashMap = new LinkedHashMap<CallSite, ElmRequirement>();
        for (ElmRequirement elmRequirement : this.getCodeSystemDefs()) {
            CodeSystemDef codeSystemDef = (CodeSystemDef)elmRequirement.getElement();
            String string = codeSystemDef.getId() + (String)(codeSystemDef.getVersion() != null ? "|" + codeSystemDef.getVersion() : "");
            if (linkedHashMap.containsKey(string)) continue;
            linkedHashMap.put((CallSite)((Object)string), elmRequirement);
        }
        for (ElmRequirement elmRequirement : linkedHashMap.values()) {
            result.reportRequirement(elmRequirement);
        }
        LinkedHashMap<CallSite, ElmRequirement> linkedHashMap2 = new LinkedHashMap<CallSite, ElmRequirement>();
        for (ElmRequirement elmRequirement : this.getValueSetDefs()) {
            ValueSetDef valueSetDef = (ValueSetDef)elmRequirement.getElement();
            String string = valueSetDef.getId() + (String)(valueSetDef.getVersion() != null ? "|" + valueSetDef.getVersion() : "");
            if (linkedHashMap2.containsKey(string)) continue;
            linkedHashMap2.put((CallSite)((Object)string), elmRequirement);
        }
        for (ElmRequirement elmRequirement : linkedHashMap2.values()) {
            result.reportRequirement(elmRequirement);
        }
        LinkedHashMap<String, ElmRequirement> linkedHashMap3 = new LinkedHashMap<String, ElmRequirement>();
        for (ElmRequirement elmRequirement : this.getConceptDefs()) {
            ConceptDef conceptDef = (ConceptDef)elmRequirement.getElement();
            String string = String.format("%s%s.%s", elmRequirement.getLibraryIdentifier().getSystem() != null ? elmRequirement.getLibraryIdentifier().getSystem() + "." : "", elmRequirement.getLibraryIdentifier().getId(), conceptDef.getName());
            if (linkedHashMap3.containsKey(string)) continue;
            linkedHashMap3.put(string, elmRequirement);
        }
        for (ElmRequirement elmRequirement : linkedHashMap3.values()) {
            result.reportRequirement(elmRequirement);
        }
        LinkedHashMap<String, ElmRequirement> linkedHashMap4 = new LinkedHashMap<String, ElmRequirement>();
        for (ElmRequirement elmRequirement : this.getCodeDefs()) {
            CodeDef codeDef = (CodeDef)elmRequirement.getElement();
            String string = String.format("%s#%s", codeDef.getCodeSystem().getName(), codeDef.getId());
            if (linkedHashMap4.containsKey(string)) continue;
            linkedHashMap4.put(string, elmRequirement);
        }
        for (ElmRequirement elmRequirement : linkedHashMap4.values()) {
            result.reportRequirement(elmRequirement);
        }
        LinkedHashMap<String, ElmRequirement> linkedHashMap5 = new LinkedHashMap<String, ElmRequirement>();
        for (ElmRequirement elmRequirement : this.getParameterDefs()) {
            ParameterDef parameterDef = (ParameterDef)elmRequirement.getElement();
            String uri = parameterDef.getName();
            if (linkedHashMap5.containsKey(uri)) continue;
            linkedHashMap5.put(uri, elmRequirement);
        }
        for (ElmRequirement elmRequirement : linkedHashMap5.values()) {
            result.reportRequirement(elmRequirement);
        }
        LinkedHashMap<String, ElmRequirement> linkedHashMap6 = new LinkedHashMap<String, ElmRequirement>();
        for (ElmRequirement elmRequirement : this.getExpressionDefs()) {
            ExpressionDef ed = (ExpressionDef)elmRequirement.getElement();
            String uri = String.format("%s%s.%s", elmRequirement.getLibraryIdentifier().getSystem() != null ? elmRequirement.getLibraryIdentifier().getSystem() + "." : "", elmRequirement.getLibraryIdentifier().getId(), ed.getName());
            if (linkedHashMap6.containsKey(uri)) continue;
            linkedHashMap6.put(uri, elmRequirement);
        }
        for (ElmRequirement elmRequirement : linkedHashMap6.values()) {
            result.reportRequirement(elmRequirement);
        }
        LinkedHashMap<String, ElmRequirement> linkedHashMap7 = new LinkedHashMap<String, ElmRequirement>();
        for (ElmRequirement r : this.getFunctionDefs()) {
            FunctionDef fd = (FunctionDef)r.getElement();
            String uri = String.format("%s%s.%s(%s)", r.getLibraryIdentifier().getSystem() != null ? r.getLibraryIdentifier().getSystem() + "." : "", r.getLibraryIdentifier().getId(), fd.getName(), this.getSignature(fd));
            if (linkedHashMap7.containsKey(uri)) continue;
            linkedHashMap7.put(uri, r);
        }
        for (ElmRequirement r : linkedHashMap7.values()) {
            result.reportRequirement(r);
        }
        LinkedHashMap linkedHashMap8 = new LinkedHashMap();
        ArrayList<ElmRequirement> unboundRequirements = new ArrayList<ElmRequirement>();
        for (ElmRequirement r : this.getRetrieves()) {
            Retrieve retrieve = (Retrieve)r.getElement();
            if (retrieve.getDataType() != null) {
                typeUri = retrieve.getTemplateId() != null ? retrieve.getTemplateId() : retrieve.getDataType().getLocalPart();
                List<ElmRequirement> typeRetrieves = null;
                if (linkedHashMap8.containsKey(typeUri)) {
                    typeRetrieves = (List)linkedHashMap8.get(typeUri);
                } else {
                    typeRetrieves = new ArrayList();
                    linkedHashMap8.put(typeUri, typeRetrieves);
                }
                typeRetrieves.add(r);
                continue;
            }
            unboundRequirements.add(r);
        }
        for (ElmRequirement requirement : unboundRequirements) {
            Iterator<Object> typeRequirements;
            ElmDataRequirement dataRequirement;
            if (!(requirement instanceof ElmDataRequirement) || !(dataRequirement = (ElmDataRequirement)requirement).hasProperties() || (typeUri = context.getTypeResolver().getTypeUri(dataRequirement.getRetrieve().getResultType())) == null || (typeRequirements = (List)linkedHashMap8.get(typeUri)) == null) continue;
            Iterator iterator = typeRequirements.iterator();
            while (iterator.hasNext()) {
                ElmRequirement typeRequirement = (ElmRequirement)iterator.next();
                if (!(typeRequirement instanceof ElmDataRequirement)) continue;
                ElmDataRequirement typeDataRequirement = (ElmDataRequirement)typeRequirement;
                for (Property p : dataRequirement.getProperties()) {
                    typeDataRequirement.addProperty(p);
                }
            }
        }
        HashMap<String, String> requirementIdMap = new HashMap<String, String>();
        for (Map.Entry entry : linkedHashMap8.entrySet()) {
            CollapsedElmRequirements collapsedRetrieves = new CollapsedElmRequirements();
            for (ElmRequirement requirement : (List)entry.getValue()) {
                collapsedRetrieves.add(requirement);
            }
            for (Map.Entry<String, String> idMapEntry : collapsedRetrieves.getRequirementIdMap().entrySet()) {
                requirementIdMap.put(idMapEntry.getKey(), idMapEntry.getValue());
            }
            for (ElmRequirement r : collapsedRetrieves.getUniqueRequirements()) {
                result.reportRequirement(r);
            }
        }
        for (ElmRequirement requirement : result.getRequirements()) {
            String mappedId;
            if (!(requirement.getElement() instanceof Retrieve)) continue;
            Retrieve r = (Retrieve)requirement.getElement();
            if (r.getIncludedIn() != null && (mappedId = (String)requirementIdMap.get(r.getIncludedIn())) != null) {
                r.setIncludedIn(mappedId);
            }
            for (IncludeElement includeElement : r.getInclude()) {
                String mappedId2;
                if (includeElement.getIncludeFrom() == null || (mappedId2 = (String)requirementIdMap.get(includeElement.getIncludeFrom())) == null) continue;
                includeElement.setIncludeFrom(mappedId2);
            }
        }
        return result;
    }

    private String getSignature(FunctionDef fd) {
        StringBuilder sb = new StringBuilder();
        for (OperandDef od : fd.getOperand()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getTypeName(od));
        }
        return sb.toString();
    }

    private String getTypeName(OperandDef od) {
        if (od.getOperandType() != null) {
            return od.toString();
        }
        if (od.getOperandTypeSpecifier() != null) {
            return od.getOperandTypeSpecifier().toString();
        }
        return "";
    }
}

