/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.requirements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.elm.requirements.ComparableElmRequirement;
import org.cqframework.cql.elm.requirements.ElmRequirement;

public class CollapsedElmRequirements {
    private List<ElmRequirement> uniqueRequirements = new ArrayList<ElmRequirement>();
    private Map<String, String> requirementIdMap = new HashMap<String, String>();

    public Iterable<ElmRequirement> getUniqueRequirements() {
        return this.uniqueRequirements;
    }

    public void add(ElmRequirement requirement) {
        ElmRequirement existing = this.getEquivalent(requirement);
        if (existing == null) {
            this.uniqueRequirements.add(requirement);
        } else {
            this.uniqueRequirements.remove(existing);
            ElmRequirement newRequirement = ComparableElmRequirement.mergeRequirements(existing, requirement);
            this.mapRequirementId(requirement, newRequirement);
            this.uniqueRequirements.add(ComparableElmRequirement.mergeRequirements(existing, requirement));
        }
    }

    public Map<String, String> getRequirementIdMap() {
        return this.requirementIdMap;
    }

    private void mapRequirementId(ElmRequirement oldRequirement, ElmRequirement newRequirement) {
        if (oldRequirement.getElement().getLocalId() != null) {
            this.requirementIdMap.put(oldRequirement.getElement().getLocalId(), newRequirement.getElement().getLocalId());
        }
    }

    public ElmRequirement getEquivalent(ElmRequirement requirement) {
        for (ElmRequirement existing : this.uniqueRequirements) {
            if (!ComparableElmRequirement.requirementsEquivalent(existing, requirement)) continue;
            return existing;
        }
        return null;
    }
}

