/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.serializing.jaxb;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.cqframework.cql.elm.serializing.ElmLibraryWriter;
import org.cqframework.cql.elm.serializing.jaxb.ElmJsonMapper;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.ObjectFactory;

public class ElmJsonLibraryWriter
implements ElmLibraryWriter {
    public void write(Library library, Writer writer) throws IOException {
        Marshaller marshaller = null;
        try {
            marshaller = ElmJsonMapper.getJaxbContext().createMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        try {
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        }
        catch (PropertyException e) {
            throw new RuntimeException(e);
        }
        try {
            marshaller.marshal((Object)new ObjectFactory().createLibrary(library), writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public String writeAsString(Library library) {
        StringWriter writer = new StringWriter();
        try {
            this.write(library, writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.getBuffer().toString();
    }
}

