/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.serializing.jaxb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.cqframework.cql.elm.serializing.ElmLibraryReader;
import org.cqframework.cql.elm.serializing.jaxb.ElmJsonMapper;
import org.cqframework.cql.elm.serializing.jaxb.LibraryReaderUtil;
import org.hl7.elm.r1.Library;

public class ElmJsonLibraryReader
implements ElmLibraryReader {
    private Unmarshaller getUnmarshaller() {
        Unmarshaller unmarshaller = null;
        try {
            unmarshaller = ElmJsonMapper.getJaxbContext().createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        try {
            unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        }
        catch (PropertyException e) {
            throw new RuntimeException(e);
        }
        try {
            unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    return true;
                }
            });
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return unmarshaller;
    }

    private Library read(Object source) throws IOException {
        Library library = null;
        try {
            library = (Library)this.getUnmarshaller().unmarshal(LibraryReaderUtil.toSource(source), Library.class).getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return library;
    }

    public Library read(File file) throws IOException {
        return this.read(LibraryReaderUtil.toSource(file));
    }

    public Library read(URL url) throws IOException {
        return this.read(LibraryReaderUtil.toSource(url));
    }

    public Library read(URI uri) throws IOException {
        return this.read(LibraryReaderUtil.toSource(uri));
    }

    public Library read(String string) throws IOException {
        return this.read(LibraryReaderUtil.toSource(string));
    }

    public Library read(InputStream inputStream) throws IOException {
        return this.read(LibraryReaderUtil.toSource(inputStream));
    }

    public Library read(Reader reader) throws IOException {
        return this.read(LibraryReaderUtil.toSource(reader));
    }
}

