/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.visiting;

import org.cqframework.cql.elm.visiting.ElmBaseClinicalVisitor;
import org.cqframework.cql.elm.visiting.ElmLibraryVisitor;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.ContextDef;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.IncludeDef;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.UsingDef;
import org.hl7.elm.r1.ValueSetDef;

public class ElmBaseLibraryVisitor<T, C>
extends ElmBaseClinicalVisitor<T, C>
implements ElmLibraryVisitor<T, C> {
    @Override
    public T visitElement(Element elm, C context) {
        if (elm instanceof IncludeDef) {
            return this.visitIncludeDef((IncludeDef)elm, context);
        }
        if (elm instanceof ContextDef) {
            return this.visitContextDef((ContextDef)elm, context);
        }
        if (elm instanceof Library) {
            return this.visitLibrary((Library)elm, context);
        }
        if (elm instanceof UsingDef) {
            return this.visitUsingDef((UsingDef)elm, context);
        }
        return super.visitElement(elm, context);
    }

    @Override
    public T visitLibrary(Library elm, C context) {
        T childResult;
        Object result = this.defaultResult();
        if (elm.getUsings() != null && elm.getUsings().getDef() != null && !elm.getUsings().getDef().isEmpty()) {
            for (UsingDef usingDef : elm.getUsings().getDef()) {
                childResult = this.visitElement(usingDef, context);
                result = this.aggregateResult(result, childResult);
            }
        }
        if (elm.getIncludes() != null && elm.getIncludes().getDef() != null && !elm.getIncludes().getDef().isEmpty()) {
            for (IncludeDef includeDef : elm.getIncludes().getDef()) {
                childResult = this.visitElement(includeDef, context);
                result = this.aggregateResult(result, childResult);
            }
        }
        if (elm.getCodeSystems() != null && elm.getCodeSystems().getDef() != null && !elm.getCodeSystems().getDef().isEmpty()) {
            for (CodeSystemDef codeSystemDef : elm.getCodeSystems().getDef()) {
                childResult = this.visitElement(codeSystemDef, context);
                result = this.aggregateResult(result, childResult);
            }
        }
        if (elm.getValueSets() != null && elm.getValueSets().getDef() != null && !elm.getValueSets().getDef().isEmpty()) {
            for (ValueSetDef valueSetDef : elm.getValueSets().getDef()) {
                childResult = this.visitElement(valueSetDef, context);
                result = this.aggregateResult(result, childResult);
            }
        }
        if (elm.getCodes() != null && elm.getCodes().getDef() != null && !elm.getCodes().getDef().isEmpty()) {
            for (CodeDef codeDef : elm.getCodes().getDef()) {
                childResult = this.visitElement(codeDef, context);
                result = this.aggregateResult(result, childResult);
            }
        }
        if (elm.getConcepts() != null && elm.getConcepts().getDef() != null && !elm.getConcepts().getDef().isEmpty()) {
            for (ConceptDef conceptDef : elm.getConcepts().getDef()) {
                childResult = this.visitElement(conceptDef, context);
                result = this.aggregateResult(result, childResult);
            }
        }
        if (elm.getParameters() != null && elm.getParameters().getDef() != null && !elm.getParameters().getDef().isEmpty()) {
            for (ParameterDef parameterDef : elm.getParameters().getDef()) {
                childResult = this.visitElement(parameterDef, context);
                result = this.aggregateResult(result, childResult);
            }
        }
        if (elm.getContexts() != null && elm.getContexts().getDef() != null && !elm.getContexts().getDef().isEmpty()) {
            for (ContextDef contextDef : elm.getContexts().getDef()) {
                childResult = this.visitElement(contextDef, context);
                result = this.aggregateResult(result, childResult);
            }
        }
        if (elm.getStatements() != null && elm.getStatements().getDef() != null && !elm.getStatements().getDef().isEmpty()) {
            for (ExpressionDef expressionDef : elm.getStatements().getDef()) {
                childResult = this.visitElement(expressionDef, context);
                result = this.aggregateResult(result, childResult);
            }
        }
        return result;
    }

    @Override
    public T visitUsingDef(UsingDef elm, C context) {
        return this.defaultResult();
    }

    @Override
    public T visitIncludeDef(IncludeDef elm, C context) {
        return this.defaultResult();
    }

    @Override
    public T visitContextDef(ContextDef elm, C context) {
        return this.defaultResult();
    }
}

