/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.evaluating;

import org.hl7.elm.r1.Code;
import org.hl7.elm.r1.CodeRef;
import org.hl7.elm.r1.CodeSystemRef;
import org.hl7.elm.r1.Concept;
import org.hl7.elm.r1.ConceptRef;
import org.hl7.elm.r1.Date;
import org.hl7.elm.r1.DateTime;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.Interval;
import org.hl7.elm.r1.List;
import org.hl7.elm.r1.Literal;
import org.hl7.elm.r1.Time;
import org.hl7.elm.r1.ValueSetRef;

public class SimpleElmEngine {
    private boolean literalsEqual(Literal left, Literal right) {
        return left == null && right == null || left.getValueType() != null && left.getValueType().equals(right.getValueType()) && this.stringsEqual(left.getValue(), right.getValue());
    }

    public boolean booleansEqual(Expression left, Expression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left instanceof Literal && right instanceof Literal) {
            return this.literalsEqual((Literal)left, (Literal)right);
        }
        return false;
    }

    public boolean integersEqual(Expression left, Expression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left instanceof Literal && right instanceof Literal) {
            return this.literalsEqual((Literal)left, (Literal)right);
        }
        return false;
    }

    public boolean decimalsEqual(Expression left, Expression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left instanceof Literal && right instanceof Literal) {
            return this.literalsEqual((Literal)left, (Literal)right);
        }
        return false;
    }

    public boolean stringsEqual(Expression left, Expression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left instanceof Literal && right instanceof Literal) {
            return this.literalsEqual((Literal)left, (Literal)right);
        }
        return false;
    }

    public boolean dateTimesEqual(Expression left, Expression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left instanceof Literal && right instanceof Literal) {
            return this.literalsEqual((Literal)left, (Literal)right);
        }
        if (left instanceof Date && right instanceof Date) {
            Date leftDate = (Date)left;
            Date rightDate = (Date)right;
            return this.integersEqual(leftDate.getYear(), rightDate.getYear()) && this.integersEqual(leftDate.getMonth(), rightDate.getMonth()) && this.integersEqual(leftDate.getDay(), rightDate.getDay());
        }
        if (left instanceof Time && right instanceof Time) {
            Time leftTime = (Time)left;
            Time rightTime = (Time)right;
            return this.integersEqual(leftTime.getHour(), rightTime.getHour()) && this.integersEqual(leftTime.getMinute(), rightTime.getMinute()) && this.integersEqual(leftTime.getSecond(), rightTime.getSecond()) && this.integersEqual(leftTime.getMillisecond(), rightTime.getMillisecond());
        }
        if (left instanceof DateTime && right instanceof DateTime) {
            DateTime leftDateTime = (DateTime)left;
            DateTime rightDateTime = (DateTime)right;
            return this.integersEqual(leftDateTime.getYear(), rightDateTime.getYear()) && this.integersEqual(leftDateTime.getMonth(), rightDateTime.getMonth()) && this.integersEqual(leftDateTime.getDay(), rightDateTime.getDay()) && this.integersEqual(leftDateTime.getHour(), rightDateTime.getHour()) && this.integersEqual(leftDateTime.getMinute(), rightDateTime.getMinute()) && this.integersEqual(leftDateTime.getSecond(), rightDateTime.getSecond()) && this.integersEqual(leftDateTime.getMillisecond(), rightDateTime.getMillisecond()) && this.decimalsEqual(leftDateTime.getTimezoneOffset(), rightDateTime.getTimezoneOffset());
        }
        return false;
    }

    public boolean dateRangesEqual(Expression left, Expression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left instanceof Interval && right instanceof Interval) {
            Interval leftInterval = (Interval)left;
            Interval rightInterval = (Interval)right;
            return this.booleansEqual(leftInterval.getLowClosedExpression(), rightInterval.getLowClosedExpression()) && this.dateTimesEqual(leftInterval.getLow(), rightInterval.getLow()) && leftInterval.isLowClosed() == rightInterval.isLowClosed() && this.booleansEqual(leftInterval.getHighClosedExpression(), rightInterval.getHighClosedExpression()) && this.dateTimesEqual(leftInterval.getHigh(), rightInterval.getHigh()) && leftInterval.isHighClosed() == rightInterval.isHighClosed();
        }
        return false;
    }

    public boolean stringsEqual(String left, String right) {
        return left == null && right == null || left != null && left.equals(right);
    }

    public boolean systemsEqual(CodeSystemRef left, CodeSystemRef right) {
        return left == null && right == null || this.stringsEqual(left.getLibraryName(), right.getLibraryName()) && this.stringsEqual(left.getName(), right.getName());
    }

    public boolean valueSetsEqual(ValueSetRef left, ValueSetRef right) {
        return left == null && right == null || this.stringsEqual(left.getLibraryName(), right.getLibraryName()) && this.stringsEqual(left.getName(), right.getName());
    }

    public boolean codesEqual(Expression left, Expression right) {
        block13: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block12: {
                                    if (left == null && right == null) {
                                        return true;
                                    }
                                    if (!(left instanceof ValueSetRef)) break block12;
                                    if (right instanceof ValueSetRef) {
                                        return this.valueSetsEqual((ValueSetRef)left, (ValueSetRef)right);
                                    }
                                    break block13;
                                }
                                if (!(left instanceof CodeSystemRef)) break block14;
                                if (right instanceof CodeSystemRef) {
                                    return this.systemsEqual((CodeSystemRef)left, (CodeSystemRef)right);
                                }
                                break block13;
                            }
                            if (!(left instanceof ConceptRef)) break block15;
                            if (right instanceof ConceptRef) {
                                ConceptRef leftConcept = (ConceptRef)left;
                                ConceptRef rightConcept = (ConceptRef)right;
                                return this.stringsEqual(leftConcept.getLibraryName(), rightConcept.getLibraryName()) && this.stringsEqual(leftConcept.getName(), rightConcept.getName());
                            }
                            break block13;
                        }
                        if (!(left instanceof CodeRef)) break block16;
                        if (right instanceof CodeRef) {
                            CodeRef leftCode = (CodeRef)left;
                            CodeRef rightCode = (CodeRef)right;
                            return this.stringsEqual(leftCode.getLibraryName(), rightCode.getLibraryName()) && this.stringsEqual(leftCode.getName(), rightCode.getName());
                        }
                        break block13;
                    }
                    if (!(left instanceof Code)) break block17;
                    if (right instanceof Code) {
                        Code leftCode = (Code)left;
                        Code rightCode = (Code)right;
                        return this.stringsEqual(leftCode.getCode(), rightCode.getCode()) && this.systemsEqual(leftCode.getSystem(), rightCode.getSystem());
                    }
                    break block13;
                }
                if (!(left instanceof Concept)) break block18;
                if (!(right instanceof Concept)) break block13;
                Concept leftConcept = (Concept)left;
                Concept rightConcept = (Concept)right;
                if (leftConcept.getCode() != null && rightConcept.getCode() != null) {
                    for (Code lc : leftConcept.getCode()) {
                        for (Code rc : rightConcept.getCode()) {
                            if (!this.codesEqual(lc, rc)) continue;
                            return true;
                        }
                    }
                }
                break block13;
            }
            if (left instanceof List && right instanceof List) {
                List leftList = (List)left;
                List rightList = (List)right;
                if (leftList.getElement().size() == rightList.getElement().size()) {
                    for (int i = 0; i < leftList.getElement().size(); ++i) {
                        if (this.codesEqual(leftList.getElement().get(i), rightList.getElement().get(i))) continue;
                        return false;
                    }
                }
            }
        }
        return false;
    }
}

