/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.serializing;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.cqframework.cql.elm.serializing.ElmLibraryWriter;
import org.cqframework.cql.elm.serializing.ElmLibraryWriterProvider;

public class ElmLibraryWriterFactory {
    private ElmLibraryWriterFactory() {
    }

    public static Iterator<ElmLibraryWriterProvider> providers(boolean refresh) {
        ServiceLoader<ElmLibraryWriterProvider> loader = ServiceLoader.load(ElmLibraryWriterProvider.class);
        if (refresh) {
            loader.reload();
        }
        return loader.iterator();
    }

    public static ElmLibraryWriter getWriter(String contentType) {
        Iterator<ElmLibraryWriterProvider> providers = ElmLibraryWriterFactory.providers(false);
        if (providers.hasNext()) {
            ElmLibraryWriterProvider p = providers.next();
            if (providers.hasNext()) {
                throw new RuntimeException(String.join((CharSequence)" ", "Multiple ElmLibraryWriterProviders found on the classpath.", "You need to remove a reference to either the 'elm-jackson' or the 'elm-jaxb' package"));
            }
            return p.create(contentType);
        }
        throw new RuntimeException(String.join((CharSequence)" ", "No ElmLibraryWriterProviders found on the classpath.", "You need to add a reference to one of the 'elm-jackson' or 'elm-jaxb' packages,", "or provide your own implementation."));
    }
}

