/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.visiting;

import org.cqframework.cql.elm.visiting.BaseElmVisitor;
import org.cqframework.cql.elm.visiting.ElmClinicalVisitor;
import org.hl7.elm.r1.AnyInCodeSystem;
import org.hl7.elm.r1.AnyInValueSet;
import org.hl7.elm.r1.BinaryExpression;
import org.hl7.elm.r1.CalculateAge;
import org.hl7.elm.r1.CalculateAgeAt;
import org.hl7.elm.r1.Code;
import org.hl7.elm.r1.CodeDef;
import org.hl7.elm.r1.CodeFilterElement;
import org.hl7.elm.r1.CodeRef;
import org.hl7.elm.r1.CodeSystemDef;
import org.hl7.elm.r1.CodeSystemRef;
import org.hl7.elm.r1.Concept;
import org.hl7.elm.r1.ConceptDef;
import org.hl7.elm.r1.ConceptRef;
import org.hl7.elm.r1.DateFilterElement;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.ExpandValueSet;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.ExpressionRef;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.InCodeSystem;
import org.hl7.elm.r1.InValueSet;
import org.hl7.elm.r1.IncludeElement;
import org.hl7.elm.r1.OperatorExpression;
import org.hl7.elm.r1.OtherFilterElement;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Quantity;
import org.hl7.elm.r1.Ratio;
import org.hl7.elm.r1.Retrieve;
import org.hl7.elm.r1.Search;
import org.hl7.elm.r1.SubsumedBy;
import org.hl7.elm.r1.Subsumes;
import org.hl7.elm.r1.UnaryExpression;
import org.hl7.elm.r1.ValueSetDef;
import org.hl7.elm.r1.ValueSetRef;

public abstract class BaseElmClinicalVisitor<T, C>
extends BaseElmVisitor<T, C>
implements ElmClinicalVisitor<T, C> {
    @Override
    public T visitElement(Element elm, C context) {
        if (elm instanceof ExpressionDef) {
            return this.visitExpressionDef((ExpressionDef)elm, context);
        }
        if (elm instanceof CodeDef) {
            return this.visitCodeDef((CodeDef)elm, context);
        }
        if (elm instanceof CodeSystemDef) {
            return this.visitCodeSystemDef((CodeSystemDef)elm, context);
        }
        if (elm instanceof ValueSetDef) {
            return this.visitValueSetDef((ValueSetDef)elm, context);
        }
        if (elm instanceof ConceptDef) {
            return this.visitConceptDef((ConceptDef)elm, context);
        }
        if (elm instanceof CodeFilterElement) {
            return this.visitCodeFilterElement((CodeFilterElement)elm, context);
        }
        if (elm instanceof DateFilterElement) {
            return this.visitDateFilterElement((DateFilterElement)elm, context);
        }
        if (elm instanceof OtherFilterElement) {
            return this.visitOtherFilterElement((OtherFilterElement)elm, context);
        }
        if (elm instanceof IncludeElement) {
            return this.visitIncludeElement((IncludeElement)elm, context);
        }
        return super.visitElement(elm, context);
    }

    @Override
    public T visitExpression(Expression elm, C context) {
        if (elm instanceof FunctionRef) {
            return this.visitFunctionRef((FunctionRef)elm, context);
        }
        if (elm instanceof ExpressionRef) {
            return this.visitExpressionRef((ExpressionRef)elm, context);
        }
        if (elm instanceof CodeSystemRef) {
            return this.visitCodeSystemRef((CodeSystemRef)elm, context);
        }
        if (elm instanceof ValueSetRef) {
            return this.visitValueSetRef((ValueSetRef)elm, context);
        }
        if (elm instanceof CodeRef) {
            return this.visitCodeRef((CodeRef)elm, context);
        }
        if (elm instanceof ConceptRef) {
            return this.visitConceptRef((ConceptRef)elm, context);
        }
        if (elm instanceof Code) {
            return this.visitCode((Code)elm, context);
        }
        if (elm instanceof Concept) {
            return this.visitConcept((Concept)elm, context);
        }
        if (elm instanceof Quantity) {
            return this.visitQuantity((Quantity)elm, context);
        }
        if (elm instanceof Ratio) {
            return this.visitRatio((Ratio)elm, context);
        }
        if (elm instanceof Retrieve) {
            return this.visitRetrieve((Retrieve)elm, context);
        }
        return super.visitExpression(elm, context);
    }

    @Override
    public T visitOperatorExpression(OperatorExpression elm, C context) {
        if (elm instanceof InCodeSystem) {
            return this.visitInCodeSystem((InCodeSystem)elm, context);
        }
        if (elm instanceof AnyInCodeSystem) {
            return this.visitAnyInCodeSystem((AnyInCodeSystem)elm, context);
        }
        if (elm instanceof InValueSet) {
            return this.visitInValueSet((InValueSet)elm, context);
        }
        if (elm instanceof AnyInValueSet) {
            return this.visitAnyInValueSet((AnyInValueSet)elm, context);
        }
        return super.visitOperatorExpression(elm, context);
    }

    @Override
    public T visitUnaryExpression(UnaryExpression elm, C context) {
        if (elm instanceof ExpandValueSet) {
            return this.visitExpandValueSet((ExpandValueSet)elm, context);
        }
        if (elm instanceof CalculateAge) {
            return this.visitCalculateAge((CalculateAge)elm, context);
        }
        return super.visitUnaryExpression(elm, context);
    }

    @Override
    public T visitBinaryExpression(BinaryExpression elm, C context) {
        if (elm instanceof CalculateAgeAt) {
            return this.visitCalculateAgeAt((CalculateAgeAt)elm, context);
        }
        if (elm instanceof Subsumes) {
            return this.visitSubsumes((Subsumes)elm, context);
        }
        if (elm instanceof SubsumedBy) {
            return this.visitSubsumedBy((SubsumedBy)elm, context);
        }
        return super.visitBinaryExpression(elm, context);
    }

    public T visitExpandValueSet(ExpandValueSet elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitCodeFilterElement(CodeFilterElement elm, C context) {
        Object result = this.visitFields(elm, context);
        if (elm.getValue() != null) {
            T childResult = this.visitExpression(elm.getValue(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitDateFilterElement(DateFilterElement elm, C context) {
        Object result = this.visitFields(elm, context);
        if (elm.getValue() != null) {
            T childResult = this.visitExpression(elm.getValue(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitOtherFilterElement(OtherFilterElement elm, C context) {
        Object result = this.visitFields(elm, context);
        if (elm.getValue() != null) {
            T childResult = this.visitExpression(elm.getValue(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitIncludeElement(IncludeElement elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitRetrieve(Retrieve elm, C context) {
        Object childResult;
        T childResult2;
        Object result = this.visitFields(elm, context);
        for (CodeFilterElement cfe : elm.getCodeFilter()) {
            childResult2 = this.visitCodeFilterElement(cfe, context);
            result = this.aggregateResult(result, childResult2);
        }
        if (elm.getCodes() != null) {
            childResult = this.visitExpression(elm.getCodes(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getContext() != null) {
            childResult = this.visitExpression(elm.getContext(), context);
            result = this.aggregateResult(result, childResult);
        }
        for (DateFilterElement dfe : elm.getDateFilter()) {
            childResult2 = this.visitDateFilterElement(dfe, context);
            result = this.aggregateResult(result, childResult2);
        }
        if (elm.getDateRange() != null) {
            childResult = this.visitExpression(elm.getDateRange(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getId() != null) {
            childResult = this.visitExpression(elm.getId(), context);
            result = this.aggregateResult(result, childResult);
        }
        for (IncludeElement ie : elm.getInclude()) {
            childResult2 = this.visitIncludeElement(ie, context);
            result = this.aggregateResult(result, childResult2);
        }
        for (OtherFilterElement ofe : elm.getOtherFilter()) {
            childResult2 = this.visitOtherFilterElement(ofe, context);
            result = this.aggregateResult(result, childResult2);
        }
        return result;
    }

    @Override
    public T visitProperty(Property elm, C context) {
        if (elm instanceof Search) {
            return this.visitSearch((Search)elm, context);
        }
        return super.visitProperty(elm, context);
    }

    @Override
    public T visitSearch(Search elm, C context) {
        Object result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            T childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitCodeSystemDef(CodeSystemDef elm, C context) {
        Object result = this.visitFields(elm, context);
        if (elm.getAccessLevel() != null) {
            Object childResult = this.visitAccessModifier(elm.getAccessLevel(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitValueSetDef(ValueSetDef elm, C context) {
        Object result = this.visitFields(elm, context);
        if (elm.getAccessLevel() != null) {
            Object childResult = this.visitAccessModifier(elm.getAccessLevel(), context);
            result = this.aggregateResult(result, childResult);
        }
        for (CodeSystemRef codeSystemRef : elm.getCodeSystem()) {
            T childResult = this.visitCodeSystemRef(codeSystemRef, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitCodeDef(CodeDef elm, C context) {
        Object childResult;
        Object result = this.visitFields(elm, context);
        if (elm.getAccessLevel() != null) {
            childResult = this.visitAccessModifier(elm.getAccessLevel(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getCodeSystem() != null) {
            childResult = this.visitCodeSystemRef(elm.getCodeSystem(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitConceptDef(ConceptDef elm, C context) {
        Object result = this.visitFields(elm, context);
        if (elm.getAccessLevel() != null) {
            Object childResult = this.visitAccessModifier(elm.getAccessLevel(), context);
            result = this.aggregateResult(result, childResult);
        }
        for (CodeRef cr : elm.getCode()) {
            T childResult = this.visitCodeRef(cr, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitCodeSystemRef(CodeSystemRef elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitValueSetRef(ValueSetRef elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitCodeRef(CodeRef elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitConceptRef(ConceptRef elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitCode(Code elm, C context) {
        Object result = this.visitFields(elm, context);
        if (elm.getSystem() != null) {
            T childResult = this.visitCodeSystemRef(elm.getSystem(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitConcept(Concept elm, C context) {
        Object result = this.visitFields(elm, context);
        for (Code c : elm.getCode()) {
            T childResult = this.visitCode(c, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitInCodeSystem(InCodeSystem elm, C context) {
        T childResult;
        Object result = this.visitFields(elm, context);
        if (elm.getCode() != null) {
            childResult = this.visitExpression(elm.getCode(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getCodesystem() != null) {
            childResult = this.visitCodeSystemRef(elm.getCodesystem(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getCodesystemExpression() != null) {
            childResult = this.visitExpression(elm.getCodesystemExpression(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitAnyInCodeSystem(AnyInCodeSystem elm, C context) {
        T childResult;
        Object result = this.visitFields(elm, context);
        if (elm.getCodes() != null) {
            childResult = this.visitExpression(elm.getCodes(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getCodesystem() != null) {
            childResult = this.visitCodeSystemRef(elm.getCodesystem(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getCodesystemExpression() != null) {
            childResult = this.visitExpression(elm.getCodesystemExpression(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitInValueSet(InValueSet elm, C context) {
        T childResult;
        Object result = this.visitFields(elm, context);
        if (elm.getCode() != null) {
            childResult = this.visitExpression(elm.getCode(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getValueset() != null) {
            childResult = this.visitValueSetRef(elm.getValueset(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getValuesetExpression() != null) {
            childResult = this.visitExpression(elm.getValuesetExpression(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitAnyInValueSet(AnyInValueSet elm, C context) {
        T childResult;
        Object result = this.visitFields(elm, context);
        if (elm.getCodes() != null) {
            childResult = this.visitExpression(elm.getCodes(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getValueset() != null) {
            childResult = this.visitValueSetRef(elm.getValueset(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getValuesetExpression() != null) {
            childResult = this.visitExpression(elm.getValuesetExpression(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitSubsumes(Subsumes elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitSubsumedBy(SubsumedBy elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitQuantity(Quantity elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitRatio(Ratio elm, C context) {
        T childResult;
        Object result = this.visitFields(elm, context);
        if (elm.getDenominator() != null) {
            childResult = this.visitQuantity(elm.getDenominator(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getNumerator() != null) {
            childResult = this.visitQuantity(elm.getNumerator(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitCalculateAge(CalculateAge elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitCalculateAgeAt(CalculateAgeAt elm, C context) {
        return this.visitFields(elm, context);
    }
}

