/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.tracking;

import org.hl7.elm.r1.VersionedIdentifier;

public class TrackBack {
    private final VersionedIdentifier library;
    private final int startLine;
    private final int startChar;
    private final int endLine;
    private final int endChar;

    public TrackBack(VersionedIdentifier library, int startLine, int startChar, int endLine, int endChar) {
        this.library = library;
        this.startLine = startLine;
        this.startChar = startChar;
        this.endLine = endLine;
        this.endChar = endChar;
    }

    public VersionedIdentifier getLibrary() {
        return this.library;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartChar() {
        return this.startChar;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndChar() {
        return this.endChar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackBack trackBack = (TrackBack)o;
        if (this.endChar != trackBack.endChar) {
            return false;
        }
        if (this.endLine != trackBack.endLine) {
            return false;
        }
        if (this.startChar != trackBack.startChar) {
            return false;
        }
        if (this.startLine != trackBack.startLine) {
            return false;
        }
        return this.library.equals(trackBack.library);
    }

    public int hashCode() {
        int result = this.library.hashCode();
        result = 31 * result + this.startLine;
        result = 31 * result + this.startChar;
        result = 31 * result + this.endLine;
        result = 31 * result + this.endChar;
        return result;
    }

    public String toString() {
        return "TrackBack{library='" + String.valueOf(this.library) + "', startLine=" + this.startLine + ", startChar=" + this.startChar + ", endLine=" + this.endLine + ", endChar=" + this.endChar + "}";
    }

    public String toLocator() {
        return this.startLine == this.endLine && this.startChar == this.endChar ? String.format("%s:%s", this.startLine, this.startChar) : String.format("%s:%s-%s:%s", this.startLine, this.startChar, this.endLine, this.endChar);
    }
}

