/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.evaluating;

import java.math.BigDecimal;
import javax.xml.namespace.QName;
import org.hl7.elm.r1.Aggregate;
import org.hl7.elm.r1.AggregateExpression;
import org.hl7.elm.r1.AliasRef;
import org.hl7.elm.r1.AnyInCodeSystem;
import org.hl7.elm.r1.AnyInValueSet;
import org.hl7.elm.r1.As;
import org.hl7.elm.r1.BinaryExpression;
import org.hl7.elm.r1.CalculateAge;
import org.hl7.elm.r1.CanConvert;
import org.hl7.elm.r1.Case;
import org.hl7.elm.r1.CaseItem;
import org.hl7.elm.r1.Children;
import org.hl7.elm.r1.ChoiceTypeSpecifier;
import org.hl7.elm.r1.Code;
import org.hl7.elm.r1.CodeRef;
import org.hl7.elm.r1.CodeSystemRef;
import org.hl7.elm.r1.Combine;
import org.hl7.elm.r1.Concept;
import org.hl7.elm.r1.ConceptRef;
import org.hl7.elm.r1.Convert;
import org.hl7.elm.r1.Current;
import org.hl7.elm.r1.Date;
import org.hl7.elm.r1.DateTime;
import org.hl7.elm.r1.DateTimeComponentFrom;
import org.hl7.elm.r1.Descendents;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionRef;
import org.hl7.elm.r1.Filter;
import org.hl7.elm.r1.First;
import org.hl7.elm.r1.ForEach;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.IdentifierRef;
import org.hl7.elm.r1.If;
import org.hl7.elm.r1.InCodeSystem;
import org.hl7.elm.r1.InValueSet;
import org.hl7.elm.r1.IndexOf;
import org.hl7.elm.r1.Instance;
import org.hl7.elm.r1.InstanceElement;
import org.hl7.elm.r1.Interval;
import org.hl7.elm.r1.IntervalTypeSpecifier;
import org.hl7.elm.r1.Is;
import org.hl7.elm.r1.Iteration;
import org.hl7.elm.r1.Last;
import org.hl7.elm.r1.LastPositionOf;
import org.hl7.elm.r1.List;
import org.hl7.elm.r1.ListTypeSpecifier;
import org.hl7.elm.r1.Literal;
import org.hl7.elm.r1.MaxValue;
import org.hl7.elm.r1.Message;
import org.hl7.elm.r1.MinValue;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.hl7.elm.r1.NaryExpression;
import org.hl7.elm.r1.Null;
import org.hl7.elm.r1.OperandRef;
import org.hl7.elm.r1.OperatorExpression;
import org.hl7.elm.r1.ParameterRef;
import org.hl7.elm.r1.PositionOf;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Quantity;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.QueryLetRef;
import org.hl7.elm.r1.Ratio;
import org.hl7.elm.r1.Repeat;
import org.hl7.elm.r1.Round;
import org.hl7.elm.r1.Slice;
import org.hl7.elm.r1.Sort;
import org.hl7.elm.r1.Split;
import org.hl7.elm.r1.SplitOnMatches;
import org.hl7.elm.r1.Substring;
import org.hl7.elm.r1.SubsumedBy;
import org.hl7.elm.r1.Subsumes;
import org.hl7.elm.r1.TernaryExpression;
import org.hl7.elm.r1.Time;
import org.hl7.elm.r1.ToList;
import org.hl7.elm.r1.Total;
import org.hl7.elm.r1.Tuple;
import org.hl7.elm.r1.TupleElementDefinition;
import org.hl7.elm.r1.TupleTypeSpecifier;
import org.hl7.elm.r1.TypeSpecifier;
import org.hl7.elm.r1.UnaryExpression;
import org.hl7.elm.r1.ValueSetRef;

public class SimpleElmEngine {
    private boolean literalsEqual(Literal left, Literal right) {
        return left == null && right == null || left != null && left.getValueType() != null && left.getValueType().equals(right.getValueType()) && this.stringsEqual(left.getValue(), right.getValue());
    }

    public boolean booleansEqual(Expression left, Expression right) {
        return this.expressionsEqual(left, right);
    }

    public boolean integersEqual(Expression left, Expression right) {
        return this.expressionsEqual(left, right);
    }

    public boolean decimalsEqual(Expression left, Expression right) {
        return this.expressionsEqual(left, right);
    }

    public boolean decimalsEqual(BigDecimal left, BigDecimal right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    public boolean quantitiesEqual(Quantity left, Quantity right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return true;
        }
        return this.decimalsEqual(left.getValue(), right.getValue()) && this.stringsEqual(left.getUnit(), right.getUnit());
    }

    public boolean stringsEqual(Expression left, Expression right) {
        return this.expressionsEqual(left, right);
    }

    public boolean dateTimesEqual(Expression left, Expression right) {
        return this.expressionsEqual(left, right);
    }

    public boolean dateRangesEqual(Expression left, Expression right) {
        return this.expressionsEqual(left, right);
    }

    public boolean stringsEqual(String left, String right) {
        return left == null && right == null || left != null && left.equals(right);
    }

    public boolean systemsEqual(CodeSystemRef left, CodeSystemRef right) {
        return left == null && right == null || left != null && this.stringsEqual(left.getLibraryName(), right.getLibraryName()) && this.stringsEqual(left.getName(), right.getName());
    }

    public boolean valueSetsEqual(ValueSetRef left, ValueSetRef right) {
        return left == null && right == null || left != null && this.stringsEqual(left.getLibraryName(), right.getLibraryName()) && this.stringsEqual(left.getName(), right.getName());
    }

    public boolean codesEqual(Expression left, Expression right) {
        return this.expressionsEqual(left, right);
    }

    public boolean qnamesEqual(QName left, QName right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    public boolean typeSpecifiersEqual(TypeSpecifier left, TypeSpecifier right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof NamedTypeSpecifier) {
            if (right instanceof NamedTypeSpecifier) {
                NamedTypeSpecifier leftArg = (NamedTypeSpecifier)left;
                NamedTypeSpecifier rightArg = (NamedTypeSpecifier)right;
                return this.qnamesEqual(leftArg.getName(), rightArg.getName());
            }
            return false;
        }
        if (left instanceof IntervalTypeSpecifier) {
            if (right instanceof IntervalTypeSpecifier) {
                IntervalTypeSpecifier leftArg = (IntervalTypeSpecifier)left;
                IntervalTypeSpecifier rightArg = (IntervalTypeSpecifier)right;
                return this.typeSpecifiersEqual(leftArg.getPointType(), rightArg.getPointType());
            }
            return false;
        }
        if (left instanceof ListTypeSpecifier) {
            if (right instanceof ListTypeSpecifier) {
                ListTypeSpecifier leftArg = (ListTypeSpecifier)left;
                ListTypeSpecifier rightArg = (ListTypeSpecifier)right;
                return this.typeSpecifiersEqual(leftArg.getElementType(), rightArg.getElementType());
            }
            return false;
        }
        if (left instanceof TupleTypeSpecifier) {
            if (right instanceof TupleTypeSpecifier) {
                TupleTypeSpecifier leftArg = (TupleTypeSpecifier)left;
                TupleTypeSpecifier rightArg = (TupleTypeSpecifier)right;
                if (leftArg.getElement() != null && rightArg.getElement() != null && leftArg.getElement().size() == rightArg.getElement().size()) {
                    for (int i = 0; i < leftArg.getElement().size(); ++i) {
                        TupleElementDefinition leftElement = leftArg.getElement().get(i);
                        TupleElementDefinition rightElement = rightArg.getElement().get(i);
                        if (this.typeSpecifiersEqual(leftElement.getType(), rightElement.getType()) && this.typeSpecifiersEqual(leftElement.getElementType(), rightElement.getElementType()) && this.stringsEqual(leftElement.getName(), rightElement.getName())) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        if (left instanceof ChoiceTypeSpecifier) {
            if (right instanceof ChoiceTypeSpecifier) {
                TypeSpecifier rightType;
                TypeSpecifier leftType;
                int i;
                ChoiceTypeSpecifier leftArg = (ChoiceTypeSpecifier)left;
                ChoiceTypeSpecifier rightArg = (ChoiceTypeSpecifier)right;
                if (leftArg.getType() != null && rightArg.getType() != null && leftArg.getType().size() == rightArg.getType().size()) {
                    for (i = 0; i < leftArg.getType().size(); ++i) {
                        leftType = leftArg.getType().get(i);
                        if (this.typeSpecifiersEqual(leftType, rightType = rightArg.getType().get(i))) continue;
                        return false;
                    }
                }
                if (leftArg.getChoice() != null && rightArg.getChoice() != null && leftArg.getChoice().size() == rightArg.getChoice().size()) {
                    for (i = 0; i < leftArg.getChoice().size(); ++i) {
                        leftType = leftArg.getChoice().get(i);
                        if (this.typeSpecifiersEqual(leftType, rightType = rightArg.getChoice().get(i))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean expressionsEqual(Expression left, Expression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof Literal) {
            if (right instanceof Literal) {
                return this.literalsEqual((Literal)left, (Literal)right);
            }
            return false;
        }
        if (left instanceof Date) {
            if (right instanceof Date) {
                Date leftDate = (Date)left;
                Date rightDate = (Date)right;
                return this.integersEqual(leftDate.getYear(), rightDate.getYear()) && this.integersEqual(leftDate.getMonth(), rightDate.getMonth()) && this.integersEqual(leftDate.getDay(), rightDate.getDay());
            }
            return false;
        }
        if (left instanceof Time) {
            if (right instanceof Time) {
                Time leftTime = (Time)left;
                Time rightTime = (Time)right;
                return this.integersEqual(leftTime.getHour(), rightTime.getHour()) && this.integersEqual(leftTime.getMinute(), rightTime.getMinute()) && this.integersEqual(leftTime.getSecond(), rightTime.getSecond()) && this.integersEqual(leftTime.getMillisecond(), rightTime.getMillisecond());
            }
            return false;
        }
        if (left instanceof DateTime) {
            if (right instanceof DateTime) {
                DateTime leftDateTime = (DateTime)left;
                DateTime rightDateTime = (DateTime)right;
                return this.integersEqual(leftDateTime.getYear(), rightDateTime.getYear()) && this.integersEqual(leftDateTime.getMonth(), rightDateTime.getMonth()) && this.integersEqual(leftDateTime.getDay(), rightDateTime.getDay()) && this.integersEqual(leftDateTime.getHour(), rightDateTime.getHour()) && this.integersEqual(leftDateTime.getMinute(), rightDateTime.getMinute()) && this.integersEqual(leftDateTime.getSecond(), rightDateTime.getSecond()) && this.integersEqual(leftDateTime.getMillisecond(), rightDateTime.getMillisecond()) && this.decimalsEqual(leftDateTime.getTimezoneOffset(), rightDateTime.getTimezoneOffset());
            }
            return false;
        }
        if (left instanceof Interval) {
            if (right instanceof Interval) {
                Interval leftInterval = (Interval)left;
                Interval rightInterval = (Interval)right;
                return this.booleansEqual(leftInterval.getLowClosedExpression(), rightInterval.getLowClosedExpression()) && this.dateTimesEqual(leftInterval.getLow(), rightInterval.getLow()) && leftInterval.isLowClosed() == rightInterval.isLowClosed() && this.booleansEqual(leftInterval.getHighClosedExpression(), rightInterval.getHighClosedExpression()) && this.dateTimesEqual(leftInterval.getHigh(), rightInterval.getHigh()) && leftInterval.isHighClosed() == rightInterval.isHighClosed();
            }
            return false;
        }
        if (left instanceof ParameterRef) {
            if (right instanceof ParameterRef) {
                ParameterRef leftParameter = (ParameterRef)left;
                ParameterRef rightParameter = (ParameterRef)right;
                return this.stringsEqual(leftParameter.getLibraryName(), rightParameter.getLibraryName()) && this.stringsEqual(leftParameter.getName(), rightParameter.getName());
            }
            return false;
        }
        if (left instanceof ValueSetRef) {
            if (right instanceof ValueSetRef) {
                return this.valueSetsEqual((ValueSetRef)left, (ValueSetRef)right);
            }
            return false;
        }
        if (left instanceof CodeSystemRef) {
            if (right instanceof CodeSystemRef) {
                return this.systemsEqual((CodeSystemRef)left, (CodeSystemRef)right);
            }
            return false;
        }
        if (left instanceof ConceptRef) {
            if (right instanceof ConceptRef) {
                ConceptRef leftConcept = (ConceptRef)left;
                ConceptRef rightConcept = (ConceptRef)right;
                return this.stringsEqual(leftConcept.getLibraryName(), rightConcept.getLibraryName()) && this.stringsEqual(leftConcept.getName(), rightConcept.getName());
            }
            return false;
        }
        if (left instanceof CodeRef) {
            if (right instanceof CodeRef) {
                CodeRef leftCode = (CodeRef)left;
                CodeRef rightCode = (CodeRef)right;
                return this.stringsEqual(leftCode.getLibraryName(), rightCode.getLibraryName()) && this.stringsEqual(leftCode.getName(), rightCode.getName());
            }
            return false;
        }
        if (left instanceof Code) {
            if (right instanceof Code) {
                Code leftCode = (Code)left;
                Code rightCode = (Code)right;
                return this.stringsEqual(leftCode.getCode(), rightCode.getCode()) && this.systemsEqual(leftCode.getSystem(), rightCode.getSystem());
            }
            return false;
        }
        if (left instanceof Concept) {
            if (right instanceof Concept) {
                Concept leftConcept = (Concept)left;
                Concept rightConcept = (Concept)right;
                if (leftConcept.getCode() != null && rightConcept.getCode() != null) {
                    for (Code lc : leftConcept.getCode()) {
                        for (Code rc : rightConcept.getCode()) {
                            if (!this.codesEqual(lc, rc)) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }
        if (left instanceof List) {
            if (right instanceof List) {
                List leftList = (List)left;
                List rightList = (List)right;
                if (leftList.getElement().size() == rightList.getElement().size()) {
                    for (int i = 0; i < leftList.getElement().size(); ++i) {
                        if (this.codesEqual(leftList.getElement().get(i), rightList.getElement().get(i))) continue;
                        return false;
                    }
                }
            }
            return false;
        }
        if (left instanceof ToList) {
            if (right instanceof ToList) {
                Expression leftSingleton = ((ToList)left).getOperand();
                Expression rightSingleton = ((ToList)right).getOperand();
                return this.codesEqual(leftSingleton, rightSingleton);
            }
            return false;
        }
        if (left instanceof Quantity) {
            if (right instanceof Quantity) {
                return this.quantitiesEqual((Quantity)left, (Quantity)right);
            }
            return false;
        }
        if (left instanceof Ratio) {
            if (right instanceof Ratio) {
                return this.quantitiesEqual(((Ratio)left).getDenominator(), ((Ratio)right).getDenominator()) && this.quantitiesEqual(((Ratio)left).getNumerator(), ((Ratio)right).getNumerator());
            }
            return false;
        }
        if (left instanceof InCodeSystem) {
            if (right instanceof InCodeSystem) {
                InCodeSystem inCodeSystemLeft = (InCodeSystem)left;
                InCodeSystem inCodeSystemRight = (InCodeSystem)right;
                return this.expressionsEqual(inCodeSystemLeft.getCode(), inCodeSystemRight.getCode()) && this.systemsEqual(inCodeSystemLeft.getCodesystem(), inCodeSystemRight.getCodesystem()) && this.expressionsEqual(inCodeSystemLeft.getCodesystemExpression(), inCodeSystemRight.getCodesystemExpression());
            }
            return false;
        }
        if (left instanceof AnyInCodeSystem) {
            if (right instanceof AnyInCodeSystem) {
                AnyInCodeSystem anyInCodeSystemLeft = (AnyInCodeSystem)left;
                AnyInCodeSystem anyInCodeSystemRight = (AnyInCodeSystem)right;
                return this.expressionsEqual(anyInCodeSystemLeft.getCodes(), anyInCodeSystemRight.getCodes()) && this.systemsEqual(anyInCodeSystemLeft.getCodesystem(), anyInCodeSystemRight.getCodesystem()) && this.expressionsEqual(anyInCodeSystemLeft.getCodesystemExpression(), anyInCodeSystemRight.getCodesystemExpression());
            }
            return false;
        }
        if (left instanceof InValueSet) {
            if (right instanceof InValueSet) {
                InValueSet inLeft = (InValueSet)left;
                InValueSet inRight = (InValueSet)right;
                return this.expressionsEqual(inLeft.getCode(), inRight.getCode()) && this.valueSetsEqual(inLeft.getValueset(), inRight.getValueset()) && this.expressionsEqual(inLeft.getValuesetExpression(), inRight.getValuesetExpression());
            }
            return false;
        }
        if (left instanceof AnyInValueSet) {
            if (right instanceof AnyInValueSet) {
                AnyInValueSet inLeft = (AnyInValueSet)left;
                AnyInValueSet inRight = (AnyInValueSet)right;
                return this.expressionsEqual(inLeft.getCodes(), inRight.getCodes()) && this.valueSetsEqual(inLeft.getValueset(), inRight.getValueset()) && this.expressionsEqual(inLeft.getValuesetExpression(), inRight.getValuesetExpression());
            }
            return false;
        }
        if (left instanceof CalculateAge) {
            if (right instanceof CalculateAge) {
                CalculateAge leftArg = (CalculateAge)left;
                CalculateAge rightArg = (CalculateAge)right;
                return this.expressionsEqual(leftArg.getOperand(), rightArg.getOperand()) && leftArg.getPrecision().equals((Object)rightArg.getPrecision());
            }
            return false;
        }
        if (left instanceof Subsumes) {
            if (right instanceof Subsumes) {
                Subsumes leftArg = (Subsumes)left;
                Subsumes rightArg = (Subsumes)right;
                return this.operandsEqual(leftArg, rightArg);
            }
            return false;
        }
        if (left instanceof SubsumedBy) {
            if (right instanceof SubsumedBy) {
                SubsumedBy leftArg = (SubsumedBy)left;
                SubsumedBy rightArg = (SubsumedBy)right;
                return this.operandsEqual(leftArg, rightArg);
            }
            return false;
        }
        if (left instanceof AggregateExpression) {
            if (right instanceof AggregateExpression) {
                AggregateExpression leftArg = (AggregateExpression)left;
                AggregateExpression rightArg = (AggregateExpression)right;
                return this.aggregateExpressionsEqual(leftArg, rightArg);
            }
            return false;
        }
        if (left instanceof OperatorExpression) {
            if (right instanceof OperatorExpression) {
                OperatorExpression leftArg = (OperatorExpression)left;
                OperatorExpression rightArg = (OperatorExpression)right;
                return this.operatorExpressionsEqual(leftArg, rightArg);
            }
            return false;
        }
        if (!left.getClass().getCanonicalName().equals(right.getClass().getCanonicalName())) {
            return false;
        }
        if (left instanceof AliasRef) {
            if (right instanceof AliasRef) {
                AliasRef leftArg = (AliasRef)left;
                AliasRef rightArg = (AliasRef)right;
                return this.stringsEqual(leftArg.getName(), rightArg.getName());
            }
            return false;
        }
        if (left instanceof Case) {
            if (right instanceof Case) {
                Case leftArg = (Case)left;
                Case rightArg = (Case)right;
                if (!this.expressionsEqual(leftArg.getComparand(), rightArg.getComparand())) {
                    return false;
                }
                if (!this.expressionsEqual(leftArg.getElse(), rightArg.getElse())) {
                    return false;
                }
                if (leftArg.getCaseItem() != null && rightArg.getCaseItem() != null && leftArg.getCaseItem().size() == rightArg.getCaseItem().size()) {
                    for (int i = 0; i < leftArg.getCaseItem().size(); ++i) {
                        CaseItem leftCaseItem = leftArg.getCaseItem().get(i);
                        CaseItem rightCaseItem = rightArg.getCaseItem().get(i);
                        if (this.expressionsEqual(leftCaseItem.getWhen(), rightCaseItem.getWhen()) && this.expressionsEqual(leftCaseItem.getThen(), rightCaseItem.getThen())) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        if (left instanceof Current) {
            if (right instanceof Current) {
                Current leftArg = (Current)left;
                Current rightArg = (Current)right;
                return this.stringsEqual(leftArg.getScope(), rightArg.getScope());
            }
            return false;
        }
        if (left instanceof FunctionRef && right instanceof FunctionRef) {
            FunctionRef leftArg = (FunctionRef)left;
            FunctionRef rightArg = (FunctionRef)right;
            return this.stringsEqual(leftArg.getLibraryName(), rightArg.getLibraryName()) && this.stringsEqual(leftArg.getName(), rightArg.getName()) && this.operandsEqual(leftArg, rightArg);
        }
        if (left instanceof ExpressionRef) {
            if (right instanceof ExpressionRef) {
                ExpressionRef leftArg = (ExpressionRef)left;
                ExpressionRef rightArg = (ExpressionRef)right;
                return this.stringsEqual(leftArg.getLibraryName(), rightArg.getLibraryName()) && this.stringsEqual(leftArg.getName(), rightArg.getName());
            }
            return false;
        }
        if (left instanceof Filter) {
            if (right instanceof Filter) {
                Filter leftArg = (Filter)left;
                Filter rightArg = (Filter)right;
                return this.expressionsEqual(leftArg.getSource(), rightArg.getSource()) && this.expressionsEqual(leftArg.getCondition(), rightArg.getCondition()) && this.stringsEqual(leftArg.getScope(), rightArg.getScope());
            }
            return false;
        }
        if (left instanceof ForEach) {
            if (right instanceof ForEach) {
                ForEach leftArg = (ForEach)left;
                ForEach rightArg = (ForEach)right;
                return this.expressionsEqual(leftArg.getSource(), rightArg.getSource()) && this.expressionsEqual(leftArg.getElement(), rightArg.getElement()) && this.stringsEqual(leftArg.getScope(), rightArg.getScope());
            }
            return false;
        }
        if (left instanceof IdentifierRef) {
            if (right instanceof IdentifierRef) {
                IdentifierRef leftArg = (IdentifierRef)left;
                IdentifierRef rightArg = (IdentifierRef)right;
                return this.stringsEqual(leftArg.getLibraryName(), rightArg.getLibraryName()) && this.stringsEqual(leftArg.getName(), rightArg.getName());
            }
            return false;
        }
        if (left instanceof If) {
            if (right instanceof If) {
                If leftArg = (If)left;
                If rightArg = (If)right;
                return this.expressionsEqual(leftArg.getCondition(), rightArg.getCondition()) && this.expressionsEqual(leftArg.getThen(), rightArg.getThen()) && this.expressionsEqual(leftArg.getElse(), rightArg.getElse());
            }
            return false;
        }
        if (left instanceof Instance) {
            if (right instanceof Instance) {
                Instance leftArg = (Instance)left;
                Instance rightArg = (Instance)right;
                if (!this.qnamesEqual(leftArg.getClassType(), rightArg.getClassType())) {
                    return false;
                }
                if (leftArg.getElement() != null && rightArg.getElement() != null && leftArg.getElement().size() == rightArg.getElement().size()) {
                    for (int i = 0; i < leftArg.getElement().size(); ++i) {
                        InstanceElement leftElement = leftArg.getElement().get(i);
                        InstanceElement rightElement = rightArg.getElement().get(i);
                        if (this.stringsEqual(leftElement.getName(), rightElement.getName()) && this.expressionsEqual(leftElement.getValue(), rightElement.getValue())) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        if (left instanceof Iteration) {
            if (right instanceof Iteration) {
                Iteration leftArg = (Iteration)left;
                Iteration rightArg = (Iteration)right;
                return this.stringsEqual(leftArg.getScope(), rightArg.getScope());
            }
            return false;
        }
        if (left instanceof MaxValue) {
            if (right instanceof MaxValue) {
                MaxValue leftArg = (MaxValue)left;
                MaxValue rightArg = (MaxValue)right;
                return this.qnamesEqual(leftArg.getValueType(), rightArg.getValueType());
            }
            return false;
        }
        if (left instanceof MinValue) {
            if (right instanceof MinValue) {
                MinValue leftArg = (MinValue)left;
                MinValue rightArg = (MinValue)right;
                return this.qnamesEqual(leftArg.getValueType(), rightArg.getValueType());
            }
            return false;
        }
        if (left instanceof Null) {
            return right instanceof Null;
        }
        if (left instanceof OperandRef) {
            if (right instanceof OperandRef) {
                OperandRef leftArg = (OperandRef)left;
                OperandRef rightArg = (OperandRef)right;
                return this.stringsEqual(leftArg.getName(), rightArg.getName());
            }
            return false;
        }
        if (left instanceof Property) {
            if (right instanceof Property) {
                Property leftArg = (Property)left;
                Property rightArg = (Property)right;
                return this.stringsEqual(leftArg.getScope(), rightArg.getScope()) && this.stringsEqual(leftArg.getPath(), rightArg.getPath());
            }
            return false;
        }
        if (left instanceof Query) {
            if (right instanceof Query) {
                Query leftArg = (Query)left;
                Query rightArg = (Query)right;
            }
            return false;
        }
        if (left instanceof QueryLetRef) {
            if (right instanceof QueryLetRef) {
                QueryLetRef leftArg = (QueryLetRef)left;
                QueryLetRef rightArg = (QueryLetRef)right;
                return this.stringsEqual(leftArg.getName(), rightArg.getName());
            }
            return false;
        }
        if (left instanceof Repeat) {
            if (right instanceof Repeat) {
                Repeat leftArg = (Repeat)left;
                Repeat repeat = (Repeat)right;
            }
            return false;
        }
        if (left instanceof Sort) {
            if (right instanceof Sort) {
                Sort leftArg = (Sort)left;
                Sort sort = (Sort)right;
            }
            return false;
        }
        if (left instanceof Total) {
            if (right instanceof Total) {
                Total leftArg = (Total)left;
                Total total = (Total)right;
            }
            return false;
        }
        if (left instanceof Tuple) {
            if (right instanceof Tuple) {
                Tuple leftArg = (Tuple)left;
                Tuple tuple = (Tuple)right;
            }
            return false;
        }
        return false;
    }

    public boolean operandsEqual(FunctionRef left, FunctionRef right) {
        if (left.getOperand() != null && left.getOperand() != null && left.getOperand().size() == left.getOperand().size()) {
            for (int i = 0; i < left.getOperand().size(); ++i) {
                if (this.expressionsEqual(left.getOperand().get(i), right.getOperand().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean operandsEqual(BinaryExpression left, BinaryExpression right) {
        if (left.getOperand() != null && left.getOperand() != null && left.getOperand().size() == left.getOperand().size()) {
            for (int i = 0; i < left.getOperand().size(); ++i) {
                if (this.expressionsEqual(left.getOperand().get(i), right.getOperand().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean operandsEqual(TernaryExpression left, TernaryExpression right) {
        if (left.getOperand() != null && left.getOperand() != null && left.getOperand().size() == left.getOperand().size()) {
            for (int i = 0; i < left.getOperand().size(); ++i) {
                if (this.expressionsEqual(left.getOperand().get(i), right.getOperand().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean operandsEqual(NaryExpression left, NaryExpression right) {
        if (left.getOperand() != null && left.getOperand() != null && left.getOperand().size() == left.getOperand().size()) {
            for (int i = 0; i < left.getOperand().size(); ++i) {
                if (this.expressionsEqual(left.getOperand().get(i), right.getOperand().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean operatorExpressionsEqual(OperatorExpression left, OperatorExpression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof UnaryExpression) {
            if (right instanceof UnaryExpression) {
                UnaryExpression leftArg = (UnaryExpression)left;
                UnaryExpression rightArg = (UnaryExpression)right;
                return this.unaryExpressionsEqual(leftArg, rightArg);
            }
            return false;
        }
        if (left instanceof BinaryExpression) {
            if (right instanceof BinaryExpression) {
                BinaryExpression leftArg = (BinaryExpression)left;
                BinaryExpression rightArg = (BinaryExpression)right;
                return this.binaryExpressionsEqual(leftArg, rightArg);
            }
            return false;
        }
        if (left instanceof TernaryExpression) {
            if (right instanceof TernaryExpression) {
                TernaryExpression leftArg = (TernaryExpression)left;
                TernaryExpression rightArg = (TernaryExpression)right;
                return this.ternaryExpressionsEqual(leftArg, rightArg);
            }
            return false;
        }
        if (left instanceof NaryExpression) {
            if (right instanceof NaryExpression) {
                NaryExpression leftArg = (NaryExpression)left;
                NaryExpression rightArg = (NaryExpression)right;
                return this.naryExpressionsEqual(leftArg, rightArg);
            }
            return false;
        }
        if (!left.getClass().getCanonicalName().equals(right.getClass().getCanonicalName())) {
            return false;
        }
        if (left instanceof Round) {
            if (right instanceof Round) {
                Round leftArg = (Round)left;
                Round rightArg = (Round)right;
                return this.expressionsEqual(leftArg.getOperand(), rightArg.getOperand()) && this.expressionsEqual(leftArg.getPrecision(), rightArg.getPrecision());
            }
            return false;
        }
        if (left instanceof Combine) {
            if (right instanceof Combine) {
                Combine leftArg = (Combine)left;
                Combine rightArg = (Combine)right;
                return this.expressionsEqual(leftArg.getSource(), rightArg.getSource()) && this.expressionsEqual(leftArg.getSeparator(), rightArg.getSeparator());
            }
            return false;
        }
        if (left instanceof Split) {
            if (right instanceof Split) {
                Split leftArg = (Split)left;
                Split rightArg = (Split)right;
                return this.expressionsEqual(leftArg.getStringToSplit(), rightArg.getStringToSplit()) && this.expressionsEqual(leftArg.getSeparator(), rightArg.getSeparator());
            }
            return false;
        }
        if (left instanceof SplitOnMatches) {
            if (right instanceof SplitOnMatches) {
                SplitOnMatches leftArg = (SplitOnMatches)left;
                SplitOnMatches rightArg = (SplitOnMatches)right;
                return this.expressionsEqual(leftArg.getStringToSplit(), rightArg.getStringToSplit()) && this.expressionsEqual(leftArg.getSeparatorPattern(), rightArg.getSeparatorPattern());
            }
            return false;
        }
        if (left instanceof PositionOf) {
            if (right instanceof PositionOf) {
                PositionOf leftArg = (PositionOf)left;
                PositionOf rightArg = (PositionOf)right;
                return this.expressionsEqual(leftArg.getString(), rightArg.getString()) && this.expressionsEqual(leftArg.getPattern(), rightArg.getPattern());
            }
            return false;
        }
        if (left instanceof LastPositionOf) {
            if (right instanceof LastPositionOf) {
                LastPositionOf leftArg = (LastPositionOf)left;
                LastPositionOf rightArg = (LastPositionOf)right;
                return this.expressionsEqual(leftArg.getString(), rightArg.getString()) && this.expressionsEqual(leftArg.getPattern(), rightArg.getPattern());
            }
            return false;
        }
        if (left instanceof Substring) {
            if (right instanceof Substring) {
                Substring leftArg = (Substring)left;
                Substring rightArg = (Substring)right;
                return this.expressionsEqual(leftArg.getStringToSub(), rightArg.getStringToSub()) && this.expressionsEqual(leftArg.getStartIndex(), rightArg.getStartIndex()) && this.expressionsEqual(leftArg.getLength(), rightArg.getLength());
            }
            return false;
        }
        if (left instanceof Time) {
            if (right instanceof Time) {
                Time leftArg = (Time)left;
                Time rightArg = (Time)right;
                return this.expressionsEqual(leftArg.getHour(), rightArg.getHour()) && this.expressionsEqual(leftArg.getMinute(), rightArg.getMinute()) && this.expressionsEqual(leftArg.getSecond(), rightArg.getSecond()) && this.expressionsEqual(leftArg.getMillisecond(), rightArg.getMillisecond());
            }
            return false;
        }
        if (left instanceof Date) {
            if (right instanceof Date) {
                Date leftArg = (Date)left;
                Date rightArg = (Date)right;
                return this.expressionsEqual(leftArg.getYear(), rightArg.getYear()) && this.expressionsEqual(leftArg.getMonth(), rightArg.getMonth()) && this.expressionsEqual(leftArg.getDay(), rightArg.getDay());
            }
            return false;
        }
        if (left instanceof DateTime) {
            if (right instanceof DateTime) {
                DateTime leftArg = (DateTime)left;
                DateTime rightArg = (DateTime)right;
                return this.expressionsEqual(leftArg.getYear(), rightArg.getYear()) && this.expressionsEqual(leftArg.getMonth(), rightArg.getMonth()) && this.expressionsEqual(leftArg.getDay(), rightArg.getDay()) && this.expressionsEqual(leftArg.getHour(), rightArg.getHour()) && this.expressionsEqual(leftArg.getMinute(), rightArg.getMinute()) && this.expressionsEqual(leftArg.getSecond(), rightArg.getSecond()) && this.expressionsEqual(leftArg.getMillisecond(), rightArg.getMillisecond()) && this.expressionsEqual(leftArg.getTimezoneOffset(), rightArg.getTimezoneOffset());
            }
            return false;
        }
        if (left instanceof First) {
            if (right instanceof First) {
                First leftArg = (First)left;
                First rightArg = (First)right;
                return this.expressionsEqual(leftArg.getSource(), rightArg.getSource()) && this.stringsEqual(leftArg.getOrderBy(), rightArg.getOrderBy());
            }
            return false;
        }
        if (left instanceof Last) {
            if (right instanceof Last) {
                Last leftArg = (Last)left;
                Last rightArg = (Last)right;
                return this.expressionsEqual(leftArg.getSource(), rightArg.getSource()) && this.stringsEqual(leftArg.getOrderBy(), rightArg.getOrderBy());
            }
            return false;
        }
        if (left instanceof IndexOf) {
            if (right instanceof IndexOf) {
                IndexOf leftArg = (IndexOf)left;
                IndexOf rightArg = (IndexOf)right;
                return this.expressionsEqual(leftArg.getSource(), rightArg.getSource()) && this.expressionsEqual(leftArg.getElement(), rightArg.getElement());
            }
            return false;
        }
        if (left instanceof Slice) {
            if (right instanceof Slice) {
                Slice leftArg = (Slice)left;
                Slice rightArg = (Slice)right;
                return this.expressionsEqual(leftArg.getSource(), rightArg.getSource()) && this.expressionsEqual(leftArg.getStartIndex(), rightArg.getStartIndex()) && this.expressionsEqual(leftArg.getEndIndex(), rightArg.getEndIndex());
            }
            return false;
        }
        if (left instanceof Children) {
            if (right instanceof Children) {
                Children leftArg = (Children)left;
                Children rightArg = (Children)right;
                return this.expressionsEqual(leftArg.getSource(), rightArg.getSource());
            }
            return false;
        }
        if (left instanceof Descendents) {
            if (right instanceof Descendents) {
                Descendents leftArg = (Descendents)left;
                Descendents rightArg = (Descendents)right;
                return this.expressionsEqual(leftArg.getSource(), rightArg.getSource());
            }
            return false;
        }
        if (left instanceof Message) {
            if (right instanceof Message) {
                Message leftArg = (Message)left;
                Message rightArg = (Message)right;
                return this.expressionsEqual(leftArg.getSource(), rightArg.getSource()) && this.expressionsEqual(leftArg.getCode(), rightArg.getCode()) && this.expressionsEqual(leftArg.getCondition(), rightArg.getCondition()) && this.expressionsEqual(leftArg.getMessage(), rightArg.getMessage()) && this.expressionsEqual(leftArg.getSeverity(), rightArg.getSeverity());
            }
            return false;
        }
        return true;
    }

    public boolean operandsEqual(UnaryExpression left, UnaryExpression right) {
        return this.expressionsEqual(left.getOperand(), right.getOperand());
    }

    public boolean unaryExpressionsEqual(UnaryExpression left, UnaryExpression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (!left.getClass().getCanonicalName().equals(right.getClass().getCanonicalName())) {
            return false;
        }
        if (!this.operandsEqual(left, right)) {
            return false;
        }
        if (left instanceof As && right instanceof As) {
            As leftArg = (As)left;
            As rightArg = (As)right;
            return this.qnamesEqual(leftArg.getAsType(), rightArg.getAsType()) && this.typeSpecifiersEqual(leftArg.getAsTypeSpecifier(), rightArg.getAsTypeSpecifier()) && leftArg.isStrict() == rightArg.isStrict();
        }
        if (left instanceof CanConvert) {
            if (right instanceof CanConvert) {
                CanConvert leftArg = (CanConvert)left;
                CanConvert rightArg = (CanConvert)right;
                return this.qnamesEqual(leftArg.getToType(), rightArg.getToType()) && this.typeSpecifiersEqual(leftArg.getToTypeSpecifier(), rightArg.getToTypeSpecifier());
            }
            return false;
        }
        if (left instanceof Convert) {
            if (right instanceof Convert) {
                Convert leftArg = (Convert)left;
                Convert rightArg = (Convert)right;
                return this.qnamesEqual(leftArg.getToType(), rightArg.getToType()) && this.typeSpecifiersEqual(leftArg.getToTypeSpecifier(), rightArg.getToTypeSpecifier());
            }
            return false;
        }
        if (left instanceof DateTimeComponentFrom) {
            if (right instanceof DateTimeComponentFrom) {
                DateTimeComponentFrom leftArg = (DateTimeComponentFrom)left;
                DateTimeComponentFrom rightArg = (DateTimeComponentFrom)right;
                return leftArg.getPrecision() == rightArg.getPrecision();
            }
            return false;
        }
        if (left instanceof Is) {
            if (right instanceof Is) {
                Is leftArg = (Is)left;
                Is rightArg = (Is)right;
                return this.qnamesEqual(leftArg.getIsType(), rightArg.getIsType()) && this.typeSpecifiersEqual(leftArg.getIsTypeSpecifier(), rightArg.getIsTypeSpecifier());
            }
            return false;
        }
        return true;
    }

    public boolean binaryExpressionsEqual(BinaryExpression left, BinaryExpression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (!left.getClass().getCanonicalName().equals(right.getClass().getCanonicalName())) {
            return false;
        }
        return this.operandsEqual(left, right);
    }

    public boolean ternaryExpressionsEqual(TernaryExpression left, TernaryExpression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (!left.getClass().getCanonicalName().equals(right.getClass().getCanonicalName())) {
            return false;
        }
        return this.operandsEqual(left, right);
    }

    public boolean naryExpressionsEqual(NaryExpression left, NaryExpression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (!left.getClass().getCanonicalName().equals(right.getClass().getCanonicalName())) {
            return false;
        }
        if (!this.operandsEqual(left, right)) {
            return false;
        }
        return false;
    }

    public boolean aggregateExpressionsEqual(AggregateExpression left, AggregateExpression right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (!left.getClass().getCanonicalName().equals(right.getClass().getCanonicalName())) {
            return false;
        }
        if (!this.expressionsEqual(left.getSource(), right.getSource()) || !this.stringsEqual(left.getPath(), right.getPath())) {
            return false;
        }
        if (left instanceof Aggregate && right instanceof Aggregate) {
            Aggregate leftArg = (Aggregate)left;
            Aggregate rightArg = (Aggregate)right;
            return this.expressionsEqual(leftArg.getInitialValue(), rightArg.getInitialValue()) && this.expressionsEqual(leftArg.getIteration(), rightArg.getIteration());
        }
        return true;
    }
}

