/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.visiting;

import java.util.Objects;
import java.util.function.BiFunction;
import org.cqframework.cql.elm.tracking.Trackable;
import org.cqframework.cql.elm.visiting.BaseElmLibraryVisitor;

public class FunctionalElmVisitor<T, C>
extends BaseElmLibraryVisitor<T, C> {
    private final BiFunction<Trackable, C, T> defaultResult;
    private final BiFunction<T, T, T> aggregateResult;

    public FunctionalElmVisitor(BiFunction<Trackable, C, T> defaultResult, BiFunction<T, T, T> aggregateResult) {
        this.defaultResult = Objects.requireNonNull(defaultResult);
        this.aggregateResult = Objects.requireNonNull(aggregateResult);
    }

    @Override
    public T defaultResult(Trackable elm, C context) {
        return this.defaultResult.apply(elm, context);
    }

    @Override
    public T aggregateResult(T aggregate, T nextResult) {
        return this.aggregateResult.apply(aggregate, nextResult);
    }

    public static <C, T> FunctionalElmVisitor<T, C> from(BiFunction<Trackable, C, T> defaultResult, BiFunction<T, T, T> aggregateResult) {
        return new FunctionalElmVisitor<T, C>(defaultResult, aggregateResult);
    }
}

