/*
 * Decompiled with CFR 0.152.
 */
package org.cqframework.cql.elm.visiting;

import java.util.Iterator;
import org.cqframework.cql.elm.tracking.Trackable;
import org.cqframework.cql.elm.visiting.ElmVisitor;
import org.hl7.elm.r1.Abs;
import org.hl7.elm.r1.AccessModifier;
import org.hl7.elm.r1.Add;
import org.hl7.elm.r1.After;
import org.hl7.elm.r1.Aggregate;
import org.hl7.elm.r1.AggregateClause;
import org.hl7.elm.r1.AggregateExpression;
import org.hl7.elm.r1.AliasRef;
import org.hl7.elm.r1.AliasedQuerySource;
import org.hl7.elm.r1.AllTrue;
import org.hl7.elm.r1.And;
import org.hl7.elm.r1.AnyTrue;
import org.hl7.elm.r1.As;
import org.hl7.elm.r1.Avg;
import org.hl7.elm.r1.Before;
import org.hl7.elm.r1.BinaryExpression;
import org.hl7.elm.r1.ByColumn;
import org.hl7.elm.r1.ByDirection;
import org.hl7.elm.r1.ByExpression;
import org.hl7.elm.r1.CanConvert;
import org.hl7.elm.r1.CanConvertQuantity;
import org.hl7.elm.r1.Case;
import org.hl7.elm.r1.CaseItem;
import org.hl7.elm.r1.Ceiling;
import org.hl7.elm.r1.Children;
import org.hl7.elm.r1.ChoiceTypeSpecifier;
import org.hl7.elm.r1.Coalesce;
import org.hl7.elm.r1.Collapse;
import org.hl7.elm.r1.Combine;
import org.hl7.elm.r1.Concatenate;
import org.hl7.elm.r1.Contains;
import org.hl7.elm.r1.Convert;
import org.hl7.elm.r1.ConvertQuantity;
import org.hl7.elm.r1.ConvertsToBoolean;
import org.hl7.elm.r1.ConvertsToDate;
import org.hl7.elm.r1.ConvertsToDateTime;
import org.hl7.elm.r1.ConvertsToDecimal;
import org.hl7.elm.r1.ConvertsToInteger;
import org.hl7.elm.r1.ConvertsToLong;
import org.hl7.elm.r1.ConvertsToQuantity;
import org.hl7.elm.r1.ConvertsToRatio;
import org.hl7.elm.r1.ConvertsToString;
import org.hl7.elm.r1.ConvertsToTime;
import org.hl7.elm.r1.Count;
import org.hl7.elm.r1.Current;
import org.hl7.elm.r1.Date;
import org.hl7.elm.r1.DateFrom;
import org.hl7.elm.r1.DateTime;
import org.hl7.elm.r1.DateTimeComponentFrom;
import org.hl7.elm.r1.Descendents;
import org.hl7.elm.r1.DifferenceBetween;
import org.hl7.elm.r1.Distinct;
import org.hl7.elm.r1.Divide;
import org.hl7.elm.r1.DurationBetween;
import org.hl7.elm.r1.Element;
import org.hl7.elm.r1.End;
import org.hl7.elm.r1.Ends;
import org.hl7.elm.r1.EndsWith;
import org.hl7.elm.r1.Equal;
import org.hl7.elm.r1.Equivalent;
import org.hl7.elm.r1.Except;
import org.hl7.elm.r1.Exists;
import org.hl7.elm.r1.Exp;
import org.hl7.elm.r1.Expand;
import org.hl7.elm.r1.Expression;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.ExpressionRef;
import org.hl7.elm.r1.Filter;
import org.hl7.elm.r1.First;
import org.hl7.elm.r1.Flatten;
import org.hl7.elm.r1.Floor;
import org.hl7.elm.r1.ForEach;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.FunctionRef;
import org.hl7.elm.r1.GeometricMean;
import org.hl7.elm.r1.Greater;
import org.hl7.elm.r1.GreaterOrEqual;
import org.hl7.elm.r1.HighBoundary;
import org.hl7.elm.r1.IdentifierRef;
import org.hl7.elm.r1.If;
import org.hl7.elm.r1.Implies;
import org.hl7.elm.r1.In;
import org.hl7.elm.r1.IncludedIn;
import org.hl7.elm.r1.Includes;
import org.hl7.elm.r1.IndexOf;
import org.hl7.elm.r1.Indexer;
import org.hl7.elm.r1.Instance;
import org.hl7.elm.r1.InstanceElement;
import org.hl7.elm.r1.Intersect;
import org.hl7.elm.r1.Interval;
import org.hl7.elm.r1.IntervalTypeSpecifier;
import org.hl7.elm.r1.Is;
import org.hl7.elm.r1.IsFalse;
import org.hl7.elm.r1.IsNull;
import org.hl7.elm.r1.IsTrue;
import org.hl7.elm.r1.Iteration;
import org.hl7.elm.r1.Last;
import org.hl7.elm.r1.LastPositionOf;
import org.hl7.elm.r1.Length;
import org.hl7.elm.r1.Less;
import org.hl7.elm.r1.LessOrEqual;
import org.hl7.elm.r1.LetClause;
import org.hl7.elm.r1.List;
import org.hl7.elm.r1.ListTypeSpecifier;
import org.hl7.elm.r1.Literal;
import org.hl7.elm.r1.Ln;
import org.hl7.elm.r1.Log;
import org.hl7.elm.r1.LowBoundary;
import org.hl7.elm.r1.Lower;
import org.hl7.elm.r1.Matches;
import org.hl7.elm.r1.Max;
import org.hl7.elm.r1.MaxValue;
import org.hl7.elm.r1.Median;
import org.hl7.elm.r1.Meets;
import org.hl7.elm.r1.MeetsAfter;
import org.hl7.elm.r1.MeetsBefore;
import org.hl7.elm.r1.Message;
import org.hl7.elm.r1.Min;
import org.hl7.elm.r1.MinValue;
import org.hl7.elm.r1.Mode;
import org.hl7.elm.r1.Modulo;
import org.hl7.elm.r1.Multiply;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.hl7.elm.r1.NaryExpression;
import org.hl7.elm.r1.Negate;
import org.hl7.elm.r1.Not;
import org.hl7.elm.r1.NotEqual;
import org.hl7.elm.r1.Now;
import org.hl7.elm.r1.Null;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.OperandRef;
import org.hl7.elm.r1.OperatorExpression;
import org.hl7.elm.r1.Or;
import org.hl7.elm.r1.Overlaps;
import org.hl7.elm.r1.OverlapsAfter;
import org.hl7.elm.r1.OverlapsBefore;
import org.hl7.elm.r1.ParameterDef;
import org.hl7.elm.r1.ParameterRef;
import org.hl7.elm.r1.ParameterTypeSpecifier;
import org.hl7.elm.r1.PointFrom;
import org.hl7.elm.r1.PopulationStdDev;
import org.hl7.elm.r1.PopulationVariance;
import org.hl7.elm.r1.PositionOf;
import org.hl7.elm.r1.Power;
import org.hl7.elm.r1.Precision;
import org.hl7.elm.r1.Predecessor;
import org.hl7.elm.r1.Product;
import org.hl7.elm.r1.ProperContains;
import org.hl7.elm.r1.ProperIn;
import org.hl7.elm.r1.ProperIncludedIn;
import org.hl7.elm.r1.ProperIncludes;
import org.hl7.elm.r1.Property;
import org.hl7.elm.r1.Query;
import org.hl7.elm.r1.QueryLetRef;
import org.hl7.elm.r1.RelationshipClause;
import org.hl7.elm.r1.Repeat;
import org.hl7.elm.r1.ReplaceMatches;
import org.hl7.elm.r1.ReturnClause;
import org.hl7.elm.r1.Round;
import org.hl7.elm.r1.SameAs;
import org.hl7.elm.r1.SameOrAfter;
import org.hl7.elm.r1.SameOrBefore;
import org.hl7.elm.r1.SingletonFrom;
import org.hl7.elm.r1.Size;
import org.hl7.elm.r1.Slice;
import org.hl7.elm.r1.Sort;
import org.hl7.elm.r1.SortByItem;
import org.hl7.elm.r1.SortClause;
import org.hl7.elm.r1.Split;
import org.hl7.elm.r1.SplitOnMatches;
import org.hl7.elm.r1.Start;
import org.hl7.elm.r1.Starts;
import org.hl7.elm.r1.StartsWith;
import org.hl7.elm.r1.StdDev;
import org.hl7.elm.r1.Substring;
import org.hl7.elm.r1.Subtract;
import org.hl7.elm.r1.Successor;
import org.hl7.elm.r1.Sum;
import org.hl7.elm.r1.TernaryExpression;
import org.hl7.elm.r1.Time;
import org.hl7.elm.r1.TimeFrom;
import org.hl7.elm.r1.TimeOfDay;
import org.hl7.elm.r1.Times;
import org.hl7.elm.r1.TimezoneFrom;
import org.hl7.elm.r1.TimezoneOffsetFrom;
import org.hl7.elm.r1.ToBoolean;
import org.hl7.elm.r1.ToChars;
import org.hl7.elm.r1.ToConcept;
import org.hl7.elm.r1.ToDate;
import org.hl7.elm.r1.ToDateTime;
import org.hl7.elm.r1.ToDecimal;
import org.hl7.elm.r1.ToInteger;
import org.hl7.elm.r1.ToList;
import org.hl7.elm.r1.ToLong;
import org.hl7.elm.r1.ToQuantity;
import org.hl7.elm.r1.ToRatio;
import org.hl7.elm.r1.ToString;
import org.hl7.elm.r1.ToTime;
import org.hl7.elm.r1.Today;
import org.hl7.elm.r1.Total;
import org.hl7.elm.r1.Truncate;
import org.hl7.elm.r1.TruncatedDivide;
import org.hl7.elm.r1.Tuple;
import org.hl7.elm.r1.TupleElement;
import org.hl7.elm.r1.TupleElementDefinition;
import org.hl7.elm.r1.TupleTypeSpecifier;
import org.hl7.elm.r1.TypeSpecifier;
import org.hl7.elm.r1.UnaryExpression;
import org.hl7.elm.r1.Union;
import org.hl7.elm.r1.Upper;
import org.hl7.elm.r1.Variance;
import org.hl7.elm.r1.Width;
import org.hl7.elm.r1.With;
import org.hl7.elm.r1.Without;
import org.hl7.elm.r1.Xor;

public abstract class BaseElmVisitor<T, C>
implements ElmVisitor<T, C> {
    protected T defaultResult(Trackable elm, C context) {
        return null;
    }

    protected T aggregateResult(T aggregate, T nextResult) {
        return nextResult;
    }

    @Override
    public T visitElement(Element elm, C context) {
        if (elm instanceof Expression) {
            return this.visitExpression((Expression)elm, context);
        }
        if (elm instanceof CaseItem) {
            return this.visitCaseItem((CaseItem)elm, context);
        }
        if (elm instanceof LetClause) {
            return this.visitLetClause((LetClause)elm, context);
        }
        if (elm instanceof OperandDef) {
            return this.visitOperandDef((OperandDef)elm, context);
        }
        if (elm instanceof ParameterDef) {
            return this.visitParameterDef((ParameterDef)elm, context);
        }
        if (elm instanceof SortByItem) {
            return this.visitSortByItem((SortByItem)elm, context);
        }
        if (elm instanceof SortClause) {
            return this.visitSortClause((SortClause)elm, context);
        }
        if (elm instanceof TupleElementDefinition) {
            return this.visitTupleElementDefinition((TupleElementDefinition)elm, context);
        }
        if (elm instanceof TypeSpecifier) {
            return this.visitTypeSpecifier((TypeSpecifier)elm, context);
        }
        throw new IllegalArgumentException("Unknown Element type: " + elm.getClass().getName());
    }

    @Override
    public T visitTypeSpecifier(TypeSpecifier elm, C context) {
        if (elm instanceof NamedTypeSpecifier) {
            return this.visitNamedTypeSpecifier((NamedTypeSpecifier)elm, context);
        }
        if (elm instanceof IntervalTypeSpecifier) {
            return this.visitIntervalTypeSpecifier((IntervalTypeSpecifier)elm, context);
        }
        if (elm instanceof ListTypeSpecifier) {
            return this.visitListTypeSpecifier((ListTypeSpecifier)elm, context);
        }
        if (elm instanceof TupleTypeSpecifier) {
            return this.visitTupleTypeSpecifier((TupleTypeSpecifier)elm, context);
        }
        if (elm instanceof ChoiceTypeSpecifier) {
            return this.visitChoiceTypeSpecifier((ChoiceTypeSpecifier)elm, context);
        }
        if (elm instanceof ParameterTypeSpecifier) {
            return this.visitParameterTypeSpecifier((ParameterTypeSpecifier)elm, context);
        }
        throw new IllegalArgumentException("Unknown TypeSpecifier type: " + elm.getClass().getName());
    }

    public T visitParameterTypeSpecifier(ParameterTypeSpecifier elm, C context) {
        return this.defaultResult(elm, context);
    }

    @Override
    public T visitNamedTypeSpecifier(NamedTypeSpecifier elm, C context) {
        return this.defaultResult(elm, context);
    }

    @Override
    public T visitIntervalTypeSpecifier(IntervalTypeSpecifier elm, C context) {
        T result = this.defaultResult(elm, context);
        if (elm.getPointType() != null) {
            T childResult = this.visitTypeSpecifier(elm.getPointType(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitListTypeSpecifier(ListTypeSpecifier elm, C context) {
        T result = this.defaultResult(elm, context);
        if (elm.getElementType() != null) {
            T childResult = this.visitTypeSpecifier(elm.getElementType(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitTupleElementDefinition(TupleElementDefinition elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getElementType() != null) {
            childResult = this.visitTypeSpecifier(elm.getElementType(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getType() != null) {
            childResult = this.visitTypeSpecifier(elm.getType(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitTupleTypeSpecifier(TupleTypeSpecifier elm, C context) {
        T result = this.defaultResult(elm, context);
        for (TupleElementDefinition element : elm.getElement()) {
            T childResult = this.visitTupleElementDefinition(element, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitChoiceTypeSpecifier(ChoiceTypeSpecifier elm, C context) {
        T childResult;
        T result = this.defaultResult(elm, context);
        for (TypeSpecifier choice : elm.getChoice()) {
            childResult = this.visitTypeSpecifier(choice, context);
            result = this.aggregateResult(result, childResult);
        }
        for (TypeSpecifier type : elm.getType()) {
            childResult = this.visitTypeSpecifier(type, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitExpression(Expression elm, C context) {
        if (elm instanceof AliasRef) {
            return this.visitAliasRef((AliasRef)elm, context);
        }
        if (elm instanceof Case) {
            return this.visitCase((Case)elm, context);
        }
        if (elm instanceof Current) {
            return this.visitCurrent((Current)elm, context);
        }
        if (elm instanceof ExpressionRef) {
            return this.visitExpressionRef((ExpressionRef)elm, context);
        }
        if (elm instanceof Filter) {
            return this.visitFilter((Filter)elm, context);
        }
        if (elm instanceof ForEach) {
            return this.visitForEach((ForEach)elm, context);
        }
        if (elm instanceof IdentifierRef) {
            return this.visitIdentifierRef((IdentifierRef)elm, context);
        }
        if (elm instanceof If) {
            return this.visitIf((If)elm, context);
        }
        if (elm instanceof Instance) {
            return this.visitInstance((Instance)elm, context);
        }
        if (elm instanceof Interval) {
            return this.visitInterval((Interval)elm, context);
        }
        if (elm instanceof Iteration) {
            return this.visitIteration((Iteration)elm, context);
        }
        if (elm instanceof List) {
            return this.visitList((List)elm, context);
        }
        if (elm instanceof Literal) {
            return this.visitLiteral((Literal)elm, context);
        }
        if (elm instanceof MaxValue) {
            return this.visitMaxValue((MaxValue)elm, context);
        }
        if (elm instanceof MinValue) {
            return this.visitMinValue((MinValue)elm, context);
        }
        if (elm instanceof Null) {
            return this.visitNull((Null)elm, context);
        }
        if (elm instanceof OperandRef) {
            return this.visitOperandRef((OperandRef)elm, context);
        }
        if (elm instanceof ParameterRef) {
            return this.visitParameterRef((ParameterRef)elm, context);
        }
        if (elm instanceof Property) {
            return this.visitProperty((Property)elm, context);
        }
        if (elm instanceof Query) {
            return this.visitQuery((Query)elm, context);
        }
        if (elm instanceof QueryLetRef) {
            return this.visitQueryLetRef((QueryLetRef)elm, context);
        }
        if (elm instanceof Repeat) {
            return this.visitRepeat((Repeat)elm, context);
        }
        if (elm instanceof Sort) {
            return this.visitSort((Sort)elm, context);
        }
        if (elm instanceof Total) {
            return this.visitTotal((Total)elm, context);
        }
        if (elm instanceof Tuple) {
            return this.visitTuple((Tuple)elm, context);
        }
        if (elm instanceof AggregateExpression) {
            return this.visitAggregateExpression((AggregateExpression)elm, context);
        }
        if (elm instanceof OperatorExpression) {
            return this.visitOperatorExpression((OperatorExpression)elm, context);
        }
        throw new IllegalArgumentException("Unknown Expression type: " + elm.getClass().getName());
    }

    @Override
    public T visitOperatorExpression(OperatorExpression elm, C context) {
        if (elm instanceof Round) {
            return this.visitRound((Round)elm, context);
        }
        if (elm instanceof Combine) {
            return this.visitCombine((Combine)elm, context);
        }
        if (elm instanceof Split) {
            return this.visitSplit((Split)elm, context);
        }
        if (elm instanceof SplitOnMatches) {
            return this.visitSplitOnMatches((SplitOnMatches)elm, context);
        }
        if (elm instanceof PositionOf) {
            return this.visitPositionOf((PositionOf)elm, context);
        }
        if (elm instanceof LastPositionOf) {
            return this.visitLastPositionOf((LastPositionOf)elm, context);
        }
        if (elm instanceof Substring) {
            return this.visitSubstring((Substring)elm, context);
        }
        if (elm instanceof TimeOfDay) {
            return this.visitTimeOfDay((TimeOfDay)elm, context);
        }
        if (elm instanceof Today) {
            return this.visitToday((Today)elm, context);
        }
        if (elm instanceof Now) {
            return this.visitNow((Now)elm, context);
        }
        if (elm instanceof Time) {
            return this.visitTime((Time)elm, context);
        }
        if (elm instanceof Date) {
            return this.visitDate((Date)elm, context);
        }
        if (elm instanceof DateTime) {
            return this.visitDateTime((DateTime)elm, context);
        }
        if (elm instanceof First) {
            return this.visitFirst((First)elm, context);
        }
        if (elm instanceof Last) {
            return this.visitLast((Last)elm, context);
        }
        if (elm instanceof IndexOf) {
            return this.visitIndexOf((IndexOf)elm, context);
        }
        if (elm instanceof Slice) {
            return this.visitSlice((Slice)elm, context);
        }
        if (elm instanceof Children) {
            return this.visitChildren((Children)elm, context);
        }
        if (elm instanceof Descendents) {
            return this.visitDescendents((Descendents)elm, context);
        }
        if (elm instanceof Message) {
            return this.visitMessage((Message)elm, context);
        }
        if (elm instanceof UnaryExpression) {
            return this.visitUnaryExpression((UnaryExpression)elm, context);
        }
        if (elm instanceof BinaryExpression) {
            return this.visitBinaryExpression((BinaryExpression)elm, context);
        }
        if (elm instanceof TernaryExpression) {
            return this.visitTernaryExpression((TernaryExpression)elm, context);
        }
        if (elm instanceof NaryExpression) {
            return this.visitNaryExpression((NaryExpression)elm, context);
        }
        throw new IllegalArgumentException("Unknown OperatorExpression type: " + elm.getClass().getName());
    }

    @Override
    public T visitUnaryExpression(UnaryExpression elm, C context) {
        if (elm instanceof Abs) {
            return this.visitAbs((Abs)elm, context);
        }
        if (elm instanceof As) {
            return this.visitAs((As)elm, context);
        }
        if (elm instanceof Ceiling) {
            return this.visitCeiling((Ceiling)elm, context);
        }
        if (elm instanceof CanConvert) {
            return this.visitCanConvert((CanConvert)elm, context);
        }
        if (elm instanceof Convert) {
            return this.visitConvert((Convert)elm, context);
        }
        if (elm instanceof ConvertsToBoolean) {
            return this.visitConvertsToBoolean((ConvertsToBoolean)elm, context);
        }
        if (elm instanceof ConvertsToDate) {
            return this.visitConvertsToDate((ConvertsToDate)elm, context);
        }
        if (elm instanceof ConvertsToDateTime) {
            return this.visitConvertsToDateTime((ConvertsToDateTime)elm, context);
        }
        if (elm instanceof ConvertsToDecimal) {
            return this.visitConvertsToDecimal((ConvertsToDecimal)elm, context);
        }
        if (elm instanceof ConvertsToInteger) {
            return this.visitConvertsToInteger((ConvertsToInteger)elm, context);
        }
        if (elm instanceof ConvertsToLong) {
            return this.visitConvertsToLong((ConvertsToLong)elm, context);
        }
        if (elm instanceof ConvertsToQuantity) {
            return this.visitConvertsToQuantity((ConvertsToQuantity)elm, context);
        }
        if (elm instanceof ConvertsToRatio) {
            return this.visitConvertsToRatio((ConvertsToRatio)elm, context);
        }
        if (elm instanceof ConvertsToString) {
            return this.visitConvertsToString((ConvertsToString)elm, context);
        }
        if (elm instanceof ConvertsToTime) {
            return this.visitConvertsToTime((ConvertsToTime)elm, context);
        }
        if (elm instanceof DateFrom) {
            return this.visitDateFrom((DateFrom)elm, context);
        }
        if (elm instanceof DateTimeComponentFrom) {
            return this.visitDateTimeComponentFrom((DateTimeComponentFrom)elm, context);
        }
        if (elm instanceof Distinct) {
            return this.visitDistinct((Distinct)elm, context);
        }
        if (elm instanceof End) {
            return this.visitEnd((End)elm, context);
        }
        if (elm instanceof Exists) {
            return this.visitExists((Exists)elm, context);
        }
        if (elm instanceof Exp) {
            return this.visitExp((Exp)elm, context);
        }
        if (elm instanceof Flatten) {
            return this.visitFlatten((Flatten)elm, context);
        }
        if (elm instanceof Floor) {
            return this.visitFloor((Floor)elm, context);
        }
        if (elm instanceof Is) {
            return this.visitIs((Is)elm, context);
        }
        if (elm instanceof IsFalse) {
            return this.visitIsFalse((IsFalse)elm, context);
        }
        if (elm instanceof IsNull) {
            return this.visitIsNull((IsNull)elm, context);
        }
        if (elm instanceof IsTrue) {
            return this.visitIsTrue((IsTrue)elm, context);
        }
        if (elm instanceof Length) {
            return this.visitLength((Length)elm, context);
        }
        if (elm instanceof Ln) {
            return this.visitLn((Ln)elm, context);
        }
        if (elm instanceof Lower) {
            return this.visitLower((Lower)elm, context);
        }
        if (elm instanceof Negate) {
            return this.visitNegate((Negate)elm, context);
        }
        if (elm instanceof Not) {
            return this.visitNot((Not)elm, context);
        }
        if (elm instanceof PointFrom) {
            return this.visitPointFrom((PointFrom)elm, context);
        }
        if (elm instanceof Precision) {
            return this.visitPrecision((Precision)elm, context);
        }
        if (elm instanceof Predecessor) {
            return this.visitPredecessor((Predecessor)elm, context);
        }
        if (elm instanceof SingletonFrom) {
            return this.visitSingletonFrom((SingletonFrom)elm, context);
        }
        if (elm instanceof Size) {
            return this.visitSize((Size)elm, context);
        }
        if (elm instanceof Start) {
            return this.visitStart((Start)elm, context);
        }
        if (elm instanceof Successor) {
            return this.visitSuccessor((Successor)elm, context);
        }
        if (elm instanceof TimeFrom) {
            return this.visitTimeFrom((TimeFrom)elm, context);
        }
        if (elm instanceof TimezoneFrom) {
            return this.visitTimezoneFrom((TimezoneFrom)elm, context);
        }
        if (elm instanceof TimezoneOffsetFrom) {
            return this.visitTimezoneOffsetFrom((TimezoneOffsetFrom)elm, context);
        }
        if (elm instanceof ToBoolean) {
            return this.visitToBoolean((ToBoolean)elm, context);
        }
        if (elm instanceof ToConcept) {
            return this.visitToConcept((ToConcept)elm, context);
        }
        if (elm instanceof ToChars) {
            return this.visitToChars((ToChars)elm, context);
        }
        if (elm instanceof ToDate) {
            return this.visitToDate((ToDate)elm, context);
        }
        if (elm instanceof ToDateTime) {
            return this.visitToDateTime((ToDateTime)elm, context);
        }
        if (elm instanceof ToDecimal) {
            return this.visitToDecimal((ToDecimal)elm, context);
        }
        if (elm instanceof ToInteger) {
            return this.visitToInteger((ToInteger)elm, context);
        }
        if (elm instanceof ToLong) {
            return this.visitToLong((ToLong)elm, context);
        }
        if (elm instanceof ToList) {
            return this.visitToList((ToList)elm, context);
        }
        if (elm instanceof ToQuantity) {
            return this.visitToQuantity((ToQuantity)elm, context);
        }
        if (elm instanceof ToRatio) {
            return this.visitToRatio((ToRatio)elm, context);
        }
        if (elm instanceof ToString) {
            return this.visitToString((ToString)elm, context);
        }
        if (elm instanceof ToTime) {
            return this.visitToTime((ToTime)elm, context);
        }
        if (elm instanceof Truncate) {
            return this.visitTruncate((Truncate)elm, context);
        }
        if (elm instanceof Upper) {
            return this.visitUpper((Upper)elm, context);
        }
        if (elm instanceof Width) {
            return this.visitWidth((Width)elm, context);
        }
        throw new IllegalArgumentException("Unknown UnaryExpression type: " + elm.getClass().getName());
    }

    @Override
    public T visitBinaryExpression(BinaryExpression elm, C context) {
        if (elm instanceof Add) {
            return this.visitAdd((Add)elm, context);
        }
        if (elm instanceof After) {
            return this.visitAfter((After)elm, context);
        }
        if (elm instanceof And) {
            return this.visitAnd((And)elm, context);
        }
        if (elm instanceof Before) {
            return this.visitBefore((Before)elm, context);
        }
        if (elm instanceof CanConvertQuantity) {
            return this.visitCanConvertQuantity((CanConvertQuantity)elm, context);
        }
        if (elm instanceof Contains) {
            return this.visitContains((Contains)elm, context);
        }
        if (elm instanceof ConvertQuantity) {
            return this.visitConvertQuantity((ConvertQuantity)elm, context);
        }
        if (elm instanceof Collapse) {
            return this.visitCollapse((Collapse)elm, context);
        }
        if (elm instanceof DifferenceBetween) {
            return this.visitDifferenceBetween((DifferenceBetween)elm, context);
        }
        if (elm instanceof Divide) {
            return this.visitDivide((Divide)elm, context);
        }
        if (elm instanceof DurationBetween) {
            return this.visitDurationBetween((DurationBetween)elm, context);
        }
        if (elm instanceof Ends) {
            return this.visitEnds((Ends)elm, context);
        }
        if (elm instanceof EndsWith) {
            return this.visitEndsWith((EndsWith)elm, context);
        }
        if (elm instanceof Equal) {
            return this.visitEqual((Equal)elm, context);
        }
        if (elm instanceof Equivalent) {
            return this.visitEquivalent((Equivalent)elm, context);
        }
        if (elm instanceof Expand) {
            return this.visitExpand((Expand)elm, context);
        }
        if (elm instanceof Greater) {
            return this.visitGreater((Greater)elm, context);
        }
        if (elm instanceof GreaterOrEqual) {
            return this.visitGreaterOrEqual((GreaterOrEqual)elm, context);
        }
        if (elm instanceof HighBoundary) {
            return this.visitHighBoundary((HighBoundary)elm, context);
        }
        if (elm instanceof Implies) {
            return this.visitImplies((Implies)elm, context);
        }
        if (elm instanceof In) {
            return this.visitIn((In)elm, context);
        }
        if (elm instanceof IncludedIn) {
            return this.visitIncludedIn((IncludedIn)elm, context);
        }
        if (elm instanceof Includes) {
            return this.visitIncludes((Includes)elm, context);
        }
        if (elm instanceof Indexer) {
            return this.visitIndexer((Indexer)elm, context);
        }
        if (elm instanceof Less) {
            return this.visitLess((Less)elm, context);
        }
        if (elm instanceof LessOrEqual) {
            return this.visitLessOrEqual((LessOrEqual)elm, context);
        }
        if (elm instanceof Log) {
            return this.visitLog((Log)elm, context);
        }
        if (elm instanceof LowBoundary) {
            return this.visitLowBoundary((LowBoundary)elm, context);
        }
        if (elm instanceof Matches) {
            return this.visitMatches((Matches)elm, context);
        }
        if (elm instanceof Meets) {
            return this.visitMeets((Meets)elm, context);
        }
        if (elm instanceof MeetsAfter) {
            return this.visitMeetsAfter((MeetsAfter)elm, context);
        }
        if (elm instanceof MeetsBefore) {
            return this.visitMeetsBefore((MeetsBefore)elm, context);
        }
        if (elm instanceof Modulo) {
            return this.visitModulo((Modulo)elm, context);
        }
        if (elm instanceof Multiply) {
            return this.visitMultiply((Multiply)elm, context);
        }
        if (elm instanceof NotEqual) {
            return this.visitNotEqual((NotEqual)elm, context);
        }
        if (elm instanceof Or) {
            return this.visitOr((Or)elm, context);
        }
        if (elm instanceof Overlaps) {
            return this.visitOverlaps((Overlaps)elm, context);
        }
        if (elm instanceof OverlapsAfter) {
            return this.visitOverlapsAfter((OverlapsAfter)elm, context);
        }
        if (elm instanceof OverlapsBefore) {
            return this.visitOverlapsBefore((OverlapsBefore)elm, context);
        }
        if (elm instanceof Power) {
            return this.visitPower((Power)elm, context);
        }
        if (elm instanceof ProperContains) {
            return this.visitProperContains((ProperContains)elm, context);
        }
        if (elm instanceof ProperIn) {
            return this.visitProperIn((ProperIn)elm, context);
        }
        if (elm instanceof ProperIncludedIn) {
            return this.visitProperIncludedIn((ProperIncludedIn)elm, context);
        }
        if (elm instanceof ProperIncludes) {
            return this.visitProperIncludes((ProperIncludes)elm, context);
        }
        if (elm instanceof SameAs) {
            return this.visitSameAs((SameAs)elm, context);
        }
        if (elm instanceof SameOrAfter) {
            return this.visitSameOrAfter((SameOrAfter)elm, context);
        }
        if (elm instanceof SameOrBefore) {
            return this.visitSameOrBefore((SameOrBefore)elm, context);
        }
        if (elm instanceof Starts) {
            return this.visitStarts((Starts)elm, context);
        }
        if (elm instanceof StartsWith) {
            return this.visitStartsWith((StartsWith)elm, context);
        }
        if (elm instanceof Subtract) {
            return this.visitSubtract((Subtract)elm, context);
        }
        if (elm instanceof Times) {
            return this.visitTimes((Times)elm, context);
        }
        if (elm instanceof TruncatedDivide) {
            return this.visitTruncatedDivide((TruncatedDivide)elm, context);
        }
        if (elm instanceof Xor) {
            return this.visitXor((Xor)elm, context);
        }
        throw new IllegalArgumentException("Unknown BinaryExpression type: " + elm.getClass().getName());
    }

    @Override
    public T visitTernaryExpression(TernaryExpression elm, C context) {
        if (elm instanceof ReplaceMatches) {
            return this.visitReplaceMatches((ReplaceMatches)elm, context);
        }
        throw new IllegalArgumentException("Unknown TernaryExpression type: " + elm.getClass().getName());
    }

    @Override
    public T visitNaryExpression(NaryExpression elm, C context) {
        if (elm instanceof Coalesce) {
            return this.visitCoalesce((Coalesce)elm, context);
        }
        if (elm instanceof Concatenate) {
            return this.visitConcatenate((Concatenate)elm, context);
        }
        if (elm instanceof Except) {
            return this.visitExcept((Except)elm, context);
        }
        if (elm instanceof Intersect) {
            return this.visitIntersect((Intersect)elm, context);
        }
        if (elm instanceof Union) {
            return this.visitUnion((Union)elm, context);
        }
        throw new IllegalArgumentException("Unknown NaryExpression type: " + elm.getClass().getName());
    }

    @Override
    public T visitExpressionDef(ExpressionDef elm, C context) {
        if (elm instanceof FunctionDef) {
            return this.visitFunctionDef((FunctionDef)elm, context);
        }
        return this.visitFields(elm, context);
    }

    @Override
    public T visitFunctionDef(FunctionDef elm, C context) {
        T result = this.visitFields(elm, context);
        for (OperandDef operand : elm.getOperand()) {
            T childResult = this.visitOperandDef(operand, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    public T visitAccessModifier(AccessModifier elm, C context) {
        return this.defaultResult(null, context);
    }

    @Override
    public T visitExpressionRef(ExpressionRef elm, C context) {
        if (elm instanceof FunctionRef) {
            return this.visitFunctionRef((FunctionRef)elm, context);
        }
        return this.visitFields(elm, context);
    }

    @Override
    public T visitFunctionRef(FunctionRef elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        for (Expression element : elm.getOperand()) {
            childResult = this.visitExpression(element, context);
            result = this.aggregateResult(result, childResult);
        }
        for (TypeSpecifier s : elm.getSignature()) {
            childResult = this.visitTypeSpecifier(s, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitParameterDef(ParameterDef elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getParameterTypeSpecifier() != null) {
            childResult = this.visitTypeSpecifier(elm.getParameterTypeSpecifier(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getDefault() != null) {
            childResult = this.visitExpression(elm.getDefault(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitParameterRef(ParameterRef elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitOperandDef(OperandDef elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getOperandTypeSpecifier() != null) {
            T childResult = this.visitTypeSpecifier(elm.getOperandTypeSpecifier(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitOperandRef(OperandRef elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitIdentifierRef(IdentifierRef elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitLiteral(Literal elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitTupleElement(TupleElement elm, C context) {
        T result = this.defaultResult(elm, context);
        if (elm.getValue() != null) {
            T childResult = this.visitExpression(elm.getValue(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitTuple(Tuple elm, C context) {
        T result = this.visitFields(elm, context);
        for (TupleElement element : elm.getElement()) {
            T childResult = this.visitTupleElement(element, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitInstanceElement(InstanceElement elm, C context) {
        T result = this.defaultResult(elm, context);
        if (elm.getValue() != null) {
            T childResult = this.visitExpression(elm.getValue(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitInstance(Instance elm, C context) {
        T result = this.visitFields(elm, context);
        for (InstanceElement element : elm.getElement()) {
            T childResult = this.visitInstanceElement(element, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitInterval(Interval elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getLow() != null) {
            childResult = this.visitExpression(elm.getLow(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getLowClosedExpression() != null) {
            childResult = this.visitExpression(elm.getLowClosedExpression(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getHigh() != null) {
            childResult = this.visitExpression(elm.getHigh(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getHighClosedExpression() != null) {
            childResult = this.visitExpression(elm.getHighClosedExpression(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitList(List elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getTypeSpecifier() != null) {
            T childResult = this.visitTypeSpecifier(elm.getTypeSpecifier(), context);
            result = this.aggregateResult(result, childResult);
        }
        for (Expression element : elm.getElement()) {
            T childResult = this.visitExpression(element, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitAnd(And elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitOr(Or elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitXor(Xor elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitImplies(Implies elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitNot(Not elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitIf(If elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getCondition() != null) {
            childResult = this.visitExpression(elm.getCondition(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getThen() != null) {
            childResult = this.visitExpression(elm.getThen(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getElse() != null) {
            childResult = this.visitExpression(elm.getElse(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitCaseItem(CaseItem elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getWhen() != null) {
            childResult = this.visitExpression(elm.getWhen(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getThen() != null) {
            childResult = this.visitExpression(elm.getThen(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitCase(Case elm, C context) {
        Iterator<CaseItem> childResult;
        Object result = this.visitFields(elm, context);
        if (elm.getComparand() != null) {
            childResult = this.visitExpression(elm.getComparand(), context);
            result = this.aggregateResult(result, childResult);
        }
        for (CaseItem ci : elm.getCaseItem()) {
            T childResult2 = this.visitCaseItem(ci, context);
            result = this.aggregateResult(result, childResult2);
        }
        if (elm.getElse() != null) {
            childResult = this.visitExpression(elm.getElse(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitNull(Null elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitIsNull(IsNull elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitIsTrue(IsTrue elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitIsFalse(IsFalse elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitCoalesce(Coalesce elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitIs(Is elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getIsTypeSpecifier() != null) {
            T childResult = this.visitTypeSpecifier(elm.getIsTypeSpecifier(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitAs(As elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getAsTypeSpecifier() != null) {
            T childResult = this.visitTypeSpecifier(elm.getAsTypeSpecifier(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitConvert(Convert elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getToTypeSpecifier() != null) {
            T childResult = this.visitTypeSpecifier(elm.getToTypeSpecifier(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitCanConvert(CanConvert elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getToTypeSpecifier() != null) {
            T childResult = this.visitTypeSpecifier(elm.getToTypeSpecifier(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitConvertsToBoolean(ConvertsToBoolean elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToBoolean(ToBoolean elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToChars(ToChars elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToConcept(ToConcept elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitConvertsToDate(ConvertsToDate elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToDate(ToDate elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitConvertsToDateTime(ConvertsToDateTime elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToDateTime(ToDateTime elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitConvertsToLong(ConvertsToLong elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToLong(ToLong elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitConvertsToDecimal(ConvertsToDecimal elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToDecimal(ToDecimal elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitConvertsToInteger(ConvertsToInteger elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToInteger(ToInteger elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToList(ToList elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitConvertQuantity(ConvertQuantity elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitCanConvertQuantity(CanConvertQuantity elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitConvertsToQuantity(ConvertsToQuantity elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToQuantity(ToQuantity elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitConvertsToRatio(ConvertsToRatio elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToRatio(ToRatio elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitConvertsToString(ConvertsToString elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToString(ToString elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitConvertsToTime(ConvertsToTime elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToTime(ToTime elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitEqual(Equal elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitEquivalent(Equivalent elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitNotEqual(NotEqual elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitLess(Less elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitGreater(Greater elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitLessOrEqual(LessOrEqual elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitGreaterOrEqual(GreaterOrEqual elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitAdd(Add elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitSubtract(Subtract elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitMultiply(Multiply elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitDivide(Divide elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitTruncatedDivide(TruncatedDivide elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitModulo(Modulo elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitCeiling(Ceiling elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitFloor(Floor elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitTruncate(Truncate elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitAbs(Abs elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitNegate(Negate elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitRound(Round elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getOperand() != null) {
            childResult = this.visitExpression(elm.getOperand(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getPrecision() != null) {
            childResult = this.visitExpression(elm.getPrecision(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitLn(Ln elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitExp(Exp elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitLog(Log elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitPower(Power elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitSuccessor(Successor elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitPredecessor(Predecessor elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitMinValue(MinValue elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitMaxValue(MaxValue elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitPrecision(Precision elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitLowBoundary(LowBoundary elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitHighBoundary(HighBoundary elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitConcatenate(Concatenate elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitCombine(Combine elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getSeparator() != null) {
            childResult = this.visitExpression(elm.getSeparator(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitSplit(Split elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getStringToSplit() != null) {
            childResult = this.visitExpression(elm.getStringToSplit(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getSeparator() != null) {
            childResult = this.visitExpression(elm.getSeparator(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitSplitOnMatches(SplitOnMatches elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getStringToSplit() != null) {
            childResult = this.visitExpression(elm.getStringToSplit(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getSeparatorPattern() != null) {
            childResult = this.visitExpression(elm.getSeparatorPattern(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitLength(Length elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitUpper(Upper elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitLower(Lower elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitIndexer(Indexer elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitPositionOf(PositionOf elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getPattern() != null) {
            childResult = this.visitExpression(elm.getPattern(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getString() != null) {
            childResult = this.visitExpression(elm.getString(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitLastPositionOf(LastPositionOf elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getPattern() != null) {
            childResult = this.visitExpression(elm.getPattern(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getString() != null) {
            childResult = this.visitExpression(elm.getString(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitSubstring(Substring elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getStringToSub() != null) {
            childResult = this.visitExpression(elm.getStringToSub(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getStartIndex() != null) {
            childResult = this.visitExpression(elm.getStartIndex(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getLength() != null) {
            childResult = this.visitExpression(elm.getLength(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitStartsWith(StartsWith elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitEndsWith(EndsWith elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitMatches(Matches elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitReplaceMatches(ReplaceMatches elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitDurationBetween(DurationBetween elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitDifferenceBetween(DifferenceBetween elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitDateFrom(DateFrom elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitTimeFrom(TimeFrom elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitTimezoneFrom(TimezoneFrom elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitTimezoneOffsetFrom(TimezoneOffsetFrom elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitDateTimeComponentFrom(DateTimeComponentFrom elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitTimeOfDay(TimeOfDay elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitToday(Today elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitNow(Now elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitDateTime(DateTime elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getYear() != null) {
            childResult = this.visitExpression(elm.getYear(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getMonth() != null) {
            childResult = this.visitExpression(elm.getMonth(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getDay() != null) {
            childResult = this.visitExpression(elm.getDay(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getHour() != null) {
            childResult = this.visitExpression(elm.getHour(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getMinute() != null) {
            childResult = this.visitExpression(elm.getMinute(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getSecond() != null) {
            childResult = this.visitExpression(elm.getSecond(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getMillisecond() != null) {
            childResult = this.visitExpression(elm.getMillisecond(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getTimezoneOffset() != null) {
            childResult = this.visitExpression(elm.getTimezoneOffset(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitDate(Date elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getYear() != null) {
            childResult = this.visitExpression(elm.getYear(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getMonth() != null) {
            childResult = this.visitExpression(elm.getMonth(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getDay() != null) {
            childResult = this.visitExpression(elm.getDay(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitTime(Time elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getHour() != null) {
            childResult = this.visitExpression(elm.getHour(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getMinute() != null) {
            childResult = this.visitExpression(elm.getMinute(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getSecond() != null) {
            childResult = this.visitExpression(elm.getSecond(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getMillisecond() != null) {
            childResult = this.visitExpression(elm.getMillisecond(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitSameAs(SameAs elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitSameOrBefore(SameOrBefore elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitSameOrAfter(SameOrAfter elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitWidth(Width elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitSize(Size elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitPointFrom(PointFrom elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitStart(Start elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitEnd(End elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitContains(Contains elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitProperContains(ProperContains elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitIn(In elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitProperIn(ProperIn elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitIncludes(Includes elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitIncludedIn(IncludedIn elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitProperIncludes(ProperIncludes elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitProperIncludedIn(ProperIncludedIn elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitBefore(Before elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitAfter(After elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitMeets(Meets elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitMeetsBefore(MeetsBefore elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitMeetsAfter(MeetsAfter elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitOverlaps(Overlaps elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitOverlapsBefore(OverlapsBefore elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitOverlapsAfter(OverlapsAfter elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitStarts(Starts elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitEnds(Ends elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitCollapse(Collapse elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitExpand(Expand elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitUnion(Union elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitIntersect(Intersect elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitExcept(Except elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitExists(Exists elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitTimes(Times elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitFilter(Filter elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getCondition() != null) {
            childResult = this.visitExpression(elm.getCondition(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitFirst(First elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            T childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitLast(Last elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            T childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitSlice(Slice elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getStartIndex() != null) {
            childResult = this.visitExpression(elm.getStartIndex(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getEndIndex() != null) {
            childResult = this.visitExpression(elm.getEndIndex(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitChildren(Children elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            T childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitDescendents(Descendents elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            T childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitMessage(Message elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getCondition() != null) {
            childResult = this.visitExpression(elm.getCondition(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getCode() != null) {
            childResult = this.visitExpression(elm.getCode(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getSeverity() != null) {
            childResult = this.visitExpression(elm.getSeverity(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getMessage() != null) {
            childResult = this.visitExpression(elm.getMessage(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitIndexOf(IndexOf elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getElement() != null) {
            childResult = this.visitExpression(elm.getElement(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitFlatten(Flatten elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitSort(Sort elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            T childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        for (SortByItem sbi : elm.getBy()) {
            T childResult = this.visitSortByItem(sbi, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitForEach(ForEach elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getElement() != null) {
            childResult = this.visitExpression(elm.getElement(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitRepeat(Repeat elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getElement() != null) {
            childResult = this.visitExpression(elm.getElement(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitDistinct(Distinct elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitCurrent(Current elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitIteration(Iteration elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitTotal(Total elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitSingletonFrom(SingletonFrom elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitAggregateExpression(AggregateExpression elm, C context) {
        if (elm instanceof Aggregate) {
            return this.visitAggregate((Aggregate)elm, context);
        }
        if (elm instanceof Count) {
            return this.visitCount((Count)elm, context);
        }
        if (elm instanceof Sum) {
            return this.visitSum((Sum)elm, context);
        }
        if (elm instanceof Product) {
            return this.visitProduct((Product)elm, context);
        }
        if (elm instanceof Min) {
            return this.visitMin((Min)elm, context);
        }
        if (elm instanceof Max) {
            return this.visitMax((Max)elm, context);
        }
        if (elm instanceof Avg) {
            return this.visitAvg((Avg)elm, context);
        }
        if (elm instanceof GeometricMean) {
            return this.visitGeometricMean((GeometricMean)elm, context);
        }
        if (elm instanceof Median) {
            return this.visitMedian((Median)elm, context);
        }
        if (elm instanceof Mode) {
            return this.visitMode((Mode)elm, context);
        }
        if (elm instanceof Variance) {
            return this.visitVariance((Variance)elm, context);
        }
        if (elm instanceof StdDev) {
            return this.visitStdDev((StdDev)elm, context);
        }
        if (elm instanceof PopulationVariance) {
            return this.visitPopulationVariance((PopulationVariance)elm, context);
        }
        if (elm instanceof PopulationStdDev) {
            return this.visitPopulationStdDev((PopulationStdDev)elm, context);
        }
        if (elm instanceof AllTrue) {
            return this.visitAllTrue((AllTrue)elm, context);
        }
        if (elm instanceof AnyTrue) {
            return this.visitAnyTrue((AnyTrue)elm, context);
        }
        throw new IllegalArgumentException("Unsupported AggregateExpression type: " + elm.getClass().getName());
    }

    @Override
    public T visitAggregate(Aggregate elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getInitialValue() != null) {
            childResult = this.visitExpression(elm.getInitialValue(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getIteration() != null) {
            childResult = this.visitExpression(elm.getIteration(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitCount(Count elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitSum(Sum elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitProduct(Product elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitGeometricMean(GeometricMean elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitMin(Min elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitMax(Max elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitAvg(Avg elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitMedian(Median elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitMode(Mode elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitVariance(Variance elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitPopulationVariance(PopulationVariance elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitStdDev(StdDev elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitPopulationStdDev(PopulationStdDev elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitAllTrue(AllTrue elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitAnyTrue(AnyTrue elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitProperty(Property elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getSource() != null) {
            T childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitAliasedQuerySource(AliasedQuerySource elm, C context) {
        if (elm instanceof RelationshipClause) {
            return this.visitRelationshipClause((RelationshipClause)elm, context);
        }
        return this.visitFields(elm, context);
    }

    @Override
    public T visitLetClause(LetClause elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getExpression() != null) {
            T childResult = this.visitExpression(elm.getExpression(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitRelationshipClause(RelationshipClause elm, C context) {
        if (elm instanceof With) {
            return this.visitWith((With)elm, context);
        }
        if (elm instanceof Without) {
            return this.visitWithout((Without)elm, context);
        }
        throw new IllegalArgumentException("Unknown RelationshipClause type: " + elm.getClass().getName());
    }

    @Override
    public T visitWith(With elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitWithout(Without elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitSortByItem(SortByItem elm, C context) {
        if (elm instanceof ByDirection) {
            return this.visitByDirection((ByDirection)elm, context);
        }
        if (elm instanceof ByColumn) {
            return this.visitByColumn((ByColumn)elm, context);
        }
        if (elm instanceof ByExpression) {
            return this.visitByExpression((ByExpression)elm, context);
        }
        throw new IllegalArgumentException("Unknown SortByItem type: " + elm.getClass().getName());
    }

    @Override
    public T visitByDirection(ByDirection elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitByColumn(ByColumn elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitByExpression(ByExpression elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getExpression() != null) {
            T childResult = this.visitExpression(elm.getExpression(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitSortClause(SortClause elm, C context) {
        T result = this.visitFields(elm, context);
        for (SortByItem sbi : elm.getBy()) {
            T childResult = this.visitSortByItem(sbi, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitAggregateClause(AggregateClause elm, C context) {
        T childResult;
        T result = this.visitFields(elm, context);
        if (elm.getExpression() != null) {
            childResult = this.visitExpression(elm.getExpression(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getStarting() != null) {
            childResult = this.visitExpression(elm.getStarting(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitReturnClause(ReturnClause elm, C context) {
        T result = this.visitFields(elm, context);
        if (elm.getExpression() != null) {
            T childResult = this.visitExpression(elm.getExpression(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitQuery(Query elm, C context) {
        T childResult;
        T childResult2;
        T result = this.visitFields(elm, context);
        for (AliasedQuerySource source : elm.getSource()) {
            childResult2 = this.visitAliasedQuerySource(source, context);
            result = this.aggregateResult(result, childResult2);
        }
        for (LetClause let : elm.getLet()) {
            childResult2 = this.visitLetClause(let, context);
            result = this.aggregateResult(result, childResult2);
        }
        for (RelationshipClause r : elm.getRelationship()) {
            childResult2 = this.visitRelationshipClause(r, context);
            result = this.aggregateResult(result, childResult2);
        }
        if (elm.getWhere() != null) {
            childResult = this.visitExpression(elm.getWhere(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getReturn() != null) {
            childResult = this.visitReturnClause(elm.getReturn(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getAggregate() != null) {
            childResult = this.visitAggregateClause(elm.getAggregate(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getSort() != null) {
            childResult = this.visitSortClause(elm.getSort(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    @Override
    public T visitAliasRef(AliasRef elm, C context) {
        return this.visitFields(elm, context);
    }

    @Override
    public T visitQueryLetRef(QueryLetRef elm, C context) {
        return this.visitFields(elm, context);
    }

    protected T visitFields(Element elm, C context) {
        T result = this.defaultResult(elm, context);
        if (elm.getResultTypeSpecifier() != null) {
            T childResult = this.visitTypeSpecifier(elm.getResultTypeSpecifier(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    protected T visitFields(Expression elm, C context) {
        return this.visitFields((Element)elm, context);
    }

    protected T visitFields(RelationshipClause elm, C context) {
        T result = this.visitFields((AliasedQuerySource)elm, context);
        if (elm.getSuchThat() != null) {
            T childResult = this.visitExpression(elm.getSuchThat(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    protected T visitFields(AggregateExpression elm, C context) {
        T result = this.visitFields((Expression)elm, context);
        if (elm.getSource() != null) {
            T childResult = this.visitExpression(elm.getSource(), context);
            result = this.aggregateResult(result, childResult);
        }
        for (TypeSpecifier s : elm.getSignature()) {
            T childResult = this.visitTypeSpecifier(s, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    protected T visitFields(ExpressionDef elm, C context) {
        T childResult;
        T result = this.visitFields((Element)elm, context);
        if (elm.getAccessLevel() != null) {
            childResult = this.visitAccessModifier(elm.getAccessLevel(), context);
            result = this.aggregateResult(result, childResult);
        }
        if (elm.getExpression() != null) {
            childResult = this.visitExpression(elm.getExpression(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    protected T visitFields(UnaryExpression elm, C context) {
        T result = this.visitFields((OperatorExpression)elm, context);
        if (elm.getOperand() != null) {
            T childResult = this.visitExpression(elm.getOperand(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    protected T visitFields(NaryExpression elm, C context) {
        T result = this.visitFields((OperatorExpression)elm, context);
        for (Expression e : elm.getOperand()) {
            T childResult = this.visitExpression(e, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    protected T visitFields(TernaryExpression elm, C context) {
        T result = this.visitFields((OperatorExpression)elm, context);
        for (Expression s : elm.getOperand()) {
            T childResult = this.visitExpression(s, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    protected T visitFields(OperatorExpression elm, C context) {
        T result = this.visitFields((Expression)elm, context);
        for (TypeSpecifier s : elm.getSignature()) {
            T childResult = this.visitTypeSpecifier(s, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    protected T visitFields(BinaryExpression elm, C context) {
        T result = this.visitFields((OperatorExpression)elm, context);
        for (Expression e : elm.getOperand()) {
            T childResult = this.visitExpression(e, context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }

    protected T visitFields(AliasedQuerySource elm, C context) {
        T result = this.visitFields((Element)elm, context);
        if (elm.getExpression() != null) {
            T childResult = this.visitExpression(elm.getExpression(), context);
            result = this.aggregateResult(result, childResult);
        }
        return result;
    }
}

