/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.converter;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.dstu2.model.BaseDateTimeType;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DateType;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.IdType;
import org.hl7.fhir.dstu2.model.IntegerType;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Range;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.TimeType;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.fhir.converter.BaseFhirTypeConverter;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Concept;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.Ratio;
import org.opencds.cqf.cql.engine.runtime.Time;
import org.opencds.cqf.cql.engine.runtime.Tuple;

class Dstu2FhirTypeConverter
extends BaseFhirTypeConverter {
    Dstu2FhirTypeConverter() {
    }

    @Override
    public IIdType toFhirId(String value) {
        if (value == null) {
            return null;
        }
        return new IdType(value);
    }

    public BooleanType toFhirBoolean(Boolean value) {
        if (value == null) {
            return null;
        }
        return new BooleanType(value);
    }

    @Override
    public IPrimitiveType<Integer> toFhirInteger(Integer value) {
        if (value == null) {
            return null;
        }
        return new IntegerType(value.intValue());
    }

    @Override
    public IPrimitiveType<BigDecimal> toFhirDecimal(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return new DecimalType(value);
    }

    @Override
    public IPrimitiveType<java.util.Date> toFhirDate(Date value) {
        if (value == null) {
            return null;
        }
        return new DateType(value.toString());
    }

    @Override
    public IPrimitiveType<java.util.Date> toFhirDateTime(DateTime value) {
        if (value == null) {
            return null;
        }
        return new DateTimeType(value.getDateTime().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
    }

    @Override
    public IPrimitiveType<String> toFhirTime(Time value) {
        if (value == null) {
            return null;
        }
        return new TimeType(value.toString());
    }

    @Override
    public IPrimitiveType<String> toFhirString(String value) {
        if (value == null) {
            return null;
        }
        return new StringType(value);
    }

    @Override
    public ICompositeType toFhirQuantity(Quantity value) {
        if (value == null) {
            return null;
        }
        String unit = value.getUnit();
        String system = this.isCqlCalendarUnit(unit) ? "http://hl7.org/fhirpath/CodeSystem/calendar-units" : "http://unitsofmeasure.org";
        String ucumUnit = this.toUcumUnit(unit);
        return new org.hl7.fhir.dstu2.model.Quantity().setSystem(system).setCode(ucumUnit).setValue(value.getValue()).setUnit(unit);
    }

    @Override
    public ICompositeType toFhirRatio(Ratio value) {
        if (value == null) {
            return null;
        }
        return new org.hl7.fhir.dstu2.model.Ratio().setNumerator((org.hl7.fhir.dstu2.model.Quantity)this.toFhirQuantity(value.getNumerator())).setDenominator((org.hl7.fhir.dstu2.model.Quantity)this.toFhirQuantity(value.getDenominator()));
    }

    @Override
    public IBase toFhirAny(Object value) {
        if (value == null) {
            return null;
        }
        throw new NotImplementedException("Unable to convert System.Any types");
    }

    @Override
    public IBaseCoding toFhirCoding(Code value) {
        if (value == null) {
            return null;
        }
        Coding coding = new Coding();
        coding.setSystem(value.getSystem());
        coding.setCode(value.getCode());
        coding.setDisplay(value.getDisplay());
        coding.setVersion(value.getVersion());
        return coding;
    }

    @Override
    public ICompositeType toFhirCodeableConcept(Concept value) {
        if (value == null) {
            return null;
        }
        CodeableConcept codeableConcept = new CodeableConcept();
        codeableConcept.setText(value.getDisplay());
        if (value.getCodes() != null) {
            for (Code c : value.getCodes()) {
                codeableConcept.addCoding((Coding)this.toFhirCoding(c));
            }
        }
        return codeableConcept;
    }

    @Override
    public ICompositeType toFhirPeriod(Interval value) {
        if (value == null) {
            return null;
        }
        Period period = new Period();
        if (this.getSimpleName(value.getPointType().getTypeName()).equals("DateTime")) {
            if (value.getStart() != null) {
                period.setStartElement((DateTimeType)this.toFhirDateTime((DateTime)value.getStart()));
            }
            if (value.getEnd() != null) {
                period.setEndElement((DateTimeType)this.toFhirDateTime((DateTime)value.getEnd()));
            }
            return period;
        }
        if (this.getSimpleName(value.getPointType().getTypeName()).equals("Date")) {
            if (value.getStart() != null) {
                period.setStart((java.util.Date)this.toFhirDate((Date)value.getStart()).getValue());
            }
            if (value.getEnd() != null) {
                period.setEnd((java.util.Date)this.toFhirDate((Date)value.getEnd()).getValue());
            }
            return period;
        }
        throw new IllegalArgumentException("FHIR Period can only be created from an Interval of Date or DateTime type");
    }

    @Override
    public ICompositeType toFhirRange(Interval value) {
        org.hl7.fhir.dstu2.model.Quantity end;
        if (value == null) {
            return null;
        }
        if (!this.getSimpleName(value.getPointType().getTypeName()).equals("Quantity")) {
            throw new IllegalArgumentException("FHIR Range can only be created from an Interval of Quantity type");
        }
        Range range = new Range();
        org.hl7.fhir.dstu2.model.Quantity start = (org.hl7.fhir.dstu2.model.Quantity)this.toFhirQuantity((Quantity)value.getStart());
        if (start != null) {
            range.setLow(this.toSimpleQuantity(start));
        }
        if ((end = (org.hl7.fhir.dstu2.model.Quantity)this.toFhirQuantity((Quantity)value.getEnd())) != null) {
            range.setHigh(this.toSimpleQuantity(end));
        }
        return range;
    }

    @Override
    public IBase toFhirTuple(Tuple value) {
        if (value == null) {
            return null;
        }
        throw new NotImplementedException("can't convert Tuples");
    }

    @Override
    public Quantity toCqlQuantity(ICompositeType value) {
        if (value == null) {
            return null;
        }
        if (!value.fhirType().equals("Quantity")) {
            throw new IllegalArgumentException("value is not a FHIR Quantity");
        }
        org.hl7.fhir.dstu2.model.Quantity quantity = (org.hl7.fhir.dstu2.model.Quantity)value;
        if (quantity.hasComparator()) {
            throw new IllegalArgumentException("Cannot convert a FHIR Quantity with a comparator to a CQL quantity");
        }
        return new Quantity().withUnit(this.toCqlCalendarUnit(quantity.getUnit())).withValue(quantity.getValue());
    }

    @Override
    public Ratio toCqlRatio(ICompositeType value) {
        if (value == null) {
            return null;
        }
        if (!value.fhirType().equals("Ratio")) {
            throw new IllegalArgumentException("value is not a FHIR Ratio");
        }
        org.hl7.fhir.dstu2.model.Ratio ratio = (org.hl7.fhir.dstu2.model.Ratio)value;
        return new Ratio().setNumerator(this.toCqlQuantity((ICompositeType)ratio.getNumerator())).setDenominator(this.toCqlQuantity((ICompositeType)ratio.getDenominator()));
    }

    @Override
    public Object toCqlAny(IBase value) {
        if (value == null) {
            return null;
        }
        throw new NotImplementedException("Unable to convert to System.Any type");
    }

    @Override
    public Code toCqlCode(IBaseCoding value) {
        if (value == null) {
            return null;
        }
        Coding coding = (Coding)value;
        return new Code().withSystem(coding.getSystem()).withCode(coding.getCode()).withVersion(coding.getVersion()).withDisplay(coding.getDisplay());
    }

    @Override
    public Concept toCqlConcept(ICompositeType value) {
        if (value == null) {
            return null;
        }
        if (!value.fhirType().equals("CodeableConcept")) {
            throw new IllegalArgumentException("value is not a FHIR CodeableConcept");
        }
        CodeableConcept codeableConcept = (CodeableConcept)value;
        return new Concept().withDisplay(codeableConcept.getText()).withCodes((Iterable)codeableConcept.getCoding().stream().map(x -> this.toCqlCode((IBaseCoding)x)).collect(Collectors.toList()));
    }

    @Override
    public Interval toCqlInterval(ICompositeType value) {
        if (value == null) {
            return null;
        }
        if (value.fhirType().equals("Range")) {
            Range range = (Range)value;
            return new Interval((Object)this.toCqlQuantity((ICompositeType)range.getLow()), true, (Object)this.toCqlQuantity((ICompositeType)range.getHigh()), true);
        }
        if (value.fhirType().equals("Period")) {
            Period period = (Period)value;
            return new Interval((Object)this.toCqlTemporal((IPrimitiveType<java.util.Date>)period.getStartElement()), true, (Object)this.toCqlTemporal((IPrimitiveType<java.util.Date>)period.getEndElement()), true);
        }
        throw new IllegalArgumentException("value is not a FHIR Range or Period");
    }

    @Override
    public Date toCqlDate(IPrimitiveType<java.util.Date> value) {
        if (value == null) {
            return null;
        }
        if (!value.fhirType().equals("date") || value.fhirType().equals("dateTime")) {
            throw new IllegalArgumentException("value is not a FHIR Date or DateTime");
        }
        BaseDateTimeType baseDateTime = (BaseDateTimeType)value;
        switch (baseDateTime.getPrecision()) {
            case YEAR: 
            case DAY: 
            case MONTH: {
                return this.toDate(this.toCalendar(baseDateTime), baseDateTime.getPrecision().getCalendarConstant());
            }
        }
        throw new IllegalArgumentException("value has a precision higher than a CQL Date");
    }

    @Override
    public DateTime toCqlDateTime(IPrimitiveType<java.util.Date> value) {
        if (value == null) {
            return null;
        }
        if (value.fhirType().equals("instant") || value.fhirType().equals("dateTime")) {
            BaseDateTimeType baseDateTime = (BaseDateTimeType)value;
            return this.toDateTime(this.toCalendar(baseDateTime), baseDateTime.getPrecision().getCalendarConstant());
        }
        throw new IllegalArgumentException("value is not a FHIR Instant or DateTime");
    }

    @Override
    public BaseTemporal toCqlTemporal(IPrimitiveType<java.util.Date> value) {
        if (value == null) {
            return null;
        }
        if (value.fhirType().equals("instant") || value.fhirType().equals("dateTime") || value.fhirType().equals("date")) {
            BaseDateTimeType baseDateTime = (BaseDateTimeType)value;
            switch (baseDateTime.getPrecision()) {
                case YEAR: 
                case DAY: 
                case MONTH: {
                    return this.toDate(this.toCalendar(baseDateTime), baseDateTime.getPrecision().getCalendarConstant());
                }
            }
            return this.toDateTime(this.toCalendar(baseDateTime), baseDateTime.getPrecision().getCalendarConstant());
        }
        throw new IllegalArgumentException("value is not a FHIR Instant or DateTime");
    }

    private Calendar toCalendar(BaseDateTimeType dateTimeType) {
        if (dateTimeType.getValue() == null) {
            return null;
        }
        GregorianCalendar cal = dateTimeType.getTimeZone() != null ? new GregorianCalendar(dateTimeType.getTimeZone()) : new GregorianCalendar();
        cal.setTime((java.util.Date)dateTimeType.getValue());
        return cal;
    }

    private SimpleQuantity toSimpleQuantity(org.hl7.fhir.dstu2.model.Quantity quantity) {
        SimpleQuantity simple = new SimpleQuantity();
        simple.setValue(quantity.getValue());
        simple.setCode(quantity.getCode());
        simple.setSystem(quantity.getSystem());
        simple.setComparator(quantity.getComparator());
        return simple;
    }
}

