/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.model;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildPrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeChildResourceDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import java.lang.reflect.InvocationTargetException;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseElement;
import org.hl7.fhir.instance.model.api.IBaseEnumeration;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.exception.DataProviderException;
import org.opencds.cqf.cql.engine.exception.InvalidCast;
import org.opencds.cqf.cql.engine.exception.InvalidPrecision;
import org.opencds.cqf.cql.engine.fhir.exception.UnknownType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.TemporalHelper;
import org.opencds.cqf.cql.engine.runtime.Time;

public abstract class FhirModelResolver<BaseType, BaseDateTimeType, TimeType, SimpleQuantityType, IdType, ResourceType, EnumerationType, EnumFactoryType>
implements ModelResolver {
    protected FhirContext fhirContext;
    protected List<String> packageNames;

    public FhirModelResolver(FhirContext fhirContext) {
        this.fhirContext = fhirContext;
        this.initialize();
    }

    protected abstract void initialize();

    protected abstract Boolean equalsDeep(BaseType var1, BaseType var2);

    protected abstract SimpleQuantityType castToSimpleQuantity(BaseType var1);

    protected abstract Calendar getCalendar(BaseDateTimeType var1);

    protected abstract Integer getCalendarConstant(BaseDateTimeType var1);

    protected abstract void setCalendarConstant(BaseDateTimeType var1, BaseTemporal var2);

    protected abstract String idToString(IdType var1);

    protected abstract String timeToString(TimeType var1);

    protected abstract String getResourceType(ResourceType var1);

    protected abstract EnumerationType enumConstructor(EnumFactoryType var1);

    protected abstract Boolean enumChecker(Object var1);

    protected abstract Class<?> enumFactoryTypeGetter(EnumerationType var1);

    public Object getContextPath(String contextType, String targetType) {
        if (targetType == null || contextType == null) {
            return null;
        }
        if (contextType.equals("Unfiltered") || contextType.equals("Unspecified") || contextType.equals("Population")) {
            return null;
        }
        if (targetType.equals(contextType)) {
            return "id";
        }
        RuntimeResourceDefinition resourceDefinition = this.fhirContext.getResourceDefinition(targetType);
        Object theValue = this.createInstance(contextType);
        Class<?> type = theValue.getClass();
        List children = resourceDefinition.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            HashSet<String> visitedElements = new HashSet<String>();
            BaseRuntimeChildDefinition child = (BaseRuntimeChildDefinition)iterator.next();
            String path = this.innerGetContextPath(visitedElements, child, type);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    protected String innerGetContextPath(Set<String> visitedElements, BaseRuntimeChildDefinition child, Class<? extends IBase> type) {
        visitedElements.add(child.getElementName());
        if (child instanceof RuntimeChildResourceDefinition) {
            RuntimeChildResourceDefinition resourceChild = (RuntimeChildResourceDefinition)child;
            for (Class resourceClass : resourceChild.getResourceTypes()) {
                if (!resourceClass.equals(type)) continue;
                return resourceChild.getElementName();
            }
            return null;
        }
        if (child instanceof RuntimeChildResourceBlockDefinition) {
            RuntimeChildResourceBlockDefinition resourceChild = (RuntimeChildResourceBlockDefinition)child;
            String currentName = resourceChild.getElementName();
            BaseRuntimeElementCompositeDefinition element = resourceChild.getChildByName(currentName);
            for (BaseRuntimeChildDefinition nextChild : element.getChildren()) {
                String path;
                if (visitedElements.contains(nextChild.getElementName()) || (path = this.innerGetContextPath(visitedElements, nextChild, type)) == null) continue;
                return String.join((CharSequence)".", currentName, path);
            }
        }
        return null;
    }

    public Boolean objectEqual(Object left, Object right) {
        if (left == null) {
            return null;
        }
        if (right == null) {
            return null;
        }
        return this.equalsDeep(left, right);
    }

    public Boolean objectEquivalent(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return this.equalsDeep(left, right);
    }

    public Object createInstance(String typeName) {
        return this.createInstance(this.resolveType(typeName));
    }

    public List<String> getPackageNames() {
        return this.packageNames;
    }

    public void setPackageNames(List<String> packageNames) {
        this.packageNames = packageNames;
    }

    public String getPackageName() {
        if (this.packageNames != null && !this.packageNames.isEmpty()) {
            return this.packageNames.get(0);
        }
        return null;
    }

    public void setPackageName(String packageName) {
        throw new UnsupportedOperationException("Use setPackageNames to set the packages names for this resolver");
    }

    public Object resolvePath(Object target, String path) {
        String[] identifiers;
        for (String identifier : identifiers = path.split("\\.")) {
            if (identifier.contains("[")) {
                int index = Character.getNumericValue(identifier.charAt(identifier.indexOf("[") + 1));
                target = this.resolveProperty(target, identifier.replaceAll("\\[\\d\\]", ""));
                target = ((ArrayList)target).get(index);
                continue;
            }
            target = this.resolveProperty(target, identifier);
        }
        return target;
    }

    public Class<?> resolveType(String typeName) {
        BaseRuntimeElementDefinition definition;
        if (typeName.startsWith("FHIR.")) {
            typeName = typeName.replace("FHIR.", "");
        }
        if ((definition = this.fhirContext.getElementDefinition(typeName)) != null) {
            return definition.getImplementingClass();
        }
        try {
            return this.fhirContext.getResourceDefinition(typeName).getImplementingClass();
        }
        catch (Exception exception) {
            try {
                if (typeName.contains(".")) {
                    String childName;
                    String[] path = typeName.split("\\.");
                    Object resourceDefinition = this.fhirContext.getResourceTypes().contains(path[0]) ? this.fhirContext.getResourceDefinition(path[0]) : this.fhirContext.getElementDefinition(path[0]);
                    BaseRuntimeChildDefinition childDefinition = resourceDefinition.getChildByName(childName = Character.toLowerCase(path[1].charAt(0)) + path[1].substring(1));
                    if (childDefinition == null) {
                        return this.resolveChildren(resourceDefinition.getChildren(), childName);
                    }
                    BaseRuntimeElementDefinition childElement = childDefinition.getChildByName(childName);
                    for (int i = 2; i < path.length; ++i) {
                        childName = Character.toLowerCase(path[i].charAt(0)) + path[i].substring(1);
                        childDefinition = childElement.getChildByName(childName);
                        childElement = childDefinition.getChildByName(childName);
                    }
                    return childElement.getImplementingClass();
                }
            }
            catch (Exception path) {
                // empty catch block
            }
            for (String packageName : this.packageNames) {
                try {
                    return Class.forName(String.format("%s.Enumerations$%s", packageName, typeName));
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            for (String packageName : this.packageNames) {
                try {
                    return Class.forName(String.format("%s.%s", packageName, typeName));
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            Class<?> clazz = this.deepSearch(typeName);
            if (clazz != null) {
                return clazz;
            }
            try {
                return Class.forName(typeName);
            }
            catch (ClassNotFoundException e) {
                throw new UnknownType(String.format("Could not resolve type %s. Primary package(s) for this resolver are %s", typeName, String.join((CharSequence)",", this.packageNames)));
            }
        }
    }

    private Class<?> resolveChildren(List<BaseRuntimeChildDefinition> children, String childName) {
        for (BaseRuntimeChildDefinition c : children) {
            if (c.getValidChildNames().contains(childName)) {
                return c.getChildByName(childName).getImplementingClass();
            }
            if (!(c instanceof RuntimeChildResourceBlockDefinition)) continue;
            for (String childrenName : c.getValidChildNames()) {
                if (c.getElementName().equals(childrenName)) continue;
                this.resolveChildren(c.getChildByName(childrenName).getChildren(), childName);
            }
        }
        return null;
    }

    public Class<?> resolveType(Object value) {
        if (value == null) {
            return Object.class;
        }
        if (this.enumChecker(value).booleanValue()) {
            String factoryName = this.enumFactoryTypeGetter(value).getSimpleName();
            return this.resolveType(factoryName.substring(0, factoryName.indexOf("EnumFactory")));
        }
        return value.getClass();
    }

    public void setValue(Object target, String path, Object value) {
        if (target == null) {
            return;
        }
        if (target instanceof IBaseEnumeration && path.equals("value")) {
            ((IBaseEnumeration)target).setValueAsString((String)value);
            return;
        }
        IBase base = (IBase)target;
        if (base instanceof IPrimitiveType) {
            this.setPrimitiveValue(value, (IPrimitiveType)base);
            return;
        }
        BaseRuntimeElementCompositeDefinition<?> definition = this.resolveRuntimeDefinition(base);
        BaseRuntimeChildDefinition child = definition.getChildByName(path);
        if (child == null) {
            child = this.resolveChoiceProperty(definition, path);
        }
        if (child == null) {
            throw new DataProviderException(String.format("Unable to resolve path %s.", path));
        }
        try {
            if (value instanceof Iterable) {
                for (Object val : (Iterable)value) {
                    child.getMutator().addValue(base, this.setBaseValue(val, base));
                }
            } else {
                child.getMutator().setValue(base, this.setBaseValue(value, base));
            }
        }
        catch (IllegalArgumentException le) {
            if (value.getClass().getSimpleName().equals("Quantity")) {
                try {
                    value = this.castToSimpleQuantity(value);
                }
                catch (FHIRException e) {
                    throw new InvalidCast("Unable to cast Quantity to SimpleQuantity");
                }
                child.getMutator().setValue(base, this.setBaseValue(value, base));
            }
            throw new DataProviderException(String.format("Configuration error encountered: %s", le.getMessage()));
        }
    }

    public FhirContext getFhirContext() {
        return this.fhirContext;
    }

    protected Object resolveProperty(Object target, String path) {
        IBase value;
        if (target == null) {
            return null;
        }
        if (target instanceof IBaseEnumeration && path.equals("value")) {
            return ((IBaseEnumeration)target).getValueAsString();
        }
        if (target instanceof IAnyResource && this.getResourceType(target).equals(path)) {
            return target;
        }
        IBase base = (IBase)target;
        if (base instanceof IPrimitiveType) {
            return this.toJavaPrimitive(path.equals("value") ? ((IPrimitiveType)target).getValue() : target, base);
        }
        BaseRuntimeElementCompositeDefinition<?> definition = this.resolveRuntimeDefinition(base);
        BaseRuntimeChildDefinition child = definition.getChildByName(path);
        if (child == null) {
            child = this.resolveChoiceProperty(definition, path);
        }
        if (child == null) {
            return null;
        }
        List values = child.getAccessor().getValues(base);
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (child instanceof RuntimeChildPrimitiveDatatypeDefinition && (value = (IBase)values.get(0)) instanceof IPrimitiveType && !((IPrimitiveType)value).hasValue()) {
            return null;
        }
        if (child instanceof RuntimeChildChoiceDefinition && !child.getElementName().equalsIgnoreCase(path) && !((IBase)values.get(0)).getClass().getSimpleName().equalsIgnoreCase(child.getChildByName(path).getImplementingClass().getSimpleName())) {
            return null;
        }
        return this.toJavaPrimitive(child.getMax() < 1 ? values : values.get(0), base);
    }

    protected BaseRuntimeElementCompositeDefinition<?> resolveRuntimeDefinition(IBase base) {
        if (base instanceof IAnyResource) {
            return this.getFhirContext().getResourceDefinition((IBaseResource)((IAnyResource)base));
        }
        if (base instanceof IBaseBackboneElement || base instanceof IBaseElement) {
            return (BaseRuntimeElementCompositeDefinition)this.getFhirContext().getElementDefinition(base.getClass());
        }
        if (base instanceof ICompositeType) {
            return (BaseRuntimeElementCompositeDefinition)this.getFhirContext().getElementDefinition(base.getClass());
        }
        throw new UnknownType(String.format("Unable to resolve the runtime definition for %s", base.getClass().getName()));
    }

    protected BaseRuntimeChildDefinition resolveChoiceProperty(BaseRuntimeElementCompositeDefinition<?> definition, String path) {
        for (Object child : definition.getChildren()) {
            RuntimeChildChoiceDefinition choiceDefinition;
            if (!(child instanceof RuntimeChildChoiceDefinition) || !(choiceDefinition = (RuntimeChildChoiceDefinition)child).getElementName().startsWith(path)) continue;
            return choiceDefinition;
        }
        return null;
    }

    private Class<?> deepSearch(String typeName) {
        String codelessName = typeName.replace("Codes", "").toLowerCase();
        String lowerName = typeName.toLowerCase();
        Collection elements = this.fhirContext.getElementDefinitions();
        for (BaseRuntimeElementDefinition element : elements) {
            Class<?>[] innerClasses;
            for (Class<?> clazz : innerClasses = element.getImplementingClass().getDeclaredClasses()) {
                String clazzLowerName = clazz.getSimpleName().toLowerCase();
                if (!clazzLowerName.equals(lowerName) && !clazzLowerName.equals(codelessName)) continue;
                return clazz;
            }
        }
        return null;
    }

    protected Object createInstance(Class<?> clazz) {
        try {
            if (clazz.isEnum()) {
                Class<?> factoryClass = this.resolveType(clazz.getName() + "EnumFactory");
                Object factory = this.createInstance(factoryClass);
                return this.enumConstructor(factory);
            }
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnknownType(String.format("Could not create an instance of class %s.\nRoot cause: %s", clazz.getName(), e.getMessage()));
        }
    }

    protected DateTime toDateTime(BaseDateTimeType value) {
        return this.toDateTime(value, this.getCalendarConstant(value));
    }

    protected Date toDate(BaseDateTimeType value) {
        return this.toDate(value, this.getCalendarConstant(value));
    }

    protected Time toTime(TimeType value) {
        return new Time(this.timeToString(value));
    }

    protected DateTime toDateTime(BaseDateTimeType value, Integer calendarConstant) {
        Calendar calendar = this.getCalendar(value);
        ZoneOffset zoneOffset = ((GregorianCalendar)calendar).toZonedDateTime().getOffset();
        switch (calendarConstant) {
            case 1: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1)});
            }
            case 2: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1), calendar.get(2) + 1});
            }
            case 5: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5)});
            }
            case 11: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11)});
            }
            case 12: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12)});
            }
            case 13: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13)});
            }
            case 14: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14)});
            }
        }
        throw new InvalidPrecision(String.format("Invalid temporal precision %s", calendarConstant));
    }

    protected Date toDate(BaseDateTimeType value, Integer calendarConstant) {
        Calendar calendar = this.getCalendar(value);
        switch (calendarConstant) {
            case 1: {
                return new Date(calendar.get(1));
            }
            case 2: {
                return new Date(calendar.get(1), calendar.get(2) + 1);
            }
            case 5: {
                return new Date(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
            }
        }
        throw new InvalidPrecision(String.format("Invalid temporal precision %s", calendarConstant));
    }

    public IBase setBaseValue(Object value, IBase target) {
        if (target instanceof IPrimitiveType) {
            this.setPrimitiveValue(value, (IPrimitiveType)target);
        }
        return (IBase)value;
    }

    public void setPrimitiveValue(Object value, IPrimitiveType target) {
        String simpleName;
        switch (simpleName = target.getClass().getSimpleName()) {
            case "DateTimeType": 
            case "InstantType": {
                target.setValue((Object)((DateTime)value).toJavaDate());
                this.setCalendarConstant(target, (BaseTemporal)value);
                break;
            }
            case "DateType": {
                target.setValue((Object)((Date)value).toJavaDate());
                this.setCalendarConstant(target, (BaseTemporal)value);
                break;
            }
            case "TimeType": {
                target.setValue((Object)value.toString());
                break;
            }
            case "Base64BinaryType": {
                target.setValueAsString((String)value);
                break;
            }
            default: {
                target.setValue(value);
            }
        }
    }

    public TemporalPrecisionEnum toTemporalPrecisionEnum(Precision precision) {
        switch (precision) {
            case YEAR: {
                return TemporalPrecisionEnum.YEAR;
            }
            case MONTH: {
                return TemporalPrecisionEnum.MONTH;
            }
            case DAY: {
                return TemporalPrecisionEnum.DAY;
            }
            case HOUR: 
            case MINUTE: {
                return TemporalPrecisionEnum.MINUTE;
            }
            case SECOND: {
                return TemporalPrecisionEnum.SECOND;
            }
            case MILLISECOND: {
                return TemporalPrecisionEnum.MILLI;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown precision %s", precision.toString()));
    }

    public Object toJavaPrimitive(Object result, Object source) {
        String simpleName;
        if (source instanceof IPrimitiveType && !((IPrimitiveType)source).hasValue()) {
            return null;
        }
        switch (simpleName = source.getClass().getSimpleName()) {
            case "InstantType": 
            case "DateTimeType": {
                return this.toDateTime(source);
            }
            case "DateType": {
                return this.toDate(source);
            }
            case "TimeType": {
                return this.toTime(source);
            }
            case "IdType": {
                return this.idToString(source);
            }
            case "Base64BinaryType": {
                return ((IPrimitiveType)source).getValueAsString();
            }
        }
        return result;
    }
}

