/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.model;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BaseDateTimeType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Count;
import org.hl7.fhir.r5.model.Distance;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MoneyQuantity;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SimpleQuantity;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UuidType;
import org.opencds.cqf.cql.engine.exception.InvalidCast;
import org.opencds.cqf.cql.engine.fhir.model.FhirModelResolver;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;

public class R5FhirModelResolver
extends FhirModelResolver<Base, BaseDateTimeType, TimeType, SimpleQuantity, IdType, Resource, Enumeration<?>, EnumFactory<?>> {
    public R5FhirModelResolver() {
        this(FhirContext.forR5());
    }

    protected R5FhirModelResolver(FhirContext fhirContext) {
        super(fhirContext);
        this.setPackageNames(Arrays.asList("org.hl7.fhir.r5.model"));
        if (fhirContext.getVersion().getVersion() != FhirVersionEnum.R5) {
            throw new IllegalArgumentException("The supplied context is not configured for R5");
        }
    }

    @Override
    protected void initialize() {
        this.fhirContext.getResourceDefinition(Enumerations.FHIRTypes.ACCOUNT.toCode());
        try {
            Field f = this.fhirContext.getClass().getDeclaredField("myNameToResourceType");
            f.setAccessible(true);
            Map myNameToResourceType = (Map)f.get(this.fhirContext);
            ArrayList<Class> toLoad = new ArrayList<Class>(myNameToResourceType.size());
            block5: for (Enumerations.FHIRTypes type : Enumerations.FHIRTypes.values()) {
                switch (type) {
                    case DOMAINRESOURCE: 
                    case RESOURCE: 
                    case NULL: {
                        continue block5;
                    }
                    default: {
                        if (!myNameToResourceType.containsKey(type.toCode().toLowerCase())) continue block5;
                        toLoad.add((Class)myNameToResourceType.get(type.toCode().toLowerCase()));
                    }
                }
            }
            Method m = this.fhirContext.getClass().getDeclaredMethod("scanResourceTypes", Collection.class);
            m.setAccessible(true);
            m.invoke((Object)this.fhirContext, toLoad);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected Object resolveProperty(Object target, String path) {
        if (target instanceof Resource && ((Resource)target).fhirType().equals(path)) {
            return target;
        }
        return super.resolveProperty(target, path);
    }

    @Override
    protected Boolean equalsDeep(Base left, Base right) {
        return left.equalsDeep(right);
    }

    @Override
    protected SimpleQuantity castToSimpleQuantity(Base base) {
        if (base instanceof SimpleQuantity) {
            return (SimpleQuantity)base;
        }
        if (base instanceof Quantity) {
            Quantity q = (Quantity)base;
            SimpleQuantity sq = new SimpleQuantity();
            sq.setValueElement(q.getValueElement());
            sq.setComparatorElement(q.getComparatorElement());
            sq.setUnitElement(q.getUnitElement());
            sq.setSystemElement(q.getSystemElement());
            sq.setCodeElement(q.getCodeElement());
            return sq;
        }
        throw new FHIRException("Unable to convert a " + base.getClass().getName() + " to an SimpleQuantity");
    }

    @Override
    protected Calendar getCalendar(BaseDateTimeType dateTime) {
        return dateTime.getValueAsCalendar();
    }

    @Override
    protected Integer getCalendarConstant(BaseDateTimeType dateTime) {
        return dateTime.getPrecision().getCalendarConstant();
    }

    @Override
    protected void setCalendarConstant(BaseDateTimeType dateTime, BaseTemporal temporal) {
        dateTime.setPrecision(this.toTemporalPrecisionEnum(temporal.getPrecision()));
    }

    @Override
    protected String timeToString(TimeType time) {
        return (String)time.getValue();
    }

    @Override
    protected String idToString(IdType id) {
        return id.getIdPart();
    }

    @Override
    protected String getResourceType(Resource resource) {
        return resource.fhirType();
    }

    @Override
    protected Enumeration<?> enumConstructor(EnumFactory<?> factory) {
        return new Enumeration(factory);
    }

    @Override
    protected Boolean enumChecker(Object object) {
        return object instanceof Enumeration;
    }

    @Override
    protected Class<?> enumFactoryTypeGetter(Enumeration<?> enumeration) {
        return enumeration.getEnumFactory().getClass();
    }

    @Override
    public Class<?> resolveType(String typeName) {
        switch (typeName) {
            case "ConfidentialityClassification": {
                typeName = "Composition$DocumentConfidentiality";
                break;
            }
            case "ContractResourceStatusCodes": {
                typeName = "Contract$ContractStatus";
                break;
            }
            case "EventStatus": {
                typeName = "Procedure$ProcedureStatus";
                break;
            }
            case "FinancialResourceStatusCodes": {
                typeName = "ClaimResponse$ClaimResponseStatus";
                break;
            }
            case "SampledDataDataType": {
                typeName = "StringType";
                break;
            }
            case "ClaimProcessingCodes": {
                typeName = "ClaimResponse$RemittanceOutcome";
                break;
            }
            case "vConfidentialityClassification": {
                typeName = "Composition$DocumentConfidentiality";
                break;
            }
            case "ContractResourcePublicationStatusCodes": {
                typeName = "Contract$ContractPublicationStatus";
                break;
            }
            case "CurrencyCode": {
                typeName = "CodeType";
                break;
            }
            case "MedicationAdministrationStatus": {
                typeName = "CodeType";
                break;
            }
            case "MedicationDispenseStatus": {
                typeName = "CodeType";
                break;
            }
            case "MedicationKnowledgeStatus": {
                typeName = "CodeType";
                break;
            }
            case "Messageheader_Response_Request": {
                typeName = "CodeType";
                break;
            }
            case "MimeType": {
                typeName = "CodeType";
                break;
            }
        }
        return super.resolveType(typeName);
    }

    public Boolean is(Object value, Class<?> type) {
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return true;
        }
        if (value instanceof UriType) {
            switch (type.getSimpleName()) {
                case "UrlType": {
                    return true;
                }
                case "CanonicalType": {
                    return true;
                }
                case "AnnotatedUuidType": 
                case "UuidType": {
                    return true;
                }
                case "OidType": {
                    return true;
                }
            }
        }
        if (value instanceof IntegerType) {
            switch (type.getSimpleName()) {
                case "PositiveIntType": {
                    return true;
                }
                case "UnsignedIntType": {
                    return true;
                }
            }
        }
        if (value instanceof StringType) {
            switch (type.getSimpleName()) {
                case "CodeType": {
                    return true;
                }
                case "MarkdownType": {
                    return true;
                }
                case "IdType": {
                    return true;
                }
            }
        }
        if (value instanceof Quantity) {
            switch (type.getSimpleName()) {
                case "Age": 
                case "Distance": 
                case "Duration": 
                case "Count": 
                case "SimpleQuantity": 
                case "MoneyQuantity": {
                    return true;
                }
            }
        }
        return false;
    }

    public Object as(Object value, Class<?> type, boolean isStrict) {
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof UriType) {
            UriType uriType = (UriType)value;
            switch (type.getSimpleName()) {
                case "UrlType": {
                    return uriType.hasPrimitiveValue() ? new UrlType(uriType.primitiveValue()) : null;
                }
                case "CanonicalType": {
                    return uriType.hasPrimitiveValue() ? new CanonicalType(uriType.primitiveValue()) : null;
                }
                case "AnnotatedUuidType": 
                case "UuidType": {
                    return uriType.hasPrimitiveValue() && ((String)uriType.getValue()).startsWith("urn:uuid:") ? new UuidType(uriType.primitiveValue()) : null;
                }
                case "OidType": {
                    return uriType.hasPrimitiveValue() && ((String)uriType.getValue()).startsWith("urn:oid:") ? new OidType(uriType.primitiveValue()) : null;
                }
            }
        }
        if (value instanceof IntegerType) {
            IntegerType integerType = (IntegerType)value;
            switch (type.getSimpleName()) {
                case "PositiveIntType": {
                    return integerType.hasPrimitiveValue() && (Integer)integerType.getValue() > 0 ? new PositiveIntType(integerType.primitiveValue()) : null;
                }
                case "UnsignedIntType": {
                    return integerType.hasPrimitiveValue() && (Integer)integerType.getValue() >= 0 ? new UnsignedIntType(integerType.primitiveValue()) : null;
                }
            }
        }
        if (value instanceof StringType) {
            StringType stringType = (StringType)value;
            switch (type.getSimpleName()) {
                case "CodeType": {
                    return stringType.hasPrimitiveValue() ? new CodeType(stringType.primitiveValue()) : null;
                }
                case "MarkdownType": {
                    return stringType.hasPrimitiveValue() ? new MarkdownType(stringType.primitiveValue()) : null;
                }
                case "IdType": {
                    return stringType.hasPrimitiveValue() ? new IdType(stringType.primitiveValue()) : null;
                }
            }
        }
        if (value instanceof Quantity) {
            Quantity quantity = (Quantity)value;
            switch (type.getSimpleName()) {
                case "Age": {
                    Age age = new Age();
                    age.setValue(quantity.getValue());
                    age.setCode(quantity.getCode());
                    return age;
                }
                case "Distance": {
                    Distance distance = new Distance();
                    distance.setValue(quantity.getValue());
                    distance.setCode(quantity.getCode());
                    return distance;
                }
                case "Duration": {
                    Duration duration = new Duration();
                    duration.setValue(quantity.getValue());
                    duration.setCode(quantity.getCode());
                    return duration;
                }
                case "Count": {
                    Count count = new Count();
                    count.setValue(quantity.getValue());
                    count.setCode(quantity.getCode());
                    return count;
                }
                case "SimpleQuantity": {
                    return this.castToSimpleQuantity((Base)quantity);
                }
                case "MoneyQuantity": {
                    MoneyQuantity moneyQuantity = new MoneyQuantity();
                    moneyQuantity.setValue(quantity.getValue());
                    moneyQuantity.setCode(quantity.getCode());
                    return moneyQuantity;
                }
            }
        }
        if (isStrict) {
            throw new InvalidCast(String.format("Cannot cast a value of type %s as %s.", value.getClass().getName(), type.getName()));
        }
        return null;
    }

    @Override
    public Object getContextPath(String contextType, String targetType) {
        if (targetType == null || contextType == null) {
            return null;
        }
        if (contextType.equals("Patient") && targetType.equals("MedicationStatement")) {
            return "subject";
        }
        if (contextType.equals("Patient") && targetType.equals("Task")) {
            return "for";
        }
        if (contextType.equals("Patient") && targetType.equals("Coverage")) {
            return "beneficiary";
        }
        return super.getContextPath(contextType, targetType);
    }
}

