/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.converter;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import java.math.BigDecimal;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.exception.InvalidPrecision;
import org.opencds.cqf.cql.engine.fhir.converter.FhirTypeConverter;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Concept;
import org.opencds.cqf.cql.engine.runtime.CqlType;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.Ratio;
import org.opencds.cqf.cql.engine.runtime.TemporalHelper;
import org.opencds.cqf.cql.engine.runtime.Time;
import org.opencds.cqf.cql.engine.runtime.Tuple;

abstract class BaseFhirTypeConverter
implements FhirTypeConverter {
    BaseFhirTypeConverter() {
    }

    @Override
    public boolean isFhirType(Object value) {
        Objects.requireNonNull(value, "value can not be null");
        if (value instanceof Iterable) {
            throw new IllegalArgumentException("isFhirType can not be used for Iterables");
        }
        return value instanceof IBase;
    }

    @Override
    public List<Object> toFhirTypes(Iterable<?> values) {
        ArrayList<Object> converted = new ArrayList<Object>();
        for (Object value : values) {
            if (value == null) {
                converted.add(null);
                continue;
            }
            if (value instanceof Iterable) {
                converted.add(this.toFhirTypes((Iterable)value));
                continue;
            }
            if (this.isFhirType(value)) {
                converted.add(value);
                continue;
            }
            if (this.isCqlType(value)) {
                converted.add(this.toFhirType(value));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown type encountered during conversion %s", value.getClass().getName()));
        }
        return converted;
    }

    @Override
    public IBase toFhirType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            throw new IllegalArgumentException("use toFhirTypes(Iterable<Object>) for iterables");
        }
        if (this.isFhirType(value)) {
            return (IBase)value;
        }
        if (!this.isCqlType(value)) {
            throw new IllegalArgumentException(String.format("can't convert %s to FHIR type", value.getClass().getName()));
        }
        switch (value.getClass().getSimpleName()) {
            case "Boolean": {
                return this.toFhirBoolean((Boolean)value);
            }
            case "Integer": {
                return this.toFhirInteger((Integer)value);
            }
            case "Long": {
                return this.toFhirInteger64((Long)value);
            }
            case "BigDecimal": {
                return this.toFhirDecimal((BigDecimal)value);
            }
            case "Date": {
                return this.toFhirDate((Date)value);
            }
            case "DateTime": {
                return this.toFhirDateTime((DateTime)value);
            }
            case "Time": {
                return this.toFhirTime((Time)value);
            }
            case "String": {
                return this.toFhirString((String)value);
            }
            case "Quantity": {
                return this.toFhirQuantity((Quantity)value);
            }
            case "Ratio": {
                return this.toFhirRatio((Ratio)value);
            }
            case "Any": {
                return this.toFhirAny(value);
            }
            case "Code": {
                return this.toFhirCoding((Code)value);
            }
            case "Concept": {
                return this.toFhirCodeableConcept((Concept)value);
            }
            case "Interval": {
                return this.toFhirInterval((Interval)value);
            }
            case "Tuple": {
                return this.toFhirTuple((Tuple)value);
            }
        }
        throw new IllegalArgumentException(String.format("missing case statement for: %s", value.getClass().getName()));
    }

    @Override
    public boolean isCqlCalendarUnit(String unit) {
        if (unit == null) {
            return false;
        }
        switch (unit) {
            case "milliseconds": 
            case "millisecond": 
            case "seconds": 
            case "second": 
            case "minutes": 
            case "minute": 
            case "hours": 
            case "hour": 
            case "days": 
            case "day": 
            case "weeks": 
            case "week": 
            case "months": 
            case "month": 
            case "years": 
            case "year": {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toUcumUnit(String unit) {
        if (unit == null) {
            return null;
        }
        switch (unit) {
            case "milliseconds": 
            case "millisecond": {
                return "ms";
            }
            case "seconds": 
            case "second": {
                return "s";
            }
            case "minutes": 
            case "minute": {
                return "min";
            }
            case "hours": 
            case "hour": {
                return "h";
            }
            case "days": 
            case "day": {
                return "d";
            }
            case "weeks": 
            case "week": {
                return "wk";
            }
            case "months": 
            case "month": {
                return "mo";
            }
            case "years": 
            case "year": {
                return "a";
            }
        }
        return unit;
    }

    @Override
    public String toCqlCalendarUnit(String unit) {
        if (unit == null) {
            return null;
        }
        switch (unit) {
            case "ms": {
                return "millisecond";
            }
            case "s": {
                return "second";
            }
            case "min": {
                return "minute";
            }
            case "h": {
                return "hour";
            }
            case "d": {
                return "day";
            }
            case "wk": {
                return "week";
            }
            case "mo": {
                return "month";
            }
            case "a": {
                return "year";
            }
        }
        return unit;
    }

    @Override
    public ICompositeType toFhirInterval(Interval value) {
        if (value == null) {
            return null;
        }
        switch (this.getSimpleName(value.getPointType().getTypeName())) {
            case "Date": 
            case "DateTime": {
                return this.toFhirPeriod(value);
            }
            case "Quantity": {
                return this.toFhirRange(value);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported interval point type for FHIR conversion %s", value.getPointType().getTypeName()));
    }

    @Override
    public boolean isCqlType(Object value) {
        Objects.requireNonNull(value, "value can not be null");
        if (value instanceof Iterable) {
            throw new IllegalArgumentException("isCqlType can not be used for Iterables");
        }
        return value instanceof BigDecimal || value instanceof String || value instanceof Integer || value instanceof Boolean || value instanceof Long || value instanceof CqlType;
    }

    @Override
    public Iterable<Object> toCqlTypes(Iterable<?> values) {
        ArrayList<Object> converted = new ArrayList<Object>();
        for (Object value : values) {
            if (value == null) {
                converted.add(null);
                continue;
            }
            if (value instanceof Iterable) {
                converted.add(this.toCqlTypes((Iterable)value));
                continue;
            }
            if (this.isCqlType(value)) {
                converted.add(value);
                continue;
            }
            if (this.isFhirType(value)) {
                converted.add(this.toCqlType(value));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown type encountered during conversion %s", value.getClass().getName()));
        }
        return converted;
    }

    @Override
    public Object toCqlType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            throw new IllegalArgumentException("use toCqlTypes(Iterable<Object>) for iterables");
        }
        if (this.isCqlType(value)) {
            return value;
        }
        if (!this.isFhirType(value)) {
            throw new IllegalArgumentException(String.format("can't convert %s to CQL type", value.getClass().getName()));
        }
        switch (value.getClass().getSimpleName()) {
            case "IdType": {
                return this.toCqlId((IIdType)value);
            }
            case "BooleanType": {
                return this.toCqlBoolean((IPrimitiveType<Boolean>)((IPrimitiveType)value));
            }
            case "IntegerType": {
                return this.toCqlInteger((IPrimitiveType<Integer>)((IPrimitiveType)value));
            }
            case "Integer64Type": {
                return this.toCqlLong((IPrimitiveType<Long>)((IPrimitiveType)value));
            }
            case "DecimalType": {
                return this.toCqlDecimal((IPrimitiveType<BigDecimal>)((IPrimitiveType)value));
            }
            case "DateType": {
                return this.toCqlDate((IPrimitiveType<java.util.Date>)((IPrimitiveType)value));
            }
            case "InstantType": 
            case "DateTimeType": {
                return this.toCqlDateTime((IPrimitiveType<java.util.Date>)((IPrimitiveType)value));
            }
            case "TimeType": {
                return this.toCqlTime((IPrimitiveType<String>)((IPrimitiveType)value));
            }
            case "StringType": {
                return this.toCqlString((IPrimitiveType<String>)((IPrimitiveType)value));
            }
            case "Quantity": {
                return this.toCqlQuantity((ICompositeType)value);
            }
            case "Ratio": {
                return this.toCqlRatio((ICompositeType)value);
            }
            case "Coding": {
                return this.toCqlCode((IBaseCoding)value);
            }
            case "CodeableConcept": {
                return this.toCqlConcept((ICompositeType)value);
            }
            case "Period": 
            case "Range": {
                return this.toCqlInterval((ICompositeType)value);
            }
        }
        throw new IllegalArgumentException(String.format("missing case statement for: %s", value.getClass().getName()));
    }

    @Override
    public String toCqlId(IIdType value) {
        if (value == null) {
            return null;
        }
        return value.getIdPart();
    }

    @Override
    public Boolean toCqlBoolean(IPrimitiveType<Boolean> value) {
        if (value == null) {
            return null;
        }
        return (Boolean)value.getValue();
    }

    @Override
    public Integer toCqlInteger(IPrimitiveType<Integer> value) {
        if (value == null) {
            return null;
        }
        return (Integer)value.getValue();
    }

    @Override
    public Long toCqlLong(IPrimitiveType<Long> value) {
        if (value == null) {
            return null;
        }
        return (Long)value.getValue();
    }

    @Override
    public BigDecimal toCqlDecimal(IPrimitiveType<BigDecimal> value) {
        if (value == null) {
            return null;
        }
        return (BigDecimal)value.getValue();
    }

    @Override
    public Time toCqlTime(IPrimitiveType<String> value) {
        if (value == null) {
            return null;
        }
        return new Time((String)value.getValue());
    }

    @Override
    public String toCqlString(IPrimitiveType<String> value) {
        if (value == null) {
            return null;
        }
        return (String)value.getValue();
    }

    @Override
    public Tuple toCqlTuple(IBase value) {
        if (value == null) {
            return null;
        }
        throw new NotImplementedException("toCqlTuple is not yet implemented");
    }

    protected String getSimpleName(String typeName) {
        String[] nameParts = typeName.split("\\.");
        return nameParts[nameParts.length - 1];
    }

    protected Time toTime(Calendar calendar, Integer calendarConstant) {
        switch (calendarConstant) {
            case 10: {
                return new Time(new int[]{calendar.get(10)});
            }
            case 12: {
                return new Time(new int[]{calendar.get(10), calendar.get(12)});
            }
            case 13: {
                return new Time(new int[]{calendar.get(10), calendar.get(12), calendar.get(13)});
            }
            case 14: {
                return new Time(new int[]{calendar.get(10), calendar.get(12), calendar.get(13), calendar.get(14)});
            }
        }
        throw new InvalidPrecision(String.format("Invalid temporal precision %s", calendarConstant));
    }

    protected DateTime toDateTime(Calendar calendar, Integer calendarConstant) {
        TimeZone tz = calendar.getTimeZone() == null ? TimeZone.getDefault() : calendar.getTimeZone();
        ZoneOffset zoneOffset = tz.toZoneId().getRules().getStandardOffset(calendar.toInstant());
        switch (calendarConstant) {
            case 1: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1)});
            }
            case 2: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1), calendar.get(2) + 1});
            }
            case 5: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5)});
            }
            case 11: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11)});
            }
            case 12: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12)});
            }
            case 13: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13)});
            }
            case 14: {
                return new DateTime(TemporalHelper.zoneToOffset((ZoneOffset)zoneOffset), new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14)});
            }
        }
        throw new InvalidPrecision(String.format("Invalid temporal precision %s", calendarConstant));
    }

    protected Date toDate(Calendar calendar, Integer calendarConstant) {
        switch (calendarConstant) {
            case 1: {
                return new Date(calendar.get(1));
            }
            case 2: {
                return new Date(calendar.get(1), calendar.get(2) + 1);
            }
            case 5: {
                return new Date(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
            }
        }
        throw new InvalidPrecision(String.format("Invalid temporal precision %s", calendarConstant));
    }

    protected TemporalPrecisionEnum toFhirPrecision(Precision precision) {
        String name = null;
        switch (precision) {
            case WEEK: 
            case HOUR: 
            case MINUTE: {
                name = TemporalPrecisionEnum.DAY.name();
                break;
            }
            case MILLISECOND: {
                name = TemporalPrecisionEnum.MILLI.name();
                break;
            }
            default: {
                name = precision.name();
            }
        }
        return TemporalPrecisionEnum.valueOf((String)name);
    }
}

