/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.model;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import org.hl7.fhir.dstu2.model.Age;
import org.hl7.fhir.dstu2.model.AnnotatedUuidType;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BaseDateTimeType;
import org.hl7.fhir.dstu2.model.Count;
import org.hl7.fhir.dstu2.model.Distance;
import org.hl7.fhir.dstu2.model.Duration;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.IdType;
import org.hl7.fhir.dstu2.model.IntegerType;
import org.hl7.fhir.dstu2.model.OidType;
import org.hl7.fhir.dstu2.model.PositiveIntType;
import org.hl7.fhir.dstu2.model.Quantity;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.TimeType;
import org.hl7.fhir.dstu2.model.UnsignedIntType;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.dstu2.model.UuidType;
import org.opencds.cqf.cql.engine.exception.InvalidCast;
import org.opencds.cqf.cql.engine.fhir.model.FhirModelResolver;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;

public class Dstu2FhirModelResolver
extends FhirModelResolver<Base, BaseDateTimeType, TimeType, SimpleQuantity, IdType, Resource, Enumeration<?>, EnumFactory<?>> {
    public Dstu2FhirModelResolver() {
        this(FhirContext.forDstu2());
    }

    protected Dstu2FhirModelResolver(FhirContext fhirContext) {
        super(fhirContext);
        this.setPackageNames(Arrays.asList("ca.uhn.fhir.model.dstu2", "org.hl7.fhir.dstu2.model", "ca.uhn.fhir.model.primitive"));
        if (fhirContext.getVersion().getVersion() != FhirVersionEnum.DSTU2) {
            throw new IllegalArgumentException("The supplied context is not configured for DSTU2");
        }
    }

    @Override
    protected void initialize() {
        this.fhirContext.registerCustomType(AnnotatedUuidType.class);
        this.fhirContext.getResourceDefinition(Enumerations.ResourceType.ACCOUNT.toCode());
        try {
            Field f = this.fhirContext.getClass().getDeclaredField("myNameToResourceType");
            f.setAccessible(true);
            Map myNameToResourceType = (Map)f.get(this.fhirContext);
            ArrayList<Class> toLoad = new ArrayList<Class>(myNameToResourceType.size());
            block5: for (Enumerations.ResourceType type : Enumerations.ResourceType.values()) {
                switch (type) {
                    case DOMAINRESOURCE: 
                    case RESOURCE: 
                    case NULL: {
                        continue block5;
                    }
                    default: {
                        if (!myNameToResourceType.containsKey(type.toCode().toLowerCase())) continue block5;
                        toLoad.add((Class)myNameToResourceType.get(type.toCode().toLowerCase()));
                    }
                }
            }
            Method m = this.fhirContext.getClass().getDeclaredMethod("scanResourceTypes", Collection.class);
            m.setAccessible(true);
            m.invoke((Object)this.fhirContext, toLoad);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected Boolean equalsDeep(Base left, Base right) {
        return left.equalsDeep(right);
    }

    @Override
    protected SimpleQuantity castToSimpleQuantity(Base base) {
        return base.castToSimpleQuantity(base);
    }

    @Override
    protected Calendar getCalendar(BaseDateTimeType dateTime) {
        return dateTime.toCalendar();
    }

    @Override
    protected Integer getCalendarConstant(BaseDateTimeType dateTime) {
        return dateTime.getPrecision().getCalendarConstant();
    }

    @Override
    protected void setCalendarConstant(BaseDateTimeType dateTime, BaseTemporal temporal) {
        dateTime.setPrecision(this.toTemporalPrecisionEnum(temporal.getPrecision()));
    }

    @Override
    protected String timeToString(TimeType time) {
        return (String)time.getValue();
    }

    @Override
    protected String idToString(IdType id) {
        return id.getIdPart();
    }

    @Override
    protected String getResourceType(Resource resource) {
        return resource.fhirType();
    }

    @Override
    protected Enumeration<?> enumConstructor(EnumFactory<?> factory) {
        return new Enumeration(factory);
    }

    @Override
    protected Boolean enumChecker(Object object) {
        return object instanceof Enumeration;
    }

    @Override
    protected Class<?> enumFactoryTypeGetter(Enumeration<?> enumeration) {
        Enum value = (Enum)enumeration.getValue();
        if (value != null) {
            String enumSimpleName = value.getClass().getSimpleName();
            return this.resolveType(enumSimpleName + "EnumFactory");
        }
        try {
            Field myEnumFactoryField = enumeration.getClass().getDeclaredField("myEnumFactory");
            myEnumFactoryField.setAccessible(true);
            EnumFactory factory = (EnumFactory)myEnumFactoryField.get(enumeration);
            return factory.getClass();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Boolean is(Object value, Class<?> type) {
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return true;
        }
        if (value instanceof UriType) {
            switch (type.getSimpleName()) {
                case "UrlType": {
                    return true;
                }
                case "CanonicalType": {
                    return true;
                }
                case "AnnotatedUuidType": 
                case "UuidType": {
                    return true;
                }
                case "OidType": {
                    return true;
                }
            }
        }
        if (value instanceof IntegerType) {
            switch (type.getSimpleName()) {
                case "PositiveIntType": {
                    return true;
                }
                case "UnsignedIntType": {
                    return true;
                }
            }
        }
        if (value instanceof StringType) {
            switch (type.getSimpleName()) {
                case "CodeType": {
                    return true;
                }
                case "MarkdownType": {
                    return true;
                }
                case "IdType": {
                    return true;
                }
            }
        }
        if (value instanceof Quantity) {
            switch (type.getSimpleName()) {
                case "Age": 
                case "Distance": 
                case "Duration": 
                case "Count": 
                case "SimpleQuantity": {
                    return true;
                }
            }
        }
        return false;
    }

    public Object as(Object value, Class<?> type, boolean isStrict) {
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof UriType) {
            UriType uriType = (UriType)value;
            switch (type.getSimpleName()) {
                case "AnnotatedUuidType": 
                case "UuidType": {
                    return uriType.hasValue() && ((String)uriType.getValue()).startsWith("urn:uuid:") ? new UuidType(uriType.primitiveValue()) : null;
                }
                case "OidType": {
                    return uriType.hasValue() && ((String)uriType.getValue()).startsWith("urn:oid:") ? new OidType(uriType.primitiveValue()) : null;
                }
            }
        }
        if (value instanceof IntegerType) {
            IntegerType integerType = (IntegerType)value;
            switch (type.getSimpleName()) {
                case "PositiveIntType": {
                    return integerType.hasValue() && (Integer)integerType.getValue() > 0 ? new PositiveIntType(integerType.primitiveValue()) : null;
                }
                case "UnsignedIntType": {
                    return integerType.hasValue() && (Integer)integerType.getValue() >= 0 ? new UnsignedIntType(integerType.primitiveValue()) : null;
                }
            }
        }
        if (value instanceof StringType) {
            StringType stringType = (StringType)value;
            switch (type.getSimpleName()) {
                case "CodeType": {
                    return stringType.castToCode((Base)stringType);
                }
                case "MarkdownType": {
                    return stringType.castToMarkdown((Base)stringType);
                }
                case "IdType": {
                    return stringType.hasValue() ? new IdType(stringType.primitiveValue()) : null;
                }
            }
        }
        if (value instanceof Quantity) {
            Quantity quantity = (Quantity)value;
            switch (type.getSimpleName()) {
                case "Age": {
                    Age age = new Age();
                    age.setValue(quantity.getValue());
                    age.setCode(quantity.getCode());
                    age.setUnit(quantity.getUnit());
                    age.setSystem(quantity.getSystem());
                    age.setComparator(quantity.getComparator());
                    return age;
                }
                case "Distance": {
                    Distance distance = new Distance();
                    distance.setValue(quantity.getValue());
                    distance.setCode(quantity.getCode());
                    distance.setUnit(quantity.getUnit());
                    distance.setSystem(quantity.getSystem());
                    distance.setComparator(quantity.getComparator());
                    return distance;
                }
                case "Duration": {
                    Duration duration = new Duration();
                    duration.setValue(quantity.getValue());
                    duration.setCode(quantity.getCode());
                    duration.setUnit(quantity.getUnit());
                    duration.setSystem(quantity.getSystem());
                    duration.setComparator(quantity.getComparator());
                    return duration;
                }
                case "Count": {
                    Count count = new Count();
                    count.setValue(quantity.getValue());
                    count.setCode(quantity.getCode());
                    count.setUnit(quantity.getUnit());
                    count.setSystem(quantity.getSystem());
                    count.setComparator(quantity.getComparator());
                    return count;
                }
                case "SimpleQuantity": {
                    return quantity.castToSimpleQuantity((Base)quantity);
                }
            }
        }
        if (isStrict) {
            throw new InvalidCast(String.format("Cannot cast a value of type %s as %s.", value.getClass().getName(), type.getName()));
        }
        return null;
    }

    @Override
    public Object getContextPath(String contextType, String targetType) {
        if (targetType == null || contextType == null) {
            return null;
        }
        return super.getContextPath(contextType, targetType);
    }
}

