/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.converter;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BaseDateTimeType;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.OperationOutcome;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.elm.executing.ToStringEvaluator;
import org.opencds.cqf.cql.engine.fhir.converter.BaseFhirTypeConverter;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Concept;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Ratio;
import org.opencds.cqf.cql.engine.runtime.Time;
import org.opencds.cqf.cql.engine.runtime.Tuple;

class Dstu3FhirTypeConverter
extends BaseFhirTypeConverter {
    Dstu3FhirTypeConverter() {
    }

    @Override
    public IIdType toFhirId(String value) {
        if (value == null) {
            return null;
        }
        return new IdType(value);
    }

    public BooleanType toFhirBoolean(Boolean value) {
        if (value == null) {
            return null;
        }
        return new BooleanType(value);
    }

    @Override
    public IPrimitiveType<Integer> toFhirInteger(Integer value) {
        if (value == null) {
            return null;
        }
        return new IntegerType(value.intValue());
    }

    @Override
    public IPrimitiveType<Long> toFhirInteger64(Long value) {
        throw new IllegalArgumentException("FHIR DSTU3 does not support Long/Integer64 values");
    }

    @Override
    public IPrimitiveType<BigDecimal> toFhirDecimal(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return new DecimalType(value);
    }

    @Override
    public IPrimitiveType<java.util.Date> toFhirDate(Date value) {
        if (value == null) {
            return null;
        }
        return new DateType(value.toString());
    }

    @Override
    public IPrimitiveType<java.util.Date> toFhirDateTime(DateTime value) {
        if (value == null) {
            return null;
        }
        DateTimeType result = new DateTimeType(value.getDateTime().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        result.setPrecision(this.toFhirPrecision(value.getPrecision()));
        return result;
    }

    @Override
    public IPrimitiveType<String> toFhirTime(Time value) {
        if (value == null) {
            return null;
        }
        return new TimeType(value.toString());
    }

    @Override
    public IPrimitiveType<String> toFhirString(String value) {
        if (value == null) {
            return null;
        }
        return new StringType(value);
    }

    @Override
    public ICompositeType toFhirQuantity(org.opencds.cqf.cql.engine.runtime.Quantity value) {
        if (value == null) {
            return null;
        }
        String unit = value.getUnit();
        String system = this.isCqlCalendarUnit(unit) ? "http://hl7.org/fhirpath/CodeSystem/calendar-units" : "http://unitsofmeasure.org";
        String ucumUnit = this.toUcumUnit(unit);
        return new Quantity().setSystem(system).setCode(ucumUnit).setValue(value.getValue()).setUnit(unit);
    }

    @Override
    public ICompositeType toFhirRatio(Ratio value) {
        if (value == null) {
            return null;
        }
        return new org.hl7.fhir.dstu3.model.Ratio().setNumerator((Quantity)this.toFhirQuantity(value.getNumerator())).setDenominator((Quantity)this.toFhirQuantity(value.getDenominator()));
    }

    @Override
    public IBase toFhirAny(Object value) {
        if (value == null) {
            return null;
        }
        throw new NotImplementedException("Unable to convert System.Any types");
    }

    @Override
    public IBaseCoding toFhirCoding(Code value) {
        if (value == null) {
            return null;
        }
        Coding coding = new Coding();
        coding.setSystem(value.getSystem());
        coding.setCode(value.getCode());
        coding.setDisplay(value.getDisplay());
        coding.setVersion(value.getVersion());
        return coding;
    }

    @Override
    public ICompositeType toFhirCodeableConcept(Concept value) {
        if (value == null) {
            return null;
        }
        CodeableConcept codeableConcept = new CodeableConcept();
        codeableConcept.setText(value.getDisplay());
        if (value.getCodes() != null) {
            for (Code c : value.getCodes()) {
                codeableConcept.addCoding((Coding)this.toFhirCoding(c));
            }
        }
        return codeableConcept;
    }

    @Override
    public ICompositeType toFhirPeriod(Interval value) {
        if (value == null) {
            return null;
        }
        Period period = new Period();
        if (this.getSimpleName(value.getPointType().getTypeName()).equals("DateTime")) {
            if (value.getStart() != null) {
                period.setStartElement((DateTimeType)this.toFhirDateTime((DateTime)value.getStart()));
            }
            if (value.getEnd() != null) {
                period.setEndElement((DateTimeType)this.toFhirDateTime((DateTime)value.getEnd()));
            }
            return period;
        }
        if (this.getSimpleName(value.getPointType().getTypeName()).equals("Date")) {
            if (value.getStart() != null) {
                period.setStart((java.util.Date)this.toFhirDate((Date)value.getStart()).getValue());
            }
            if (value.getEnd() != null) {
                period.setEnd((java.util.Date)this.toFhirDate((Date)value.getEnd()).getValue());
            }
            return period;
        }
        throw new IllegalArgumentException("FHIR Period can only be created from an Interval of Date or DateTime type");
    }

    @Override
    public ICompositeType toFhirRange(Interval value) {
        Quantity end;
        if (value == null) {
            return null;
        }
        if (!this.getSimpleName(value.getPointType().getTypeName()).equals("Quantity")) {
            throw new IllegalArgumentException("FHIR Range can only be created from an Interval of Quantity type");
        }
        Range range = new Range();
        Quantity start = (Quantity)this.toFhirQuantity((org.opencds.cqf.cql.engine.runtime.Quantity)value.getStart());
        if (start != null) {
            range.setLow(start.castToSimpleQuantity((Base)start));
        }
        if ((end = (Quantity)this.toFhirQuantity((org.opencds.cqf.cql.engine.runtime.Quantity)value.getEnd())) != null) {
            range.setHigh(end.castToSimpleQuantity((Base)end));
        }
        return range;
    }

    private static BooleanType emptyBooleanWithExtension(String url, Type value) {
        BooleanType result = new BooleanType((String)null);
        result.addExtension().setUrl(url).setValue(value);
        return result;
    }

    private static void addPartWithNameAndValue(Parameters.ParametersParameterComponent param, String key, Object value) {
        if (value instanceof Parameters.ParametersParameterComponent) {
            Parameters.ParametersParameterComponent part = (Parameters.ParametersParameterComponent)value;
            part.setName(key);
            param.addPart(part);
        } else {
            Parameters.ParametersParameterComponent part = param.addPart().setName(key);
            if (value instanceof Resource) {
                part.setResource((Resource)value);
            } else if (value instanceof Type) {
                part.setValue((Type)value);
            } else {
                throw new IllegalArgumentException("Unsupported FHIR type: " + value.getClass().getName());
            }
        }
    }

    private static Iterable<?> asIterable(Object value) {
        if (value instanceof Iterable) {
            return (Iterable)value;
        }
        return null;
    }

    private void addElementToParameter(Parameters.ParametersParameterComponent param, String key, Object value) {
        if (value == null) {
            BooleanType dataAbsentValue = Dstu3FhirTypeConverter.emptyBooleanWithExtension("http://hl7.org/fhir/StructureDefinition/data-absent-reason", (Type)new CodeType("unknown"));
            Dstu3FhirTypeConverter.addPartWithNameAndValue(param, key, dataAbsentValue);
            return;
        }
        Iterable<?> iterable = Dstu3FhirTypeConverter.asIterable(value);
        if (iterable == null) {
            Dstu3FhirTypeConverter.addPartWithNameAndValue(param, key, this.toFhirType(value));
            return;
        }
        if (!iterable.iterator().hasNext()) {
            BooleanType emptyListValue = Dstu3FhirTypeConverter.emptyBooleanWithExtension("http://hl7.org/fhir/StructureDefinition/cqf-isEmptyList", (Type)new BooleanType(true));
            Dstu3FhirTypeConverter.addPartWithNameAndValue(param, key, emptyListValue);
        } else {
            List<Object> fhirTypes = this.toFhirTypes(iterable);
            for (Object fhirType : fhirTypes) {
                Dstu3FhirTypeConverter.addPartWithNameAndValue(param, key, fhirType);
            }
        }
    }

    @Override
    public IBase toFhirTuple(Tuple value) {
        if (value == null) {
            return null;
        }
        Parameters parameters = new Parameters();
        Parameters.ParametersParameterComponent param = parameters.addParameter();
        if (value.getElements().isEmpty()) {
            param.setValue((Type)Dstu3FhirTypeConverter.emptyBooleanWithExtension("http://hl7.org/fhir/StructureDefinition/cqf-isEmptyTuple", (Type)new BooleanType(true)));
        }
        for (String key : value.getElements().keySet()) {
            this.addElementToParameter(param, key, value.getElements().get(key));
        }
        return param;
    }

    @Override
    public org.opencds.cqf.cql.engine.runtime.Quantity toCqlQuantity(ICompositeType value) {
        if (value == null) {
            return null;
        }
        if (!value.fhirType().equals("Quantity")) {
            throw new IllegalArgumentException("value is not a FHIR Quantity");
        }
        Quantity quantity = (Quantity)value;
        if (quantity.hasComparator()) {
            throw new IllegalArgumentException("Cannot convert a FHIR Quantity with a comparator to a CQL quantity");
        }
        return new org.opencds.cqf.cql.engine.runtime.Quantity().withUnit(this.toCqlCalendarUnit(quantity.getUnit())).withValue(quantity.getValue());
    }

    @Override
    public Ratio toCqlRatio(ICompositeType value) {
        if (value == null) {
            return null;
        }
        if (!value.fhirType().equals("Ratio")) {
            throw new IllegalArgumentException("value is not a FHIR Ratio");
        }
        org.hl7.fhir.dstu3.model.Ratio ratio = (org.hl7.fhir.dstu3.model.Ratio)value;
        return new Ratio().setNumerator(this.toCqlQuantity((ICompositeType)ratio.getNumerator())).setDenominator(this.toCqlQuantity((ICompositeType)ratio.getDenominator()));
    }

    @Override
    public Object toCqlAny(IBase value) {
        if (value == null) {
            return null;
        }
        throw new NotImplementedException("Unable to convert to System.Any type");
    }

    @Override
    public Code toCqlCode(IBaseCoding value) {
        if (value == null) {
            return null;
        }
        Coding coding = (Coding)value;
        return new Code().withSystem(coding.getSystem()).withCode(coding.getCode()).withVersion(coding.getVersion()).withDisplay(coding.getDisplay());
    }

    @Override
    public Concept toCqlConcept(ICompositeType value) {
        if (value == null) {
            return null;
        }
        if (!value.fhirType().equals("CodeableConcept")) {
            throw new IllegalArgumentException("value is not a FHIR CodeableConcept");
        }
        CodeableConcept codeableConcept = (CodeableConcept)value;
        return new Concept().withDisplay(codeableConcept.getText()).withCodes((Iterable)codeableConcept.getCoding().stream().map(x -> this.toCqlCode((IBaseCoding)x)).collect(Collectors.toList()));
    }

    @Override
    public Interval toCqlInterval(ICompositeType value) {
        if (value == null) {
            return null;
        }
        if (value.fhirType().equals("Range")) {
            Range range = (Range)value;
            return new Interval((Object)this.toCqlQuantity((ICompositeType)range.getLow()), true, (Object)this.toCqlQuantity((ICompositeType)range.getHigh()), true);
        }
        if (value.fhirType().equals("Period")) {
            Period period = (Period)value;
            return new Interval((Object)this.toCqlTemporal((IPrimitiveType<java.util.Date>)period.getStartElement()), true, (Object)this.toCqlTemporal((IPrimitiveType<java.util.Date>)period.getEndElement()), true);
        }
        throw new IllegalArgumentException("value is not a FHIR Range or Period");
    }

    @Override
    public Date toCqlDate(IPrimitiveType<java.util.Date> value) {
        if (value == null) {
            return null;
        }
        if (!value.fhirType().equals("date") || value.fhirType().equals("dateTime")) {
            throw new IllegalArgumentException("value is not a FHIR Date or DateTime");
        }
        BaseDateTimeType baseDateTime = (BaseDateTimeType)value;
        switch (baseDateTime.getPrecision()) {
            case YEAR: 
            case DAY: 
            case MONTH: {
                return this.toDate(baseDateTime.getValueAsCalendar(), baseDateTime.getPrecision().getCalendarConstant());
            }
        }
        throw new IllegalArgumentException("value has a precision higher than a CQL Date");
    }

    @Override
    public DateTime toCqlDateTime(IPrimitiveType<java.util.Date> value) {
        if (value == null) {
            return null;
        }
        if (value.fhirType().equals("instant") || value.fhirType().equals("dateTime")) {
            BaseDateTimeType baseDateTime = (BaseDateTimeType)value;
            return this.toDateTime(baseDateTime.getValueAsCalendar(), baseDateTime.getPrecision().getCalendarConstant());
        }
        throw new IllegalArgumentException("value is not a FHIR Instant or DateTime");
    }

    @Override
    public BaseTemporal toCqlTemporal(IPrimitiveType<java.util.Date> value) {
        if (value == null) {
            return null;
        }
        if (value.fhirType().equals("instant") || value.fhirType().equals("dateTime") || value.fhirType().equals("date")) {
            BaseDateTimeType baseDateTime = (BaseDateTimeType)value;
            switch (baseDateTime.getPrecision()) {
                case YEAR: 
                case DAY: 
                case MONTH: {
                    return this.toDate(baseDateTime.getValueAsCalendar(), baseDateTime.getPrecision().getCalendarConstant());
                }
            }
            return this.toDateTime(baseDateTime.getValueAsCalendar(), baseDateTime.getPrecision().getCalendarConstant());
        }
        throw new IllegalArgumentException("value is not a FHIR Instant or DateTime");
    }

    @Override
    public IBaseOperationOutcome toFhirOperationOutcome(Exception exception) {
        if (exception == null) {
            return null;
        }
        OperationOutcome outcome = new OperationOutcome();
        outcome.addIssue().setSeverity(OperationOutcome.IssueSeverity.ERROR).setCode(OperationOutcome.IssueType.EXCEPTION).setDiagnostics(exception.getMessage()).addExtension("http://hl7.org/fhir/StructureDefinition/cqf-nativeStackTrace", (Type)new StringType(this.getStackTraceAsString(exception)));
        return outcome;
    }

    @Override
    public IBaseDatatype toCqlText(Object value) {
        if (value == null) {
            return null;
        }
        String s = (String)ToStringEvaluator.toString((Object)value);
        StringType text = new StringType(s);
        text.addExtension("http://hl7.org/fhir/StructureDefinition/cqf-cqlText", (Type)new BooleanType(true));
        return text;
    }
}

