/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.retrieve;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import org.opencds.cqf.cql.engine.fhir.exception.FhirVersionMisMatchException;
import org.opencds.cqf.cql.engine.fhir.retrieve.BaseFhirQueryGenerator;
import org.opencds.cqf.cql.engine.fhir.retrieve.Dstu3FhirQueryGenerator;
import org.opencds.cqf.cql.engine.fhir.retrieve.R4FhirQueryGenerator;
import org.opencds.cqf.cql.engine.fhir.searchparam.SearchParameterMap;
import org.opencds.cqf.cql.engine.fhir.searchparam.SearchParameterResolver;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.cql.engine.retrieve.TerminologyAwareRetrieveProvider;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Interval;

public abstract class SearchParamFhirRetrieveProvider
extends TerminologyAwareRetrieveProvider {
    protected FhirContext fhirContext;
    protected SearchParameterResolver searchParameterResolver;
    protected Integer pageSize;
    protected Integer maxCodesPerQuery;
    protected Integer queryBatchThreshold;
    private BaseFhirQueryGenerator fhirQueryGenerator;
    private ModelResolver modelResolver;

    protected SearchParamFhirRetrieveProvider(SearchParameterResolver searchParameterResolver) {
        this.searchParameterResolver = searchParameterResolver;
        this.fhirContext = searchParameterResolver.getFhirContext();
    }

    protected SearchParamFhirRetrieveProvider(SearchParameterResolver searchParameterResolver, ModelResolver modelResolver) {
        this(searchParameterResolver);
        this.modelResolver = modelResolver;
    }

    public void setPageSize(Integer value) {
        if (value == null || value < 1) {
            throw new IllegalArgumentException("value must be a non-null integer > 0");
        }
        this.pageSize = value;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setFhirQueryGenerator(BaseFhirQueryGenerator fhirQueryGenerator) {
        this.fhirQueryGenerator = fhirQueryGenerator;
    }

    public BaseFhirQueryGenerator getFhirQueryGenerator() {
        return this.fhirQueryGenerator;
    }

    public void setModelResolver(ModelResolver modelResolver) {
        this.modelResolver = modelResolver;
    }

    public ModelResolver getModelResolver() {
        return this.modelResolver;
    }

    public void setMaxCodesPerQuery(Integer value) {
        if (value == null || value < 1) {
            throw new IllegalArgumentException("value must be a non-null integer > 0");
        }
        this.maxCodesPerQuery = value;
    }

    public Integer getMaxCodesPerQuery() {
        return this.maxCodesPerQuery;
    }

    public void setQueryBatchThreshold(Integer value) {
        if (value == null || value < 1) {
            throw new IllegalArgumentException("value must be a non-null integer > 0");
        }
        this.queryBatchThreshold = value;
    }

    public Integer getQueryBatchThreshold() {
        return this.queryBatchThreshold;
    }

    protected abstract Iterable<Object> executeQueries(String var1, List<SearchParameterMap> var2);

    public Iterable<Object> retrieve(String context, String contextPath, Object contextValue, String dataType, String templateId, String codePath, Iterable<Code> codes, String valueSet, String datePath, String dateLowPath, String dateHighPath, Interval dateRange) {
        List<SearchParameterMap> queries = null;
        if (this.fhirContext != null && this.modelResolver != null) {
            try {
                if (this.fhirContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU3)) {
                    this.fhirQueryGenerator = new Dstu3FhirQueryGenerator(this.searchParameterResolver, this.terminologyProvider, this.modelResolver);
                } else if (this.fhirContext.getVersion().getVersion().equals((Object)FhirVersionEnum.R4)) {
                    this.fhirQueryGenerator = new R4FhirQueryGenerator(this.searchParameterResolver, this.terminologyProvider, this.modelResolver);
                }
            }
            catch (FhirVersionMisMatchException exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (this.fhirQueryGenerator != null) {
            this.fhirQueryGenerator.setExpandValueSets(this.isExpandValueSets());
            if (this.getMaxCodesPerQuery() != null && this.getMaxCodesPerQuery() > 0) {
                this.fhirQueryGenerator.setMaxCodesPerQuery(this.getMaxCodesPerQuery());
            }
            if (this.getQueryBatchThreshold() != null && this.getQueryBatchThreshold() > 0) {
                this.fhirQueryGenerator.setQueryBatchThreshold(this.getQueryBatchThreshold());
            }
            if (this.getPageSize() != null && this.getPageSize() > 0) {
                this.fhirQueryGenerator.setPageSize(this.getPageSize());
            }
            queries = this.fhirQueryGenerator.setupQueries(context, contextPath, contextValue, dataType, templateId, codePath, codes, valueSet, datePath, dateLowPath, dateHighPath, dateRange);
        }
        return this.executeQueries(dataType, queries);
    }
}

