/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.ExpressionDef;
import org.cqframework.cql.elm.execution.VersionedIdentifier;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.execution.ExpressionResult;

public class ExpressionDefEvaluator
extends ExpressionDef {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object internalEvaluate(Context context) {
        if (this.getContext() != null) {
            context.enterContext(this.getContext());
        }
        try {
            context.pushEvaluatedResourceStack();
            VersionedIdentifier libraryId = context.getCurrentLibrary().getIdentifier();
            if (context.isExpressionCachingEnabled() && context.isExpressionCached(libraryId, this.name)) {
                ExpressionResult er = context.getCachedExpression(libraryId, this.name);
                context.getEvaluatedResources().addAll(er.evaluatedResources());
                Object object = er.value();
                return object;
            }
            Object value = this.getExpression().evaluate(context);
            if (context.isExpressionCachingEnabled()) {
                ExpressionResult er = new ExpressionResult(value, context.getEvaluatedResources());
                context.cacheExpression(libraryId, this.name, er);
            }
            Object object = value;
            return object;
        }
        finally {
            context.popEvaluatedResourceStack();
            if (this.getContext() != null) {
                context.exitContext();
            }
        }
    }
}

