/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.Overlaps;
import org.opencds.cqf.cql.engine.elm.execution.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SameOrBeforeEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class OverlapsEvaluator
extends Overlaps {
    public static Boolean overlaps(Object left, Object right, String precision, Context context) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval && right instanceof Interval) {
            Object leftStart = ((Interval)left).getStart();
            Object leftEnd = ((Interval)left).getEnd();
            Object rightStart = ((Interval)right).getStart();
            Object rightEnd = ((Interval)right).getEnd();
            if (leftStart instanceof BaseTemporal && rightStart instanceof BaseTemporal) {
                return AndEvaluator.and(SameOrBeforeEvaluator.sameOrBefore(leftStart, rightEnd, precision, context), SameOrBeforeEvaluator.sameOrBefore(rightStart, leftEnd, precision, context));
            }
            return AndEvaluator.and(LessOrEqualEvaluator.lessOrEqual(leftStart, rightEnd, context), LessOrEqualEvaluator.lessOrEqual(rightStart, leftEnd, context));
        }
        throw new InvalidOperatorArgument("Overlaps(Interval<T>, Interval<T>)", String.format("Overlaps(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String precision = this.getPrecision() == null ? null : this.getPrecision().value();
        return OverlapsEvaluator.overlaps(left, right, precision, context);
    }
}

