/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.TruncatedDivide;
import org.opencds.cqf.cql.engine.elm.execution.EqualEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class TruncatedDivideEvaluator
extends TruncatedDivide {
    public static Object div(Object left, Object right, Context context) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer) {
            if ((Integer)right == 0) {
                return null;
            }
            return (Integer)left / (Integer)right;
        }
        if (left instanceof BigDecimal) {
            if (EqualEvaluator.equal(right, new BigDecimal("0.0"), context).booleanValue()) {
                return null;
            }
            return ((BigDecimal)left).divideAndRemainder((BigDecimal)right)[0];
        }
        if (left instanceof Quantity) {
            if (EqualEvaluator.equal(((Quantity)right).getValue(), new BigDecimal("0.0"), context).booleanValue()) {
                return null;
            }
            return new Quantity().withUnit(((Quantity)left).getUnit()).withValue(((Quantity)left).getValue().divideAndRemainder(((Quantity)right).getValue())[0]);
        }
        if (left instanceof Interval && right instanceof Interval) {
            Interval leftInterval = (Interval)left;
            Interval rightInterval = (Interval)right;
            return new Interval(TruncatedDivideEvaluator.div(leftInterval.getStart(), rightInterval.getStart(), context), true, TruncatedDivideEvaluator.div(leftInterval.getEnd(), rightInterval.getEnd(), context), true);
        }
        throw new InvalidOperatorArgument("TruncatedDivide(Integer, Integer), TruncatedDivide(Decimal, Decimal),  TruncatedDivide(Quantity, Quantity)", String.format("TruncatedDivide(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        return TruncatedDivideEvaluator.div(left, right, context);
    }
}

