/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.Abs;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class AbsEvaluator
extends Abs {
    public static Object abs(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof Integer) {
            return Math.abs((Integer)operand);
        }
        if (operand instanceof Long) {
            return Math.abs((Long)operand);
        }
        if (operand instanceof BigDecimal) {
            return ((BigDecimal)operand).abs();
        }
        if (operand instanceof Quantity) {
            return new Quantity().withValue(((Quantity)operand).getValue().abs()).withUnit(((Quantity)operand).getUnit());
        }
        throw new InvalidOperatorArgument("Abs(Integer), Abs(Long), Abs(Decimal) or Abs(Quantity)", String.format("Abs(%s)", operand.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        return AbsEvaluator.abs(operand);
    }
}

