/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.InValueSet;
import org.opencds.cqf.cql.engine.elm.execution.ValueSetRefEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Concept;
import org.opencds.cqf.cql.engine.runtime.ValueSet;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;

public class InValueSetEvaluator
extends InValueSet {
    public static Object inValueSet(Context context, Object code, Object valueset) {
        if (code == null || valueset == null) {
            return null;
        }
        if (valueset instanceof ValueSet) {
            ValueSetInfo vsi = ValueSetInfo.fromValueSet((ValueSet)valueset);
            TerminologyProvider provider = context.resolveTerminologyProvider();
            if (code instanceof String) {
                if (provider.in(new Code().withCode((String)code), vsi)) {
                    return true;
                }
                return false;
            }
            if (code instanceof Code) {
                if (provider.in((Code)code, vsi)) {
                    return true;
                }
                return false;
            }
            if (code instanceof Concept) {
                for (Code codes : ((Concept)code).getCodes()) {
                    if (codes == null) {
                        return null;
                    }
                    if (!provider.in(codes, vsi)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new InvalidOperatorArgument("In(String, ValueSetRef), In(Code, ValueSetRef) or In(Concept, ValueSetRef)", String.format("In(%s, %s)", code.getClass().getName(), valueset.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object code = this.getCode().evaluate(context);
        Object vs = null;
        if (this.getValueset() != null) {
            vs = ValueSetRefEvaluator.toValueSet(context, this.getValueset());
        } else if (this.getValuesetExpression() != null) {
            vs = this.getValuesetExpression().evaluate(context);
        }
        return InValueSetEvaluator.inValueSet(context, code, vs);
    }
}

