/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.Indexer;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;

public class IndexerEvaluator
extends Indexer {
    public static Object indexer(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof String && right instanceof Integer) {
            if ((Integer)right < 0 || (Integer)right >= ((String)left).length()) {
                return null;
            }
            return "" + ((String)left).charAt((Integer)right);
        }
        if (left instanceof Iterable && right instanceof Integer) {
            int index = -1;
            for (Object element : (Iterable)left) {
                if ((Integer)right != ++index) continue;
                return element;
            }
            return null;
        }
        throw new InvalidOperatorArgument("Indexer(String, Integer) or Indexer(List<T>, Integer)", String.format("Indexer(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        return IndexerEvaluator.indexer(left, right);
    }
}

