/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.TimeFrom;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Time;

public class TimeFromEvaluator
extends TimeFrom {
    public static Object timeFrom(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof DateTime) {
            if (((DateTime)operand).getPrecision().toDateTimeIndex() <= 2) {
                return null;
            }
            int hour = ((DateTime)operand).getDateTime().getHour();
            if (((DateTime)operand).getPrecision().toDateTimeIndex() <= 3) {
                return new Time(hour);
            }
            int minute = ((DateTime)operand).getDateTime().getMinute();
            if (((DateTime)operand).getPrecision().toDateTimeIndex() <= 4) {
                return new Time(hour, minute);
            }
            int second = ((DateTime)operand).getDateTime().getSecond();
            if (((DateTime)operand).getPrecision().toDateTimeIndex() <= 5) {
                return new Time(hour, minute, second);
            }
            int millisecond = ((DateTime)operand).getDateTime().get(Precision.MILLISECOND.toChronoField());
            return new Time(hour, minute, second, millisecond);
        }
        throw new InvalidOperatorArgument("TimeFrom(DateTime)", String.format("TimeFrom(%s)", operand.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        return TimeFromEvaluator.timeFrom(operand);
    }
}

