/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.CodeSystemRef;
import org.cqframework.cql.elm.execution.ValueSetDef;
import org.cqframework.cql.elm.execution.ValueSetRef;
import org.opencds.cqf.cql.engine.elm.execution.CodeSystemRefEvaluator;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.CodeSystem;
import org.opencds.cqf.cql.engine.runtime.ValueSet;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;

public class ValueSetRefEvaluator
extends ValueSetRef {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValueSet toValueSet(Context context, ValueSetRef vsr) {
        boolean enteredLibrary = context.enterLibrary(vsr.getLibraryName());
        try {
            ValueSetDef vsd = context.resolveValueSetRef(vsr.getName());
            ValueSet vs = new ValueSet().withId(vsd.getId()).withVersion(vsd.getVersion());
            for (CodeSystemRef csr : vsd.getCodeSystem()) {
                CodeSystem cs = CodeSystemRefEvaluator.toCodeSystem(context, csr);
                vs.addCodeSystem(cs);
            }
            ValueSet valueSet = vs;
            return valueSet;
        }
        finally {
            context.exitLibrary(enteredLibrary);
        }
    }

    @Override
    protected Object internalEvaluate(Context context) {
        ValueSet vs = ValueSetRefEvaluator.toValueSet(context, this);
        if (this.isPreserve() != null && this.isPreserve().booleanValue()) {
            return vs;
        }
        TerminologyProvider tp = context.resolveTerminologyProvider();
        return tp.expand(ValueSetInfo.fromValueSet(vs));
    }
}

