/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.execution;

import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.cqframework.cql.elm.execution.ChoiceTypeSpecifier;
import org.cqframework.cql.elm.execution.CodeDef;
import org.cqframework.cql.elm.execution.CodeSystemDef;
import org.cqframework.cql.elm.execution.ConceptDef;
import org.cqframework.cql.elm.execution.ExpressionDef;
import org.cqframework.cql.elm.execution.FunctionDef;
import org.cqframework.cql.elm.execution.IncludeDef;
import org.cqframework.cql.elm.execution.IntervalTypeSpecifier;
import org.cqframework.cql.elm.execution.Library;
import org.cqframework.cql.elm.execution.ListTypeSpecifier;
import org.cqframework.cql.elm.execution.NamedTypeSpecifier;
import org.cqframework.cql.elm.execution.OperandDef;
import org.cqframework.cql.elm.execution.ParameterDef;
import org.cqframework.cql.elm.execution.TypeSpecifier;
import org.cqframework.cql.elm.execution.ValueSetDef;
import org.cqframework.cql.elm.execution.VersionedIdentifier;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumException;
import org.fhir.ucum.UcumService;
import org.opencds.cqf.cql.engine.data.DataProvider;
import org.opencds.cqf.cql.engine.data.ExternalFunctionProvider;
import org.opencds.cqf.cql.engine.data.SystemDataProvider;
import org.opencds.cqf.cql.engine.debug.DebugAction;
import org.opencds.cqf.cql.engine.debug.DebugMap;
import org.opencds.cqf.cql.engine.debug.DebugResult;
import org.opencds.cqf.cql.engine.debug.SourceLocator;
import org.opencds.cqf.cql.engine.elm.execution.Executable;
import org.opencds.cqf.cql.engine.exception.CqlException;
import org.opencds.cqf.cql.engine.exception.Severity;
import org.opencds.cqf.cql.engine.execution.DefaultLibraryLoader;
import org.opencds.cqf.cql.engine.execution.ExpressionResult;
import org.opencds.cqf.cql.engine.execution.LibraryLoader;
import org.opencds.cqf.cql.engine.execution.NamespaceHelper;
import org.opencds.cqf.cql.engine.execution.Variable;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Tuple;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private static Logger logger = LoggerFactory.getLogger(Context.class);
    private static UcumService sharedUcumService;
    private boolean enableExpressionCache = false;
    private LinkedHashMap<VersionedIdentifier, LinkedHashMap<String, ExpressionResult>> expressions = new LinkedHashMap<VersionedIdentifier, LinkedHashMap<String, ExpressionResult>>(10, 0.9f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<VersionedIdentifier, LinkedHashMap<String, ExpressionResult>> eldestEntry) {
            return this.size() > 10;
        }
    };
    private Stack<HashSet<Object>> evaluatedResourceStack = new Stack();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Stack<String> currentContext = new Stack();
    private Map<String, Object> contextValues = new HashMap<String, Object>();
    private Stack<Stack<Variable>> windows = new Stack();
    private Map<String, Library> libraries = new HashMap<String, Library>();
    private Stack<Library> currentLibrary = new Stack();
    private LibraryLoader libraryLoader;
    private ZonedDateTime evaluationZonedDateTime;
    private OffsetDateTime evaluationOffsetDateTime;
    private DateTime evaluationDateTime;
    private UcumService ucumService;
    private DebugMap debugMap;
    private DebugResult debugResult;
    private Map<String, List<FunctionDesc>> functionCache = new HashMap<String, List<FunctionDesc>>();
    private Map<String, DataProvider> dataProviders = new HashMap<String, DataProvider>();
    private Map<String, DataProvider> packageMap = new HashMap<String, DataProvider>();
    private TerminologyProvider terminologyProvider;
    private Map<VersionedIdentifier, ExternalFunctionProvider> externalFunctionProviders = new HashMap<VersionedIdentifier, ExternalFunctionProvider>();

    private LinkedHashMap<String, ExpressionResult> constructLibraryExpressionHashMap() {
        return new LinkedHashMap<String, ExpressionResult>(15, 0.9f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ExpressionResult> eldestEntry) {
                return this.size() > 15;
            }
        };
    }

    public Set<Object> getEvaluatedResources() {
        if (this.evaluatedResourceStack.empty()) {
            throw new IllegalStateException("Attempted to get the evaluatedResource stack when it's empty");
        }
        return this.evaluatedResourceStack.peek();
    }

    public void clearEvaluatedResources() {
        this.evaluatedResourceStack.clear();
        this.pushEvaluatedResourceStack();
    }

    public void pushEvaluatedResourceStack() {
        this.evaluatedResourceStack.push(new HashSet());
    }

    public void popEvaluatedResourceStack() {
        if (this.evaluatedResourceStack.empty()) {
            throw new IllegalStateException("Attempted to pop the evaluatedResource stack when it's empty");
        }
        if (this.evaluatedResourceStack.size() == 1) {
            throw new IllegalStateException("Attempted to pop the evaluatedResource stack when only the root remains");
        }
        Set objects = this.evaluatedResourceStack.pop();
        HashSet<Object> set = this.evaluatedResourceStack.peek();
        set.addAll(objects);
    }

    public DebugMap getDebugMap() {
        return this.debugMap;
    }

    public void setDebugMap(DebugMap debugMap) {
        this.debugMap = debugMap;
    }

    public DebugResult getDebugResult() {
        return this.debugResult;
    }

    public DebugAction shouldDebug(Exception e) {
        if (this.debugMap == null) {
            return DebugAction.NONE;
        }
        return this.debugMap.shouldDebug(e);
    }

    public DebugAction shouldDebug(Executable node) {
        if (this.debugMap == null) {
            return DebugAction.NONE;
        }
        return this.debugMap.shouldDebug(node, this.getCurrentLibrary());
    }

    private void ensureDebugResult() {
        if (this.debugResult == null) {
            this.debugResult = new DebugResult();
        }
    }

    public void clearExpressions() {
        this.expressions.clear();
    }

    public void logDebugResult(Executable node, Object result, DebugAction action) {
        this.ensureDebugResult();
        this.debugResult.logDebugResult(node, this.getCurrentLibrary(), result, action);
    }

    public void logDebugMessage(SourceLocator locator, String message) {
        this.ensureDebugResult();
        this.debugResult.logDebugError(new CqlException(message, locator, Severity.MESSAGE));
    }

    public void logDebugWarning(SourceLocator locator, String message) {
        this.ensureDebugResult();
        this.debugResult.logDebugError(new CqlException(message, locator, Severity.WARNING));
    }

    public void logDebugTrace(SourceLocator locator, String message) {
        this.ensureDebugResult();
        this.debugResult.logDebugError(new CqlException(message, locator, Severity.TRACE));
    }

    public void logDebugError(CqlException e) {
        this.ensureDebugResult();
        this.debugResult.logDebugError(e);
    }

    public Context(Library library) {
        this.setEvaluationDateTime(ZonedDateTime.now());
        this.init(library, new SystemDataProvider(), null);
    }

    public Context(Library library, DataProvider systemDataProvider) {
        this.setEvaluationDateTime(ZonedDateTime.now());
        this.init(library, systemDataProvider, null);
    }

    public Context(Library library, ZonedDateTime evaluationZonedDateTime) {
        this.setEvaluationDateTime(evaluationZonedDateTime);
        this.init(library, new SystemDataProvider(), null);
    }

    public Context(Library library, ZonedDateTime evaluationZonedDateTime, DataProvider systemDataProvider) {
        this.setEvaluationDateTime(evaluationZonedDateTime);
        this.init(library, systemDataProvider, null);
    }

    public Context(Library library, ZonedDateTime evaluationZonedDateTime, DataProvider systemDataProvider, UcumService ucumService) {
        this.setEvaluationDateTime(evaluationZonedDateTime);
        this.init(library, systemDataProvider, ucumService);
    }

    private void init(Library library, DataProvider systemDataProvider, UcumService ucumService) {
        this.pushWindow();
        this.registerDataProvider("urn:hl7-org:elm-types:r1", systemDataProvider);
        this.libraryLoader = new DefaultLibraryLoader();
        if (library.getIdentifier() != null) {
            this.libraries.put(library.getIdentifier().getId(), library);
        }
        this.currentLibrary.push(library);
        this.ucumService = ucumService != null ? ucumService : this.getSharedUcumService();
        this.pushEvaluatedResourceStack();
    }

    private void setEvaluationDateTime(ZonedDateTime evaluationZonedDateTime) {
        this.evaluationZonedDateTime = evaluationZonedDateTime;
        this.evaluationOffsetDateTime = evaluationZonedDateTime.toOffsetDateTime();
        this.evaluationDateTime = new DateTime(this.evaluationOffsetDateTime);
    }

    public ZonedDateTime getEvaluationZonedDateTime() {
        return this.evaluationZonedDateTime;
    }

    public OffsetDateTime getEvaluationOffsetDateTime() {
        return this.evaluationOffsetDateTime;
    }

    public DateTime getEvaluationDateTime() {
        return this.evaluationDateTime;
    }

    public UcumService getUcumService() {
        return this.ucumService;
    }

    protected synchronized UcumService getSharedUcumService() {
        if (sharedUcumService == null) {
            try {
                sharedUcumService = new UcumEssenceService(UcumEssenceService.class.getResourceAsStream("/ucum-essence.xml"));
            }
            catch (UcumException e) {
                logger.warn("Error creating shared UcumService", (Throwable)e);
            }
        }
        return sharedUcumService;
    }

    public void setExpressionCaching(boolean yayOrNay) {
        this.enableExpressionCache = yayOrNay;
    }

    protected Map<String, ExpressionResult> getCacheForLibrary(VersionedIdentifier libraryId) {
        return this.expressions.computeIfAbsent(libraryId, k -> this.constructLibraryExpressionHashMap());
    }

    public boolean isExpressionCached(VersionedIdentifier libraryId, String name) {
        return this.getCacheForLibrary(libraryId).containsKey(name);
    }

    public boolean isExpressionCachingEnabled() {
        return this.enableExpressionCache;
    }

    public void cacheExpression(VersionedIdentifier libraryId, String name, ExpressionResult er) {
        this.getCacheForLibrary(libraryId).put(name, er);
    }

    public ExpressionResult getCachedExpression(VersionedIdentifier libraryId, String name) {
        return this.getCacheForLibrary(libraryId).get(name);
    }

    public void registerLibraryLoader(LibraryLoader libraryLoader) {
        if (libraryLoader == null) {
            throw new CqlException("Library loader implementation must not be null.");
        }
        this.libraryLoader = libraryLoader;
    }

    public Library getCurrentLibrary() {
        return this.currentLibrary.peek();
    }

    private Library resolveIncludeDef(IncludeDef includeDef) {
        VersionedIdentifier libraryIdentifier = new VersionedIdentifier().withSystem(NamespaceHelper.getUriPart(includeDef.getPath())).withId(NamespaceHelper.getNamePart(includeDef.getPath())).withVersion(includeDef.getVersion());
        Library library = this.libraries.get(libraryIdentifier.getId());
        if (library == null) {
            library = this.libraryLoader.load(libraryIdentifier);
            this.libraries.put(libraryIdentifier.getId(), library);
        }
        if (libraryIdentifier.getVersion() != null && !libraryIdentifier.getVersion().equals(library.getIdentifier().getVersion())) {
            throw new CqlException(String.format("Could not load library '%s' version '%s' because version '%s' is already loaded.", libraryIdentifier.getId(), libraryIdentifier.getVersion(), library.getIdentifier().getVersion()));
        }
        return library;
    }

    public boolean enterLibrary(String libraryName) {
        if (libraryName != null) {
            IncludeDef includeDef = this.resolveLibraryRef(libraryName);
            Library library = this.resolveIncludeDef(includeDef);
            this.currentLibrary.push(library);
            return true;
        }
        return false;
    }

    public void exitLibrary(boolean enteredLibrary) {
        if (enteredLibrary) {
            this.currentLibrary.pop();
        }
    }

    public CodeDef resolveCodeRef(String name) {
        for (CodeDef codeDef : this.getCurrentLibrary().getCodes().getDef()) {
            if (!codeDef.getName().equals(name)) continue;
            return codeDef;
        }
        throw new CqlException(String.format("Could not resolve code reference '%s'.", name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeDef resolveCodeRef(String libraryName, String name) {
        boolean enteredLibrary = this.enterLibrary(libraryName);
        try {
            CodeDef codeDef = this.resolveCodeRef(name);
            return codeDef;
        }
        finally {
            this.exitLibrary(enteredLibrary);
        }
    }

    public ConceptDef resolveConceptRef(String name) {
        for (ConceptDef conceptDef : this.getCurrentLibrary().getConcepts().getDef()) {
            if (!conceptDef.getName().equals(name)) continue;
            return conceptDef;
        }
        throw new CqlException(String.format("Could not resolve concept reference '%s'.", name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConceptDef resolveConceptRef(String libraryName, String name) {
        boolean enteredLibrary = this.enterLibrary(libraryName);
        try {
            ConceptDef conceptDef = this.resolveConceptRef(name);
            return conceptDef;
        }
        finally {
            this.exitLibrary(enteredLibrary);
        }
    }

    private IncludeDef resolveLibraryRef(String libraryName) {
        for (IncludeDef includeDef : this.getCurrentLibrary().getIncludes().getDef()) {
            if (!includeDef.getLocalIdentifier().equals(libraryName)) continue;
            return includeDef;
        }
        throw new CqlException(String.format("Could not resolve library reference '%s'.", libraryName));
    }

    public ExpressionDef resolveExpressionRef(String name) {
        for (ExpressionDef expressionDef : this.getCurrentLibrary().getStatements().getDef()) {
            if (!expressionDef.getName().equals(name)) continue;
            return expressionDef;
        }
        throw new CqlException(String.format("Could not resolve expression reference '%s' in library '%s'.", name, this.getCurrentLibrary().getIdentifier().getId()));
    }

    public Object resolveIdentifierRef(String name) {
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            for (int j = 0; j < ((Stack)this.windows.get(i)).size(); ++j) {
                Object value = ((Variable)((Stack)this.windows.get(i)).get(j)).getValue();
                if (value instanceof Tuple) {
                    for (String key : ((Tuple)value).getElements().keySet()) {
                        if (!key.equals(name)) continue;
                        return ((Tuple)value).getElements().get(key);
                    }
                }
                try {
                    return this.resolvePath(value, name);
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        throw new CqlException("Cannot resolve identifier " + name);
    }

    public QName fixupQName(QName typeName) {
        int closeIndex;
        if ((typeName.getNamespaceURI() == null || typeName.getNamespaceURI().isEmpty()) && typeName.getLocalPart() != null && typeName.getLocalPart().startsWith("{") && (closeIndex = typeName.getLocalPart().indexOf(125)) > 0 && typeName.getLocalPart().length() > closeIndex) {
            return new QName(typeName.getLocalPart().substring(1, closeIndex), typeName.getLocalPart().substring(closeIndex + 1));
        }
        return typeName;
    }

    public Object createInstance(QName typeName) {
        typeName = this.fixupQName(typeName);
        DataProvider dataProvider = this.resolveDataProvider(typeName);
        return dataProvider.createInstance(typeName.getLocalPart());
    }

    public Class<?> resolveType(QName typeName) {
        typeName = this.fixupQName(typeName);
        DataProvider dataProvider = this.resolveDataProvider(typeName);
        return dataProvider.resolveType(typeName.getLocalPart());
    }

    public Class<?> resolveType(TypeSpecifier typeSpecifier) {
        if (typeSpecifier instanceof NamedTypeSpecifier) {
            return this.resolveType(((NamedTypeSpecifier)typeSpecifier).getName());
        }
        if (typeSpecifier instanceof ListTypeSpecifier) {
            return List.class;
        }
        if (typeSpecifier instanceof IntervalTypeSpecifier) {
            return Interval.class;
        }
        if (typeSpecifier instanceof ChoiceTypeSpecifier) {
            return Object.class;
        }
        return Tuple.class;
    }

    public Class<?> resolveType(Object value) {
        if (value == null) {
            return null;
        }
        String packageName = value.getClass().getPackage().getName();
        if (value instanceof Iterable) {
            return List.class;
        }
        if (value instanceof Tuple) {
            return Tuple.class;
        }
        if (packageName.startsWith("java")) {
            return value.getClass();
        }
        DataProvider dataProvider = this.resolveDataProvider(value.getClass().getPackage().getName());
        return dataProvider.resolveType(value);
    }

    private Class<?> resolveOperandType(OperandDef operandDef) {
        if (operandDef.getOperandTypeSpecifier() != null) {
            return this.resolveType(operandDef.getOperandTypeSpecifier());
        }
        return this.resolveType(operandDef.getOperandType());
    }

    public Boolean is(Object operand, Class<?> type) {
        if (operand == null) {
            return null;
        }
        if (type.isAssignableFrom(operand.getClass())) {
            return true;
        }
        DataProvider provider = this.resolveDataProvider(type.getPackage().getName(), false);
        if (provider != null) {
            return provider.is(operand, type);
        }
        return false;
    }

    public Object as(Object operand, Class<?> type, boolean isStrict) {
        if (operand == null) {
            return null;
        }
        if (type.isAssignableFrom(operand.getClass())) {
            return operand;
        }
        DataProvider provider = this.resolveDataProvider(type.getPackage().getName(), false);
        if (provider != null) {
            return provider.as(operand, type, isStrict);
        }
        return null;
    }

    private boolean isType(Class<?> argumentType, Class<?> operandType) {
        return argumentType == null || operandType.isAssignableFrom(argumentType);
    }

    private FunctionDef resolveFunctionDesc(FunctionDesc functionDesc, List<Object> arguments) {
        boolean isMatch = true;
        List<Class<?>> operands = functionDesc.operandTypes();
        if (arguments.size() != operands.size()) {
            return null;
        }
        for (int i = 0; i < arguments.size() && (isMatch = this.isType(this.resolveType(arguments.get(i)), operands.get(i))); ++i) {
        }
        return isMatch ? functionDesc.functionDef() : null;
    }

    private FunctionDesc createFunctionDesc(FunctionDef functionDef) {
        ArrayList operandTypes = new ArrayList(functionDef.getOperand().size());
        for (OperandDef op : functionDef.getOperand()) {
            operandTypes.add(this.resolveOperandType(op));
        }
        return new FunctionDesc(functionDef, operandTypes);
    }

    public FunctionDef resolveFunctionRef(String name, List<Object> arguments, String libraryName) {
        FunctionDef ret = null;
        String mangledFunctionName = (libraryName == null ? this.getCurrentLibrary().getIdentifier().getId() : libraryName) + "." + name;
        if (this.functionCache.containsKey(mangledFunctionName)) {
            FunctionDesc functionDesc;
            Iterator<Object> iterator = this.functionCache.get(mangledFunctionName).iterator();
            while (iterator.hasNext() && (ret = this.resolveFunctionDesc(functionDesc = (FunctionDesc)iterator.next(), arguments)) == null) {
            }
        } else {
            for (ExpressionDef expressionDef : this.getCurrentLibrary().getStatements().getDef()) {
                if (!expressionDef.getName().equals(name) || !(expressionDef instanceof FunctionDef)) continue;
                FunctionDesc functionDesc = this.createFunctionDesc((FunctionDef)expressionDef);
                this.functionCache.computeIfAbsent(mangledFunctionName, k -> new ArrayList()).add(functionDesc);
                FunctionDef candidate = this.resolveFunctionDesc(functionDesc, arguments);
                if (candidate == null) continue;
                ret = candidate;
            }
        }
        if (ret != null) {
            return ret;
        }
        StringBuilder argStr = new StringBuilder();
        if (arguments != null) {
            arguments.forEach(a -> argStr.append(argStr.length() > 0 ? ", " : "").append(this.resolveType(a).getName()));
        }
        throw new CqlException(String.format("Could not resolve call to operator '%s(%s)' in library '%s'.", name, argStr.toString(), this.getCurrentLibrary().getIdentifier().getId()));
    }

    private ParameterDef resolveParameterRef(String name) {
        for (ParameterDef parameterDef : this.getCurrentLibrary().getParameters().getDef()) {
            if (!parameterDef.getName().equals(name)) continue;
            return parameterDef;
        }
        throw new CqlException(String.format("Could not resolve parameter reference '%s' in library '%s'.", name, this.getCurrentLibrary().getIdentifier().getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String libraryName, String name, Object value) {
        boolean enteredLibrary = this.enterLibrary(libraryName);
        try {
            String fullName = libraryName != null ? String.format("%s.%s", this.getCurrentLibrary().getIdentifier().getId(), name) : name;
            this.parameters.put(fullName, value);
        }
        finally {
            this.exitLibrary(enteredLibrary);
        }
    }

    public void setParameters(Library library, Map<String, Object> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, Object> parameterValue : parameters.entrySet()) {
                this.setParameter(null, parameterValue.getKey(), parameterValue.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object resolveParameterRef(String libraryName, String name) {
        boolean enteredLibrary = this.enterLibrary(libraryName);
        try {
            String fullName;
            String string = fullName = libraryName != null ? String.format("%s.%s", this.getCurrentLibrary().getIdentifier().getId(), name) : name;
            if (this.parameters.containsKey(fullName)) {
                Object object = this.parameters.get(fullName);
                return object;
            }
            ParameterDef parameterDef = this.resolveParameterRef(name);
            Object result = parameterDef.getDefault() != null ? parameterDef.getDefault().evaluate(this) : null;
            this.parameters.put(fullName, result);
            Object object = result;
            return object;
        }
        finally {
            this.exitLibrary(enteredLibrary);
        }
    }

    public ValueSetDef resolveValueSetRef(String name) {
        for (ValueSetDef valueSetDef : this.getCurrentLibrary().getValueSets().getDef()) {
            if (!valueSetDef.getName().equals(name)) continue;
            return valueSetDef;
        }
        throw new CqlException(String.format("Could not resolve value set reference '%s' in library '%s'.", name, this.getCurrentLibrary().getIdentifier().getId()));
    }

    public CodeSystemDef resolveCodeSystemRef(String name) {
        for (CodeSystemDef codeSystemDef : this.getCurrentLibrary().getCodeSystems().getDef()) {
            if (!codeSystemDef.getName().equals(name)) continue;
            return codeSystemDef;
        }
        throw new CqlException(String.format("Could not resolve code system reference '%s' in library '%s'.", name, this.getCurrentLibrary().getIdentifier().getId()));
    }

    public void registerDataProvider(String modelUri, DataProvider dataProvider) {
        this.dataProviders.put(modelUri, dataProvider);
        dataProvider.getPackageNames().forEach(pn -> this.packageMap.put((String)pn, dataProvider));
    }

    public DataProvider resolveDataProvider(QName dataType) {
        DataProvider dataProvider = this.dataProviders.get((dataType = this.fixupQName(dataType)).getNamespaceURI());
        if (dataProvider == null) {
            throw new CqlException(String.format("Could not resolve data provider for model '%s'.", dataType.getNamespaceURI()));
        }
        return dataProvider;
    }

    public DataProvider resolveDataProviderByModelUri(String modelUri) {
        DataProvider dataProvider = this.dataProviders.get(modelUri);
        if (dataProvider == null) {
            throw new CqlException(String.format("Could not resolve data provider for model '%s'.", modelUri));
        }
        return dataProvider;
    }

    public DataProvider resolveDataProvider(String packageName) {
        return this.resolveDataProvider(packageName, true);
    }

    public DataProvider resolveDataProvider(String packageName, boolean mustResolve) {
        DataProvider dataProvider = this.packageMap.get(packageName);
        if (dataProvider == null && mustResolve) {
            throw new CqlException(String.format("Could not resolve data provider for package '%s'.", packageName));
        }
        return dataProvider;
    }

    public void registerTerminologyProvider(TerminologyProvider tp) {
        this.terminologyProvider = tp;
    }

    public TerminologyProvider resolveTerminologyProvider() {
        return this.terminologyProvider;
    }

    public void registerExternalFunctionProvider(VersionedIdentifier identifier, ExternalFunctionProvider provider) {
        this.externalFunctionProviders.put(identifier, provider);
    }

    public ExternalFunctionProvider getExternalFunctionProvider() {
        Library currentLibrary = this.getCurrentLibrary();
        VersionedIdentifier identifier = currentLibrary.getIdentifier();
        ExternalFunctionProvider provider = this.externalFunctionProviders.get(identifier);
        if (provider == null) {
            throw new CqlException(String.format("Could not resolve external function provider for library '%s'.", identifier));
        }
        return provider;
    }

    public void enterContext(String context) {
        this.currentContext.push(context);
    }

    public void exitContext() {
        this.currentContext.pop();
    }

    public String getCurrentContext() {
        if (this.currentContext.empty()) {
            return null;
        }
        return this.currentContext.peek();
    }

    public void setContextValue(String context, Object contextValue) {
        if (this.hasContextValueChanged(context, contextValue)) {
            this.clearExpressions();
        }
        this.contextValues.put(context, contextValue);
    }

    private boolean hasContextValueChanged(String context, Object contextValue) {
        if (this.contextValues.containsKey(context)) {
            return !this.contextValues.get(context).equals(contextValue);
        }
        return true;
    }

    public Object getCurrentContextValue() {
        String context = this.getCurrentContext();
        if (context != null && this.contextValues.containsKey(context)) {
            return this.contextValues.get(context);
        }
        return null;
    }

    public void push(Variable variable) {
        this.getStack().push(variable);
    }

    public Variable resolveVariable(String name) {
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            for (int j = 0; j < ((Stack)this.windows.get(i)).size(); ++j) {
                if (!((Variable)((Stack)this.windows.get(i)).get(j)).getName().equals(name)) continue;
                return (Variable)((Stack)this.windows.get(i)).get(j);
            }
        }
        return null;
    }

    public Variable resolveVariable(String name, boolean mustResolve) {
        Variable result = this.resolveVariable(name);
        if (mustResolve && result == null) {
            throw new CqlException(String.format("Could not resolve variable reference %s", name));
        }
        return result;
    }

    public Object resolveAlias(String name) {
        ArrayList<Object> ret = new ArrayList<Object>();
        boolean isList = false;
        for (Variable v : this.getStack()) {
            if (!v.getName().equals(name)) continue;
            if (v.isList()) {
                isList = true;
            }
            ret.add(v.getValue());
        }
        return isList ? ret : ret.get(ret.size() - 1);
    }

    public void pop() {
        if (!this.windows.peek().empty()) {
            this.getStack().pop();
        }
    }

    public void pushWindow() {
        this.windows.push(new Stack());
    }

    public void popWindow() {
        this.windows.pop();
    }

    private Stack<Variable> getStack() {
        return this.windows.peek();
    }

    public Object resolvePath(Object target, String path) {
        if (target == null) {
            return null;
        }
        Class<?> clazz = target.getClass();
        if (clazz.getPackage().getName().startsWith("java.lang")) {
            throw new CqlException(String.format("Invalid path: %s for type: %s - this is likely an issue with the data model.", path, clazz.getName()));
        }
        DataProvider dataProvider = this.resolveDataProvider(clazz.getPackage().getName());
        return dataProvider.resolvePath(target, path);
    }

    public void setValue(Object target, String path, Object value) {
        if (target == null) {
            return;
        }
        Class<?> clazz = target.getClass();
        DataProvider dataProvider = this.resolveDataProvider(clazz.getPackage().getName());
        dataProvider.setValue(target, path, value);
    }

    public Boolean objectEqual(Object left, Object right) {
        if (left == null) {
            return null;
        }
        Class<?> clazz = left.getClass();
        DataProvider dataProvider = this.resolveDataProvider(clazz.getPackage().getName());
        return dataProvider.objectEqual(left, right);
    }

    public Boolean objectEquivalent(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null) {
            return false;
        }
        Class<?> clazz = left.getClass();
        DataProvider dataProvider = this.resolveDataProvider(clazz.getPackage().getName());
        return dataProvider.objectEquivalent(left, right);
    }

    static class FunctionDesc {
        private FunctionDef functionDef;
        private List<Class<?>> operandTypes;

        public FunctionDesc(FunctionDef functionDef, List<Class<?>> operandTypes) {
            this.functionDef = functionDef;
            this.operandTypes = operandTypes;
        }

        public FunctionDef functionDef() {
            return this.functionDef;
        }

        public List<Class<?>> operandTypes() {
            return this.operandTypes;
        }
    }
}

