/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.serializing;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.opencds.cqf.cql.engine.serializing.CqlLibraryReader;
import org.opencds.cqf.cql.engine.serializing.CqlLibraryReaderProvider;

public class CqlLibraryReaderFactory {
    private CqlLibraryReaderFactory() {
    }

    public static Iterator<CqlLibraryReaderProvider> providers(boolean refresh) {
        ServiceLoader<CqlLibraryReaderProvider> loader = ServiceLoader.load(CqlLibraryReaderProvider.class);
        if (refresh) {
            loader.reload();
        }
        return loader.iterator();
    }

    public static CqlLibraryReader getReader(String contentType) {
        Iterator<CqlLibraryReaderProvider> providers = CqlLibraryReaderFactory.providers(false);
        if (providers.hasNext()) {
            CqlLibraryReaderProvider p = providers.next();
            if (providers.hasNext()) {
                throw new RuntimeException(String.join((CharSequence)" ", "Multiple CqlLibraryReaderProviders found on the classpath.", "You need to remove a reference to either the 'engine.jackson' or the 'engine.jaxb' package"));
            }
            return p.create(contentType);
        }
        throw new RuntimeException(String.join((CharSequence)" ", "No CqlLibraryReaderProviders found on the classpath.", "You need to add a reference to one of the 'engine.jackson' or 'engine.jaxb' packages,", "or provide your own implementation."));
    }
}

