/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.CalculateAge;
import org.opencds.cqf.cql.engine.elm.execution.CalculateAgeAtEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.DateFromEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;

public class CalculateAgeEvaluator
extends CalculateAge {
    public static Object calculateAge(Object operand, String precision, Object today) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof Date || operand instanceof DateTime) {
            return CalculateAgeAtEvaluator.calculateAgeAt(operand, today, precision);
        }
        throw new InvalidOperatorArgument("CalculateAgeInYears(Date), CalculateAgeInYears(DateTime), CalculateAgeInMonths(Date), CalculateAgeInMonths(DateTime), CalculateAgeInWeeks(Date), CalculateAgeInWeeks(DateTime), CalculateAgeInDays(Date), CalculateAgeInDays(DateTime), CalculateAgeInHours(Date), CalculateAgeInHours(DateTime), CalculateAgeInMinutes(Date), CalculateAgeInMinutes(DateTime), CalculateAgeInSeconds(Date), CalculateAgeInSeconds(DateTime)", String.format("CalculateAgeIn%ss(%s)", precision, operand.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        String precision = this.getPrecision().value();
        BaseTemporal today = operand instanceof Date ? DateFromEvaluator.dateFrom(context.getEvaluationDateTime()) : context.getEvaluationDateTime();
        return CalculateAgeEvaluator.calculateAge(operand, precision, today);
    }
}

