/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.apache.commons.lang3.ArrayUtils;
import org.cqframework.cql.elm.execution.ConvertsToBoolean;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;

public class ConvertsToBooleanEvaluator
extends ConvertsToBoolean {
    private static String[] validTrueValues = new String[]{"true", "t", "yes", "y", "1"};
    private static String[] validFalseValues = new String[]{"false", "f", "no", "n", "0"};

    public static Boolean convertsToBoolean(Object argument) {
        if (argument == null) {
            return null;
        }
        if (argument instanceof Boolean) {
            return true;
        }
        if (argument instanceof Integer) {
            Integer value = (Integer)argument;
            return value == 0 || value == 1;
        }
        if (argument instanceof BigDecimal) {
            BigDecimal value = (BigDecimal)argument;
            return value.compareTo(new BigDecimal("1.0")) == 0 || value.compareTo(new BigDecimal("0.0")) == 0;
        }
        if (argument instanceof String) {
            return ArrayUtils.contains((Object[])validTrueValues, (Object)((String)argument).toLowerCase()) || ArrayUtils.contains((Object[])validFalseValues, (Object)((String)argument).toLowerCase());
        }
        throw new InvalidOperatorArgument("ConvertsToBoolean(String)", String.format("ConvertsToBoolean(%s)", argument.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        return ConvertsToBooleanEvaluator.convertsToBoolean(operand);
    }
}

