/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.cqframework.cql.elm.execution.Divide;
import org.opencds.cqf.cql.engine.elm.execution.EqualEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.Value;

public class DivideEvaluator
extends Divide {
    private static BigDecimal divideHelper(BigDecimal left, BigDecimal right, Context context) {
        if (EqualEvaluator.equal(right, new BigDecimal("0.0"), context).booleanValue()) {
            return null;
        }
        try {
            return Value.verifyPrecision(left.divide(right), null);
        }
        catch (ArithmeticException e) {
            return left.divide(right, 8, RoundingMode.FLOOR);
        }
    }

    public static Object divide(Object left, Object right, Context context) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            return DivideEvaluator.divideHelper((BigDecimal)left, (BigDecimal)right, context);
        }
        if (left instanceof Quantity && right instanceof Quantity) {
            BigDecimal value = DivideEvaluator.divideHelper(((Quantity)left).getValue(), ((Quantity)right).getValue(), context);
            return new Quantity().withValue(Value.verifyPrecision(value, null)).withUnit(((Quantity)left).getUnit());
        }
        if (left instanceof Quantity && right instanceof BigDecimal) {
            BigDecimal value = DivideEvaluator.divideHelper(((Quantity)left).getValue(), (BigDecimal)right, context);
            return new Quantity().withValue(Value.verifyPrecision(value, null)).withUnit(((Quantity)left).getUnit());
        }
        if (left instanceof Interval && right instanceof Interval) {
            Interval leftInterval = (Interval)left;
            Interval rightInterval = (Interval)right;
            return new Interval(DivideEvaluator.divide(leftInterval.getStart(), rightInterval.getStart(), context), true, DivideEvaluator.divide(leftInterval.getEnd(), rightInterval.getEnd(), context), true);
        }
        throw new InvalidOperatorArgument("Divide(Decimal, Decimal), Divide(Quantity, Decimal), Divide(Quantity, Quantity)", String.format("Divide(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        return DivideEvaluator.divide(left, right, context);
    }
}

